/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
import $protobuf from "protobufjs/minimal.js";

const $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

const $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

export const proto = $root.proto = (() => {

    const proto = {};

    proto.ADVDeviceIdentity = (function() {

        function ADVDeviceIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVDeviceIdentity.prototype.rawId = null;
        ADVDeviceIdentity.prototype.timestamp = null;
        ADVDeviceIdentity.prototype.keyIndex = null;
        ADVDeviceIdentity.prototype.accountType = null;
        ADVDeviceIdentity.prototype.deviceType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_rawId", {
            get: $util.oneOfGetter($oneOfFields = ["rawId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_keyIndex", {
            get: $util.oneOfGetter($oneOfFields = ["keyIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_deviceType", {
            get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        ADVDeviceIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                w.uint32(8).uint32(m.rawId);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(16).uint64(m.timestamp);
            if (m.keyIndex != null && Object.hasOwnProperty.call(m, "keyIndex"))
                w.uint32(24).uint32(m.keyIndex);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(32).int32(m.accountType);
            if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                w.uint32(40).int32(m.deviceType);
            return w;
        };

        ADVDeviceIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVDeviceIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.rawId = r.uint32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.uint64();
                        break;
                    }
                case 3: {
                        m.keyIndex = r.uint32();
                        break;
                    }
                case 4: {
                        m.accountType = r.int32();
                        break;
                    }
                case 5: {
                        m.deviceType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVDeviceIdentity.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVDeviceIdentity)
                return d;
            var m = new $root.proto.ADVDeviceIdentity();
            if (d.rawId != null) {
                m.rawId = d.rawId >>> 0;
            }
            if (d.timestamp != null) {
                if ($util.Long)
                    (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = true;
                else if (typeof d.timestamp === "string")
                    m.timestamp = parseInt(d.timestamp, 10);
                else if (typeof d.timestamp === "number")
                    m.timestamp = d.timestamp;
                else if (typeof d.timestamp === "object")
                    m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber(true);
            }
            if (d.keyIndex != null) {
                m.keyIndex = d.keyIndex >>> 0;
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.accountType = 1;
                break;
            }
            switch (d.deviceType) {
            default:
                if (typeof d.deviceType === "number") {
                    m.deviceType = d.deviceType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.deviceType = 0;
                break;
            case "HOSTED":
            case 1:
                m.deviceType = 1;
                break;
            }
            return m;
        };

        ADVDeviceIdentity.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.rawId != null && m.hasOwnProperty("rawId")) {
                d.rawId = m.rawId;
                if (o.oneofs)
                    d._rawId = "rawId";
            }
            if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                if (typeof m.timestamp === "number")
                    d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                else
                    d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber(true) : m.timestamp;
                if (o.oneofs)
                    d._timestamp = "timestamp";
            }
            if (m.keyIndex != null && m.hasOwnProperty("keyIndex")) {
                d.keyIndex = m.keyIndex;
                if (o.oneofs)
                    d._keyIndex = "keyIndex";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ADVEncryptionType[m.accountType] === undefined ? m.accountType : $root.proto.ADVEncryptionType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            if (m.deviceType != null && m.hasOwnProperty("deviceType")) {
                d.deviceType = o.enums === String ? $root.proto.ADVEncryptionType[m.deviceType] === undefined ? m.deviceType : $root.proto.ADVEncryptionType[m.deviceType] : m.deviceType;
                if (o.oneofs)
                    d._deviceType = "deviceType";
            }
            return d;
        };

        ADVDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVDeviceIdentity";
        };

        return ADVDeviceIdentity;
    })();

    proto.ADVEncryptionType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "E2EE"] = 0;
        values[valuesById[1] = "HOSTED"] = 1;
        return values;
    })();

    proto.ADVKeyIndexList = (function() {

        function ADVKeyIndexList(p) {
            this.validIndexes = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVKeyIndexList.prototype.rawId = null;
        ADVKeyIndexList.prototype.timestamp = null;
        ADVKeyIndexList.prototype.currentIndex = null;
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;
        ADVKeyIndexList.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_rawId", {
            get: $util.oneOfGetter($oneOfFields = ["rawId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_currentIndex", {
            get: $util.oneOfGetter($oneOfFields = ["currentIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        ADVKeyIndexList.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                w.uint32(8).uint32(m.rawId);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(16).uint64(m.timestamp);
            if (m.currentIndex != null && Object.hasOwnProperty.call(m, "currentIndex"))
                w.uint32(24).uint32(m.currentIndex);
            if (m.validIndexes != null && m.validIndexes.length) {
                w.uint32(34).fork();
                for (var i = 0; i < m.validIndexes.length; ++i)
                    w.uint32(m.validIndexes[i]);
                w.ldelim();
            }
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(40).int32(m.accountType);
            return w;
        };

        ADVKeyIndexList.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVKeyIndexList();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.rawId = r.uint32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.uint64();
                        break;
                    }
                case 3: {
                        m.currentIndex = r.uint32();
                        break;
                    }
                case 4: {
                        if (!(m.validIndexes && m.validIndexes.length))
                            m.validIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.validIndexes.push(r.uint32());
                        } else
                            m.validIndexes.push(r.uint32());
                        break;
                    }
                case 5: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVKeyIndexList.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVKeyIndexList)
                return d;
            var m = new $root.proto.ADVKeyIndexList();
            if (d.rawId != null) {
                m.rawId = d.rawId >>> 0;
            }
            if (d.timestamp != null) {
                if ($util.Long)
                    (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = true;
                else if (typeof d.timestamp === "string")
                    m.timestamp = parseInt(d.timestamp, 10);
                else if (typeof d.timestamp === "number")
                    m.timestamp = d.timestamp;
                else if (typeof d.timestamp === "object")
                    m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber(true);
            }
            if (d.currentIndex != null) {
                m.currentIndex = d.currentIndex >>> 0;
            }
            if (d.validIndexes) {
                if (!Array.isArray(d.validIndexes))
                    throw TypeError(".proto.ADVKeyIndexList.validIndexes: array expected");
                m.validIndexes = [];
                for (var i = 0; i < d.validIndexes.length; ++i) {
                    m.validIndexes[i] = d.validIndexes[i] >>> 0;
                }
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.accountType = 1;
                break;
            }
            return m;
        };

        ADVKeyIndexList.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.validIndexes = [];
            }
            if (m.rawId != null && m.hasOwnProperty("rawId")) {
                d.rawId = m.rawId;
                if (o.oneofs)
                    d._rawId = "rawId";
            }
            if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                if (typeof m.timestamp === "number")
                    d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                else
                    d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber(true) : m.timestamp;
                if (o.oneofs)
                    d._timestamp = "timestamp";
            }
            if (m.currentIndex != null && m.hasOwnProperty("currentIndex")) {
                d.currentIndex = m.currentIndex;
                if (o.oneofs)
                    d._currentIndex = "currentIndex";
            }
            if (m.validIndexes && m.validIndexes.length) {
                d.validIndexes = [];
                for (var j = 0; j < m.validIndexes.length; ++j) {
                    d.validIndexes[j] = m.validIndexes[j];
                }
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ADVEncryptionType[m.accountType] === undefined ? m.accountType : $root.proto.ADVEncryptionType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        ADVKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVKeyIndexList";
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        function ADVSignedDeviceIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedDeviceIdentity.prototype.details = null;
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = null;
        ADVSignedDeviceIdentity.prototype.accountSignature = null;
        ADVSignedDeviceIdentity.prototype.deviceSignature = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_accountSignatureKey", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignatureKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_accountSignature", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_deviceSignature", {
            get: $util.oneOfGetter($oneOfFields = ["deviceSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        ADVSignedDeviceIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.accountSignatureKey != null && Object.hasOwnProperty.call(m, "accountSignatureKey"))
                w.uint32(18).bytes(m.accountSignatureKey);
            if (m.accountSignature != null && Object.hasOwnProperty.call(m, "accountSignature"))
                w.uint32(26).bytes(m.accountSignature);
            if (m.deviceSignature != null && Object.hasOwnProperty.call(m, "deviceSignature"))
                w.uint32(34).bytes(m.deviceSignature);
            return w;
        };

        ADVSignedDeviceIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedDeviceIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.accountSignatureKey = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountSignature = r.bytes();
                        break;
                    }
                case 4: {
                        m.deviceSignature = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedDeviceIdentity.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVSignedDeviceIdentity)
                return d;
            var m = new $root.proto.ADVSignedDeviceIdentity();
            if (d.details != null) {
                if (typeof d.details === "string")
                    $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                else if (d.details.length >= 0)
                    m.details = d.details;
            }
            if (d.accountSignatureKey != null) {
                if (typeof d.accountSignatureKey === "string")
                    $util.base64.decode(d.accountSignatureKey, m.accountSignatureKey = $util.newBuffer($util.base64.length(d.accountSignatureKey)), 0);
                else if (d.accountSignatureKey.length >= 0)
                    m.accountSignatureKey = d.accountSignatureKey;
            }
            if (d.accountSignature != null) {
                if (typeof d.accountSignature === "string")
                    $util.base64.decode(d.accountSignature, m.accountSignature = $util.newBuffer($util.base64.length(d.accountSignature)), 0);
                else if (d.accountSignature.length >= 0)
                    m.accountSignature = d.accountSignature;
            }
            if (d.deviceSignature != null) {
                if (typeof d.deviceSignature === "string")
                    $util.base64.decode(d.deviceSignature, m.deviceSignature = $util.newBuffer($util.base64.length(d.deviceSignature)), 0);
                else if (d.deviceSignature.length >= 0)
                    m.deviceSignature = d.deviceSignature;
            }
            return m;
        };

        ADVSignedDeviceIdentity.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.details != null && m.hasOwnProperty("details")) {
                d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                if (o.oneofs)
                    d._details = "details";
            }
            if (m.accountSignatureKey != null && m.hasOwnProperty("accountSignatureKey")) {
                d.accountSignatureKey = o.bytes === String ? $util.base64.encode(m.accountSignatureKey, 0, m.accountSignatureKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignatureKey) : m.accountSignatureKey;
                if (o.oneofs)
                    d._accountSignatureKey = "accountSignatureKey";
            }
            if (m.accountSignature != null && m.hasOwnProperty("accountSignature")) {
                d.accountSignature = o.bytes === String ? $util.base64.encode(m.accountSignature, 0, m.accountSignature.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignature) : m.accountSignature;
                if (o.oneofs)
                    d._accountSignature = "accountSignature";
            }
            if (m.deviceSignature != null && m.hasOwnProperty("deviceSignature")) {
                d.deviceSignature = o.bytes === String ? $util.base64.encode(m.deviceSignature, 0, m.deviceSignature.length) : o.bytes === Array ? Array.prototype.slice.call(m.deviceSignature) : m.deviceSignature;
                if (o.oneofs)
                    d._deviceSignature = "deviceSignature";
            }
            return d;
        };

        ADVSignedDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVSignedDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentity";
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        function ADVSignedDeviceIdentityHMAC(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedDeviceIdentityHMAC.prototype.details = null;
        ADVSignedDeviceIdentityHMAC.prototype.hmac = null;
        ADVSignedDeviceIdentityHMAC.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_hmac", {
            get: $util.oneOfGetter($oneOfFields = ["hmac"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        ADVSignedDeviceIdentityHMAC.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.hmac != null && Object.hasOwnProperty.call(m, "hmac"))
                w.uint32(18).bytes(m.hmac);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(24).int32(m.accountType);
            return w;
        };

        ADVSignedDeviceIdentityHMAC.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.hmac = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedDeviceIdentityHMAC.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVSignedDeviceIdentityHMAC)
                return d;
            var m = new $root.proto.ADVSignedDeviceIdentityHMAC();
            if (d.details != null) {
                if (typeof d.details === "string")
                    $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                else if (d.details.length >= 0)
                    m.details = d.details;
            }
            if (d.hmac != null) {
                if (typeof d.hmac === "string")
                    $util.base64.decode(d.hmac, m.hmac = $util.newBuffer($util.base64.length(d.hmac)), 0);
                else if (d.hmac.length >= 0)
                    m.hmac = d.hmac;
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.accountType = 1;
                break;
            }
            return m;
        };

        ADVSignedDeviceIdentityHMAC.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.details != null && m.hasOwnProperty("details")) {
                d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                if (o.oneofs)
                    d._details = "details";
            }
            if (m.hmac != null && m.hasOwnProperty("hmac")) {
                d.hmac = o.bytes === String ? $util.base64.encode(m.hmac, 0, m.hmac.length) : o.bytes === Array ? Array.prototype.slice.call(m.hmac) : m.hmac;
                if (o.oneofs)
                    d._hmac = "hmac";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ADVEncryptionType[m.accountType] === undefined ? m.accountType : $root.proto.ADVEncryptionType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        ADVSignedDeviceIdentityHMAC.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVSignedDeviceIdentityHMAC.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentityHMAC";
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        function ADVSignedKeyIndexList(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedKeyIndexList.prototype.details = null;
        ADVSignedKeyIndexList.prototype.accountSignature = null;
        ADVSignedKeyIndexList.prototype.accountSignatureKey = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_accountSignature", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_accountSignatureKey", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignatureKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        ADVSignedKeyIndexList.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.accountSignature != null && Object.hasOwnProperty.call(m, "accountSignature"))
                w.uint32(18).bytes(m.accountSignature);
            if (m.accountSignatureKey != null && Object.hasOwnProperty.call(m, "accountSignatureKey"))
                w.uint32(26).bytes(m.accountSignatureKey);
            return w;
        };

        ADVSignedKeyIndexList.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedKeyIndexList();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.accountSignature = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountSignatureKey = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedKeyIndexList.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVSignedKeyIndexList)
                return d;
            var m = new $root.proto.ADVSignedKeyIndexList();
            if (d.details != null) {
                if (typeof d.details === "string")
                    $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                else if (d.details.length >= 0)
                    m.details = d.details;
            }
            if (d.accountSignature != null) {
                if (typeof d.accountSignature === "string")
                    $util.base64.decode(d.accountSignature, m.accountSignature = $util.newBuffer($util.base64.length(d.accountSignature)), 0);
                else if (d.accountSignature.length >= 0)
                    m.accountSignature = d.accountSignature;
            }
            if (d.accountSignatureKey != null) {
                if (typeof d.accountSignatureKey === "string")
                    $util.base64.decode(d.accountSignatureKey, m.accountSignatureKey = $util.newBuffer($util.base64.length(d.accountSignatureKey)), 0);
                else if (d.accountSignatureKey.length >= 0)
                    m.accountSignatureKey = d.accountSignatureKey;
            }
            return m;
        };

        ADVSignedKeyIndexList.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.details != null && m.hasOwnProperty("details")) {
                d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                if (o.oneofs)
                    d._details = "details";
            }
            if (m.accountSignature != null && m.hasOwnProperty("accountSignature")) {
                d.accountSignature = o.bytes === String ? $util.base64.encode(m.accountSignature, 0, m.accountSignature.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignature) : m.accountSignature;
                if (o.oneofs)
                    d._accountSignature = "accountSignature";
            }
            if (m.accountSignatureKey != null && m.hasOwnProperty("accountSignatureKey")) {
                d.accountSignatureKey = o.bytes === String ? $util.base64.encode(m.accountSignatureKey, 0, m.accountSignatureKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignatureKey) : m.accountSignatureKey;
                if (o.oneofs)
                    d._accountSignatureKey = "accountSignatureKey";
            }
            return d;
        };

        ADVSignedKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVSignedKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedKeyIndexList";
        };

        return ADVSignedKeyIndexList;
    })();

    proto.AIHomeState = (function() {

        function AIHomeState(p) {
            this.capabilityOptions = [];
            this.conversationOptions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIHomeState.prototype.lastFetchTime = null;
        AIHomeState.prototype.capabilityOptions = $util.emptyArray;
        AIHomeState.prototype.conversationOptions = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIHomeState.prototype, "_lastFetchTime", {
            get: $util.oneOfGetter($oneOfFields = ["lastFetchTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIHomeState.create = function create(properties) {
            return new AIHomeState(properties);
        };

        AIHomeState.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.lastFetchTime != null && Object.hasOwnProperty.call(m, "lastFetchTime"))
                w.uint32(8).int64(m.lastFetchTime);
            if (m.capabilityOptions != null && m.capabilityOptions.length) {
                for (var i = 0; i < m.capabilityOptions.length; ++i)
                    $root.proto.AIHomeState.AIHomeOption.encode(m.capabilityOptions[i], w.uint32(18).fork()).ldelim();
            }
            if (m.conversationOptions != null && m.conversationOptions.length) {
                for (var i = 0; i < m.conversationOptions.length; ++i)
                    $root.proto.AIHomeState.AIHomeOption.encode(m.conversationOptions[i], w.uint32(26).fork()).ldelim();
            }
            return w;
        };

        AIHomeState.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIHomeState();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.lastFetchTime = r.int64();
                        break;
                    }
                case 2: {
                        if (!(m.capabilityOptions && m.capabilityOptions.length))
                            m.capabilityOptions = [];
                        m.capabilityOptions.push($root.proto.AIHomeState.AIHomeOption.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        if (!(m.conversationOptions && m.conversationOptions.length))
                            m.conversationOptions = [];
                        m.conversationOptions.push($root.proto.AIHomeState.AIHomeOption.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIHomeState.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIHomeState)
                return d;
            var m = new $root.proto.AIHomeState();
            if (d.lastFetchTime != null) {
                if ($util.Long)
                    (m.lastFetchTime = $util.Long.fromValue(d.lastFetchTime)).unsigned = false;
                else if (typeof d.lastFetchTime === "string")
                    m.lastFetchTime = parseInt(d.lastFetchTime, 10);
                else if (typeof d.lastFetchTime === "number")
                    m.lastFetchTime = d.lastFetchTime;
                else if (typeof d.lastFetchTime === "object")
                    m.lastFetchTime = new $util.LongBits(d.lastFetchTime.low >>> 0, d.lastFetchTime.high >>> 0).toNumber();
            }
            if (d.capabilityOptions) {
                if (!Array.isArray(d.capabilityOptions))
                    throw TypeError(".proto.AIHomeState.capabilityOptions: array expected");
                m.capabilityOptions = [];
                for (var i = 0; i < d.capabilityOptions.length; ++i) {
                    if (typeof d.capabilityOptions[i] !== "object")
                        throw TypeError(".proto.AIHomeState.capabilityOptions: object expected");
                    m.capabilityOptions[i] = $root.proto.AIHomeState.AIHomeOption.fromObject(d.capabilityOptions[i]);
                }
            }
            if (d.conversationOptions) {
                if (!Array.isArray(d.conversationOptions))
                    throw TypeError(".proto.AIHomeState.conversationOptions: array expected");
                m.conversationOptions = [];
                for (var i = 0; i < d.conversationOptions.length; ++i) {
                    if (typeof d.conversationOptions[i] !== "object")
                        throw TypeError(".proto.AIHomeState.conversationOptions: object expected");
                    m.conversationOptions[i] = $root.proto.AIHomeState.AIHomeOption.fromObject(d.conversationOptions[i]);
                }
            }
            return m;
        };

        AIHomeState.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.capabilityOptions = [];
                d.conversationOptions = [];
            }
            if (m.lastFetchTime != null && m.hasOwnProperty("lastFetchTime")) {
                if (typeof m.lastFetchTime === "number")
                    d.lastFetchTime = o.longs === String ? String(m.lastFetchTime) : m.lastFetchTime;
                else
                    d.lastFetchTime = o.longs === String ? $util.Long.prototype.toString.call(m.lastFetchTime) : o.longs === Number ? new $util.LongBits(m.lastFetchTime.low >>> 0, m.lastFetchTime.high >>> 0).toNumber() : m.lastFetchTime;
                if (o.oneofs)
                    d._lastFetchTime = "lastFetchTime";
            }
            if (m.capabilityOptions && m.capabilityOptions.length) {
                d.capabilityOptions = [];
                for (var j = 0; j < m.capabilityOptions.length; ++j) {
                    d.capabilityOptions[j] = $root.proto.AIHomeState.AIHomeOption.toObject(m.capabilityOptions[j], o);
                }
            }
            if (m.conversationOptions && m.conversationOptions.length) {
                d.conversationOptions = [];
                for (var j = 0; j < m.conversationOptions.length; ++j) {
                    d.conversationOptions[j] = $root.proto.AIHomeState.AIHomeOption.toObject(m.conversationOptions[j], o);
                }
            }
            return d;
        };

        AIHomeState.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIHomeState.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIHomeState";
        };

        AIHomeState.AIHomeOption = (function() {

            function AIHomeOption(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIHomeOption.prototype.type = null;
            AIHomeOption.prototype.title = null;
            AIHomeOption.prototype.promptText = null;
            AIHomeOption.prototype.sessionId = null;
            AIHomeOption.prototype.imageWdsIdentifier = null;
            AIHomeOption.prototype.imageTintColor = null;
            AIHomeOption.prototype.imageBackgroundColor = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_type", {
                get: $util.oneOfGetter($oneOfFields = ["type"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_title", {
                get: $util.oneOfGetter($oneOfFields = ["title"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_promptText", {
                get: $util.oneOfGetter($oneOfFields = ["promptText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_sessionId", {
                get: $util.oneOfGetter($oneOfFields = ["sessionId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_imageWdsIdentifier", {
                get: $util.oneOfGetter($oneOfFields = ["imageWdsIdentifier"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_imageTintColor", {
                get: $util.oneOfGetter($oneOfFields = ["imageTintColor"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIHomeOption.prototype, "_imageBackgroundColor", {
                get: $util.oneOfGetter($oneOfFields = ["imageBackgroundColor"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIHomeOption.create = function create(properties) {
                return new AIHomeOption(properties);
            };

            AIHomeOption.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(8).int32(m.type);
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(18).string(m.title);
                if (m.promptText != null && Object.hasOwnProperty.call(m, "promptText"))
                    w.uint32(26).string(m.promptText);
                if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                    w.uint32(34).string(m.sessionId);
                if (m.imageWdsIdentifier != null && Object.hasOwnProperty.call(m, "imageWdsIdentifier"))
                    w.uint32(42).string(m.imageWdsIdentifier);
                if (m.imageTintColor != null && Object.hasOwnProperty.call(m, "imageTintColor"))
                    w.uint32(50).string(m.imageTintColor);
                if (m.imageBackgroundColor != null && Object.hasOwnProperty.call(m, "imageBackgroundColor"))
                    w.uint32(58).string(m.imageBackgroundColor);
                return w;
            };

            AIHomeOption.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIHomeState.AIHomeOption();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.type = r.int32();
                            break;
                        }
                    case 2: {
                            m.title = r.string();
                            break;
                        }
                    case 3: {
                            m.promptText = r.string();
                            break;
                        }
                    case 4: {
                            m.sessionId = r.string();
                            break;
                        }
                    case 5: {
                            m.imageWdsIdentifier = r.string();
                            break;
                        }
                    case 6: {
                            m.imageTintColor = r.string();
                            break;
                        }
                    case 7: {
                            m.imageBackgroundColor = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIHomeOption.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIHomeState.AIHomeOption)
                    return d;
                var m = new $root.proto.AIHomeState.AIHomeOption();
                switch (d.type) {
                default:
                    if (typeof d.type === "number") {
                        m.type = d.type;
                        break;
                    }
                    break;
                case "PROMPT":
                case 0:
                    m.type = 0;
                    break;
                case "CREATE_IMAGE":
                case 1:
                    m.type = 1;
                    break;
                case "ANIMATE_PHOTO":
                case 2:
                    m.type = 2;
                    break;
                case "ANALYZE_FILE":
                case 3:
                    m.type = 3;
                    break;
                }
                if (d.title != null) {
                    m.title = String(d.title);
                }
                if (d.promptText != null) {
                    m.promptText = String(d.promptText);
                }
                if (d.sessionId != null) {
                    m.sessionId = String(d.sessionId);
                }
                if (d.imageWdsIdentifier != null) {
                    m.imageWdsIdentifier = String(d.imageWdsIdentifier);
                }
                if (d.imageTintColor != null) {
                    m.imageTintColor = String(d.imageTintColor);
                }
                if (d.imageBackgroundColor != null) {
                    m.imageBackgroundColor = String(d.imageBackgroundColor);
                }
                return m;
            };

            AIHomeOption.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.type != null && m.hasOwnProperty("type")) {
                    d.type = o.enums === String ? $root.proto.AIHomeState.AIHomeOption.AIHomeActionType[m.type] === undefined ? m.type : $root.proto.AIHomeState.AIHomeOption.AIHomeActionType[m.type] : m.type;
                    if (o.oneofs)
                        d._type = "type";
                }
                if (m.title != null && m.hasOwnProperty("title")) {
                    d.title = m.title;
                    if (o.oneofs)
                        d._title = "title";
                }
                if (m.promptText != null && m.hasOwnProperty("promptText")) {
                    d.promptText = m.promptText;
                    if (o.oneofs)
                        d._promptText = "promptText";
                }
                if (m.sessionId != null && m.hasOwnProperty("sessionId")) {
                    d.sessionId = m.sessionId;
                    if (o.oneofs)
                        d._sessionId = "sessionId";
                }
                if (m.imageWdsIdentifier != null && m.hasOwnProperty("imageWdsIdentifier")) {
                    d.imageWdsIdentifier = m.imageWdsIdentifier;
                    if (o.oneofs)
                        d._imageWdsIdentifier = "imageWdsIdentifier";
                }
                if (m.imageTintColor != null && m.hasOwnProperty("imageTintColor")) {
                    d.imageTintColor = m.imageTintColor;
                    if (o.oneofs)
                        d._imageTintColor = "imageTintColor";
                }
                if (m.imageBackgroundColor != null && m.hasOwnProperty("imageBackgroundColor")) {
                    d.imageBackgroundColor = m.imageBackgroundColor;
                    if (o.oneofs)
                        d._imageBackgroundColor = "imageBackgroundColor";
                }
                return d;
            };

            AIHomeOption.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIHomeOption.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIHomeState.AIHomeOption";
            };

            AIHomeOption.AIHomeActionType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "PROMPT"] = 0;
                values[valuesById[1] = "CREATE_IMAGE"] = 1;
                values[valuesById[2] = "ANIMATE_PHOTO"] = 2;
                values[valuesById[3] = "ANALYZE_FILE"] = 3;
                return values;
            })();

            return AIHomeOption;
        })();

        return AIHomeState;
    })();

    proto.AIQueryFanout = (function() {

        function AIQueryFanout(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIQueryFanout.prototype.messageKey = null;
        AIQueryFanout.prototype.message = null;
        AIQueryFanout.prototype.timestamp = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_messageKey", {
            get: $util.oneOfGetter($oneOfFields = ["messageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_message", {
            get: $util.oneOfGetter($oneOfFields = ["message"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIQueryFanout.create = function create(properties) {
            return new AIQueryFanout(properties);
        };

        AIQueryFanout.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
            if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                $root.proto.Message.encode(m.message, w.uint32(18).fork()).ldelim();
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(24).int64(m.timestamp);
            return w;
        };

        AIQueryFanout.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIQueryFanout();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.message = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.timestamp = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIQueryFanout.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIQueryFanout)
                return d;
            var m = new $root.proto.AIQueryFanout();
            if (d.messageKey != null) {
                if (typeof d.messageKey !== "object")
                    throw TypeError(".proto.AIQueryFanout.messageKey: object expected");
                m.messageKey = $root.proto.MessageKey.fromObject(d.messageKey);
            }
            if (d.message != null) {
                if (typeof d.message !== "object")
                    throw TypeError(".proto.AIQueryFanout.message: object expected");
                m.message = $root.proto.Message.fromObject(d.message);
            }
            if (d.timestamp != null) {
                if ($util.Long)
                    (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = false;
                else if (typeof d.timestamp === "string")
                    m.timestamp = parseInt(d.timestamp, 10);
                else if (typeof d.timestamp === "number")
                    m.timestamp = d.timestamp;
                else if (typeof d.timestamp === "object")
                    m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber();
            }
            return m;
        };

        AIQueryFanout.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.messageKey != null && m.hasOwnProperty("messageKey")) {
                d.messageKey = $root.proto.MessageKey.toObject(m.messageKey, o);
                if (o.oneofs)
                    d._messageKey = "messageKey";
            }
            if (m.message != null && m.hasOwnProperty("message")) {
                d.message = $root.proto.Message.toObject(m.message, o);
                if (o.oneofs)
                    d._message = "message";
            }
            if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                if (typeof m.timestamp === "number")
                    d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                else
                    d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber() : m.timestamp;
                if (o.oneofs)
                    d._timestamp = "timestamp";
            }
            return d;
        };

        AIQueryFanout.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIQueryFanout.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIQueryFanout";
        };

        return AIQueryFanout;
    })();

    proto.AIRegenerateMetadata = (function() {

        function AIRegenerateMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRegenerateMetadata.prototype.messageKey = null;
        AIRegenerateMetadata.prototype.responseTimestampMs = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRegenerateMetadata.prototype, "_messageKey", {
            get: $util.oneOfGetter($oneOfFields = ["messageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRegenerateMetadata.prototype, "_responseTimestampMs", {
            get: $util.oneOfGetter($oneOfFields = ["responseTimestampMs"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRegenerateMetadata.create = function create(properties) {
            return new AIRegenerateMetadata(properties);
        };

        AIRegenerateMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
            if (m.responseTimestampMs != null && Object.hasOwnProperty.call(m, "responseTimestampMs"))
                w.uint32(16).int64(m.responseTimestampMs);
            return w;
        };

        AIRegenerateMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRegenerateMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.responseTimestampMs = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRegenerateMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRegenerateMetadata)
                return d;
            var m = new $root.proto.AIRegenerateMetadata();
            if (d.messageKey != null) {
                if (typeof d.messageKey !== "object")
                    throw TypeError(".proto.AIRegenerateMetadata.messageKey: object expected");
                m.messageKey = $root.proto.MessageKey.fromObject(d.messageKey);
            }
            if (d.responseTimestampMs != null) {
                if ($util.Long)
                    (m.responseTimestampMs = $util.Long.fromValue(d.responseTimestampMs)).unsigned = false;
                else if (typeof d.responseTimestampMs === "string")
                    m.responseTimestampMs = parseInt(d.responseTimestampMs, 10);
                else if (typeof d.responseTimestampMs === "number")
                    m.responseTimestampMs = d.responseTimestampMs;
                else if (typeof d.responseTimestampMs === "object")
                    m.responseTimestampMs = new $util.LongBits(d.responseTimestampMs.low >>> 0, d.responseTimestampMs.high >>> 0).toNumber();
            }
            return m;
        };

        AIRegenerateMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.messageKey != null && m.hasOwnProperty("messageKey")) {
                d.messageKey = $root.proto.MessageKey.toObject(m.messageKey, o);
                if (o.oneofs)
                    d._messageKey = "messageKey";
            }
            if (m.responseTimestampMs != null && m.hasOwnProperty("responseTimestampMs")) {
                if (typeof m.responseTimestampMs === "number")
                    d.responseTimestampMs = o.longs === String ? String(m.responseTimestampMs) : m.responseTimestampMs;
                else
                    d.responseTimestampMs = o.longs === String ? $util.Long.prototype.toString.call(m.responseTimestampMs) : o.longs === Number ? new $util.LongBits(m.responseTimestampMs.low >>> 0, m.responseTimestampMs.high >>> 0).toNumber() : m.responseTimestampMs;
                if (o.oneofs)
                    d._responseTimestampMs = "responseTimestampMs";
            }
            return d;
        };

        AIRegenerateMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRegenerateMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRegenerateMetadata";
        };

        return AIRegenerateMetadata;
    })();

    proto.AIRichResponseCodeMetadata = (function() {

        function AIRichResponseCodeMetadata(p) {
            this.codeBlocks = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseCodeMetadata.prototype.codeLanguage = null;
        AIRichResponseCodeMetadata.prototype.codeBlocks = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseCodeMetadata.prototype, "_codeLanguage", {
            get: $util.oneOfGetter($oneOfFields = ["codeLanguage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseCodeMetadata.create = function create(properties) {
            return new AIRichResponseCodeMetadata(properties);
        };

        AIRichResponseCodeMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.codeLanguage != null && Object.hasOwnProperty.call(m, "codeLanguage"))
                w.uint32(10).string(m.codeLanguage);
            if (m.codeBlocks != null && m.codeBlocks.length) {
                for (var i = 0; i < m.codeBlocks.length; ++i)
                    $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.encode(m.codeBlocks[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        AIRichResponseCodeMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseCodeMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.codeLanguage = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.codeBlocks && m.codeBlocks.length))
                            m.codeBlocks = [];
                        m.codeBlocks.push($root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseCodeMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseCodeMetadata)
                return d;
            var m = new $root.proto.AIRichResponseCodeMetadata();
            if (d.codeLanguage != null) {
                m.codeLanguage = String(d.codeLanguage);
            }
            if (d.codeBlocks) {
                if (!Array.isArray(d.codeBlocks))
                    throw TypeError(".proto.AIRichResponseCodeMetadata.codeBlocks: array expected");
                m.codeBlocks = [];
                for (var i = 0; i < d.codeBlocks.length; ++i) {
                    if (typeof d.codeBlocks[i] !== "object")
                        throw TypeError(".proto.AIRichResponseCodeMetadata.codeBlocks: object expected");
                    m.codeBlocks[i] = $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.fromObject(d.codeBlocks[i]);
                }
            }
            return m;
        };

        AIRichResponseCodeMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.codeBlocks = [];
            }
            if (m.codeLanguage != null && m.hasOwnProperty("codeLanguage")) {
                d.codeLanguage = m.codeLanguage;
                if (o.oneofs)
                    d._codeLanguage = "codeLanguage";
            }
            if (m.codeBlocks && m.codeBlocks.length) {
                d.codeBlocks = [];
                for (var j = 0; j < m.codeBlocks.length; ++j) {
                    d.codeBlocks[j] = $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.toObject(m.codeBlocks[j], o);
                }
            }
            return d;
        };

        AIRichResponseCodeMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseCodeMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseCodeMetadata";
        };

        AIRichResponseCodeMetadata.AIRichResponseCodeBlock = (function() {

            function AIRichResponseCodeBlock(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseCodeBlock.prototype.highlightType = null;
            AIRichResponseCodeBlock.prototype.codeContent = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseCodeBlock.prototype, "_highlightType", {
                get: $util.oneOfGetter($oneOfFields = ["highlightType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseCodeBlock.prototype, "_codeContent", {
                get: $util.oneOfGetter($oneOfFields = ["codeContent"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseCodeBlock.create = function create(properties) {
                return new AIRichResponseCodeBlock(properties);
            };

            AIRichResponseCodeBlock.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.highlightType != null && Object.hasOwnProperty.call(m, "highlightType"))
                    w.uint32(8).int32(m.highlightType);
                if (m.codeContent != null && Object.hasOwnProperty.call(m, "codeContent"))
                    w.uint32(18).string(m.codeContent);
                return w;
            };

            AIRichResponseCodeBlock.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.highlightType = r.int32();
                            break;
                        }
                    case 2: {
                            m.codeContent = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseCodeBlock.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock)
                    return d;
                var m = new $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                switch (d.highlightType) {
                default:
                    if (typeof d.highlightType === "number") {
                        m.highlightType = d.highlightType;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT":
                case 0:
                    m.highlightType = 0;
                    break;
                case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD":
                case 1:
                    m.highlightType = 1;
                    break;
                case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD":
                case 2:
                    m.highlightType = 2;
                    break;
                case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING":
                case 3:
                    m.highlightType = 3;
                    break;
                case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER":
                case 4:
                    m.highlightType = 4;
                    break;
                case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT":
                case 5:
                    m.highlightType = 5;
                    break;
                }
                if (d.codeContent != null) {
                    m.codeContent = String(d.codeContent);
                }
                return m;
            };

            AIRichResponseCodeBlock.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.highlightType != null && m.hasOwnProperty("highlightType")) {
                    d.highlightType = o.enums === String ? $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType[m.highlightType] === undefined ? m.highlightType : $root.proto.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType[m.highlightType] : m.highlightType;
                    if (o.oneofs)
                        d._highlightType = "highlightType";
                }
                if (m.codeContent != null && m.hasOwnProperty("codeContent")) {
                    d.codeContent = m.codeContent;
                    if (o.oneofs)
                        d._codeContent = "codeContent";
                }
                return d;
            };

            AIRichResponseCodeBlock.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseCodeBlock.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseCodeMetadata.AIRichResponseCodeBlock";
            };

            return AIRichResponseCodeBlock;
        })();

        AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD"] = 1;
            values[valuesById[2] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD"] = 2;
            values[valuesById[3] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING"] = 3;
            values[valuesById[4] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER"] = 4;
            values[valuesById[5] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT"] = 5;
            return values;
        })();

        return AIRichResponseCodeMetadata;
    })();

    proto.AIRichResponseContentItemsMetadata = (function() {

        function AIRichResponseContentItemsMetadata(p) {
            this.itemsMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseContentItemsMetadata.prototype.itemsMetadata = $util.emptyArray;
        AIRichResponseContentItemsMetadata.prototype.contentType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseContentItemsMetadata.prototype, "_contentType", {
            get: $util.oneOfGetter($oneOfFields = ["contentType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseContentItemsMetadata.create = function create(properties) {
            return new AIRichResponseContentItemsMetadata(properties);
        };

        AIRichResponseContentItemsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.itemsMetadata != null && m.itemsMetadata.length) {
                for (var i = 0; i < m.itemsMetadata.length; ++i)
                    $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.encode(m.itemsMetadata[i], w.uint32(10).fork()).ldelim();
            }
            if (m.contentType != null && Object.hasOwnProperty.call(m, "contentType"))
                w.uint32(16).int32(m.contentType);
            return w;
        };

        AIRichResponseContentItemsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseContentItemsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.itemsMetadata && m.itemsMetadata.length))
                            m.itemsMetadata = [];
                        m.itemsMetadata.push($root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        m.contentType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseContentItemsMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseContentItemsMetadata)
                return d;
            var m = new $root.proto.AIRichResponseContentItemsMetadata();
            if (d.itemsMetadata) {
                if (!Array.isArray(d.itemsMetadata))
                    throw TypeError(".proto.AIRichResponseContentItemsMetadata.itemsMetadata: array expected");
                m.itemsMetadata = [];
                for (var i = 0; i < d.itemsMetadata.length; ++i) {
                    if (typeof d.itemsMetadata[i] !== "object")
                        throw TypeError(".proto.AIRichResponseContentItemsMetadata.itemsMetadata: object expected");
                    m.itemsMetadata[i] = $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.fromObject(d.itemsMetadata[i]);
                }
            }
            switch (d.contentType) {
            default:
                if (typeof d.contentType === "number") {
                    m.contentType = d.contentType;
                    break;
                }
                break;
            case "DEFAULT":
            case 0:
                m.contentType = 0;
                break;
            case "CAROUSEL":
            case 1:
                m.contentType = 1;
                break;
            }
            return m;
        };

        AIRichResponseContentItemsMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.itemsMetadata = [];
            }
            if (m.itemsMetadata && m.itemsMetadata.length) {
                d.itemsMetadata = [];
                for (var j = 0; j < m.itemsMetadata.length; ++j) {
                    d.itemsMetadata[j] = $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.toObject(m.itemsMetadata[j], o);
                }
            }
            if (m.contentType != null && m.hasOwnProperty("contentType")) {
                d.contentType = o.enums === String ? $root.proto.AIRichResponseContentItemsMetadata.ContentType[m.contentType] === undefined ? m.contentType : $root.proto.AIRichResponseContentItemsMetadata.ContentType[m.contentType] : m.contentType;
                if (o.oneofs)
                    d._contentType = "contentType";
            }
            return d;
        };

        AIRichResponseContentItemsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseContentItemsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseContentItemsMetadata";
        };

        AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata = (function() {

            function AIRichResponseContentItemMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseContentItemMetadata.prototype.reelItem = null;

            let $oneOfFields;

            Object.defineProperty(AIRichResponseContentItemMetadata.prototype, "aIRichResponseContentItem", {
                get: $util.oneOfGetter($oneOfFields = ["reelItem"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseContentItemMetadata.create = function create(properties) {
                return new AIRichResponseContentItemMetadata(properties);
            };

            AIRichResponseContentItemMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.reelItem != null && Object.hasOwnProperty.call(m, "reelItem"))
                    $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.encode(m.reelItem, w.uint32(10).fork()).ldelim();
                return w;
            };

            AIRichResponseContentItemMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.reelItem = $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseContentItemMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                if (d.reelItem != null) {
                    if (typeof d.reelItem !== "object")
                        throw TypeError(".proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.reelItem: object expected");
                    m.reelItem = $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.fromObject(d.reelItem);
                }
                return m;
            };

            AIRichResponseContentItemMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.reelItem != null && m.hasOwnProperty("reelItem")) {
                    d.reelItem = $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.toObject(m.reelItem, o);
                    if (o.oneofs)
                        d.aIRichResponseContentItem = "reelItem";
                }
                return d;
            };

            AIRichResponseContentItemMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseContentItemMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata";
            };

            return AIRichResponseContentItemMetadata;
        })();

        AIRichResponseContentItemsMetadata.AIRichResponseReelItem = (function() {

            function AIRichResponseReelItem(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseReelItem.prototype.title = null;
            AIRichResponseReelItem.prototype.profileIconUrl = null;
            AIRichResponseReelItem.prototype.thumbnailUrl = null;
            AIRichResponseReelItem.prototype.videoUrl = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseReelItem.prototype, "_title", {
                get: $util.oneOfGetter($oneOfFields = ["title"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseReelItem.prototype, "_profileIconUrl", {
                get: $util.oneOfGetter($oneOfFields = ["profileIconUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseReelItem.prototype, "_thumbnailUrl", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseReelItem.prototype, "_videoUrl", {
                get: $util.oneOfGetter($oneOfFields = ["videoUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseReelItem.create = function create(properties) {
                return new AIRichResponseReelItem(properties);
            };

            AIRichResponseReelItem.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                if (m.profileIconUrl != null && Object.hasOwnProperty.call(m, "profileIconUrl"))
                    w.uint32(18).string(m.profileIconUrl);
                if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                    w.uint32(26).string(m.thumbnailUrl);
                if (m.videoUrl != null && Object.hasOwnProperty.call(m, "videoUrl"))
                    w.uint32(34).string(m.videoUrl);
                return w;
            };

            AIRichResponseReelItem.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    case 2: {
                            m.profileIconUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.thumbnailUrl = r.string();
                            break;
                        }
                    case 4: {
                            m.videoUrl = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseReelItem.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem)
                    return d;
                var m = new $root.proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                if (d.title != null) {
                    m.title = String(d.title);
                }
                if (d.profileIconUrl != null) {
                    m.profileIconUrl = String(d.profileIconUrl);
                }
                if (d.thumbnailUrl != null) {
                    m.thumbnailUrl = String(d.thumbnailUrl);
                }
                if (d.videoUrl != null) {
                    m.videoUrl = String(d.videoUrl);
                }
                return m;
            };

            AIRichResponseReelItem.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.title != null && m.hasOwnProperty("title")) {
                    d.title = m.title;
                    if (o.oneofs)
                        d._title = "title";
                }
                if (m.profileIconUrl != null && m.hasOwnProperty("profileIconUrl")) {
                    d.profileIconUrl = m.profileIconUrl;
                    if (o.oneofs)
                        d._profileIconUrl = "profileIconUrl";
                }
                if (m.thumbnailUrl != null && m.hasOwnProperty("thumbnailUrl")) {
                    d.thumbnailUrl = m.thumbnailUrl;
                    if (o.oneofs)
                        d._thumbnailUrl = "thumbnailUrl";
                }
                if (m.videoUrl != null && m.hasOwnProperty("videoUrl")) {
                    d.videoUrl = m.videoUrl;
                    if (o.oneofs)
                        d._videoUrl = "videoUrl";
                }
                return d;
            };

            AIRichResponseReelItem.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseReelItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseContentItemsMetadata.AIRichResponseReelItem";
            };

            return AIRichResponseReelItem;
        })();

        AIRichResponseContentItemsMetadata.ContentType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "CAROUSEL"] = 1;
            return values;
        })();

        return AIRichResponseContentItemsMetadata;
    })();

    proto.AIRichResponseDynamicMetadata = (function() {

        function AIRichResponseDynamicMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseDynamicMetadata.prototype.type = null;
        AIRichResponseDynamicMetadata.prototype.version = null;
        AIRichResponseDynamicMetadata.prototype.url = null;
        AIRichResponseDynamicMetadata.prototype.loopCount = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_type", {
            get: $util.oneOfGetter($oneOfFields = ["type"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_version", {
            get: $util.oneOfGetter($oneOfFields = ["version"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_url", {
            get: $util.oneOfGetter($oneOfFields = ["url"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_loopCount", {
            get: $util.oneOfGetter($oneOfFields = ["loopCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseDynamicMetadata.create = function create(properties) {
            return new AIRichResponseDynamicMetadata(properties);
        };

        AIRichResponseDynamicMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                w.uint32(8).int32(m.type);
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                w.uint32(16).uint64(m.version);
            if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                w.uint32(26).string(m.url);
            if (m.loopCount != null && Object.hasOwnProperty.call(m, "loopCount"))
                w.uint32(32).uint32(m.loopCount);
            return w;
        };

        AIRichResponseDynamicMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseDynamicMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.type = r.int32();
                        break;
                    }
                case 2: {
                        m.version = r.uint64();
                        break;
                    }
                case 3: {
                        m.url = r.string();
                        break;
                    }
                case 4: {
                        m.loopCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseDynamicMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseDynamicMetadata)
                return d;
            var m = new $root.proto.AIRichResponseDynamicMetadata();
            switch (d.type) {
            default:
                if (typeof d.type === "number") {
                    m.type = d.type;
                    break;
                }
                break;
            case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN":
            case 0:
                m.type = 0;
                break;
            case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE":
            case 1:
                m.type = 1;
                break;
            case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF":
            case 2:
                m.type = 2;
                break;
            }
            if (d.version != null) {
                if ($util.Long)
                    (m.version = $util.Long.fromValue(d.version)).unsigned = true;
                else if (typeof d.version === "string")
                    m.version = parseInt(d.version, 10);
                else if (typeof d.version === "number")
                    m.version = d.version;
                else if (typeof d.version === "object")
                    m.version = new $util.LongBits(d.version.low >>> 0, d.version.high >>> 0).toNumber(true);
            }
            if (d.url != null) {
                m.url = String(d.url);
            }
            if (d.loopCount != null) {
                m.loopCount = d.loopCount >>> 0;
            }
            return m;
        };

        AIRichResponseDynamicMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.type != null && m.hasOwnProperty("type")) {
                d.type = o.enums === String ? $root.proto.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType[m.type] === undefined ? m.type : $root.proto.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType[m.type] : m.type;
                if (o.oneofs)
                    d._type = "type";
            }
            if (m.version != null && m.hasOwnProperty("version")) {
                if (typeof m.version === "number")
                    d.version = o.longs === String ? String(m.version) : m.version;
                else
                    d.version = o.longs === String ? $util.Long.prototype.toString.call(m.version) : o.longs === Number ? new $util.LongBits(m.version.low >>> 0, m.version.high >>> 0).toNumber(true) : m.version;
                if (o.oneofs)
                    d._version = "version";
            }
            if (m.url != null && m.hasOwnProperty("url")) {
                d.url = m.url;
                if (o.oneofs)
                    d._url = "url";
            }
            if (m.loopCount != null && m.hasOwnProperty("loopCount")) {
                d.loopCount = m.loopCount;
                if (o.oneofs)
                    d._loopCount = "loopCount";
            }
            return d;
        };

        AIRichResponseDynamicMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseDynamicMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseDynamicMetadata";
        };

        AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE"] = 1;
            values[valuesById[2] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF"] = 2;
            return values;
        })();

        return AIRichResponseDynamicMetadata;
    })();

    proto.AIRichResponseGridImageMetadata = (function() {

        function AIRichResponseGridImageMetadata(p) {
            this.imageUrls = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseGridImageMetadata.prototype.gridImageUrl = null;
        AIRichResponseGridImageMetadata.prototype.imageUrls = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseGridImageMetadata.prototype, "_gridImageUrl", {
            get: $util.oneOfGetter($oneOfFields = ["gridImageUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseGridImageMetadata.create = function create(properties) {
            return new AIRichResponseGridImageMetadata(properties);
        };

        AIRichResponseGridImageMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.gridImageUrl != null && Object.hasOwnProperty.call(m, "gridImageUrl"))
                $root.proto.AIRichResponseImageURL.encode(m.gridImageUrl, w.uint32(10).fork()).ldelim();
            if (m.imageUrls != null && m.imageUrls.length) {
                for (var i = 0; i < m.imageUrls.length; ++i)
                    $root.proto.AIRichResponseImageURL.encode(m.imageUrls[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        AIRichResponseGridImageMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseGridImageMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.gridImageUrl = $root.proto.AIRichResponseImageURL.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        if (!(m.imageUrls && m.imageUrls.length))
                            m.imageUrls = [];
                        m.imageUrls.push($root.proto.AIRichResponseImageURL.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseGridImageMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseGridImageMetadata)
                return d;
            var m = new $root.proto.AIRichResponseGridImageMetadata();
            if (d.gridImageUrl != null) {
                if (typeof d.gridImageUrl !== "object")
                    throw TypeError(".proto.AIRichResponseGridImageMetadata.gridImageUrl: object expected");
                m.gridImageUrl = $root.proto.AIRichResponseImageURL.fromObject(d.gridImageUrl);
            }
            if (d.imageUrls) {
                if (!Array.isArray(d.imageUrls))
                    throw TypeError(".proto.AIRichResponseGridImageMetadata.imageUrls: array expected");
                m.imageUrls = [];
                for (var i = 0; i < d.imageUrls.length; ++i) {
                    if (typeof d.imageUrls[i] !== "object")
                        throw TypeError(".proto.AIRichResponseGridImageMetadata.imageUrls: object expected");
                    m.imageUrls[i] = $root.proto.AIRichResponseImageURL.fromObject(d.imageUrls[i]);
                }
            }
            return m;
        };

        AIRichResponseGridImageMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.imageUrls = [];
            }
            if (m.gridImageUrl != null && m.hasOwnProperty("gridImageUrl")) {
                d.gridImageUrl = $root.proto.AIRichResponseImageURL.toObject(m.gridImageUrl, o);
                if (o.oneofs)
                    d._gridImageUrl = "gridImageUrl";
            }
            if (m.imageUrls && m.imageUrls.length) {
                d.imageUrls = [];
                for (var j = 0; j < m.imageUrls.length; ++j) {
                    d.imageUrls[j] = $root.proto.AIRichResponseImageURL.toObject(m.imageUrls[j], o);
                }
            }
            return d;
        };

        AIRichResponseGridImageMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseGridImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseGridImageMetadata";
        };

        return AIRichResponseGridImageMetadata;
    })();

    proto.AIRichResponseImageURL = (function() {

        function AIRichResponseImageURL(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseImageURL.prototype.imagePreviewUrl = null;
        AIRichResponseImageURL.prototype.imageHighResUrl = null;
        AIRichResponseImageURL.prototype.sourceUrl = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseImageURL.prototype, "_imagePreviewUrl", {
            get: $util.oneOfGetter($oneOfFields = ["imagePreviewUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseImageURL.prototype, "_imageHighResUrl", {
            get: $util.oneOfGetter($oneOfFields = ["imageHighResUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseImageURL.prototype, "_sourceUrl", {
            get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseImageURL.create = function create(properties) {
            return new AIRichResponseImageURL(properties);
        };

        AIRichResponseImageURL.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.imagePreviewUrl != null && Object.hasOwnProperty.call(m, "imagePreviewUrl"))
                w.uint32(10).string(m.imagePreviewUrl);
            if (m.imageHighResUrl != null && Object.hasOwnProperty.call(m, "imageHighResUrl"))
                w.uint32(18).string(m.imageHighResUrl);
            if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                w.uint32(26).string(m.sourceUrl);
            return w;
        };

        AIRichResponseImageURL.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseImageURL();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.imagePreviewUrl = r.string();
                        break;
                    }
                case 2: {
                        m.imageHighResUrl = r.string();
                        break;
                    }
                case 3: {
                        m.sourceUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseImageURL.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseImageURL)
                return d;
            var m = new $root.proto.AIRichResponseImageURL();
            if (d.imagePreviewUrl != null) {
                m.imagePreviewUrl = String(d.imagePreviewUrl);
            }
            if (d.imageHighResUrl != null) {
                m.imageHighResUrl = String(d.imageHighResUrl);
            }
            if (d.sourceUrl != null) {
                m.sourceUrl = String(d.sourceUrl);
            }
            return m;
        };

        AIRichResponseImageURL.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.imagePreviewUrl != null && m.hasOwnProperty("imagePreviewUrl")) {
                d.imagePreviewUrl = m.imagePreviewUrl;
                if (o.oneofs)
                    d._imagePreviewUrl = "imagePreviewUrl";
            }
            if (m.imageHighResUrl != null && m.hasOwnProperty("imageHighResUrl")) {
                d.imageHighResUrl = m.imageHighResUrl;
                if (o.oneofs)
                    d._imageHighResUrl = "imageHighResUrl";
            }
            if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                d.sourceUrl = m.sourceUrl;
                if (o.oneofs)
                    d._sourceUrl = "sourceUrl";
            }
            return d;
        };

        AIRichResponseImageURL.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseImageURL.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseImageURL";
        };

        return AIRichResponseImageURL;
    })();

    proto.AIRichResponseInlineImageMetadata = (function() {

        function AIRichResponseInlineImageMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseInlineImageMetadata.prototype.imageUrl = null;
        AIRichResponseInlineImageMetadata.prototype.imageText = null;
        AIRichResponseInlineImageMetadata.prototype.alignment = null;
        AIRichResponseInlineImageMetadata.prototype.tapLinkUrl = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_imageUrl", {
            get: $util.oneOfGetter($oneOfFields = ["imageUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_imageText", {
            get: $util.oneOfGetter($oneOfFields = ["imageText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_alignment", {
            get: $util.oneOfGetter($oneOfFields = ["alignment"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_tapLinkUrl", {
            get: $util.oneOfGetter($oneOfFields = ["tapLinkUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseInlineImageMetadata.create = function create(properties) {
            return new AIRichResponseInlineImageMetadata(properties);
        };

        AIRichResponseInlineImageMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.imageUrl != null && Object.hasOwnProperty.call(m, "imageUrl"))
                $root.proto.AIRichResponseImageURL.encode(m.imageUrl, w.uint32(10).fork()).ldelim();
            if (m.imageText != null && Object.hasOwnProperty.call(m, "imageText"))
                w.uint32(18).string(m.imageText);
            if (m.alignment != null && Object.hasOwnProperty.call(m, "alignment"))
                w.uint32(24).int32(m.alignment);
            if (m.tapLinkUrl != null && Object.hasOwnProperty.call(m, "tapLinkUrl"))
                w.uint32(34).string(m.tapLinkUrl);
            return w;
        };

        AIRichResponseInlineImageMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseInlineImageMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.imageUrl = $root.proto.AIRichResponseImageURL.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.imageText = r.string();
                        break;
                    }
                case 3: {
                        m.alignment = r.int32();
                        break;
                    }
                case 4: {
                        m.tapLinkUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseInlineImageMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseInlineImageMetadata)
                return d;
            var m = new $root.proto.AIRichResponseInlineImageMetadata();
            if (d.imageUrl != null) {
                if (typeof d.imageUrl !== "object")
                    throw TypeError(".proto.AIRichResponseInlineImageMetadata.imageUrl: object expected");
                m.imageUrl = $root.proto.AIRichResponseImageURL.fromObject(d.imageUrl);
            }
            if (d.imageText != null) {
                m.imageText = String(d.imageText);
            }
            switch (d.alignment) {
            default:
                if (typeof d.alignment === "number") {
                    m.alignment = d.alignment;
                    break;
                }
                break;
            case "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED":
            case 0:
                m.alignment = 0;
                break;
            case "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED":
            case 1:
                m.alignment = 1;
                break;
            case "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED":
            case 2:
                m.alignment = 2;
                break;
            }
            if (d.tapLinkUrl != null) {
                m.tapLinkUrl = String(d.tapLinkUrl);
            }
            return m;
        };

        AIRichResponseInlineImageMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.imageUrl != null && m.hasOwnProperty("imageUrl")) {
                d.imageUrl = $root.proto.AIRichResponseImageURL.toObject(m.imageUrl, o);
                if (o.oneofs)
                    d._imageUrl = "imageUrl";
            }
            if (m.imageText != null && m.hasOwnProperty("imageText")) {
                d.imageText = m.imageText;
                if (o.oneofs)
                    d._imageText = "imageText";
            }
            if (m.alignment != null && m.hasOwnProperty("alignment")) {
                d.alignment = o.enums === String ? $root.proto.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment[m.alignment] === undefined ? m.alignment : $root.proto.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment[m.alignment] : m.alignment;
                if (o.oneofs)
                    d._alignment = "alignment";
            }
            if (m.tapLinkUrl != null && m.hasOwnProperty("tapLinkUrl")) {
                d.tapLinkUrl = m.tapLinkUrl;
                if (o.oneofs)
                    d._tapLinkUrl = "tapLinkUrl";
            }
            return d;
        };

        AIRichResponseInlineImageMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseInlineImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseInlineImageMetadata";
        };

        AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED"] = 1;
            values[valuesById[2] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED"] = 2;
            return values;
        })();

        return AIRichResponseInlineImageMetadata;
    })();

    proto.AIRichResponseLatexMetadata = (function() {

        function AIRichResponseLatexMetadata(p) {
            this.expressions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseLatexMetadata.prototype.text = null;
        AIRichResponseLatexMetadata.prototype.expressions = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseLatexMetadata.prototype, "_text", {
            get: $util.oneOfGetter($oneOfFields = ["text"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseLatexMetadata.create = function create(properties) {
            return new AIRichResponseLatexMetadata(properties);
        };

        AIRichResponseLatexMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                w.uint32(10).string(m.text);
            if (m.expressions != null && m.expressions.length) {
                for (var i = 0; i < m.expressions.length; ++i)
                    $root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.encode(m.expressions[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        AIRichResponseLatexMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseLatexMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.text = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.expressions && m.expressions.length))
                            m.expressions = [];
                        m.expressions.push($root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseLatexMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseLatexMetadata)
                return d;
            var m = new $root.proto.AIRichResponseLatexMetadata();
            if (d.text != null) {
                m.text = String(d.text);
            }
            if (d.expressions) {
                if (!Array.isArray(d.expressions))
                    throw TypeError(".proto.AIRichResponseLatexMetadata.expressions: array expected");
                m.expressions = [];
                for (var i = 0; i < d.expressions.length; ++i) {
                    if (typeof d.expressions[i] !== "object")
                        throw TypeError(".proto.AIRichResponseLatexMetadata.expressions: object expected");
                    m.expressions[i] = $root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.fromObject(d.expressions[i]);
                }
            }
            return m;
        };

        AIRichResponseLatexMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.expressions = [];
            }
            if (m.text != null && m.hasOwnProperty("text")) {
                d.text = m.text;
                if (o.oneofs)
                    d._text = "text";
            }
            if (m.expressions && m.expressions.length) {
                d.expressions = [];
                for (var j = 0; j < m.expressions.length; ++j) {
                    d.expressions[j] = $root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.toObject(m.expressions[j], o);
                }
            }
            return d;
        };

        AIRichResponseLatexMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseLatexMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseLatexMetadata";
        };

        AIRichResponseLatexMetadata.AIRichResponseLatexExpression = (function() {

            function AIRichResponseLatexExpression(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseLatexExpression.prototype.latexExpression = null;
            AIRichResponseLatexExpression.prototype.url = null;
            AIRichResponseLatexExpression.prototype.width = null;
            AIRichResponseLatexExpression.prototype.height = null;
            AIRichResponseLatexExpression.prototype.fontHeight = null;
            AIRichResponseLatexExpression.prototype.imageTopPadding = null;
            AIRichResponseLatexExpression.prototype.imageLeadingPadding = null;
            AIRichResponseLatexExpression.prototype.imageBottomPadding = null;
            AIRichResponseLatexExpression.prototype.imageTrailingPadding = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_latexExpression", {
                get: $util.oneOfGetter($oneOfFields = ["latexExpression"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_url", {
                get: $util.oneOfGetter($oneOfFields = ["url"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_width", {
                get: $util.oneOfGetter($oneOfFields = ["width"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_height", {
                get: $util.oneOfGetter($oneOfFields = ["height"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_fontHeight", {
                get: $util.oneOfGetter($oneOfFields = ["fontHeight"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageTopPadding", {
                get: $util.oneOfGetter($oneOfFields = ["imageTopPadding"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageLeadingPadding", {
                get: $util.oneOfGetter($oneOfFields = ["imageLeadingPadding"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageBottomPadding", {
                get: $util.oneOfGetter($oneOfFields = ["imageBottomPadding"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageTrailingPadding", {
                get: $util.oneOfGetter($oneOfFields = ["imageTrailingPadding"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseLatexExpression.create = function create(properties) {
                return new AIRichResponseLatexExpression(properties);
            };

            AIRichResponseLatexExpression.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.latexExpression != null && Object.hasOwnProperty.call(m, "latexExpression"))
                    w.uint32(10).string(m.latexExpression);
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(18).string(m.url);
                if (m.width != null && Object.hasOwnProperty.call(m, "width"))
                    w.uint32(25).double(m.width);
                if (m.height != null && Object.hasOwnProperty.call(m, "height"))
                    w.uint32(33).double(m.height);
                if (m.fontHeight != null && Object.hasOwnProperty.call(m, "fontHeight"))
                    w.uint32(41).double(m.fontHeight);
                if (m.imageTopPadding != null && Object.hasOwnProperty.call(m, "imageTopPadding"))
                    w.uint32(49).double(m.imageTopPadding);
                if (m.imageLeadingPadding != null && Object.hasOwnProperty.call(m, "imageLeadingPadding"))
                    w.uint32(57).double(m.imageLeadingPadding);
                if (m.imageBottomPadding != null && Object.hasOwnProperty.call(m, "imageBottomPadding"))
                    w.uint32(65).double(m.imageBottomPadding);
                if (m.imageTrailingPadding != null && Object.hasOwnProperty.call(m, "imageTrailingPadding"))
                    w.uint32(73).double(m.imageTrailingPadding);
                return w;
            };

            AIRichResponseLatexExpression.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.latexExpression = r.string();
                            break;
                        }
                    case 2: {
                            m.url = r.string();
                            break;
                        }
                    case 3: {
                            m.width = r.double();
                            break;
                        }
                    case 4: {
                            m.height = r.double();
                            break;
                        }
                    case 5: {
                            m.fontHeight = r.double();
                            break;
                        }
                    case 6: {
                            m.imageTopPadding = r.double();
                            break;
                        }
                    case 7: {
                            m.imageLeadingPadding = r.double();
                            break;
                        }
                    case 8: {
                            m.imageBottomPadding = r.double();
                            break;
                        }
                    case 9: {
                            m.imageTrailingPadding = r.double();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseLatexExpression.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression)
                    return d;
                var m = new $root.proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                if (d.latexExpression != null) {
                    m.latexExpression = String(d.latexExpression);
                }
                if (d.url != null) {
                    m.url = String(d.url);
                }
                if (d.width != null) {
                    m.width = Number(d.width);
                }
                if (d.height != null) {
                    m.height = Number(d.height);
                }
                if (d.fontHeight != null) {
                    m.fontHeight = Number(d.fontHeight);
                }
                if (d.imageTopPadding != null) {
                    m.imageTopPadding = Number(d.imageTopPadding);
                }
                if (d.imageLeadingPadding != null) {
                    m.imageLeadingPadding = Number(d.imageLeadingPadding);
                }
                if (d.imageBottomPadding != null) {
                    m.imageBottomPadding = Number(d.imageBottomPadding);
                }
                if (d.imageTrailingPadding != null) {
                    m.imageTrailingPadding = Number(d.imageTrailingPadding);
                }
                return m;
            };

            AIRichResponseLatexExpression.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.latexExpression != null && m.hasOwnProperty("latexExpression")) {
                    d.latexExpression = m.latexExpression;
                    if (o.oneofs)
                        d._latexExpression = "latexExpression";
                }
                if (m.url != null && m.hasOwnProperty("url")) {
                    d.url = m.url;
                    if (o.oneofs)
                        d._url = "url";
                }
                if (m.width != null && m.hasOwnProperty("width")) {
                    d.width = o.json && !isFinite(m.width) ? String(m.width) : m.width;
                    if (o.oneofs)
                        d._width = "width";
                }
                if (m.height != null && m.hasOwnProperty("height")) {
                    d.height = o.json && !isFinite(m.height) ? String(m.height) : m.height;
                    if (o.oneofs)
                        d._height = "height";
                }
                if (m.fontHeight != null && m.hasOwnProperty("fontHeight")) {
                    d.fontHeight = o.json && !isFinite(m.fontHeight) ? String(m.fontHeight) : m.fontHeight;
                    if (o.oneofs)
                        d._fontHeight = "fontHeight";
                }
                if (m.imageTopPadding != null && m.hasOwnProperty("imageTopPadding")) {
                    d.imageTopPadding = o.json && !isFinite(m.imageTopPadding) ? String(m.imageTopPadding) : m.imageTopPadding;
                    if (o.oneofs)
                        d._imageTopPadding = "imageTopPadding";
                }
                if (m.imageLeadingPadding != null && m.hasOwnProperty("imageLeadingPadding")) {
                    d.imageLeadingPadding = o.json && !isFinite(m.imageLeadingPadding) ? String(m.imageLeadingPadding) : m.imageLeadingPadding;
                    if (o.oneofs)
                        d._imageLeadingPadding = "imageLeadingPadding";
                }
                if (m.imageBottomPadding != null && m.hasOwnProperty("imageBottomPadding")) {
                    d.imageBottomPadding = o.json && !isFinite(m.imageBottomPadding) ? String(m.imageBottomPadding) : m.imageBottomPadding;
                    if (o.oneofs)
                        d._imageBottomPadding = "imageBottomPadding";
                }
                if (m.imageTrailingPadding != null && m.hasOwnProperty("imageTrailingPadding")) {
                    d.imageTrailingPadding = o.json && !isFinite(m.imageTrailingPadding) ? String(m.imageTrailingPadding) : m.imageTrailingPadding;
                    if (o.oneofs)
                        d._imageTrailingPadding = "imageTrailingPadding";
                }
                return d;
            };

            AIRichResponseLatexExpression.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseLatexExpression.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseLatexMetadata.AIRichResponseLatexExpression";
            };

            return AIRichResponseLatexExpression;
        })();

        return AIRichResponseLatexMetadata;
    })();

    proto.AIRichResponseMapMetadata = (function() {

        function AIRichResponseMapMetadata(p) {
            this.annotations = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseMapMetadata.prototype.centerLatitude = null;
        AIRichResponseMapMetadata.prototype.centerLongitude = null;
        AIRichResponseMapMetadata.prototype.latitudeDelta = null;
        AIRichResponseMapMetadata.prototype.longitudeDelta = null;
        AIRichResponseMapMetadata.prototype.annotations = $util.emptyArray;
        AIRichResponseMapMetadata.prototype.showInfoList = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMapMetadata.prototype, "_centerLatitude", {
            get: $util.oneOfGetter($oneOfFields = ["centerLatitude"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMapMetadata.prototype, "_centerLongitude", {
            get: $util.oneOfGetter($oneOfFields = ["centerLongitude"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMapMetadata.prototype, "_latitudeDelta", {
            get: $util.oneOfGetter($oneOfFields = ["latitudeDelta"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMapMetadata.prototype, "_longitudeDelta", {
            get: $util.oneOfGetter($oneOfFields = ["longitudeDelta"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMapMetadata.prototype, "_showInfoList", {
            get: $util.oneOfGetter($oneOfFields = ["showInfoList"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseMapMetadata.create = function create(properties) {
            return new AIRichResponseMapMetadata(properties);
        };

        AIRichResponseMapMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.centerLatitude != null && Object.hasOwnProperty.call(m, "centerLatitude"))
                w.uint32(9).double(m.centerLatitude);
            if (m.centerLongitude != null && Object.hasOwnProperty.call(m, "centerLongitude"))
                w.uint32(17).double(m.centerLongitude);
            if (m.latitudeDelta != null && Object.hasOwnProperty.call(m, "latitudeDelta"))
                w.uint32(25).double(m.latitudeDelta);
            if (m.longitudeDelta != null && Object.hasOwnProperty.call(m, "longitudeDelta"))
                w.uint32(33).double(m.longitudeDelta);
            if (m.annotations != null && m.annotations.length) {
                for (var i = 0; i < m.annotations.length; ++i)
                    $root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.encode(m.annotations[i], w.uint32(42).fork()).ldelim();
            }
            if (m.showInfoList != null && Object.hasOwnProperty.call(m, "showInfoList"))
                w.uint32(48).bool(m.showInfoList);
            return w;
        };

        AIRichResponseMapMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMapMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.centerLatitude = r.double();
                        break;
                    }
                case 2: {
                        m.centerLongitude = r.double();
                        break;
                    }
                case 3: {
                        m.latitudeDelta = r.double();
                        break;
                    }
                case 4: {
                        m.longitudeDelta = r.double();
                        break;
                    }
                case 5: {
                        if (!(m.annotations && m.annotations.length))
                            m.annotations = [];
                        m.annotations.push($root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.decode(r, r.uint32()));
                        break;
                    }
                case 6: {
                        m.showInfoList = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseMapMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseMapMetadata)
                return d;
            var m = new $root.proto.AIRichResponseMapMetadata();
            if (d.centerLatitude != null) {
                m.centerLatitude = Number(d.centerLatitude);
            }
            if (d.centerLongitude != null) {
                m.centerLongitude = Number(d.centerLongitude);
            }
            if (d.latitudeDelta != null) {
                m.latitudeDelta = Number(d.latitudeDelta);
            }
            if (d.longitudeDelta != null) {
                m.longitudeDelta = Number(d.longitudeDelta);
            }
            if (d.annotations) {
                if (!Array.isArray(d.annotations))
                    throw TypeError(".proto.AIRichResponseMapMetadata.annotations: array expected");
                m.annotations = [];
                for (var i = 0; i < d.annotations.length; ++i) {
                    if (typeof d.annotations[i] !== "object")
                        throw TypeError(".proto.AIRichResponseMapMetadata.annotations: object expected");
                    m.annotations[i] = $root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.fromObject(d.annotations[i]);
                }
            }
            if (d.showInfoList != null) {
                m.showInfoList = Boolean(d.showInfoList);
            }
            return m;
        };

        AIRichResponseMapMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.annotations = [];
            }
            if (m.centerLatitude != null && m.hasOwnProperty("centerLatitude")) {
                d.centerLatitude = o.json && !isFinite(m.centerLatitude) ? String(m.centerLatitude) : m.centerLatitude;
                if (o.oneofs)
                    d._centerLatitude = "centerLatitude";
            }
            if (m.centerLongitude != null && m.hasOwnProperty("centerLongitude")) {
                d.centerLongitude = o.json && !isFinite(m.centerLongitude) ? String(m.centerLongitude) : m.centerLongitude;
                if (o.oneofs)
                    d._centerLongitude = "centerLongitude";
            }
            if (m.latitudeDelta != null && m.hasOwnProperty("latitudeDelta")) {
                d.latitudeDelta = o.json && !isFinite(m.latitudeDelta) ? String(m.latitudeDelta) : m.latitudeDelta;
                if (o.oneofs)
                    d._latitudeDelta = "latitudeDelta";
            }
            if (m.longitudeDelta != null && m.hasOwnProperty("longitudeDelta")) {
                d.longitudeDelta = o.json && !isFinite(m.longitudeDelta) ? String(m.longitudeDelta) : m.longitudeDelta;
                if (o.oneofs)
                    d._longitudeDelta = "longitudeDelta";
            }
            if (m.annotations && m.annotations.length) {
                d.annotations = [];
                for (var j = 0; j < m.annotations.length; ++j) {
                    d.annotations[j] = $root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.toObject(m.annotations[j], o);
                }
            }
            if (m.showInfoList != null && m.hasOwnProperty("showInfoList")) {
                d.showInfoList = m.showInfoList;
                if (o.oneofs)
                    d._showInfoList = "showInfoList";
            }
            return d;
        };

        AIRichResponseMapMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseMapMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseMapMetadata";
        };

        AIRichResponseMapMetadata.AIRichResponseMapAnnotation = (function() {

            function AIRichResponseMapAnnotation(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseMapAnnotation.prototype.annotationNumber = null;
            AIRichResponseMapAnnotation.prototype.latitude = null;
            AIRichResponseMapAnnotation.prototype.longitude = null;
            AIRichResponseMapAnnotation.prototype.title = null;
            AIRichResponseMapAnnotation.prototype.body = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_annotationNumber", {
                get: $util.oneOfGetter($oneOfFields = ["annotationNumber"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_latitude", {
                get: $util.oneOfGetter($oneOfFields = ["latitude"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_longitude", {
                get: $util.oneOfGetter($oneOfFields = ["longitude"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_title", {
                get: $util.oneOfGetter($oneOfFields = ["title"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_body", {
                get: $util.oneOfGetter($oneOfFields = ["body"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseMapAnnotation.create = function create(properties) {
                return new AIRichResponseMapAnnotation(properties);
            };

            AIRichResponseMapAnnotation.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.annotationNumber != null && Object.hasOwnProperty.call(m, "annotationNumber"))
                    w.uint32(8).uint32(m.annotationNumber);
                if (m.latitude != null && Object.hasOwnProperty.call(m, "latitude"))
                    w.uint32(17).double(m.latitude);
                if (m.longitude != null && Object.hasOwnProperty.call(m, "longitude"))
                    w.uint32(25).double(m.longitude);
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(34).string(m.title);
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    w.uint32(42).string(m.body);
                return w;
            };

            AIRichResponseMapAnnotation.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.annotationNumber = r.uint32();
                            break;
                        }
                    case 2: {
                            m.latitude = r.double();
                            break;
                        }
                    case 3: {
                            m.longitude = r.double();
                            break;
                        }
                    case 4: {
                            m.title = r.string();
                            break;
                        }
                    case 5: {
                            m.body = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseMapAnnotation.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation)
                    return d;
                var m = new $root.proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                if (d.annotationNumber != null) {
                    m.annotationNumber = d.annotationNumber >>> 0;
                }
                if (d.latitude != null) {
                    m.latitude = Number(d.latitude);
                }
                if (d.longitude != null) {
                    m.longitude = Number(d.longitude);
                }
                if (d.title != null) {
                    m.title = String(d.title);
                }
                if (d.body != null) {
                    m.body = String(d.body);
                }
                return m;
            };

            AIRichResponseMapAnnotation.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.annotationNumber != null && m.hasOwnProperty("annotationNumber")) {
                    d.annotationNumber = m.annotationNumber;
                    if (o.oneofs)
                        d._annotationNumber = "annotationNumber";
                }
                if (m.latitude != null && m.hasOwnProperty("latitude")) {
                    d.latitude = o.json && !isFinite(m.latitude) ? String(m.latitude) : m.latitude;
                    if (o.oneofs)
                        d._latitude = "latitude";
                }
                if (m.longitude != null && m.hasOwnProperty("longitude")) {
                    d.longitude = o.json && !isFinite(m.longitude) ? String(m.longitude) : m.longitude;
                    if (o.oneofs)
                        d._longitude = "longitude";
                }
                if (m.title != null && m.hasOwnProperty("title")) {
                    d.title = m.title;
                    if (o.oneofs)
                        d._title = "title";
                }
                if (m.body != null && m.hasOwnProperty("body")) {
                    d.body = m.body;
                    if (o.oneofs)
                        d._body = "body";
                }
                return d;
            };

            AIRichResponseMapAnnotation.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseMapAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMapMetadata.AIRichResponseMapAnnotation";
            };

            return AIRichResponseMapAnnotation;
        })();

        return AIRichResponseMapMetadata;
    })();

    proto.AIRichResponseMessage = (function() {

        function AIRichResponseMessage(p) {
            this.submessages = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseMessage.prototype.messageType = null;
        AIRichResponseMessage.prototype.submessages = $util.emptyArray;
        AIRichResponseMessage.prototype.unifiedResponse = null;
        AIRichResponseMessage.prototype.contextInfo = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_messageType", {
            get: $util.oneOfGetter($oneOfFields = ["messageType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_unifiedResponse", {
            get: $util.oneOfGetter($oneOfFields = ["unifiedResponse"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_contextInfo", {
            get: $util.oneOfGetter($oneOfFields = ["contextInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseMessage.create = function create(properties) {
            return new AIRichResponseMessage(properties);
        };

        AIRichResponseMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageType != null && Object.hasOwnProperty.call(m, "messageType"))
                w.uint32(8).int32(m.messageType);
            if (m.submessages != null && m.submessages.length) {
                for (var i = 0; i < m.submessages.length; ++i)
                    $root.proto.AIRichResponseSubMessage.encode(m.submessages[i], w.uint32(18).fork()).ldelim();
            }
            if (m.unifiedResponse != null && Object.hasOwnProperty.call(m, "unifiedResponse"))
                $root.proto.AIRichResponseUnifiedResponse.encode(m.unifiedResponse, w.uint32(26).fork()).ldelim();
            if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(34).fork()).ldelim();
            return w;
        };

        AIRichResponseMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageType = r.int32();
                        break;
                    }
                case 2: {
                        if (!(m.submessages && m.submessages.length))
                            m.submessages = [];
                        m.submessages.push($root.proto.AIRichResponseSubMessage.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.unifiedResponse = $root.proto.AIRichResponseUnifiedResponse.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseMessage.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseMessage)
                return d;
            var m = new $root.proto.AIRichResponseMessage();
            switch (d.messageType) {
            default:
                if (typeof d.messageType === "number") {
                    m.messageType = d.messageType;
                    break;
                }
                break;
            case "AI_RICH_RESPONSE_TYPE_UNKNOWN":
            case 0:
                m.messageType = 0;
                break;
            case "AI_RICH_RESPONSE_TYPE_STANDARD":
            case 1:
                m.messageType = 1;
                break;
            }
            if (d.submessages) {
                if (!Array.isArray(d.submessages))
                    throw TypeError(".proto.AIRichResponseMessage.submessages: array expected");
                m.submessages = [];
                for (var i = 0; i < d.submessages.length; ++i) {
                    if (typeof d.submessages[i] !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.submessages: object expected");
                    m.submessages[i] = $root.proto.AIRichResponseSubMessage.fromObject(d.submessages[i]);
                }
            }
            if (d.unifiedResponse != null) {
                if (typeof d.unifiedResponse !== "object")
                    throw TypeError(".proto.AIRichResponseMessage.unifiedResponse: object expected");
                m.unifiedResponse = $root.proto.AIRichResponseUnifiedResponse.fromObject(d.unifiedResponse);
            }
            if (d.contextInfo != null) {
                if (typeof d.contextInfo !== "object")
                    throw TypeError(".proto.AIRichResponseMessage.contextInfo: object expected");
                m.contextInfo = $root.proto.ContextInfo.fromObject(d.contextInfo);
            }
            return m;
        };

        AIRichResponseMessage.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.submessages = [];
            }
            if (m.messageType != null && m.hasOwnProperty("messageType")) {
                d.messageType = o.enums === String ? $root.proto.AIRichResponseMessageType[m.messageType] === undefined ? m.messageType : $root.proto.AIRichResponseMessageType[m.messageType] : m.messageType;
                if (o.oneofs)
                    d._messageType = "messageType";
            }
            if (m.submessages && m.submessages.length) {
                d.submessages = [];
                for (var j = 0; j < m.submessages.length; ++j) {
                    d.submessages[j] = $root.proto.AIRichResponseSubMessage.toObject(m.submessages[j], o);
                }
            }
            if (m.unifiedResponse != null && m.hasOwnProperty("unifiedResponse")) {
                d.unifiedResponse = $root.proto.AIRichResponseUnifiedResponse.toObject(m.unifiedResponse, o);
                if (o.oneofs)
                    d._unifiedResponse = "unifiedResponse";
            }
            if (m.contextInfo != null && m.hasOwnProperty("contextInfo")) {
                d.contextInfo = $root.proto.ContextInfo.toObject(m.contextInfo, o);
                if (o.oneofs)
                    d._contextInfo = "contextInfo";
            }
            return d;
        };

        AIRichResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseMessage";
        };

        return AIRichResponseMessage;
    })();

    proto.AIRichResponseMessageType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "AI_RICH_RESPONSE_TYPE_UNKNOWN"] = 0;
        values[valuesById[1] = "AI_RICH_RESPONSE_TYPE_STANDARD"] = 1;
        return values;
    })();

    proto.AIRichResponseSubMessage = (function() {

        function AIRichResponseSubMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseSubMessage.prototype.messageType = null;
        AIRichResponseSubMessage.prototype.gridImageMetadata = null;
        AIRichResponseSubMessage.prototype.messageText = null;
        AIRichResponseSubMessage.prototype.imageMetadata = null;
        AIRichResponseSubMessage.prototype.codeMetadata = null;
        AIRichResponseSubMessage.prototype.tableMetadata = null;
        AIRichResponseSubMessage.prototype.dynamicMetadata = null;
        AIRichResponseSubMessage.prototype.latexMetadata = null;
        AIRichResponseSubMessage.prototype.mapMetadata = null;
        AIRichResponseSubMessage.prototype.contentItemsMetadata = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_messageType", {
            get: $util.oneOfGetter($oneOfFields = ["messageType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_gridImageMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["gridImageMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_messageText", {
            get: $util.oneOfGetter($oneOfFields = ["messageText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_imageMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["imageMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_codeMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["codeMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_tableMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["tableMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_dynamicMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["dynamicMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_latexMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["latexMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_mapMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["mapMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseSubMessage.prototype, "_contentItemsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["contentItemsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseSubMessage.create = function create(properties) {
            return new AIRichResponseSubMessage(properties);
        };

        AIRichResponseSubMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageType != null && Object.hasOwnProperty.call(m, "messageType"))
                w.uint32(8).int32(m.messageType);
            if (m.gridImageMetadata != null && Object.hasOwnProperty.call(m, "gridImageMetadata"))
                $root.proto.AIRichResponseGridImageMetadata.encode(m.gridImageMetadata, w.uint32(18).fork()).ldelim();
            if (m.messageText != null && Object.hasOwnProperty.call(m, "messageText"))
                w.uint32(26).string(m.messageText);
            if (m.imageMetadata != null && Object.hasOwnProperty.call(m, "imageMetadata"))
                $root.proto.AIRichResponseInlineImageMetadata.encode(m.imageMetadata, w.uint32(34).fork()).ldelim();
            if (m.codeMetadata != null && Object.hasOwnProperty.call(m, "codeMetadata"))
                $root.proto.AIRichResponseCodeMetadata.encode(m.codeMetadata, w.uint32(42).fork()).ldelim();
            if (m.tableMetadata != null && Object.hasOwnProperty.call(m, "tableMetadata"))
                $root.proto.AIRichResponseTableMetadata.encode(m.tableMetadata, w.uint32(50).fork()).ldelim();
            if (m.dynamicMetadata != null && Object.hasOwnProperty.call(m, "dynamicMetadata"))
                $root.proto.AIRichResponseDynamicMetadata.encode(m.dynamicMetadata, w.uint32(58).fork()).ldelim();
            if (m.latexMetadata != null && Object.hasOwnProperty.call(m, "latexMetadata"))
                $root.proto.AIRichResponseLatexMetadata.encode(m.latexMetadata, w.uint32(66).fork()).ldelim();
            if (m.mapMetadata != null && Object.hasOwnProperty.call(m, "mapMetadata"))
                $root.proto.AIRichResponseMapMetadata.encode(m.mapMetadata, w.uint32(74).fork()).ldelim();
            if (m.contentItemsMetadata != null && Object.hasOwnProperty.call(m, "contentItemsMetadata"))
                $root.proto.AIRichResponseContentItemsMetadata.encode(m.contentItemsMetadata, w.uint32(82).fork()).ldelim();
            return w;
        };

        AIRichResponseSubMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseSubMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageType = r.int32();
                        break;
                    }
                case 2: {
                        m.gridImageMetadata = $root.proto.AIRichResponseGridImageMetadata.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.messageText = r.string();
                        break;
                    }
                case 4: {
                        m.imageMetadata = $root.proto.AIRichResponseInlineImageMetadata.decode(r, r.uint32());
                        break;
                    }
                case 5: {
                        m.codeMetadata = $root.proto.AIRichResponseCodeMetadata.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.tableMetadata = $root.proto.AIRichResponseTableMetadata.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.dynamicMetadata = $root.proto.AIRichResponseDynamicMetadata.decode(r, r.uint32());
                        break;
                    }
                case 8: {
                        m.latexMetadata = $root.proto.AIRichResponseLatexMetadata.decode(r, r.uint32());
                        break;
                    }
                case 9: {
                        m.mapMetadata = $root.proto.AIRichResponseMapMetadata.decode(r, r.uint32());
                        break;
                    }
                case 10: {
                        m.contentItemsMetadata = $root.proto.AIRichResponseContentItemsMetadata.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseSubMessage.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseSubMessage)
                return d;
            var m = new $root.proto.AIRichResponseSubMessage();
            switch (d.messageType) {
            default:
                if (typeof d.messageType === "number") {
                    m.messageType = d.messageType;
                    break;
                }
                break;
            case "AI_RICH_RESPONSE_UNKNOWN":
            case 0:
                m.messageType = 0;
                break;
            case "AI_RICH_RESPONSE_GRID_IMAGE":
            case 1:
                m.messageType = 1;
                break;
            case "AI_RICH_RESPONSE_TEXT":
            case 2:
                m.messageType = 2;
                break;
            case "AI_RICH_RESPONSE_INLINE_IMAGE":
            case 3:
                m.messageType = 3;
                break;
            case "AI_RICH_RESPONSE_TABLE":
            case 4:
                m.messageType = 4;
                break;
            case "AI_RICH_RESPONSE_CODE":
            case 5:
                m.messageType = 5;
                break;
            case "AI_RICH_RESPONSE_DYNAMIC":
            case 6:
                m.messageType = 6;
                break;
            case "AI_RICH_RESPONSE_MAP":
            case 7:
                m.messageType = 7;
                break;
            case "AI_RICH_RESPONSE_LATEX":
            case 8:
                m.messageType = 8;
                break;
            case "AI_RICH_RESPONSE_CONTENT_ITEMS":
            case 9:
                m.messageType = 9;
                break;
            }
            if (d.gridImageMetadata != null) {
                if (typeof d.gridImageMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.gridImageMetadata: object expected");
                m.gridImageMetadata = $root.proto.AIRichResponseGridImageMetadata.fromObject(d.gridImageMetadata);
            }
            if (d.messageText != null) {
                m.messageText = String(d.messageText);
            }
            if (d.imageMetadata != null) {
                if (typeof d.imageMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.imageMetadata: object expected");
                m.imageMetadata = $root.proto.AIRichResponseInlineImageMetadata.fromObject(d.imageMetadata);
            }
            if (d.codeMetadata != null) {
                if (typeof d.codeMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.codeMetadata: object expected");
                m.codeMetadata = $root.proto.AIRichResponseCodeMetadata.fromObject(d.codeMetadata);
            }
            if (d.tableMetadata != null) {
                if (typeof d.tableMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.tableMetadata: object expected");
                m.tableMetadata = $root.proto.AIRichResponseTableMetadata.fromObject(d.tableMetadata);
            }
            if (d.dynamicMetadata != null) {
                if (typeof d.dynamicMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.dynamicMetadata: object expected");
                m.dynamicMetadata = $root.proto.AIRichResponseDynamicMetadata.fromObject(d.dynamicMetadata);
            }
            if (d.latexMetadata != null) {
                if (typeof d.latexMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.latexMetadata: object expected");
                m.latexMetadata = $root.proto.AIRichResponseLatexMetadata.fromObject(d.latexMetadata);
            }
            if (d.mapMetadata != null) {
                if (typeof d.mapMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.mapMetadata: object expected");
                m.mapMetadata = $root.proto.AIRichResponseMapMetadata.fromObject(d.mapMetadata);
            }
            if (d.contentItemsMetadata != null) {
                if (typeof d.contentItemsMetadata !== "object")
                    throw TypeError(".proto.AIRichResponseSubMessage.contentItemsMetadata: object expected");
                m.contentItemsMetadata = $root.proto.AIRichResponseContentItemsMetadata.fromObject(d.contentItemsMetadata);
            }
            return m;
        };

        AIRichResponseSubMessage.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.messageType != null && m.hasOwnProperty("messageType")) {
                d.messageType = o.enums === String ? $root.proto.AIRichResponseSubMessageType[m.messageType] === undefined ? m.messageType : $root.proto.AIRichResponseSubMessageType[m.messageType] : m.messageType;
                if (o.oneofs)
                    d._messageType = "messageType";
            }
            if (m.gridImageMetadata != null && m.hasOwnProperty("gridImageMetadata")) {
                d.gridImageMetadata = $root.proto.AIRichResponseGridImageMetadata.toObject(m.gridImageMetadata, o);
                if (o.oneofs)
                    d._gridImageMetadata = "gridImageMetadata";
            }
            if (m.messageText != null && m.hasOwnProperty("messageText")) {
                d.messageText = m.messageText;
                if (o.oneofs)
                    d._messageText = "messageText";
            }
            if (m.imageMetadata != null && m.hasOwnProperty("imageMetadata")) {
                d.imageMetadata = $root.proto.AIRichResponseInlineImageMetadata.toObject(m.imageMetadata, o);
                if (o.oneofs)
                    d._imageMetadata = "imageMetadata";
            }
            if (m.codeMetadata != null && m.hasOwnProperty("codeMetadata")) {
                d.codeMetadata = $root.proto.AIRichResponseCodeMetadata.toObject(m.codeMetadata, o);
                if (o.oneofs)
                    d._codeMetadata = "codeMetadata";
            }
            if (m.tableMetadata != null && m.hasOwnProperty("tableMetadata")) {
                d.tableMetadata = $root.proto.AIRichResponseTableMetadata.toObject(m.tableMetadata, o);
                if (o.oneofs)
                    d._tableMetadata = "tableMetadata";
            }
            if (m.dynamicMetadata != null && m.hasOwnProperty("dynamicMetadata")) {
                d.dynamicMetadata = $root.proto.AIRichResponseDynamicMetadata.toObject(m.dynamicMetadata, o);
                if (o.oneofs)
                    d._dynamicMetadata = "dynamicMetadata";
            }
            if (m.latexMetadata != null && m.hasOwnProperty("latexMetadata")) {
                d.latexMetadata = $root.proto.AIRichResponseLatexMetadata.toObject(m.latexMetadata, o);
                if (o.oneofs)
                    d._latexMetadata = "latexMetadata";
            }
            if (m.mapMetadata != null && m.hasOwnProperty("mapMetadata")) {
                d.mapMetadata = $root.proto.AIRichResponseMapMetadata.toObject(m.mapMetadata, o);
                if (o.oneofs)
                    d._mapMetadata = "mapMetadata";
            }
            if (m.contentItemsMetadata != null && m.hasOwnProperty("contentItemsMetadata")) {
                d.contentItemsMetadata = $root.proto.AIRichResponseContentItemsMetadata.toObject(m.contentItemsMetadata, o);
                if (o.oneofs)
                    d._contentItemsMetadata = "contentItemsMetadata";
            }
            return d;
        };

        AIRichResponseSubMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseSubMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseSubMessage";
        };

        return AIRichResponseSubMessage;
    })();

    proto.AIRichResponseSubMessageType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "AI_RICH_RESPONSE_UNKNOWN"] = 0;
        values[valuesById[1] = "AI_RICH_RESPONSE_GRID_IMAGE"] = 1;
        values[valuesById[2] = "AI_RICH_RESPONSE_TEXT"] = 2;
        values[valuesById[3] = "AI_RICH_RESPONSE_INLINE_IMAGE"] = 3;
        values[valuesById[4] = "AI_RICH_RESPONSE_TABLE"] = 4;
        values[valuesById[5] = "AI_RICH_RESPONSE_CODE"] = 5;
        values[valuesById[6] = "AI_RICH_RESPONSE_DYNAMIC"] = 6;
        values[valuesById[7] = "AI_RICH_RESPONSE_MAP"] = 7;
        values[valuesById[8] = "AI_RICH_RESPONSE_LATEX"] = 8;
        values[valuesById[9] = "AI_RICH_RESPONSE_CONTENT_ITEMS"] = 9;
        return values;
    })();

    proto.AIRichResponseTableMetadata = (function() {

        function AIRichResponseTableMetadata(p) {
            this.rows = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseTableMetadata.prototype.rows = $util.emptyArray;
        AIRichResponseTableMetadata.prototype.title = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseTableMetadata.prototype, "_title", {
            get: $util.oneOfGetter($oneOfFields = ["title"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseTableMetadata.create = function create(properties) {
            return new AIRichResponseTableMetadata(properties);
        };

        AIRichResponseTableMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rows != null && m.rows.length) {
                for (var i = 0; i < m.rows.length; ++i)
                    $root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow.encode(m.rows[i], w.uint32(10).fork()).ldelim();
            }
            if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                w.uint32(18).string(m.title);
            return w;
        };

        AIRichResponseTableMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseTableMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.rows && m.rows.length))
                            m.rows = [];
                        m.rows.push($root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        m.title = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseTableMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseTableMetadata)
                return d;
            var m = new $root.proto.AIRichResponseTableMetadata();
            if (d.rows) {
                if (!Array.isArray(d.rows))
                    throw TypeError(".proto.AIRichResponseTableMetadata.rows: array expected");
                m.rows = [];
                for (var i = 0; i < d.rows.length; ++i) {
                    if (typeof d.rows[i] !== "object")
                        throw TypeError(".proto.AIRichResponseTableMetadata.rows: object expected");
                    m.rows[i] = $root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow.fromObject(d.rows[i]);
                }
            }
            if (d.title != null) {
                m.title = String(d.title);
            }
            return m;
        };

        AIRichResponseTableMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.rows = [];
            }
            if (m.rows && m.rows.length) {
                d.rows = [];
                for (var j = 0; j < m.rows.length; ++j) {
                    d.rows[j] = $root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow.toObject(m.rows[j], o);
                }
            }
            if (m.title != null && m.hasOwnProperty("title")) {
                d.title = m.title;
                if (o.oneofs)
                    d._title = "title";
            }
            return d;
        };

        AIRichResponseTableMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseTableMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseTableMetadata";
        };

        AIRichResponseTableMetadata.AIRichResponseTableRow = (function() {

            function AIRichResponseTableRow(p) {
                this.items = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseTableRow.prototype.items = $util.emptyArray;
            AIRichResponseTableRow.prototype.isHeading = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseTableRow.prototype, "_isHeading", {
                get: $util.oneOfGetter($oneOfFields = ["isHeading"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseTableRow.create = function create(properties) {
                return new AIRichResponseTableRow(properties);
            };

            AIRichResponseTableRow.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.items != null && m.items.length) {
                    for (var i = 0; i < m.items.length; ++i)
                        w.uint32(10).string(m.items[i]);
                }
                if (m.isHeading != null && Object.hasOwnProperty.call(m, "isHeading"))
                    w.uint32(16).bool(m.isHeading);
                return w;
            };

            AIRichResponseTableRow.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.items && m.items.length))
                                m.items = [];
                            m.items.push(r.string());
                            break;
                        }
                    case 2: {
                            m.isHeading = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseTableRow.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow)
                    return d;
                var m = new $root.proto.AIRichResponseTableMetadata.AIRichResponseTableRow();
                if (d.items) {
                    if (!Array.isArray(d.items))
                        throw TypeError(".proto.AIRichResponseTableMetadata.AIRichResponseTableRow.items: array expected");
                    m.items = [];
                    for (var i = 0; i < d.items.length; ++i) {
                        m.items[i] = String(d.items[i]);
                    }
                }
                if (d.isHeading != null) {
                    m.isHeading = Boolean(d.isHeading);
                }
                return m;
            };

            AIRichResponseTableRow.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.items = [];
                }
                if (m.items && m.items.length) {
                    d.items = [];
                    for (var j = 0; j < m.items.length; ++j) {
                        d.items[j] = m.items[j];
                    }
                }
                if (m.isHeading != null && m.hasOwnProperty("isHeading")) {
                    d.isHeading = m.isHeading;
                    if (o.oneofs)
                        d._isHeading = "isHeading";
                }
                return d;
            };

            AIRichResponseTableRow.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseTableRow.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseTableMetadata.AIRichResponseTableRow";
            };

            return AIRichResponseTableRow;
        })();

        return AIRichResponseTableMetadata;
    })();

    proto.AIRichResponseUnifiedResponse = (function() {

        function AIRichResponseUnifiedResponse(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseUnifiedResponse.prototype.data = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseUnifiedResponse.prototype, "_data", {
            get: $util.oneOfGetter($oneOfFields = ["data"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseUnifiedResponse.create = function create(properties) {
            return new AIRichResponseUnifiedResponse(properties);
        };

        AIRichResponseUnifiedResponse.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.data != null && Object.hasOwnProperty.call(m, "data"))
                w.uint32(10).bytes(m.data);
            return w;
        };

        AIRichResponseUnifiedResponse.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseUnifiedResponse();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.data = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseUnifiedResponse.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseUnifiedResponse)
                return d;
            var m = new $root.proto.AIRichResponseUnifiedResponse();
            if (d.data != null) {
                if (typeof d.data === "string")
                    $util.base64.decode(d.data, m.data = $util.newBuffer($util.base64.length(d.data)), 0);
                else if (d.data.length >= 0)
                    m.data = d.data;
            }
            return m;
        };

        AIRichResponseUnifiedResponse.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.data != null && m.hasOwnProperty("data")) {
                d.data = o.bytes === String ? $util.base64.encode(m.data, 0, m.data.length) : o.bytes === Array ? Array.prototype.slice.call(m.data) : m.data;
                if (o.oneofs)
                    d._data = "data";
            }
            return d;
        };

        AIRichResponseUnifiedResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseUnifiedResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseUnifiedResponse";
        };

        return AIRichResponseUnifiedResponse;
    })();

    proto.AIThreadInfo = (function() {

        function AIThreadInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIThreadInfo.prototype.serverInfo = null;
        AIThreadInfo.prototype.clientInfo = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIThreadInfo.prototype, "_serverInfo", {
            get: $util.oneOfGetter($oneOfFields = ["serverInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIThreadInfo.prototype, "_clientInfo", {
            get: $util.oneOfGetter($oneOfFields = ["clientInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIThreadInfo.create = function create(properties) {
            return new AIThreadInfo(properties);
        };

        AIThreadInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.serverInfo != null && Object.hasOwnProperty.call(m, "serverInfo"))
                $root.proto.AIThreadInfo.AIThreadServerInfo.encode(m.serverInfo, w.uint32(10).fork()).ldelim();
            if (m.clientInfo != null && Object.hasOwnProperty.call(m, "clientInfo"))
                $root.proto.AIThreadInfo.AIThreadClientInfo.encode(m.clientInfo, w.uint32(18).fork()).ldelim();
            return w;
        };

        AIThreadInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIThreadInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.serverInfo = $root.proto.AIThreadInfo.AIThreadServerInfo.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.clientInfo = $root.proto.AIThreadInfo.AIThreadClientInfo.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIThreadInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIThreadInfo)
                return d;
            var m = new $root.proto.AIThreadInfo();
            if (d.serverInfo != null) {
                if (typeof d.serverInfo !== "object")
                    throw TypeError(".proto.AIThreadInfo.serverInfo: object expected");
                m.serverInfo = $root.proto.AIThreadInfo.AIThreadServerInfo.fromObject(d.serverInfo);
            }
            if (d.clientInfo != null) {
                if (typeof d.clientInfo !== "object")
                    throw TypeError(".proto.AIThreadInfo.clientInfo: object expected");
                m.clientInfo = $root.proto.AIThreadInfo.AIThreadClientInfo.fromObject(d.clientInfo);
            }
            return m;
        };

        AIThreadInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.serverInfo != null && m.hasOwnProperty("serverInfo")) {
                d.serverInfo = $root.proto.AIThreadInfo.AIThreadServerInfo.toObject(m.serverInfo, o);
                if (o.oneofs)
                    d._serverInfo = "serverInfo";
            }
            if (m.clientInfo != null && m.hasOwnProperty("clientInfo")) {
                d.clientInfo = $root.proto.AIThreadInfo.AIThreadClientInfo.toObject(m.clientInfo, o);
                if (o.oneofs)
                    d._clientInfo = "clientInfo";
            }
            return d;
        };

        AIThreadInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIThreadInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIThreadInfo";
        };

        AIThreadInfo.AIThreadClientInfo = (function() {

            function AIThreadClientInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIThreadClientInfo.prototype.type = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIThreadClientInfo.prototype, "_type", {
                get: $util.oneOfGetter($oneOfFields = ["type"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIThreadClientInfo.create = function create(properties) {
                return new AIThreadClientInfo(properties);
            };

            AIThreadClientInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(8).int32(m.type);
                return w;
            };

            AIThreadClientInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIThreadInfo.AIThreadClientInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.type = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIThreadClientInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIThreadInfo.AIThreadClientInfo)
                    return d;
                var m = new $root.proto.AIThreadInfo.AIThreadClientInfo();
                switch (d.type) {
                default:
                    if (typeof d.type === "number") {
                        m.type = d.type;
                        break;
                    }
                    break;
                case "UNKNOWN":
                case 0:
                    m.type = 0;
                    break;
                case "DEFAULT":
                case 1:
                    m.type = 1;
                    break;
                case "INCOGNITO":
                case 2:
                    m.type = 2;
                    break;
                }
                return m;
            };

            AIThreadClientInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.type != null && m.hasOwnProperty("type")) {
                    d.type = o.enums === String ? $root.proto.AIThreadInfo.AIThreadClientInfo.AIThreadType[m.type] === undefined ? m.type : $root.proto.AIThreadInfo.AIThreadClientInfo.AIThreadType[m.type] : m.type;
                    if (o.oneofs)
                        d._type = "type";
                }
                return d;
            };

            AIThreadClientInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIThreadClientInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIThreadInfo.AIThreadClientInfo";
            };

            AIThreadClientInfo.AIThreadType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "DEFAULT"] = 1;
                values[valuesById[2] = "INCOGNITO"] = 2;
                return values;
            })();

            return AIThreadClientInfo;
        })();

        AIThreadInfo.AIThreadServerInfo = (function() {

            function AIThreadServerInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIThreadServerInfo.prototype.title = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIThreadServerInfo.prototype, "_title", {
                get: $util.oneOfGetter($oneOfFields = ["title"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIThreadServerInfo.create = function create(properties) {
                return new AIThreadServerInfo(properties);
            };

            AIThreadServerInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                return w;
            };

            AIThreadServerInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIThreadInfo.AIThreadServerInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIThreadServerInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIThreadInfo.AIThreadServerInfo)
                    return d;
                var m = new $root.proto.AIThreadInfo.AIThreadServerInfo();
                if (d.title != null) {
                    m.title = String(d.title);
                }
                return m;
            };

            AIThreadServerInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.title != null && m.hasOwnProperty("title")) {
                    d.title = m.title;
                    if (o.oneofs)
                        d._title = "title";
                }
                return d;
            };

            AIThreadServerInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIThreadServerInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIThreadInfo.AIThreadServerInfo";
            };

            return AIThreadServerInfo;
        })();

        return AIThreadInfo;
    })();

    proto.Account = (function() {

        function Account(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Account.prototype.lid = null;
        Account.prototype.username = null;
        Account.prototype.countryCode = null;
        Account.prototype.isUsernameDeleted = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_lid", {
            get: $util.oneOfGetter($oneOfFields = ["lid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_username", {
            get: $util.oneOfGetter($oneOfFields = ["username"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_countryCode", {
            get: $util.oneOfGetter($oneOfFields = ["countryCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_isUsernameDeleted", {
            get: $util.oneOfGetter($oneOfFields = ["isUsernameDeleted"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        Account.create = function create(properties) {
            return new Account(properties);
        };

        Account.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.lid != null && Object.hasOwnProperty.call(m, "lid"))
                w.uint32(10).string(m.lid);
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(18).string(m.username);
            if (m.countryCode != null && Object.hasOwnProperty.call(m, "countryCode"))
                w.uint32(26).string(m.countryCode);
            if (m.isUsernameDeleted != null && Object.hasOwnProperty.call(m, "isUsernameDeleted"))
                w.uint32(32).bool(m.isUsernameDeleted);
            return w;
        };

        Account.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Account();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.lid = r.string();
                        break;
                    }
                case 2: {
                        m.username = r.string();
                        break;
                    }
                case 3: {
                        m.countryCode = r.string();
                        break;
                    }
                case 4: {
                        m.isUsernameDeleted = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Account.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Account)
                return d;
            var m = new $root.proto.Account();
            if (d.lid != null) {
                m.lid = String(d.lid);
            }
            if (d.username != null) {
                m.username = String(d.username);
            }
            if (d.countryCode != null) {
                m.countryCode = String(d.countryCode);
            }
            if (d.isUsernameDeleted != null) {
                m.isUsernameDeleted = Boolean(d.isUsernameDeleted);
            }
            return m;
        };

        Account.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.lid != null && m.hasOwnProperty("lid")) {
                d.lid = m.lid;
                if (o.oneofs)
                    d._lid = "lid";
            }
            if (m.username != null && m.hasOwnProperty("username")) {
                d.username = m.username;
                if (o.oneofs)
                    d._username = "username";
            }
            if (m.countryCode != null && m.hasOwnProperty("countryCode")) {
                d.countryCode = m.countryCode;
                if (o.oneofs)
                    d._countryCode = "countryCode";
            }
            if (m.isUsernameDeleted != null && m.hasOwnProperty("isUsernameDeleted")) {
                d.isUsernameDeleted = m.isUsernameDeleted;
                if (o.oneofs)
                    d._isUsernameDeleted = "isUsernameDeleted";
            }
            return d;
        };

        Account.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Account.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Account";
        };

        return Account;
    })();

    proto.ActionLink = (function() {

        function ActionLink(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ActionLink.prototype.url = null;
        ActionLink.prototype.buttonTitle = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ActionLink.prototype, "_url", {
            get: $util.oneOfGetter($oneOfFields = ["url"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ActionLink.prototype, "_buttonTitle", {
            get: $util.oneOfGetter($oneOfFields = ["buttonTitle"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        ActionLink.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                w.uint32(10).string(m.url);
            if (m.buttonTitle != null && Object.hasOwnProperty.call(m, "buttonTitle"))
                w.uint32(18).string(m.buttonTitle);
            return w;
        };

        ActionLink.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ActionLink();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.url = r.string();
                        break;
                    }
                case 2: {
                        m.buttonTitle = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ActionLink.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ActionLink)
                return d;
            var m = new $root.proto.ActionLink();
            if (d.url != null) {
                m.url = String(d.url);
            }
            if (d.buttonTitle != null) {
                m.buttonTitle = String(d.buttonTitle);
            }
            return m;
        };

        ActionLink.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.url != null && m.hasOwnProperty("url")) {
                d.url = m.url;
                if (o.oneofs)
                    d._url = "url";
            }
            if (m.buttonTitle != null && m.hasOwnProperty("buttonTitle")) {
                d.buttonTitle = m.buttonTitle;
                if (o.oneofs)
                    d._buttonTitle = "buttonTitle";
            }
            return d;
        };

        ActionLink.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ActionLink.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ActionLink";
        };

        return ActionLink;
    })();

    proto.AutoDownloadSettings = (function() {

        function AutoDownloadSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AutoDownloadSettings.prototype.downloadImages = null;
        AutoDownloadSettings.prototype.downloadAudio = null;
        AutoDownloadSettings.prototype.downloadVideo = null;
        AutoDownloadSettings.prototype.downloadDocuments = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadImages", {
            get: $util.oneOfGetter($oneOfFields = ["downloadImages"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadAudio", {
            get: $util.oneOfGetter($oneOfFields = ["downloadAudio"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadVideo", {
            get: $util.oneOfGetter($oneOfFields = ["downloadVideo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadDocuments", {
            get: $util.oneOfGetter($oneOfFields = ["downloadDocuments"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AutoDownloadSettings.create = function create(properties) {
            return new AutoDownloadSettings(properties);
        };

        AutoDownloadSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.downloadImages != null && Object.hasOwnProperty.call(m, "downloadImages"))
                w.uint32(8).bool(m.downloadImages);
            if (m.downloadAudio != null && Object.hasOwnProperty.call(m, "downloadAudio"))
                w.uint32(16).bool(m.downloadAudio);
            if (m.downloadVideo != null && Object.hasOwnProperty.call(m, "downloadVideo"))
                w.uint32(24).bool(m.downloadVideo);
            if (m.downloadDocuments != null && Object.hasOwnProperty.call(m, "downloadDocuments"))
                w.uint32(32).bool(m.downloadDocuments);
            return w;
        };

        AutoDownloadSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AutoDownloadSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.downloadImages = r.bool();
                        break;
                    }
                case 2: {
                        m.downloadAudio = r.bool();
                        break;
                    }
                case 3: {
                        m.downloadVideo = r.bool();
                        break;
                    }
                case 4: {
                        m.downloadDocuments = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AutoDownloadSettings.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AutoDownloadSettings)
                return d;
            var m = new $root.proto.AutoDownloadSettings();
            if (d.downloadImages != null) {
                m.downloadImages = Boolean(d.downloadImages);
            }
            if (d.downloadAudio != null) {
                m.downloadAudio = Boolean(d.downloadAudio);
            }
            if (d.downloadVideo != null) {
                m.downloadVideo = Boolean(d.downloadVideo);
            }
            if (d.downloadDocuments != null) {
                m.downloadDocuments = Boolean(d.downloadDocuments);
            }
            return m;
        };

        AutoDownloadSettings.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.downloadImages != null && m.hasOwnProperty("downloadImages")) {
                d.downloadImages = m.downloadImages;
                if (o.oneofs)
                    d._downloadImages = "downloadImages";
            }
            if (m.downloadAudio != null && m.hasOwnProperty("downloadAudio")) {
                d.downloadAudio = m.downloadAudio;
                if (o.oneofs)
                    d._downloadAudio = "downloadAudio";
            }
            if (m.downloadVideo != null && m.hasOwnProperty("downloadVideo")) {
                d.downloadVideo = m.downloadVideo;
                if (o.oneofs)
                    d._downloadVideo = "downloadVideo";
            }
            if (m.downloadDocuments != null && m.hasOwnProperty("downloadDocuments")) {
                d.downloadDocuments = m.downloadDocuments;
                if (o.oneofs)
                    d._downloadDocuments = "downloadDocuments";
            }
            return d;
        };

        AutoDownloadSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AutoDownloadSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AutoDownloadSettings";
        };

        return AutoDownloadSettings;
    })();

    proto.AvatarUserSettings = (function() {

        function AvatarUserSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AvatarUserSettings.prototype.fbid = null;
        AvatarUserSettings.prototype.password = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AvatarUserSettings.prototype, "_fbid", {
            get: $util.oneOfGetter($oneOfFields = ["fbid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AvatarUserSettings.prototype, "_password", {
            get: $util.oneOfGetter($oneOfFields = ["password"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AvatarUserSettings.create = function create(properties) {
            return new AvatarUserSettings(properties);
        };

        AvatarUserSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fbid != null && Object.hasOwnProperty.call(m, "fbid"))
                w.uint32(10).string(m.fbid);
            if (m.password != null && Object.hasOwnProperty.call(m, "password"))
                w.uint32(18).string(m.password);
            return w;
        };

        AvatarUserSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AvatarUserSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fbid = r.string();
                        break;
                    }
                case 2: {
                        m.password = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AvatarUserSettings.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AvatarUserSettings)
                return d;
            var m = new $root.proto.AvatarUserSettings();
            if (d.fbid != null) {
                m.fbid = String(d.fbid);
            }
            if (d.password != null) {
                m.password = String(d.password);
            }
            return m;
        };

        AvatarUserSettings.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.fbid != null && m.hasOwnProperty("fbid")) {
                d.fbid = m.fbid;
                if (o.oneofs)
                    d._fbid = "fbid";
            }
            if (m.password != null && m.hasOwnProperty("password")) {
                d.password = m.password;
                if (o.oneofs)
                    d._password = "password";
            }
            return d;
        };

        AvatarUserSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AvatarUserSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AvatarUserSettings";
        };

        return AvatarUserSettings;
    })();

    proto.BizAccountLinkInfo = (function() {

        function BizAccountLinkInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = null;
        BizAccountLinkInfo.prototype.whatsappAcctNumber = null;
        BizAccountLinkInfo.prototype.issueTime = null;
        BizAccountLinkInfo.prototype.hostStorage = null;
        BizAccountLinkInfo.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_whatsappBizAcctFbid", {
            get: $util.oneOfGetter($oneOfFields = ["whatsappBizAcctFbid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_whatsappAcctNumber", {
            get: $util.oneOfGetter($oneOfFields = ["whatsappAcctNumber"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_issueTime", {
            get: $util.oneOfGetter($oneOfFields = ["issueTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_hostStorage", {
            get: $util.oneOfGetter($oneOfFields = ["hostStorage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        BizAccountLinkInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(m, "whatsappBizAcctFbid"))
                w.uint32(8).uint64(m.whatsappBizAcctFbid);
            if (m.whatsappAcctNumber != null && Object.hasOwnProperty.call(m, "whatsappAcctNumber"))
                w.uint32(18).string(m.whatsappAcctNumber);
            if (m.issueTime != null && Object.hasOwnProperty.call(m, "issueTime"))
                w.uint32(24).uint64(m.issueTime);
            if (m.hostStorage != null && Object.hasOwnProperty.call(m, "hostStorage"))
                w.uint32(32).int32(m.hostStorage);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(40).int32(m.accountType);
            return w;
        };

        BizAccountLinkInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizAccountLinkInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.whatsappBizAcctFbid = r.uint64();
                        break;
                    }
                case 2: {
                        m.whatsappAcctNumber = r.string();
                        break;
                    }
                case 3: {
                        m.issueTime = r.uint64();
                        break;
                    }
                case 4: {
                        m.hostStorage = r.int32();
                        break;
                    }
                case 5: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizAccountLinkInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BizAccountLinkInfo)
                return d;
            var m = new $root.proto.BizAccountLinkInfo();
            if (d.whatsappBizAcctFbid != null) {
                if ($util.Long)
                    (m.whatsappBizAcctFbid = $util.Long.fromValue(d.whatsappBizAcctFbid)).unsigned = true;
                else if (typeof d.whatsappBizAcctFbid === "string")
                    m.whatsappBizAcctFbid = parseInt(d.whatsappBizAcctFbid, 10);
                else if (typeof d.whatsappBizAcctFbid === "number")
                    m.whatsappBizAcctFbid = d.whatsappBizAcctFbid;
                else if (typeof d.whatsappBizAcctFbid === "object")
                    m.whatsappBizAcctFbid = new $util.LongBits(d.whatsappBizAcctFbid.low >>> 0, d.whatsappBizAcctFbid.high >>> 0).toNumber(true);
            }
            if (d.whatsappAcctNumber != null) {
                m.whatsappAcctNumber = String(d.whatsappAcctNumber);
            }
            if (d.issueTime != null) {
                if ($util.Long)
                    (m.issueTime = $util.Long.fromValue(d.issueTime)).unsigned = true;
                else if (typeof d.issueTime === "string")
                    m.issueTime = parseInt(d.issueTime, 10);
                else if (typeof d.issueTime === "number")
                    m.issueTime = d.issueTime;
                else if (typeof d.issueTime === "object")
                    m.issueTime = new $util.LongBits(d.issueTime.low >>> 0, d.issueTime.high >>> 0).toNumber(true);
            }
            switch (d.hostStorage) {
            default:
                if (typeof d.hostStorage === "number") {
                    m.hostStorage = d.hostStorage;
                    break;
                }
                break;
            case "ON_PREMISE":
            case 0:
                m.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                m.hostStorage = 1;
                break;
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "ENTERPRISE":
            case 0:
                m.accountType = 0;
                break;
            }
            return m;
        };

        BizAccountLinkInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.whatsappBizAcctFbid != null && m.hasOwnProperty("whatsappBizAcctFbid")) {
                if (typeof m.whatsappBizAcctFbid === "number")
                    d.whatsappBizAcctFbid = o.longs === String ? String(m.whatsappBizAcctFbid) : m.whatsappBizAcctFbid;
                else
                    d.whatsappBizAcctFbid = o.longs === String ? $util.Long.prototype.toString.call(m.whatsappBizAcctFbid) : o.longs === Number ? new $util.LongBits(m.whatsappBizAcctFbid.low >>> 0, m.whatsappBizAcctFbid.high >>> 0).toNumber(true) : m.whatsappBizAcctFbid;
                if (o.oneofs)
                    d._whatsappBizAcctFbid = "whatsappBizAcctFbid";
            }
            if (m.whatsappAcctNumber != null && m.hasOwnProperty("whatsappAcctNumber")) {
                d.whatsappAcctNumber = m.whatsappAcctNumber;
                if (o.oneofs)
                    d._whatsappAcctNumber = "whatsappAcctNumber";
            }
            if (m.issueTime != null && m.hasOwnProperty("issueTime")) {
                if (typeof m.issueTime === "number")
                    d.issueTime = o.longs === String ? String(m.issueTime) : m.issueTime;
                else
                    d.issueTime = o.longs === String ? $util.Long.prototype.toString.call(m.issueTime) : o.longs === Number ? new $util.LongBits(m.issueTime.low >>> 0, m.issueTime.high >>> 0).toNumber(true) : m.issueTime;
                if (o.oneofs)
                    d._issueTime = "issueTime";
            }
            if (m.hostStorage != null && m.hasOwnProperty("hostStorage")) {
                d.hostStorage = o.enums === String ? $root.proto.BizAccountLinkInfo.HostStorageType[m.hostStorage] === undefined ? m.hostStorage : $root.proto.BizAccountLinkInfo.HostStorageType[m.hostStorage] : m.hostStorage;
                if (o.oneofs)
                    d._hostStorage = "hostStorage";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.BizAccountLinkInfo.AccountType[m.accountType] === undefined ? m.accountType : $root.proto.BizAccountLinkInfo.AccountType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        BizAccountLinkInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BizAccountLinkInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountLinkInfo";
        };

        BizAccountLinkInfo.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        BizAccountLinkInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        function BizAccountPayload(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizAccountPayload.prototype.vnameCert = null;
        BizAccountPayload.prototype.bizAcctLinkInfo = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountPayload.prototype, "_vnameCert", {
            get: $util.oneOfGetter($oneOfFields = ["vnameCert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountPayload.prototype, "_bizAcctLinkInfo", {
            get: $util.oneOfGetter($oneOfFields = ["bizAcctLinkInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        BizAccountPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.vnameCert != null && Object.hasOwnProperty.call(m, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(m.vnameCert, w.uint32(10).fork()).ldelim();
            if (m.bizAcctLinkInfo != null && Object.hasOwnProperty.call(m, "bizAcctLinkInfo"))
                w.uint32(18).bytes(m.bizAcctLinkInfo);
            return w;
        };

        BizAccountPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizAccountPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.vnameCert = $root.proto.VerifiedNameCertificate.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.bizAcctLinkInfo = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizAccountPayload.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BizAccountPayload)
                return d;
            var m = new $root.proto.BizAccountPayload();
            if (d.vnameCert != null) {
                if (typeof d.vnameCert !== "object")
                    throw TypeError(".proto.BizAccountPayload.vnameCert: object expected");
                m.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(d.vnameCert);
            }
            if (d.bizAcctLinkInfo != null) {
                if (typeof d.bizAcctLinkInfo === "string")
                    $util.base64.decode(d.bizAcctLinkInfo, m.bizAcctLinkInfo = $util.newBuffer($util.base64.length(d.bizAcctLinkInfo)), 0);
                else if (d.bizAcctLinkInfo.length >= 0)
                    m.bizAcctLinkInfo = d.bizAcctLinkInfo;
            }
            return m;
        };

        BizAccountPayload.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.vnameCert != null && m.hasOwnProperty("vnameCert")) {
                d.vnameCert = $root.proto.VerifiedNameCertificate.toObject(m.vnameCert, o);
                if (o.oneofs)
                    d._vnameCert = "vnameCert";
            }
            if (m.bizAcctLinkInfo != null && m.hasOwnProperty("bizAcctLinkInfo")) {
                d.bizAcctLinkInfo = o.bytes === String ? $util.base64.encode(m.bizAcctLinkInfo, 0, m.bizAcctLinkInfo.length) : o.bytes === Array ? Array.prototype.slice.call(m.bizAcctLinkInfo) : m.bizAcctLinkInfo;
                if (o.oneofs)
                    d._bizAcctLinkInfo = "bizAcctLinkInfo";
            }
            return d;
        };

        BizAccountPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BizAccountPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountPayload";
        };

        return BizAccountPayload;
    })();

    proto.BizIdentityInfo = (function() {

        function BizIdentityInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizIdentityInfo.prototype.vlevel = null;
        BizIdentityInfo.prototype.vnameCert = null;
        BizIdentityInfo.prototype.signed = null;
        BizIdentityInfo.prototype.revoked = null;
        BizIdentityInfo.prototype.hostStorage = null;
        BizIdentityInfo.prototype.actualActors = null;
        BizIdentityInfo.prototype.privacyModeTs = null;
        BizIdentityInfo.prototype.featureControls = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_vlevel", {
            get: $util.oneOfGetter($oneOfFields = ["vlevel"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_vnameCert", {
            get: $util.oneOfGetter($oneOfFields = ["vnameCert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_signed", {
            get: $util.oneOfGetter($oneOfFields = ["signed"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_revoked", {
            get: $util.oneOfGetter($oneOfFields = ["revoked"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_hostStorage", {
            get: $util.oneOfGetter($oneOfFields = ["hostStorage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_actualActors", {
            get: $util.oneOfGetter($oneOfFields = ["actualActors"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_privacyModeTs", {
            get: $util.oneOfGetter($oneOfFields = ["privacyModeTs"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_featureControls", {
            get: $util.oneOfGetter($oneOfFields = ["featureControls"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        BizIdentityInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.vlevel != null && Object.hasOwnProperty.call(m, "vlevel"))
                w.uint32(8).int32(m.vlevel);
            if (m.vnameCert != null && Object.hasOwnProperty.call(m, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(m.vnameCert, w.uint32(18).fork()).ldelim();
            if (m.signed != null && Object.hasOwnProperty.call(m, "signed"))
                w.uint32(24).bool(m.signed);
            if (m.revoked != null && Object.hasOwnProperty.call(m, "revoked"))
                w.uint32(32).bool(m.revoked);
            if (m.hostStorage != null && Object.hasOwnProperty.call(m, "hostStorage"))
                w.uint32(40).int32(m.hostStorage);
            if (m.actualActors != null && Object.hasOwnProperty.call(m, "actualActors"))
                w.uint32(48).int32(m.actualActors);
            if (m.privacyModeTs != null && Object.hasOwnProperty.call(m, "privacyModeTs"))
                w.uint32(56).uint64(m.privacyModeTs);
            if (m.featureControls != null && Object.hasOwnProperty.call(m, "featureControls"))
                w.uint32(64).uint64(m.featureControls);
            return w;
        };

        BizIdentityInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizIdentityInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.vlevel = r.int32();
                        break;
                    }
                case 2: {
                        m.vnameCert = $root.proto.VerifiedNameCertificate.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.signed = r.bool();
                        break;
                    }
                case 4: {
                        m.revoked = r.bool();
                        break;
                    }
                case 5: {
                        m.hostStorage = r.int32();
                        break;
                    }
                case 6: {
                        m.actualActors = r.int32();
                        break;
                    }
                case 7: {
                        m.privacyModeTs = r.uint64();
                        break;
                    }
                case 8: {
                        m.featureControls = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizIdentityInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BizIdentityInfo)
                return d;
            var m = new $root.proto.BizIdentityInfo();
            switch (d.vlevel) {
            default:
                if (typeof d.vlevel === "number") {
                    m.vlevel = d.vlevel;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.vlevel = 0;
                break;
            case "LOW":
            case 1:
                m.vlevel = 1;
                break;
            case "HIGH":
            case 2:
                m.vlevel = 2;
                break;
            }
            if (d.vnameCert != null) {
                if (typeof d.vnameCert !== "object")
                    throw TypeError(".proto.BizIdentityInfo.vnameCert: object expected");
                m.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(d.vnameCert);
            }
            if (d.signed != null) {
                m.signed = Boolean(d.signed);
            }
            if (d.revoked != null) {
                m.revoked = Boolean(d.revoked);
            }
            switch (d.hostStorage) {
            default:
                if (typeof d.hostStorage === "number") {
                    m.hostStorage = d.hostStorage;
                    break;
                }
                break;
            case "ON_PREMISE":
            case 0:
                m.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                m.hostStorage = 1;
                break;
            }
            switch (d.actualActors) {
            default:
                if (typeof d.actualActors === "number") {
                    m.actualActors = d.actualActors;
                    break;
                }
                break;
            case "SELF":
            case 0:
                m.actualActors = 0;
                break;
            case "BSP":
            case 1:
                m.actualActors = 1;
                break;
            }
            if (d.privacyModeTs != null) {
                if ($util.Long)
                    (m.privacyModeTs = $util.Long.fromValue(d.privacyModeTs)).unsigned = true;
                else if (typeof d.privacyModeTs === "string")
                    m.privacyModeTs = parseInt(d.privacyModeTs, 10);
                else if (typeof d.privacyModeTs === "number")
                    m.privacyModeTs = d.privacyModeTs;
                else if (typeof d.privacyModeTs === "object")
                    m.privacyModeTs = new $util.LongBits(d.privacyModeTs.low >>> 0, d.privacyModeTs.high >>> 0).toNumber(true);
            }
            if (d.featureControls != null) {
                if ($util.Long)
                    (m.featureControls = $util.Long.fromValue(d.featureControls)).unsigned = true;
                else if (typeof d.featureControls === "string")
                    m.featureControls = parseInt(d.featureControls, 10);
                else if (typeof d.featureControls === "number")
                    m.featureControls = d.featureControls;
                else if (typeof d.featureControls === "object")
                    m.featureControls = new $util.LongBits(d.featureControls.low >>> 0, d.featureControls.high >>> 0).toNumber(true);
            }
            return m;
        };

        BizIdentityInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.vlevel != null && m.hasOwnProperty("vlevel")) {
                d.vlevel = o.enums === String ? $root.proto.BizIdentityInfo.VerifiedLevelValue[m.vlevel] === undefined ? m.vlevel : $root.proto.BizIdentityInfo.VerifiedLevelValue[m.vlevel] : m.vlevel;
                if (o.oneofs)
                    d._vlevel = "vlevel";
            }
            if (m.vnameCert != null && m.hasOwnProperty("vnameCert")) {
                d.vnameCert = $root.proto.VerifiedNameCertificate.toObject(m.vnameCert, o);
                if (o.oneofs)
                    d._vnameCert = "vnameCert";
            }
            if (m.signed != null && m.hasOwnProperty("signed")) {
                d.signed = m.signed;
                if (o.oneofs)
                    d._signed = "signed";
            }
            if (m.revoked != null && m.hasOwnProperty("revoked")) {
                d.revoked = m.revoked;
                if (o.oneofs)
                    d._revoked = "revoked";
            }
            if (m.hostStorage != null && m.hasOwnProperty("hostStorage")) {
                d.hostStorage = o.enums === String ? $root.proto.BizIdentityInfo.HostStorageType[m.hostStorage] === undefined ? m.hostStorage : $root.proto.BizIdentityInfo.HostStorageType[m.hostStorage] : m.hostStorage;
                if (o.oneofs)
                    d._hostStorage = "hostStorage";
            }
            if (m.actualActors != null && m.hasOwnProperty("actualActors")) {
                d.actualActors = o.enums === String ? $root.proto.BizIdentityInfo.ActualActorsType[m.actualActors] === undefined ? m.actualActors : $root.proto.BizIdentityInfo.ActualActorsType[m.actualActors] : m.actualActors;
                if (o.oneofs)
                    d._actualActors = "actualActors";
            }
            if (m.privacyModeTs != null && m.hasOwnProperty("privacyModeTs")) {
                if (typeof m.privacyModeTs === "number")
                    d.privacyModeTs = o.longs === String ? String(m.privacyModeTs) : m.privacyModeTs;
                else
                    d.privacyModeTs = o.longs === String ? $util.Long.prototype.toString.call(m.privacyModeTs) : o.longs === Number ? new $util.LongBits(m.privacyModeTs.low >>> 0, m.privacyModeTs.high >>> 0).toNumber(true) : m.privacyModeTs;
                if (o.oneofs)
                    d._privacyModeTs = "privacyModeTs";
            }
            if (m.featureControls != null && m.hasOwnProperty("featureControls")) {
                if (typeof m.featureControls === "number")
                    d.featureControls = o.longs === String ? String(m.featureControls) : m.featureControls;
                else
                    d.featureControls = o.longs === String ? $util.Long.prototype.toString.call(m.featureControls) : o.longs === Number ? new $util.LongBits(m.featureControls.low >>> 0, m.featureControls.high >>> 0).toNumber(true) : m.featureControls;
                if (o.oneofs)
                    d._featureControls = "featureControls";
            }
            return d;
        };

        BizIdentityInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BizIdentityInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizIdentityInfo";
        };

        BizIdentityInfo.ActualActorsType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        BizIdentityInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        BizIdentityInfo.VerifiedLevelValue = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.BotAgeCollectionMetadata = (function() {

        function BotAgeCollectionMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotAgeCollectionMetadata.prototype.ageCollectionEligible = null;
        BotAgeCollectionMetadata.prototype.shouldTriggerAgeCollectionOnClient = null;
        BotAgeCollectionMetadata.prototype.ageCollectionType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_ageCollectionEligible", {
            get: $util.oneOfGetter($oneOfFields = ["ageCollectionEligible"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_shouldTriggerAgeCollectionOnClient", {
            get: $util.oneOfGetter($oneOfFields = ["shouldTriggerAgeCollectionOnClient"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_ageCollectionType", {
            get: $util.oneOfGetter($oneOfFields = ["ageCollectionType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotAgeCollectionMetadata.create = function create(properties) {
            return new BotAgeCollectionMetadata(properties);
        };

        BotAgeCollectionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.ageCollectionEligible != null && Object.hasOwnProperty.call(m, "ageCollectionEligible"))
                w.uint32(8).bool(m.ageCollectionEligible);
            if (m.shouldTriggerAgeCollectionOnClient != null && Object.hasOwnProperty.call(m, "shouldTriggerAgeCollectionOnClient"))
                w.uint32(16).bool(m.shouldTriggerAgeCollectionOnClient);
            if (m.ageCollectionType != null && Object.hasOwnProperty.call(m, "ageCollectionType"))
                w.uint32(24).int32(m.ageCollectionType);
            return w;
        };

        BotAgeCollectionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotAgeCollectionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.ageCollectionEligible = r.bool();
                        break;
                    }
                case 2: {
                        m.shouldTriggerAgeCollectionOnClient = r.bool();
                        break;
                    }
                case 3: {
                        m.ageCollectionType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotAgeCollectionMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotAgeCollectionMetadata)
                return d;
            var m = new $root.proto.BotAgeCollectionMetadata();
            if (d.ageCollectionEligible != null) {
                m.ageCollectionEligible = Boolean(d.ageCollectionEligible);
            }
            if (d.shouldTriggerAgeCollectionOnClient != null) {
                m.shouldTriggerAgeCollectionOnClient = Boolean(d.shouldTriggerAgeCollectionOnClient);
            }
            switch (d.ageCollectionType) {
            default:
                if (typeof d.ageCollectionType === "number") {
                    m.ageCollectionType = d.ageCollectionType;
                    break;
                }
                break;
            case "O18_BINARY":
            case 0:
                m.ageCollectionType = 0;
                break;
            case "WAFFLE":
            case 1:
                m.ageCollectionType = 1;
                break;
            }
            return m;
        };

        BotAgeCollectionMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.ageCollectionEligible != null && m.hasOwnProperty("ageCollectionEligible")) {
                d.ageCollectionEligible = m.ageCollectionEligible;
                if (o.oneofs)
                    d._ageCollectionEligible = "ageCollectionEligible";
            }
            if (m.shouldTriggerAgeCollectionOnClient != null && m.hasOwnProperty("shouldTriggerAgeCollectionOnClient")) {
                d.shouldTriggerAgeCollectionOnClient = m.shouldTriggerAgeCollectionOnClient;
                if (o.oneofs)
                    d._shouldTriggerAgeCollectionOnClient = "shouldTriggerAgeCollectionOnClient";
            }
            if (m.ageCollectionType != null && m.hasOwnProperty("ageCollectionType")) {
                d.ageCollectionType = o.enums === String ? $root.proto.BotAgeCollectionMetadata.AgeCollectionType[m.ageCollectionType] === undefined ? m.ageCollectionType : $root.proto.BotAgeCollectionMetadata.AgeCollectionType[m.ageCollectionType] : m.ageCollectionType;
                if (o.oneofs)
                    d._ageCollectionType = "ageCollectionType";
            }
            return d;
        };

        BotAgeCollectionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotAgeCollectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAgeCollectionMetadata";
        };

        BotAgeCollectionMetadata.AgeCollectionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "O18_BINARY"] = 0;
            values[valuesById[1] = "WAFFLE"] = 1;
            return values;
        })();

        return BotAgeCollectionMetadata;
    })();

    proto.BotAvatarMetadata = (function() {

        function BotAvatarMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotAvatarMetadata.prototype.sentiment = null;
        BotAvatarMetadata.prototype.behaviorGraph = null;
        BotAvatarMetadata.prototype.action = null;
        BotAvatarMetadata.prototype.intensity = null;
        BotAvatarMetadata.prototype.wordCount = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_sentiment", {
            get: $util.oneOfGetter($oneOfFields = ["sentiment"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_behaviorGraph", {
            get: $util.oneOfGetter($oneOfFields = ["behaviorGraph"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_action", {
            get: $util.oneOfGetter($oneOfFields = ["action"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_intensity", {
            get: $util.oneOfGetter($oneOfFields = ["intensity"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_wordCount", {
            get: $util.oneOfGetter($oneOfFields = ["wordCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotAvatarMetadata.create = function create(properties) {
            return new BotAvatarMetadata(properties);
        };

        BotAvatarMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sentiment != null && Object.hasOwnProperty.call(m, "sentiment"))
                w.uint32(8).uint32(m.sentiment);
            if (m.behaviorGraph != null && Object.hasOwnProperty.call(m, "behaviorGraph"))
                w.uint32(18).string(m.behaviorGraph);
            if (m.action != null && Object.hasOwnProperty.call(m, "action"))
                w.uint32(24).uint32(m.action);
            if (m.intensity != null && Object.hasOwnProperty.call(m, "intensity"))
                w.uint32(32).uint32(m.intensity);
            if (m.wordCount != null && Object.hasOwnProperty.call(m, "wordCount"))
                w.uint32(40).uint32(m.wordCount);
            return w;
        };

        BotAvatarMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotAvatarMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sentiment = r.uint32();
                        break;
                    }
                case 2: {
                        m.behaviorGraph = r.string();
                        break;
                    }
                case 3: {
                        m.action = r.uint32();
                        break;
                    }
                case 4: {
                        m.intensity = r.uint32();
                        break;
                    }
                case 5: {
                        m.wordCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotAvatarMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotAvatarMetadata)
                return d;
            var m = new $root.proto.BotAvatarMetadata();
            if (d.sentiment != null) {
                m.sentiment = d.sentiment >>> 0;
            }
            if (d.behaviorGraph != null) {
                m.behaviorGraph = String(d.behaviorGraph);
            }
            if (d.action != null) {
                m.action = d.action >>> 0;
            }
            if (d.intensity != null) {
                m.intensity = d.intensity >>> 0;
            }
            if (d.wordCount != null) {
                m.wordCount = d.wordCount >>> 0;
            }
            return m;
        };

        BotAvatarMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.sentiment != null && m.hasOwnProperty("sentiment")) {
                d.sentiment = m.sentiment;
                if (o.oneofs)
                    d._sentiment = "sentiment";
            }
            if (m.behaviorGraph != null && m.hasOwnProperty("behaviorGraph")) {
                d.behaviorGraph = m.behaviorGraph;
                if (o.oneofs)
                    d._behaviorGraph = "behaviorGraph";
            }
            if (m.action != null && m.hasOwnProperty("action")) {
                d.action = m.action;
                if (o.oneofs)
                    d._action = "action";
            }
            if (m.intensity != null && m.hasOwnProperty("intensity")) {
                d.intensity = m.intensity;
                if (o.oneofs)
                    d._intensity = "intensity";
            }
            if (m.wordCount != null && m.hasOwnProperty("wordCount")) {
                d.wordCount = m.wordCount;
                if (o.oneofs)
                    d._wordCount = "wordCount";
            }
            return d;
        };

        BotAvatarMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotAvatarMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAvatarMetadata";
        };

        return BotAvatarMetadata;
    })();

    proto.BotCapabilityMetadata = (function() {

        function BotCapabilityMetadata(p) {
            this.capabilities = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotCapabilityMetadata.prototype.capabilities = $util.emptyArray;

        BotCapabilityMetadata.create = function create(properties) {
            return new BotCapabilityMetadata(properties);
        };

        BotCapabilityMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.capabilities != null && m.capabilities.length) {
                w.uint32(10).fork();
                for (var i = 0; i < m.capabilities.length; ++i)
                    w.int32(m.capabilities[i]);
                w.ldelim();
            }
            return w;
        };

        BotCapabilityMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotCapabilityMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.capabilities && m.capabilities.length))
                            m.capabilities = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.capabilities.push(r.int32());
                        } else
                            m.capabilities.push(r.int32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotCapabilityMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotCapabilityMetadata)
                return d;
            var m = new $root.proto.BotCapabilityMetadata();
            if (d.capabilities) {
                if (!Array.isArray(d.capabilities))
                    throw TypeError(".proto.BotCapabilityMetadata.capabilities: array expected");
                m.capabilities = [];
                for (var i = 0; i < d.capabilities.length; ++i) {
                    switch (d.capabilities[i]) {
                    default:
                        if (typeof d.capabilities[i] === "number") {
                            m.capabilities[i] = d.capabilities[i];
                            break;
                        }
                    case "UNKNOWN":
                    case 0:
                        m.capabilities[i] = 0;
                        break;
                    case "PROGRESS_INDICATOR":
                    case 1:
                        m.capabilities[i] = 1;
                        break;
                    case "RICH_RESPONSE_HEADING":
                    case 2:
                        m.capabilities[i] = 2;
                        break;
                    case "RICH_RESPONSE_NESTED_LIST":
                    case 3:
                        m.capabilities[i] = 3;
                        break;
                    case "AI_MEMORY":
                    case 4:
                        m.capabilities[i] = 4;
                        break;
                    case "RICH_RESPONSE_THREAD_SURFING":
                    case 5:
                        m.capabilities[i] = 5;
                        break;
                    case "RICH_RESPONSE_TABLE":
                    case 6:
                        m.capabilities[i] = 6;
                        break;
                    case "RICH_RESPONSE_CODE":
                    case 7:
                        m.capabilities[i] = 7;
                        break;
                    case "RICH_RESPONSE_STRUCTURED_RESPONSE":
                    case 8:
                        m.capabilities[i] = 8;
                        break;
                    case "RICH_RESPONSE_INLINE_IMAGE":
                    case 9:
                        m.capabilities[i] = 9;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_CONTROL":
                    case 10:
                        m.capabilities[i] = 10;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_1":
                    case 11:
                        m.capabilities[i] = 11;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_2":
                    case 12:
                        m.capabilities[i] = 12;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_3":
                    case 13:
                        m.capabilities[i] = 13;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_4":
                    case 14:
                        m.capabilities[i] = 14;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_5":
                    case 15:
                        m.capabilities[i] = 15;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_6":
                    case 16:
                        m.capabilities[i] = 16;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_7":
                    case 17:
                        m.capabilities[i] = 17;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_8":
                    case 18:
                        m.capabilities[i] = 18;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_9":
                    case 19:
                        m.capabilities[i] = 19;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_10":
                    case 20:
                        m.capabilities[i] = 20;
                        break;
                    case "RICH_RESPONSE_SUB_HEADING":
                    case 21:
                        m.capabilities[i] = 21;
                        break;
                    case "RICH_RESPONSE_GRID_IMAGE":
                    case 22:
                        m.capabilities[i] = 22;
                        break;
                    case "AI_STUDIO_UGC_MEMORY":
                    case 23:
                        m.capabilities[i] = 23;
                        break;
                    case "RICH_RESPONSE_LATEX":
                    case 24:
                        m.capabilities[i] = 24;
                        break;
                    case "RICH_RESPONSE_MAPS":
                    case 25:
                        m.capabilities[i] = 25;
                        break;
                    case "RICH_RESPONSE_INLINE_REELS":
                    case 26:
                        m.capabilities[i] = 26;
                        break;
                    case "AGENTIC_PLANNING":
                    case 27:
                        m.capabilities[i] = 27;
                        break;
                    case "ACCOUNT_LINKING":
                    case 28:
                        m.capabilities[i] = 28;
                        break;
                    case "STREAMING_DISAGGREGATION":
                    case 29:
                        m.capabilities[i] = 29;
                        break;
                    case "RICH_RESPONSE_GRID_IMAGE_3P":
                    case 30:
                        m.capabilities[i] = 30;
                        break;
                    case "RICH_RESPONSE_LATEX_INLINE":
                    case 31:
                        m.capabilities[i] = 31;
                        break;
                    case "QUERY_PLAN":
                    case 32:
                        m.capabilities[i] = 32;
                        break;
                    case "PROACTIVE_MESSAGE":
                    case 33:
                        m.capabilities[i] = 33;
                        break;
                    case "RICH_RESPONSE_UNIFIED_RESPONSE":
                    case 34:
                        m.capabilities[i] = 34;
                        break;
                    case "PROMOTION_MESSAGE":
                    case 35:
                        m.capabilities[i] = 35;
                        break;
                    case "SIMPLIFIED_PROFILE_PAGE":
                    case 36:
                        m.capabilities[i] = 36;
                        break;
                    case "RICH_RESPONSE_SOURCES_IN_MESSAGE":
                    case 37:
                        m.capabilities[i] = 37;
                        break;
                    case "RICH_RESPONSE_SIDE_BY_SIDE_SURVEY":
                    case 38:
                        m.capabilities[i] = 38;
                        break;
                    case "RICH_RESPONSE_UNIFIED_TEXT_COMPONENT":
                    case 39:
                        m.capabilities[i] = 39;
                        break;
                    case "AI_SHARED_MEMORY":
                    case 40:
                        m.capabilities[i] = 40;
                        break;
                    case "RICH_RESPONSE_UNIFIED_SOURCES":
                    case 41:
                        m.capabilities[i] = 41;
                        break;
                    case "RICH_RESPONSE_UNIFIED_DOMAIN_CITATIONS":
                    case 42:
                        m.capabilities[i] = 42;
                        break;
                    case "RICH_RESPONSE_UR_INLINE_REELS_ENABLED":
                    case 43:
                        m.capabilities[i] = 43;
                        break;
                    case "RICH_RESPONSE_UR_MEDIA_GRID_ENABLED":
                    case 44:
                        m.capabilities[i] = 44;
                        break;
                    case "RICH_RESPONSE_UR_TIMESTAMP_PLACEHOLDER":
                    case 45:
                        m.capabilities[i] = 45;
                        break;
                    case "RICH_RESPONSE_IN_APP_SURVEY":
                    case 46:
                        m.capabilities[i] = 46;
                        break;
                    case "AI_RESPONSE_MODEL_BRANDING":
                    case 47:
                        m.capabilities[i] = 47;
                        break;
                    case "SESSION_TRANSPARENCY_SYSTEM_MESSAGE":
                    case 48:
                        m.capabilities[i] = 48;
                        break;
                    case "RICH_RESPONSE_UR_REASONING":
                    case 49:
                        m.capabilities[i] = 49;
                        break;
                    }
                }
            }
            return m;
        };

        BotCapabilityMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.capabilities = [];
            }
            if (m.capabilities && m.capabilities.length) {
                d.capabilities = [];
                for (var j = 0; j < m.capabilities.length; ++j) {
                    d.capabilities[j] = o.enums === String ? $root.proto.BotCapabilityMetadata.BotCapabilityType[m.capabilities[j]] === undefined ? m.capabilities[j] : $root.proto.BotCapabilityMetadata.BotCapabilityType[m.capabilities[j]] : m.capabilities[j];
                }
            }
            return d;
        };

        BotCapabilityMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotCapabilityMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotCapabilityMetadata";
        };

        BotCapabilityMetadata.BotCapabilityType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "PROGRESS_INDICATOR"] = 1;
            values[valuesById[2] = "RICH_RESPONSE_HEADING"] = 2;
            values[valuesById[3] = "RICH_RESPONSE_NESTED_LIST"] = 3;
            values[valuesById[4] = "AI_MEMORY"] = 4;
            values[valuesById[5] = "RICH_RESPONSE_THREAD_SURFING"] = 5;
            values[valuesById[6] = "RICH_RESPONSE_TABLE"] = 6;
            values[valuesById[7] = "RICH_RESPONSE_CODE"] = 7;
            values[valuesById[8] = "RICH_RESPONSE_STRUCTURED_RESPONSE"] = 8;
            values[valuesById[9] = "RICH_RESPONSE_INLINE_IMAGE"] = 9;
            values[valuesById[10] = "WA_IG_1P_PLUGIN_RANKING_CONTROL"] = 10;
            values[valuesById[11] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_1"] = 11;
            values[valuesById[12] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_2"] = 12;
            values[valuesById[13] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_3"] = 13;
            values[valuesById[14] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_4"] = 14;
            values[valuesById[15] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_5"] = 15;
            values[valuesById[16] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_6"] = 16;
            values[valuesById[17] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_7"] = 17;
            values[valuesById[18] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_8"] = 18;
            values[valuesById[19] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_9"] = 19;
            values[valuesById[20] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_10"] = 20;
            values[valuesById[21] = "RICH_RESPONSE_SUB_HEADING"] = 21;
            values[valuesById[22] = "RICH_RESPONSE_GRID_IMAGE"] = 22;
            values[valuesById[23] = "AI_STUDIO_UGC_MEMORY"] = 23;
            values[valuesById[24] = "RICH_RESPONSE_LATEX"] = 24;
            values[valuesById[25] = "RICH_RESPONSE_MAPS"] = 25;
            values[valuesById[26] = "RICH_RESPONSE_INLINE_REELS"] = 26;
            values[valuesById[27] = "AGENTIC_PLANNING"] = 27;
            values[valuesById[28] = "ACCOUNT_LINKING"] = 28;
            values[valuesById[29] = "STREAMING_DISAGGREGATION"] = 29;
            values[valuesById[30] = "RICH_RESPONSE_GRID_IMAGE_3P"] = 30;
            values[valuesById[31] = "RICH_RESPONSE_LATEX_INLINE"] = 31;
            values[valuesById[32] = "QUERY_PLAN"] = 32;
            values[valuesById[33] = "PROACTIVE_MESSAGE"] = 33;
            values[valuesById[34] = "RICH_RESPONSE_UNIFIED_RESPONSE"] = 34;
            values[valuesById[35] = "PROMOTION_MESSAGE"] = 35;
            values[valuesById[36] = "SIMPLIFIED_PROFILE_PAGE"] = 36;
            values[valuesById[37] = "RICH_RESPONSE_SOURCES_IN_MESSAGE"] = 37;
            values[valuesById[38] = "RICH_RESPONSE_SIDE_BY_SIDE_SURVEY"] = 38;
            values[valuesById[39] = "RICH_RESPONSE_UNIFIED_TEXT_COMPONENT"] = 39;
            values[valuesById[40] = "AI_SHARED_MEMORY"] = 40;
            values[valuesById[41] = "RICH_RESPONSE_UNIFIED_SOURCES"] = 41;
            values[valuesById[42] = "RICH_RESPONSE_UNIFIED_DOMAIN_CITATIONS"] = 42;
            values[valuesById[43] = "RICH_RESPONSE_UR_INLINE_REELS_ENABLED"] = 43;
            values[valuesById[44] = "RICH_RESPONSE_UR_MEDIA_GRID_ENABLED"] = 44;
            values[valuesById[45] = "RICH_RESPONSE_UR_TIMESTAMP_PLACEHOLDER"] = 45;
            values[valuesById[46] = "RICH_RESPONSE_IN_APP_SURVEY"] = 46;
            values[valuesById[47] = "AI_RESPONSE_MODEL_BRANDING"] = 47;
            values[valuesById[48] = "SESSION_TRANSPARENCY_SYSTEM_MESSAGE"] = 48;
            values[valuesById[49] = "RICH_RESPONSE_UR_REASONING"] = 49;
            return values;
        })();

        return BotCapabilityMetadata;
    })();

    proto.BotFeedbackMessage = (function() {

        function BotFeedbackMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotFeedbackMessage.prototype.messageKey = null;
        BotFeedbackMessage.prototype.kind = null;
        BotFeedbackMessage.prototype.text = null;
        BotFeedbackMessage.prototype.kindNegative = null;
        BotFeedbackMessage.prototype.kindPositive = null;
        BotFeedbackMessage.prototype.kindReport = null;
        BotFeedbackMessage.prototype.sideBySideSurveyMetadata = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_messageKey", {
            get: $util.oneOfGetter($oneOfFields = ["messageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_kind", {
            get: $util.oneOfGetter($oneOfFields = ["kind"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_text", {
            get: $util.oneOfGetter($oneOfFields = ["text"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_kindNegative", {
            get: $util.oneOfGetter($oneOfFields = ["kindNegative"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_kindPositive", {
            get: $util.oneOfGetter($oneOfFields = ["kindPositive"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_kindReport", {
            get: $util.oneOfGetter($oneOfFields = ["kindReport"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotFeedbackMessage.prototype, "_sideBySideSurveyMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["sideBySideSurveyMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotFeedbackMessage.create = function create(properties) {
            return new BotFeedbackMessage(properties);
        };

        BotFeedbackMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
            if (m.kind != null && Object.hasOwnProperty.call(m, "kind"))
                w.uint32(16).int32(m.kind);
            if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                w.uint32(26).string(m.text);
            if (m.kindNegative != null && Object.hasOwnProperty.call(m, "kindNegative"))
                w.uint32(32).uint64(m.kindNegative);
            if (m.kindPositive != null && Object.hasOwnProperty.call(m, "kindPositive"))
                w.uint32(40).uint64(m.kindPositive);
            if (m.kindReport != null && Object.hasOwnProperty.call(m, "kindReport"))
                w.uint32(48).int32(m.kindReport);
            if (m.sideBySideSurveyMetadata != null && Object.hasOwnProperty.call(m, "sideBySideSurveyMetadata"))
                $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.encode(m.sideBySideSurveyMetadata, w.uint32(58).fork()).ldelim();
            return w;
        };

        BotFeedbackMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.kind = r.int32();
                        break;
                    }
                case 3: {
                        m.text = r.string();
                        break;
                    }
                case 4: {
                        m.kindNegative = r.uint64();
                        break;
                    }
                case 5: {
                        m.kindPositive = r.uint64();
                        break;
                    }
                case 6: {
                        m.kindReport = r.int32();
                        break;
                    }
                case 7: {
                        m.sideBySideSurveyMetadata = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotFeedbackMessage.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotFeedbackMessage)
                return d;
            var m = new $root.proto.BotFeedbackMessage();
            if (d.messageKey != null) {
                if (typeof d.messageKey !== "object")
                    throw TypeError(".proto.BotFeedbackMessage.messageKey: object expected");
                m.messageKey = $root.proto.MessageKey.fromObject(d.messageKey);
            }
            switch (d.kind) {
            default:
                if (typeof d.kind === "number") {
                    m.kind = d.kind;
                    break;
                }
                break;
            case "BOT_FEEDBACK_POSITIVE":
            case 0:
                m.kind = 0;
                break;
            case "BOT_FEEDBACK_NEGATIVE_GENERIC":
            case 1:
                m.kind = 1;
                break;
            case "BOT_FEEDBACK_NEGATIVE_HELPFUL":
            case 2:
                m.kind = 2;
                break;
            case "BOT_FEEDBACK_NEGATIVE_INTERESTING":
            case 3:
                m.kind = 3;
                break;
            case "BOT_FEEDBACK_NEGATIVE_ACCURATE":
            case 4:
                m.kind = 4;
                break;
            case "BOT_FEEDBACK_NEGATIVE_SAFE":
            case 5:
                m.kind = 5;
                break;
            case "BOT_FEEDBACK_NEGATIVE_OTHER":
            case 6:
                m.kind = 6;
                break;
            case "BOT_FEEDBACK_NEGATIVE_REFUSED":
            case 7:
                m.kind = 7;
                break;
            case "BOT_FEEDBACK_NEGATIVE_NOT_VISUALLY_APPEALING":
            case 8:
                m.kind = 8;
                break;
            case "BOT_FEEDBACK_NEGATIVE_NOT_RELEVANT_TO_TEXT":
            case 9:
                m.kind = 9;
                break;
            case "BOT_FEEDBACK_NEGATIVE_PERSONALIZED":
            case 10:
                m.kind = 10;
                break;
            case "BOT_FEEDBACK_NEGATIVE_CLARITY":
            case 11:
                m.kind = 11;
                break;
            case "BOT_FEEDBACK_NEGATIVE_DOESNT_LOOK_LIKE_THE_PERSON":
            case 12:
                m.kind = 12;
                break;
            case "BOT_FEEDBACK_NEGATIVE_HALLUCINATION_INTERNAL_ONLY":
            case 13:
                m.kind = 13;
                break;
            case "BOT_FEEDBACK_NEGATIVE":
            case 14:
                m.kind = 14;
                break;
            }
            if (d.text != null) {
                m.text = String(d.text);
            }
            if (d.kindNegative != null) {
                if ($util.Long)
                    (m.kindNegative = $util.Long.fromValue(d.kindNegative)).unsigned = true;
                else if (typeof d.kindNegative === "string")
                    m.kindNegative = parseInt(d.kindNegative, 10);
                else if (typeof d.kindNegative === "number")
                    m.kindNegative = d.kindNegative;
                else if (typeof d.kindNegative === "object")
                    m.kindNegative = new $util.LongBits(d.kindNegative.low >>> 0, d.kindNegative.high >>> 0).toNumber(true);
            }
            if (d.kindPositive != null) {
                if ($util.Long)
                    (m.kindPositive = $util.Long.fromValue(d.kindPositive)).unsigned = true;
                else if (typeof d.kindPositive === "string")
                    m.kindPositive = parseInt(d.kindPositive, 10);
                else if (typeof d.kindPositive === "number")
                    m.kindPositive = d.kindPositive;
                else if (typeof d.kindPositive === "object")
                    m.kindPositive = new $util.LongBits(d.kindPositive.low >>> 0, d.kindPositive.high >>> 0).toNumber(true);
            }
            switch (d.kindReport) {
            default:
                if (typeof d.kindReport === "number") {
                    m.kindReport = d.kindReport;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.kindReport = 0;
                break;
            case "GENERIC":
            case 1:
                m.kindReport = 1;
                break;
            }
            if (d.sideBySideSurveyMetadata != null) {
                if (typeof d.sideBySideSurveyMetadata !== "object")
                    throw TypeError(".proto.BotFeedbackMessage.sideBySideSurveyMetadata: object expected");
                m.sideBySideSurveyMetadata = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.fromObject(d.sideBySideSurveyMetadata);
            }
            return m;
        };

        BotFeedbackMessage.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.messageKey != null && m.hasOwnProperty("messageKey")) {
                d.messageKey = $root.proto.MessageKey.toObject(m.messageKey, o);
                if (o.oneofs)
                    d._messageKey = "messageKey";
            }
            if (m.kind != null && m.hasOwnProperty("kind")) {
                d.kind = o.enums === String ? $root.proto.BotFeedbackMessage.BotFeedbackKind[m.kind] === undefined ? m.kind : $root.proto.BotFeedbackMessage.BotFeedbackKind[m.kind] : m.kind;
                if (o.oneofs)
                    d._kind = "kind";
            }
            if (m.text != null && m.hasOwnProperty("text")) {
                d.text = m.text;
                if (o.oneofs)
                    d._text = "text";
            }
            if (m.kindNegative != null && m.hasOwnProperty("kindNegative")) {
                if (typeof m.kindNegative === "number")
                    d.kindNegative = o.longs === String ? String(m.kindNegative) : m.kindNegative;
                else
                    d.kindNegative = o.longs === String ? $util.Long.prototype.toString.call(m.kindNegative) : o.longs === Number ? new $util.LongBits(m.kindNegative.low >>> 0, m.kindNegative.high >>> 0).toNumber(true) : m.kindNegative;
                if (o.oneofs)
                    d._kindNegative = "kindNegative";
            }
            if (m.kindPositive != null && m.hasOwnProperty("kindPositive")) {
                if (typeof m.kindPositive === "number")
                    d.kindPositive = o.longs === String ? String(m.kindPositive) : m.kindPositive;
                else
                    d.kindPositive = o.longs === String ? $util.Long.prototype.toString.call(m.kindPositive) : o.longs === Number ? new $util.LongBits(m.kindPositive.low >>> 0, m.kindPositive.high >>> 0).toNumber(true) : m.kindPositive;
                if (o.oneofs)
                    d._kindPositive = "kindPositive";
            }
            if (m.kindReport != null && m.hasOwnProperty("kindReport")) {
                d.kindReport = o.enums === String ? $root.proto.BotFeedbackMessage.ReportKind[m.kindReport] === undefined ? m.kindReport : $root.proto.BotFeedbackMessage.ReportKind[m.kindReport] : m.kindReport;
                if (o.oneofs)
                    d._kindReport = "kindReport";
            }
            if (m.sideBySideSurveyMetadata != null && m.hasOwnProperty("sideBySideSurveyMetadata")) {
                d.sideBySideSurveyMetadata = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.toObject(m.sideBySideSurveyMetadata, o);
                if (o.oneofs)
                    d._sideBySideSurveyMetadata = "sideBySideSurveyMetadata";
            }
            return d;
        };

        BotFeedbackMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotFeedbackMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotFeedbackMessage";
        };

        BotFeedbackMessage.BotFeedbackKind = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "BOT_FEEDBACK_POSITIVE"] = 0;
            values[valuesById[1] = "BOT_FEEDBACK_NEGATIVE_GENERIC"] = 1;
            values[valuesById[2] = "BOT_FEEDBACK_NEGATIVE_HELPFUL"] = 2;
            values[valuesById[3] = "BOT_FEEDBACK_NEGATIVE_INTERESTING"] = 3;
            values[valuesById[4] = "BOT_FEEDBACK_NEGATIVE_ACCURATE"] = 4;
            values[valuesById[5] = "BOT_FEEDBACK_NEGATIVE_SAFE"] = 5;
            values[valuesById[6] = "BOT_FEEDBACK_NEGATIVE_OTHER"] = 6;
            values[valuesById[7] = "BOT_FEEDBACK_NEGATIVE_REFUSED"] = 7;
            values[valuesById[8] = "BOT_FEEDBACK_NEGATIVE_NOT_VISUALLY_APPEALING"] = 8;
            values[valuesById[9] = "BOT_FEEDBACK_NEGATIVE_NOT_RELEVANT_TO_TEXT"] = 9;
            values[valuesById[10] = "BOT_FEEDBACK_NEGATIVE_PERSONALIZED"] = 10;
            values[valuesById[11] = "BOT_FEEDBACK_NEGATIVE_CLARITY"] = 11;
            values[valuesById[12] = "BOT_FEEDBACK_NEGATIVE_DOESNT_LOOK_LIKE_THE_PERSON"] = 12;
            values[valuesById[13] = "BOT_FEEDBACK_NEGATIVE_HALLUCINATION_INTERNAL_ONLY"] = 13;
            values[valuesById[14] = "BOT_FEEDBACK_NEGATIVE"] = 14;
            return values;
        })();

        BotFeedbackMessage.BotFeedbackKindMultipleNegative = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_GENERIC"] = 1;
            values[valuesById[2] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_HELPFUL"] = 2;
            values[valuesById[4] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_INTERESTING"] = 4;
            values[valuesById[8] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_ACCURATE"] = 8;
            values[valuesById[16] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_SAFE"] = 16;
            values[valuesById[32] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_OTHER"] = 32;
            values[valuesById[64] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_REFUSED"] = 64;
            values[valuesById[128] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_NOT_VISUALLY_APPEALING"] = 128;
            values[valuesById[256] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_NOT_RELEVANT_TO_TEXT"] = 256;
            return values;
        })();

        BotFeedbackMessage.BotFeedbackKindMultiplePositive = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "BOT_FEEDBACK_MULTIPLE_POSITIVE_GENERIC"] = 1;
            return values;
        })();

        BotFeedbackMessage.ReportKind = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "GENERIC"] = 1;
            return values;
        })();

        BotFeedbackMessage.SideBySideSurveyMetadata = (function() {

            function SideBySideSurveyMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            SideBySideSurveyMetadata.prototype.selectedRequestId = null;
            SideBySideSurveyMetadata.prototype.surveyId = null;
            SideBySideSurveyMetadata.prototype.simonSessionFbid = null;
            SideBySideSurveyMetadata.prototype.responseOtid = null;
            SideBySideSurveyMetadata.prototype.responseTimestampMsString = null;
            SideBySideSurveyMetadata.prototype.isSelectedResponsePrimary = null;
            SideBySideSurveyMetadata.prototype.messageIdToEdit = null;
            SideBySideSurveyMetadata.prototype.analyticsData = null;
            SideBySideSurveyMetadata.prototype.metaAiAnalyticsData = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_selectedRequestId", {
                get: $util.oneOfGetter($oneOfFields = ["selectedRequestId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_surveyId", {
                get: $util.oneOfGetter($oneOfFields = ["surveyId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_simonSessionFbid", {
                get: $util.oneOfGetter($oneOfFields = ["simonSessionFbid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_responseOtid", {
                get: $util.oneOfGetter($oneOfFields = ["responseOtid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_responseTimestampMsString", {
                get: $util.oneOfGetter($oneOfFields = ["responseTimestampMsString"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_isSelectedResponsePrimary", {
                get: $util.oneOfGetter($oneOfFields = ["isSelectedResponsePrimary"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_messageIdToEdit", {
                get: $util.oneOfGetter($oneOfFields = ["messageIdToEdit"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_analyticsData", {
                get: $util.oneOfGetter($oneOfFields = ["analyticsData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideSurveyMetadata.prototype, "_metaAiAnalyticsData", {
                get: $util.oneOfGetter($oneOfFields = ["metaAiAnalyticsData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            SideBySideSurveyMetadata.create = function create(properties) {
                return new SideBySideSurveyMetadata(properties);
            };

            SideBySideSurveyMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.selectedRequestId != null && Object.hasOwnProperty.call(m, "selectedRequestId"))
                    w.uint32(10).string(m.selectedRequestId);
                if (m.surveyId != null && Object.hasOwnProperty.call(m, "surveyId"))
                    w.uint32(16).uint32(m.surveyId);
                if (m.simonSessionFbid != null && Object.hasOwnProperty.call(m, "simonSessionFbid"))
                    w.uint32(26).string(m.simonSessionFbid);
                if (m.responseOtid != null && Object.hasOwnProperty.call(m, "responseOtid"))
                    w.uint32(34).string(m.responseOtid);
                if (m.responseTimestampMsString != null && Object.hasOwnProperty.call(m, "responseTimestampMsString"))
                    w.uint32(42).string(m.responseTimestampMsString);
                if (m.isSelectedResponsePrimary != null && Object.hasOwnProperty.call(m, "isSelectedResponsePrimary"))
                    w.uint32(48).bool(m.isSelectedResponsePrimary);
                if (m.messageIdToEdit != null && Object.hasOwnProperty.call(m, "messageIdToEdit"))
                    w.uint32(58).string(m.messageIdToEdit);
                if (m.analyticsData != null && Object.hasOwnProperty.call(m, "analyticsData"))
                    $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData.encode(m.analyticsData, w.uint32(66).fork()).ldelim();
                if (m.metaAiAnalyticsData != null && Object.hasOwnProperty.call(m, "metaAiAnalyticsData"))
                    $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.encode(m.metaAiAnalyticsData, w.uint32(74).fork()).ldelim();
                return w;
            };

            SideBySideSurveyMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.selectedRequestId = r.string();
                            break;
                        }
                    case 2: {
                            m.surveyId = r.uint32();
                            break;
                        }
                    case 3: {
                            m.simonSessionFbid = r.string();
                            break;
                        }
                    case 4: {
                            m.responseOtid = r.string();
                            break;
                        }
                    case 5: {
                            m.responseTimestampMsString = r.string();
                            break;
                        }
                    case 6: {
                            m.isSelectedResponsePrimary = r.bool();
                            break;
                        }
                    case 7: {
                            m.messageIdToEdit = r.string();
                            break;
                        }
                    case 8: {
                            m.analyticsData = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData.decode(r, r.uint32());
                            break;
                        }
                    case 9: {
                            m.metaAiAnalyticsData = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            SideBySideSurveyMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata)
                    return d;
                var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata();
                if (d.selectedRequestId != null) {
                    m.selectedRequestId = String(d.selectedRequestId);
                }
                if (d.surveyId != null) {
                    m.surveyId = d.surveyId >>> 0;
                }
                if (d.simonSessionFbid != null) {
                    m.simonSessionFbid = String(d.simonSessionFbid);
                }
                if (d.responseOtid != null) {
                    m.responseOtid = String(d.responseOtid);
                }
                if (d.responseTimestampMsString != null) {
                    m.responseTimestampMsString = String(d.responseTimestampMsString);
                }
                if (d.isSelectedResponsePrimary != null) {
                    m.isSelectedResponsePrimary = Boolean(d.isSelectedResponsePrimary);
                }
                if (d.messageIdToEdit != null) {
                    m.messageIdToEdit = String(d.messageIdToEdit);
                }
                if (d.analyticsData != null) {
                    if (typeof d.analyticsData !== "object")
                        throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.analyticsData: object expected");
                    m.analyticsData = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData.fromObject(d.analyticsData);
                }
                if (d.metaAiAnalyticsData != null) {
                    if (typeof d.metaAiAnalyticsData !== "object")
                        throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.metaAiAnalyticsData: object expected");
                    m.metaAiAnalyticsData = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.fromObject(d.metaAiAnalyticsData);
                }
                return m;
            };

            SideBySideSurveyMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.selectedRequestId != null && m.hasOwnProperty("selectedRequestId")) {
                    d.selectedRequestId = m.selectedRequestId;
                    if (o.oneofs)
                        d._selectedRequestId = "selectedRequestId";
                }
                if (m.surveyId != null && m.hasOwnProperty("surveyId")) {
                    d.surveyId = m.surveyId;
                    if (o.oneofs)
                        d._surveyId = "surveyId";
                }
                if (m.simonSessionFbid != null && m.hasOwnProperty("simonSessionFbid")) {
                    d.simonSessionFbid = m.simonSessionFbid;
                    if (o.oneofs)
                        d._simonSessionFbid = "simonSessionFbid";
                }
                if (m.responseOtid != null && m.hasOwnProperty("responseOtid")) {
                    d.responseOtid = m.responseOtid;
                    if (o.oneofs)
                        d._responseOtid = "responseOtid";
                }
                if (m.responseTimestampMsString != null && m.hasOwnProperty("responseTimestampMsString")) {
                    d.responseTimestampMsString = m.responseTimestampMsString;
                    if (o.oneofs)
                        d._responseTimestampMsString = "responseTimestampMsString";
                }
                if (m.isSelectedResponsePrimary != null && m.hasOwnProperty("isSelectedResponsePrimary")) {
                    d.isSelectedResponsePrimary = m.isSelectedResponsePrimary;
                    if (o.oneofs)
                        d._isSelectedResponsePrimary = "isSelectedResponsePrimary";
                }
                if (m.messageIdToEdit != null && m.hasOwnProperty("messageIdToEdit")) {
                    d.messageIdToEdit = m.messageIdToEdit;
                    if (o.oneofs)
                        d._messageIdToEdit = "messageIdToEdit";
                }
                if (m.analyticsData != null && m.hasOwnProperty("analyticsData")) {
                    d.analyticsData = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData.toObject(m.analyticsData, o);
                    if (o.oneofs)
                        d._analyticsData = "analyticsData";
                }
                if (m.metaAiAnalyticsData != null && m.hasOwnProperty("metaAiAnalyticsData")) {
                    d.metaAiAnalyticsData = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.toObject(m.metaAiAnalyticsData, o);
                    if (o.oneofs)
                        d._metaAiAnalyticsData = "metaAiAnalyticsData";
                }
                return d;
            };

            SideBySideSurveyMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            SideBySideSurveyMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata";
            };

            SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData = (function() {

                function SideBySideSurveyAnalyticsData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                SideBySideSurveyAnalyticsData.prototype.tessaEvent = null;
                SideBySideSurveyAnalyticsData.prototype.tessaSessionFbid = null;
                SideBySideSurveyAnalyticsData.prototype.simonSessionFbid = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SideBySideSurveyAnalyticsData.prototype, "_tessaEvent", {
                    get: $util.oneOfGetter($oneOfFields = ["tessaEvent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SideBySideSurveyAnalyticsData.prototype, "_tessaSessionFbid", {
                    get: $util.oneOfGetter($oneOfFields = ["tessaSessionFbid"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SideBySideSurveyAnalyticsData.prototype, "_simonSessionFbid", {
                    get: $util.oneOfGetter($oneOfFields = ["simonSessionFbid"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                SideBySideSurveyAnalyticsData.create = function create(properties) {
                    return new SideBySideSurveyAnalyticsData(properties);
                };

                SideBySideSurveyAnalyticsData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.tessaEvent != null && Object.hasOwnProperty.call(m, "tessaEvent"))
                        w.uint32(10).string(m.tessaEvent);
                    if (m.tessaSessionFbid != null && Object.hasOwnProperty.call(m, "tessaSessionFbid"))
                        w.uint32(18).string(m.tessaSessionFbid);
                    if (m.simonSessionFbid != null && Object.hasOwnProperty.call(m, "simonSessionFbid"))
                        w.uint32(26).string(m.simonSessionFbid);
                    return w;
                };

                SideBySideSurveyAnalyticsData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.tessaEvent = r.string();
                                break;
                            }
                        case 2: {
                                m.tessaSessionFbid = r.string();
                                break;
                            }
                        case 3: {
                                m.simonSessionFbid = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                SideBySideSurveyAnalyticsData.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData)
                        return d;
                    var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData();
                    if (d.tessaEvent != null) {
                        m.tessaEvent = String(d.tessaEvent);
                    }
                    if (d.tessaSessionFbid != null) {
                        m.tessaSessionFbid = String(d.tessaSessionFbid);
                    }
                    if (d.simonSessionFbid != null) {
                        m.simonSessionFbid = String(d.simonSessionFbid);
                    }
                    return m;
                };

                SideBySideSurveyAnalyticsData.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.tessaEvent != null && m.hasOwnProperty("tessaEvent")) {
                        d.tessaEvent = m.tessaEvent;
                        if (o.oneofs)
                            d._tessaEvent = "tessaEvent";
                    }
                    if (m.tessaSessionFbid != null && m.hasOwnProperty("tessaSessionFbid")) {
                        d.tessaSessionFbid = m.tessaSessionFbid;
                        if (o.oneofs)
                            d._tessaSessionFbid = "tessaSessionFbid";
                    }
                    if (m.simonSessionFbid != null && m.hasOwnProperty("simonSessionFbid")) {
                        d.simonSessionFbid = m.simonSessionFbid;
                        if (o.oneofs)
                            d._simonSessionFbid = "simonSessionFbid";
                    }
                    return d;
                };

                SideBySideSurveyAnalyticsData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                SideBySideSurveyAnalyticsData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SideBySideSurveyAnalyticsData";
                };

                return SideBySideSurveyAnalyticsData;
            })();

            SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData = (function() {

                function SidebySideSurveyMetaAiAnalyticsData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                SidebySideSurveyMetaAiAnalyticsData.prototype.surveyId = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.primaryResponseId = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.testArmName = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.timestampMsString = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.ctaImpressionEvent = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.ctaClickEvent = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.cardImpressionEvent = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.responseEvent = null;
                SidebySideSurveyMetaAiAnalyticsData.prototype.abandonEvent = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_surveyId", {
                    get: $util.oneOfGetter($oneOfFields = ["surveyId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_primaryResponseId", {
                    get: $util.oneOfGetter($oneOfFields = ["primaryResponseId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_testArmName", {
                    get: $util.oneOfGetter($oneOfFields = ["testArmName"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_timestampMsString", {
                    get: $util.oneOfGetter($oneOfFields = ["timestampMsString"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_ctaImpressionEvent", {
                    get: $util.oneOfGetter($oneOfFields = ["ctaImpressionEvent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_ctaClickEvent", {
                    get: $util.oneOfGetter($oneOfFields = ["ctaClickEvent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_cardImpressionEvent", {
                    get: $util.oneOfGetter($oneOfFields = ["cardImpressionEvent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_responseEvent", {
                    get: $util.oneOfGetter($oneOfFields = ["responseEvent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(SidebySideSurveyMetaAiAnalyticsData.prototype, "_abandonEvent", {
                    get: $util.oneOfGetter($oneOfFields = ["abandonEvent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                SidebySideSurveyMetaAiAnalyticsData.create = function create(properties) {
                    return new SidebySideSurveyMetaAiAnalyticsData(properties);
                };

                SidebySideSurveyMetaAiAnalyticsData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.surveyId != null && Object.hasOwnProperty.call(m, "surveyId"))
                        w.uint32(8).uint32(m.surveyId);
                    if (m.primaryResponseId != null && Object.hasOwnProperty.call(m, "primaryResponseId"))
                        w.uint32(18).string(m.primaryResponseId);
                    if (m.testArmName != null && Object.hasOwnProperty.call(m, "testArmName"))
                        w.uint32(26).string(m.testArmName);
                    if (m.timestampMsString != null && Object.hasOwnProperty.call(m, "timestampMsString"))
                        w.uint32(34).string(m.timestampMsString);
                    if (m.ctaImpressionEvent != null && Object.hasOwnProperty.call(m, "ctaImpressionEvent"))
                        $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData.encode(m.ctaImpressionEvent, w.uint32(42).fork()).ldelim();
                    if (m.ctaClickEvent != null && Object.hasOwnProperty.call(m, "ctaClickEvent"))
                        $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData.encode(m.ctaClickEvent, w.uint32(50).fork()).ldelim();
                    if (m.cardImpressionEvent != null && Object.hasOwnProperty.call(m, "cardImpressionEvent"))
                        $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData.encode(m.cardImpressionEvent, w.uint32(58).fork()).ldelim();
                    if (m.responseEvent != null && Object.hasOwnProperty.call(m, "responseEvent"))
                        $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData.encode(m.responseEvent, w.uint32(66).fork()).ldelim();
                    if (m.abandonEvent != null && Object.hasOwnProperty.call(m, "abandonEvent"))
                        $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData.encode(m.abandonEvent, w.uint32(74).fork()).ldelim();
                    return w;
                };

                SidebySideSurveyMetaAiAnalyticsData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.surveyId = r.uint32();
                                break;
                            }
                        case 2: {
                                m.primaryResponseId = r.string();
                                break;
                            }
                        case 3: {
                                m.testArmName = r.string();
                                break;
                            }
                        case 4: {
                                m.timestampMsString = r.string();
                                break;
                            }
                        case 5: {
                                m.ctaImpressionEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData.decode(r, r.uint32());
                                break;
                            }
                        case 6: {
                                m.ctaClickEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData.decode(r, r.uint32());
                                break;
                            }
                        case 7: {
                                m.cardImpressionEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData.decode(r, r.uint32());
                                break;
                            }
                        case 8: {
                                m.responseEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData.decode(r, r.uint32());
                                break;
                            }
                        case 9: {
                                m.abandonEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                SidebySideSurveyMetaAiAnalyticsData.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData)
                        return d;
                    var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData();
                    if (d.surveyId != null) {
                        m.surveyId = d.surveyId >>> 0;
                    }
                    if (d.primaryResponseId != null) {
                        m.primaryResponseId = String(d.primaryResponseId);
                    }
                    if (d.testArmName != null) {
                        m.testArmName = String(d.testArmName);
                    }
                    if (d.timestampMsString != null) {
                        m.timestampMsString = String(d.timestampMsString);
                    }
                    if (d.ctaImpressionEvent != null) {
                        if (typeof d.ctaImpressionEvent !== "object")
                            throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.ctaImpressionEvent: object expected");
                        m.ctaImpressionEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData.fromObject(d.ctaImpressionEvent);
                    }
                    if (d.ctaClickEvent != null) {
                        if (typeof d.ctaClickEvent !== "object")
                            throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.ctaClickEvent: object expected");
                        m.ctaClickEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData.fromObject(d.ctaClickEvent);
                    }
                    if (d.cardImpressionEvent != null) {
                        if (typeof d.cardImpressionEvent !== "object")
                            throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.cardImpressionEvent: object expected");
                        m.cardImpressionEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData.fromObject(d.cardImpressionEvent);
                    }
                    if (d.responseEvent != null) {
                        if (typeof d.responseEvent !== "object")
                            throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.responseEvent: object expected");
                        m.responseEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData.fromObject(d.responseEvent);
                    }
                    if (d.abandonEvent != null) {
                        if (typeof d.abandonEvent !== "object")
                            throw TypeError(".proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.abandonEvent: object expected");
                        m.abandonEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData.fromObject(d.abandonEvent);
                    }
                    return m;
                };

                SidebySideSurveyMetaAiAnalyticsData.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.surveyId != null && m.hasOwnProperty("surveyId")) {
                        d.surveyId = m.surveyId;
                        if (o.oneofs)
                            d._surveyId = "surveyId";
                    }
                    if (m.primaryResponseId != null && m.hasOwnProperty("primaryResponseId")) {
                        d.primaryResponseId = m.primaryResponseId;
                        if (o.oneofs)
                            d._primaryResponseId = "primaryResponseId";
                    }
                    if (m.testArmName != null && m.hasOwnProperty("testArmName")) {
                        d.testArmName = m.testArmName;
                        if (o.oneofs)
                            d._testArmName = "testArmName";
                    }
                    if (m.timestampMsString != null && m.hasOwnProperty("timestampMsString")) {
                        d.timestampMsString = m.timestampMsString;
                        if (o.oneofs)
                            d._timestampMsString = "timestampMsString";
                    }
                    if (m.ctaImpressionEvent != null && m.hasOwnProperty("ctaImpressionEvent")) {
                        d.ctaImpressionEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData.toObject(m.ctaImpressionEvent, o);
                        if (o.oneofs)
                            d._ctaImpressionEvent = "ctaImpressionEvent";
                    }
                    if (m.ctaClickEvent != null && m.hasOwnProperty("ctaClickEvent")) {
                        d.ctaClickEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData.toObject(m.ctaClickEvent, o);
                        if (o.oneofs)
                            d._ctaClickEvent = "ctaClickEvent";
                    }
                    if (m.cardImpressionEvent != null && m.hasOwnProperty("cardImpressionEvent")) {
                        d.cardImpressionEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData.toObject(m.cardImpressionEvent, o);
                        if (o.oneofs)
                            d._cardImpressionEvent = "cardImpressionEvent";
                    }
                    if (m.responseEvent != null && m.hasOwnProperty("responseEvent")) {
                        d.responseEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData.toObject(m.responseEvent, o);
                        if (o.oneofs)
                            d._responseEvent = "responseEvent";
                    }
                    if (m.abandonEvent != null && m.hasOwnProperty("abandonEvent")) {
                        d.abandonEvent = $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData.toObject(m.abandonEvent, o);
                        if (o.oneofs)
                            d._abandonEvent = "abandonEvent";
                    }
                    return d;
                };

                SidebySideSurveyMetaAiAnalyticsData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                SidebySideSurveyMetaAiAnalyticsData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData";
                };

                SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData = (function() {

                    function SideBySideSurveyAbandonEventData(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    SideBySideSurveyAbandonEventData.prototype.abandonDwellTimeMsString = null;

                    let $oneOfFields;

                    // Virtual OneOf for proto3 optional field
                    Object.defineProperty(SideBySideSurveyAbandonEventData.prototype, "_abandonDwellTimeMsString", {
                        get: $util.oneOfGetter($oneOfFields = ["abandonDwellTimeMsString"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    SideBySideSurveyAbandonEventData.create = function create(properties) {
                        return new SideBySideSurveyAbandonEventData(properties);
                    };

                    SideBySideSurveyAbandonEventData.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.abandonDwellTimeMsString != null && Object.hasOwnProperty.call(m, "abandonDwellTimeMsString"))
                            w.uint32(10).string(m.abandonDwellTimeMsString);
                        return w;
                    };

                    SideBySideSurveyAbandonEventData.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.abandonDwellTimeMsString = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    SideBySideSurveyAbandonEventData.fromObject = function fromObject(d) {
                        if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData)
                            return d;
                        var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData();
                        if (d.abandonDwellTimeMsString != null) {
                            m.abandonDwellTimeMsString = String(d.abandonDwellTimeMsString);
                        }
                        return m;
                    };

                    SideBySideSurveyAbandonEventData.toObject = function toObject(m, o) {
                        if (!o)
                            o = {};
                        var d = {};
                        if (m.abandonDwellTimeMsString != null && m.hasOwnProperty("abandonDwellTimeMsString")) {
                            d.abandonDwellTimeMsString = m.abandonDwellTimeMsString;
                            if (o.oneofs)
                                d._abandonDwellTimeMsString = "abandonDwellTimeMsString";
                        }
                        return d;
                    };

                    SideBySideSurveyAbandonEventData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    SideBySideSurveyAbandonEventData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyAbandonEventData";
                    };

                    return SideBySideSurveyAbandonEventData;
                })();

                SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData = (function() {

                    function SideBySideSurveyCTAClickEventData(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    SideBySideSurveyCTAClickEventData.prototype.isSurveyExpired = null;
                    SideBySideSurveyCTAClickEventData.prototype.clickDwellTimeMsString = null;

                    let $oneOfFields;

                    // Virtual OneOf for proto3 optional field
                    Object.defineProperty(SideBySideSurveyCTAClickEventData.prototype, "_isSurveyExpired", {
                        get: $util.oneOfGetter($oneOfFields = ["isSurveyExpired"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    // Virtual OneOf for proto3 optional field
                    Object.defineProperty(SideBySideSurveyCTAClickEventData.prototype, "_clickDwellTimeMsString", {
                        get: $util.oneOfGetter($oneOfFields = ["clickDwellTimeMsString"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    SideBySideSurveyCTAClickEventData.create = function create(properties) {
                        return new SideBySideSurveyCTAClickEventData(properties);
                    };

                    SideBySideSurveyCTAClickEventData.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.isSurveyExpired != null && Object.hasOwnProperty.call(m, "isSurveyExpired"))
                            w.uint32(8).bool(m.isSurveyExpired);
                        if (m.clickDwellTimeMsString != null && Object.hasOwnProperty.call(m, "clickDwellTimeMsString"))
                            w.uint32(18).string(m.clickDwellTimeMsString);
                        return w;
                    };

                    SideBySideSurveyCTAClickEventData.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.isSurveyExpired = r.bool();
                                    break;
                                }
                            case 2: {
                                    m.clickDwellTimeMsString = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    SideBySideSurveyCTAClickEventData.fromObject = function fromObject(d) {
                        if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData)
                            return d;
                        var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData();
                        if (d.isSurveyExpired != null) {
                            m.isSurveyExpired = Boolean(d.isSurveyExpired);
                        }
                        if (d.clickDwellTimeMsString != null) {
                            m.clickDwellTimeMsString = String(d.clickDwellTimeMsString);
                        }
                        return m;
                    };

                    SideBySideSurveyCTAClickEventData.toObject = function toObject(m, o) {
                        if (!o)
                            o = {};
                        var d = {};
                        if (m.isSurveyExpired != null && m.hasOwnProperty("isSurveyExpired")) {
                            d.isSurveyExpired = m.isSurveyExpired;
                            if (o.oneofs)
                                d._isSurveyExpired = "isSurveyExpired";
                        }
                        if (m.clickDwellTimeMsString != null && m.hasOwnProperty("clickDwellTimeMsString")) {
                            d.clickDwellTimeMsString = m.clickDwellTimeMsString;
                            if (o.oneofs)
                                d._clickDwellTimeMsString = "clickDwellTimeMsString";
                        }
                        return d;
                    };

                    SideBySideSurveyCTAClickEventData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    SideBySideSurveyCTAClickEventData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAClickEventData";
                    };

                    return SideBySideSurveyCTAClickEventData;
                })();

                SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData = (function() {

                    function SideBySideSurveyCTAImpressionEventData(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    SideBySideSurveyCTAImpressionEventData.prototype.isSurveyExpired = null;

                    let $oneOfFields;

                    // Virtual OneOf for proto3 optional field
                    Object.defineProperty(SideBySideSurveyCTAImpressionEventData.prototype, "_isSurveyExpired", {
                        get: $util.oneOfGetter($oneOfFields = ["isSurveyExpired"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    SideBySideSurveyCTAImpressionEventData.create = function create(properties) {
                        return new SideBySideSurveyCTAImpressionEventData(properties);
                    };

                    SideBySideSurveyCTAImpressionEventData.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.isSurveyExpired != null && Object.hasOwnProperty.call(m, "isSurveyExpired"))
                            w.uint32(8).bool(m.isSurveyExpired);
                        return w;
                    };

                    SideBySideSurveyCTAImpressionEventData.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.isSurveyExpired = r.bool();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    SideBySideSurveyCTAImpressionEventData.fromObject = function fromObject(d) {
                        if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData)
                            return d;
                        var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData();
                        if (d.isSurveyExpired != null) {
                            m.isSurveyExpired = Boolean(d.isSurveyExpired);
                        }
                        return m;
                    };

                    SideBySideSurveyCTAImpressionEventData.toObject = function toObject(m, o) {
                        if (!o)
                            o = {};
                        var d = {};
                        if (m.isSurveyExpired != null && m.hasOwnProperty("isSurveyExpired")) {
                            d.isSurveyExpired = m.isSurveyExpired;
                            if (o.oneofs)
                                d._isSurveyExpired = "isSurveyExpired";
                        }
                        return d;
                    };

                    SideBySideSurveyCTAImpressionEventData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    SideBySideSurveyCTAImpressionEventData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCTAImpressionEventData";
                    };

                    return SideBySideSurveyCTAImpressionEventData;
                })();

                SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData = (function() {

                    function SideBySideSurveyCardImpressionEventData(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    SideBySideSurveyCardImpressionEventData.create = function create(properties) {
                        return new SideBySideSurveyCardImpressionEventData(properties);
                    };

                    SideBySideSurveyCardImpressionEventData.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        return w;
                    };

                    SideBySideSurveyCardImpressionEventData.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    SideBySideSurveyCardImpressionEventData.fromObject = function fromObject(d) {
                        if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData)
                            return d;
                        return new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData();
                    };

                    SideBySideSurveyCardImpressionEventData.toObject = function toObject() {
                        return {};
                    };

                    SideBySideSurveyCardImpressionEventData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    SideBySideSurveyCardImpressionEventData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyCardImpressionEventData";
                    };

                    return SideBySideSurveyCardImpressionEventData;
                })();

                SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData = (function() {

                    function SideBySideSurveyResponseEventData(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    SideBySideSurveyResponseEventData.prototype.responseDwellTimeMsString = null;
                    SideBySideSurveyResponseEventData.prototype.selectedResponseId = null;

                    let $oneOfFields;

                    // Virtual OneOf for proto3 optional field
                    Object.defineProperty(SideBySideSurveyResponseEventData.prototype, "_responseDwellTimeMsString", {
                        get: $util.oneOfGetter($oneOfFields = ["responseDwellTimeMsString"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    // Virtual OneOf for proto3 optional field
                    Object.defineProperty(SideBySideSurveyResponseEventData.prototype, "_selectedResponseId", {
                        get: $util.oneOfGetter($oneOfFields = ["selectedResponseId"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    SideBySideSurveyResponseEventData.create = function create(properties) {
                        return new SideBySideSurveyResponseEventData(properties);
                    };

                    SideBySideSurveyResponseEventData.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.responseDwellTimeMsString != null && Object.hasOwnProperty.call(m, "responseDwellTimeMsString"))
                            w.uint32(10).string(m.responseDwellTimeMsString);
                        if (m.selectedResponseId != null && Object.hasOwnProperty.call(m, "selectedResponseId"))
                            w.uint32(18).string(m.selectedResponseId);
                        return w;
                    };

                    SideBySideSurveyResponseEventData.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.responseDwellTimeMsString = r.string();
                                    break;
                                }
                            case 2: {
                                    m.selectedResponseId = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    SideBySideSurveyResponseEventData.fromObject = function fromObject(d) {
                        if (d instanceof $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData)
                            return d;
                        var m = new $root.proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData();
                        if (d.responseDwellTimeMsString != null) {
                            m.responseDwellTimeMsString = String(d.responseDwellTimeMsString);
                        }
                        if (d.selectedResponseId != null) {
                            m.selectedResponseId = String(d.selectedResponseId);
                        }
                        return m;
                    };

                    SideBySideSurveyResponseEventData.toObject = function toObject(m, o) {
                        if (!o)
                            o = {};
                        var d = {};
                        if (m.responseDwellTimeMsString != null && m.hasOwnProperty("responseDwellTimeMsString")) {
                            d.responseDwellTimeMsString = m.responseDwellTimeMsString;
                            if (o.oneofs)
                                d._responseDwellTimeMsString = "responseDwellTimeMsString";
                        }
                        if (m.selectedResponseId != null && m.hasOwnProperty("selectedResponseId")) {
                            d.selectedResponseId = m.selectedResponseId;
                            if (o.oneofs)
                                d._selectedResponseId = "selectedResponseId";
                        }
                        return d;
                    };

                    SideBySideSurveyResponseEventData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    SideBySideSurveyResponseEventData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.BotFeedbackMessage.SideBySideSurveyMetadata.SidebySideSurveyMetaAiAnalyticsData.SideBySideSurveyResponseEventData";
                    };

                    return SideBySideSurveyResponseEventData;
                })();

                return SidebySideSurveyMetaAiAnalyticsData;
            })();

            return SideBySideSurveyMetadata;
        })();

        return BotFeedbackMessage;
    })();

    proto.BotImagineMetadata = (function() {

        function BotImagineMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotImagineMetadata.prototype.imagineType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotImagineMetadata.prototype, "_imagineType", {
            get: $util.oneOfGetter($oneOfFields = ["imagineType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotImagineMetadata.create = function create(properties) {
            return new BotImagineMetadata(properties);
        };

        BotImagineMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.imagineType != null && Object.hasOwnProperty.call(m, "imagineType"))
                w.uint32(8).int32(m.imagineType);
            return w;
        };

        BotImagineMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotImagineMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.imagineType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotImagineMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotImagineMetadata)
                return d;
            var m = new $root.proto.BotImagineMetadata();
            switch (d.imagineType) {
            default:
                if (typeof d.imagineType === "number") {
                    m.imagineType = d.imagineType;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.imagineType = 0;
                break;
            case "IMAGINE":
            case 1:
                m.imagineType = 1;
                break;
            case "MEMU":
            case 2:
                m.imagineType = 2;
                break;
            case "FLASH":
            case 3:
                m.imagineType = 3;
                break;
            case "EDIT":
            case 4:
                m.imagineType = 4;
                break;
            }
            return m;
        };

        BotImagineMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.imagineType != null && m.hasOwnProperty("imagineType")) {
                d.imagineType = o.enums === String ? $root.proto.BotImagineMetadata.ImagineType[m.imagineType] === undefined ? m.imagineType : $root.proto.BotImagineMetadata.ImagineType[m.imagineType] : m.imagineType;
                if (o.oneofs)
                    d._imagineType = "imagineType";
            }
            return d;
        };

        BotImagineMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotImagineMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotImagineMetadata";
        };

        BotImagineMetadata.ImagineType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "IMAGINE"] = 1;
            values[valuesById[2] = "MEMU"] = 2;
            values[valuesById[3] = "FLASH"] = 3;
            values[valuesById[4] = "EDIT"] = 4;
            return values;
        })();

        return BotImagineMetadata;
    })();

    proto.BotLinkedAccount = (function() {

        function BotLinkedAccount(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotLinkedAccount.prototype.type = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccount.prototype, "_type", {
            get: $util.oneOfGetter($oneOfFields = ["type"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotLinkedAccount.create = function create(properties) {
            return new BotLinkedAccount(properties);
        };

        BotLinkedAccount.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                w.uint32(8).int32(m.type);
            return w;
        };

        BotLinkedAccount.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotLinkedAccount();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.type = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotLinkedAccount.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotLinkedAccount)
                return d;
            var m = new $root.proto.BotLinkedAccount();
            switch (d.type) {
            default:
                if (typeof d.type === "number") {
                    m.type = d.type;
                    break;
                }
                break;
            case "BOT_LINKED_ACCOUNT_TYPE_1P":
            case 0:
                m.type = 0;
                break;
            }
            return m;
        };

        BotLinkedAccount.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.type != null && m.hasOwnProperty("type")) {
                d.type = o.enums === String ? $root.proto.BotLinkedAccount.BotLinkedAccountType[m.type] === undefined ? m.type : $root.proto.BotLinkedAccount.BotLinkedAccountType[m.type] : m.type;
                if (o.oneofs)
                    d._type = "type";
            }
            return d;
        };

        BotLinkedAccount.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotLinkedAccount.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccount";
        };

        BotLinkedAccount.BotLinkedAccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "BOT_LINKED_ACCOUNT_TYPE_1P"] = 0;
            return values;
        })();

        return BotLinkedAccount;
    })();

    proto.BotLinkedAccountsMetadata = (function() {

        function BotLinkedAccountsMetadata(p) {
            this.accounts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotLinkedAccountsMetadata.prototype.accounts = $util.emptyArray;
        BotLinkedAccountsMetadata.prototype.acAuthTokens = null;
        BotLinkedAccountsMetadata.prototype.acErrorCode = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccountsMetadata.prototype, "_acAuthTokens", {
            get: $util.oneOfGetter($oneOfFields = ["acAuthTokens"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccountsMetadata.prototype, "_acErrorCode", {
            get: $util.oneOfGetter($oneOfFields = ["acErrorCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotLinkedAccountsMetadata.create = function create(properties) {
            return new BotLinkedAccountsMetadata(properties);
        };

        BotLinkedAccountsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.accounts != null && m.accounts.length) {
                for (var i = 0; i < m.accounts.length; ++i)
                    $root.proto.BotLinkedAccount.encode(m.accounts[i], w.uint32(10).fork()).ldelim();
            }
            if (m.acAuthTokens != null && Object.hasOwnProperty.call(m, "acAuthTokens"))
                w.uint32(18).bytes(m.acAuthTokens);
            if (m.acErrorCode != null && Object.hasOwnProperty.call(m, "acErrorCode"))
                w.uint32(24).int32(m.acErrorCode);
            return w;
        };

        BotLinkedAccountsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotLinkedAccountsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.accounts && m.accounts.length))
                            m.accounts = [];
                        m.accounts.push($root.proto.BotLinkedAccount.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        m.acAuthTokens = r.bytes();
                        break;
                    }
                case 3: {
                        m.acErrorCode = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotLinkedAccountsMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotLinkedAccountsMetadata)
                return d;
            var m = new $root.proto.BotLinkedAccountsMetadata();
            if (d.accounts) {
                if (!Array.isArray(d.accounts))
                    throw TypeError(".proto.BotLinkedAccountsMetadata.accounts: array expected");
                m.accounts = [];
                for (var i = 0; i < d.accounts.length; ++i) {
                    if (typeof d.accounts[i] !== "object")
                        throw TypeError(".proto.BotLinkedAccountsMetadata.accounts: object expected");
                    m.accounts[i] = $root.proto.BotLinkedAccount.fromObject(d.accounts[i]);
                }
            }
            if (d.acAuthTokens != null) {
                if (typeof d.acAuthTokens === "string")
                    $util.base64.decode(d.acAuthTokens, m.acAuthTokens = $util.newBuffer($util.base64.length(d.acAuthTokens)), 0);
                else if (d.acAuthTokens.length >= 0)
                    m.acAuthTokens = d.acAuthTokens;
            }
            if (d.acErrorCode != null) {
                m.acErrorCode = d.acErrorCode | 0;
            }
            return m;
        };

        BotLinkedAccountsMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.accounts = [];
            }
            if (m.accounts && m.accounts.length) {
                d.accounts = [];
                for (var j = 0; j < m.accounts.length; ++j) {
                    d.accounts[j] = $root.proto.BotLinkedAccount.toObject(m.accounts[j], o);
                }
            }
            if (m.acAuthTokens != null && m.hasOwnProperty("acAuthTokens")) {
                d.acAuthTokens = o.bytes === String ? $util.base64.encode(m.acAuthTokens, 0, m.acAuthTokens.length) : o.bytes === Array ? Array.prototype.slice.call(m.acAuthTokens) : m.acAuthTokens;
                if (o.oneofs)
                    d._acAuthTokens = "acAuthTokens";
            }
            if (m.acErrorCode != null && m.hasOwnProperty("acErrorCode")) {
                d.acErrorCode = m.acErrorCode;
                if (o.oneofs)
                    d._acErrorCode = "acErrorCode";
            }
            return d;
        };

        BotLinkedAccountsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotLinkedAccountsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccountsMetadata";
        };

        return BotLinkedAccountsMetadata;
    })();

    proto.BotMediaMetadata = (function() {

        function BotMediaMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMediaMetadata.prototype.fileSha256 = null;
        BotMediaMetadata.prototype.mediaKey = null;
        BotMediaMetadata.prototype.fileEncSha256 = null;
        BotMediaMetadata.prototype.directPath = null;
        BotMediaMetadata.prototype.mediaKeyTimestamp = null;
        BotMediaMetadata.prototype.mimetype = null;
        BotMediaMetadata.prototype.orientationType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_fileSha256", {
            get: $util.oneOfGetter($oneOfFields = ["fileSha256"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mediaKey", {
            get: $util.oneOfGetter($oneOfFields = ["mediaKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_fileEncSha256", {
            get: $util.oneOfGetter($oneOfFields = ["fileEncSha256"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_directPath", {
            get: $util.oneOfGetter($oneOfFields = ["directPath"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mediaKeyTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["mediaKeyTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mimetype", {
            get: $util.oneOfGetter($oneOfFields = ["mimetype"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_orientationType", {
            get: $util.oneOfGetter($oneOfFields = ["orientationType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMediaMetadata.create = function create(properties) {
            return new BotMediaMetadata(properties);
        };

        BotMediaMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                w.uint32(10).string(m.fileSha256);
            if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                w.uint32(18).string(m.mediaKey);
            if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                w.uint32(26).string(m.fileEncSha256);
            if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                w.uint32(34).string(m.directPath);
            if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                w.uint32(40).int64(m.mediaKeyTimestamp);
            if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                w.uint32(50).string(m.mimetype);
            if (m.orientationType != null && Object.hasOwnProperty.call(m, "orientationType"))
                w.uint32(56).int32(m.orientationType);
            return w;
        };

        BotMediaMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMediaMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fileSha256 = r.string();
                        break;
                    }
                case 2: {
                        m.mediaKey = r.string();
                        break;
                    }
                case 3: {
                        m.fileEncSha256 = r.string();
                        break;
                    }
                case 4: {
                        m.directPath = r.string();
                        break;
                    }
                case 5: {
                        m.mediaKeyTimestamp = r.int64();
                        break;
                    }
                case 6: {
                        m.mimetype = r.string();
                        break;
                    }
                case 7: {
                        m.orientationType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMediaMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMediaMetadata)
                return d;
            var m = new $root.proto.BotMediaMetadata();
            if (d.fileSha256 != null) {
                m.fileSha256 = String(d.fileSha256);
            }
            if (d.mediaKey != null) {
                m.mediaKey = String(d.mediaKey);
            }
            if (d.fileEncSha256 != null) {
                m.fileEncSha256 = String(d.fileEncSha256);
            }
            if (d.directPath != null) {
                m.directPath = String(d.directPath);
            }
            if (d.mediaKeyTimestamp != null) {
                if ($util.Long)
                    (m.mediaKeyTimestamp = $util.Long.fromValue(d.mediaKeyTimestamp)).unsigned = false;
                else if (typeof d.mediaKeyTimestamp === "string")
                    m.mediaKeyTimestamp = parseInt(d.mediaKeyTimestamp, 10);
                else if (typeof d.mediaKeyTimestamp === "number")
                    m.mediaKeyTimestamp = d.mediaKeyTimestamp;
                else if (typeof d.mediaKeyTimestamp === "object")
                    m.mediaKeyTimestamp = new $util.LongBits(d.mediaKeyTimestamp.low >>> 0, d.mediaKeyTimestamp.high >>> 0).toNumber();
            }
            if (d.mimetype != null) {
                m.mimetype = String(d.mimetype);
            }
            switch (d.orientationType) {
            default:
                if (typeof d.orientationType === "number") {
                    m.orientationType = d.orientationType;
                    break;
                }
                break;
            case "CENTER":
            case 1:
                m.orientationType = 1;
                break;
            case "LEFT":
            case 2:
                m.orientationType = 2;
                break;
            case "RIGHT":
            case 3:
                m.orientationType = 3;
                break;
            }
            return m;
        };

        BotMediaMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.fileSha256 != null && m.hasOwnProperty("fileSha256")) {
                d.fileSha256 = m.fileSha256;
                if (o.oneofs)
                    d._fileSha256 = "fileSha256";
            }
            if (m.mediaKey != null && m.hasOwnProperty("mediaKey")) {
                d.mediaKey = m.mediaKey;
                if (o.oneofs)
                    d._mediaKey = "mediaKey";
            }
            if (m.fileEncSha256 != null && m.hasOwnProperty("fileEncSha256")) {
                d.fileEncSha256 = m.fileEncSha256;
                if (o.oneofs)
                    d._fileEncSha256 = "fileEncSha256";
            }
            if (m.directPath != null && m.hasOwnProperty("directPath")) {
                d.directPath = m.directPath;
                if (o.oneofs)
                    d._directPath = "directPath";
            }
            if (m.mediaKeyTimestamp != null && m.hasOwnProperty("mediaKeyTimestamp")) {
                if (typeof m.mediaKeyTimestamp === "number")
                    d.mediaKeyTimestamp = o.longs === String ? String(m.mediaKeyTimestamp) : m.mediaKeyTimestamp;
                else
                    d.mediaKeyTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.mediaKeyTimestamp) : o.longs === Number ? new $util.LongBits(m.mediaKeyTimestamp.low >>> 0, m.mediaKeyTimestamp.high >>> 0).toNumber() : m.mediaKeyTimestamp;
                if (o.oneofs)
                    d._mediaKeyTimestamp = "mediaKeyTimestamp";
            }
            if (m.mimetype != null && m.hasOwnProperty("mimetype")) {
                d.mimetype = m.mimetype;
                if (o.oneofs)
                    d._mimetype = "mimetype";
            }
            if (m.orientationType != null && m.hasOwnProperty("orientationType")) {
                d.orientationType = o.enums === String ? $root.proto.BotMediaMetadata.OrientationType[m.orientationType] === undefined ? m.orientationType : $root.proto.BotMediaMetadata.OrientationType[m.orientationType] : m.orientationType;
                if (o.oneofs)
                    d._orientationType = "orientationType";
            }
            return d;
        };

        BotMediaMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMediaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMediaMetadata";
        };

        BotMediaMetadata.OrientationType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "CENTER"] = 1;
            values[valuesById[2] = "LEFT"] = 2;
            values[valuesById[3] = "RIGHT"] = 3;
            return values;
        })();

        return BotMediaMetadata;
    })();

    proto.BotMemoryFact = (function() {

        function BotMemoryFact(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemoryFact.prototype.fact = null;
        BotMemoryFact.prototype.factId = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryFact.prototype, "_fact", {
            get: $util.oneOfGetter($oneOfFields = ["fact"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryFact.prototype, "_factId", {
            get: $util.oneOfGetter($oneOfFields = ["factId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMemoryFact.create = function create(properties) {
            return new BotMemoryFact(properties);
        };

        BotMemoryFact.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fact != null && Object.hasOwnProperty.call(m, "fact"))
                w.uint32(10).string(m.fact);
            if (m.factId != null && Object.hasOwnProperty.call(m, "factId"))
                w.uint32(18).string(m.factId);
            return w;
        };

        BotMemoryFact.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemoryFact();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fact = r.string();
                        break;
                    }
                case 2: {
                        m.factId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemoryFact.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMemoryFact)
                return d;
            var m = new $root.proto.BotMemoryFact();
            if (d.fact != null) {
                m.fact = String(d.fact);
            }
            if (d.factId != null) {
                m.factId = String(d.factId);
            }
            return m;
        };

        BotMemoryFact.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.fact != null && m.hasOwnProperty("fact")) {
                d.fact = m.fact;
                if (o.oneofs)
                    d._fact = "fact";
            }
            if (m.factId != null && m.hasOwnProperty("factId")) {
                d.factId = m.factId;
                if (o.oneofs)
                    d._factId = "factId";
            }
            return d;
        };

        BotMemoryFact.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMemoryFact.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryFact";
        };

        return BotMemoryFact;
    })();

    proto.BotMemoryMetadata = (function() {

        function BotMemoryMetadata(p) {
            this.addedFacts = [];
            this.removedFacts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemoryMetadata.prototype.addedFacts = $util.emptyArray;
        BotMemoryMetadata.prototype.removedFacts = $util.emptyArray;
        BotMemoryMetadata.prototype.disclaimer = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryMetadata.prototype, "_disclaimer", {
            get: $util.oneOfGetter($oneOfFields = ["disclaimer"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMemoryMetadata.create = function create(properties) {
            return new BotMemoryMetadata(properties);
        };

        BotMemoryMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.addedFacts != null && m.addedFacts.length) {
                for (var i = 0; i < m.addedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(m.addedFacts[i], w.uint32(10).fork()).ldelim();
            }
            if (m.removedFacts != null && m.removedFacts.length) {
                for (var i = 0; i < m.removedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(m.removedFacts[i], w.uint32(18).fork()).ldelim();
            }
            if (m.disclaimer != null && Object.hasOwnProperty.call(m, "disclaimer"))
                w.uint32(26).string(m.disclaimer);
            return w;
        };

        BotMemoryMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemoryMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.addedFacts && m.addedFacts.length))
                            m.addedFacts = [];
                        m.addedFacts.push($root.proto.BotMemoryFact.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        if (!(m.removedFacts && m.removedFacts.length))
                            m.removedFacts = [];
                        m.removedFacts.push($root.proto.BotMemoryFact.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.disclaimer = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemoryMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMemoryMetadata)
                return d;
            var m = new $root.proto.BotMemoryMetadata();
            if (d.addedFacts) {
                if (!Array.isArray(d.addedFacts))
                    throw TypeError(".proto.BotMemoryMetadata.addedFacts: array expected");
                m.addedFacts = [];
                for (var i = 0; i < d.addedFacts.length; ++i) {
                    if (typeof d.addedFacts[i] !== "object")
                        throw TypeError(".proto.BotMemoryMetadata.addedFacts: object expected");
                    m.addedFacts[i] = $root.proto.BotMemoryFact.fromObject(d.addedFacts[i]);
                }
            }
            if (d.removedFacts) {
                if (!Array.isArray(d.removedFacts))
                    throw TypeError(".proto.BotMemoryMetadata.removedFacts: array expected");
                m.removedFacts = [];
                for (var i = 0; i < d.removedFacts.length; ++i) {
                    if (typeof d.removedFacts[i] !== "object")
                        throw TypeError(".proto.BotMemoryMetadata.removedFacts: object expected");
                    m.removedFacts[i] = $root.proto.BotMemoryFact.fromObject(d.removedFacts[i]);
                }
            }
            if (d.disclaimer != null) {
                m.disclaimer = String(d.disclaimer);
            }
            return m;
        };

        BotMemoryMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.addedFacts = [];
                d.removedFacts = [];
            }
            if (m.addedFacts && m.addedFacts.length) {
                d.addedFacts = [];
                for (var j = 0; j < m.addedFacts.length; ++j) {
                    d.addedFacts[j] = $root.proto.BotMemoryFact.toObject(m.addedFacts[j], o);
                }
            }
            if (m.removedFacts && m.removedFacts.length) {
                d.removedFacts = [];
                for (var j = 0; j < m.removedFacts.length; ++j) {
                    d.removedFacts[j] = $root.proto.BotMemoryFact.toObject(m.removedFacts[j], o);
                }
            }
            if (m.disclaimer != null && m.hasOwnProperty("disclaimer")) {
                d.disclaimer = m.disclaimer;
                if (o.oneofs)
                    d._disclaimer = "disclaimer";
            }
            return d;
        };

        BotMemoryMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMemoryMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryMetadata";
        };

        return BotMemoryMetadata;
    })();

    proto.BotMemuMetadata = (function() {

        function BotMemuMetadata(p) {
            this.faceImages = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemuMetadata.prototype.faceImages = $util.emptyArray;

        BotMemuMetadata.create = function create(properties) {
            return new BotMemuMetadata(properties);
        };

        BotMemuMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.faceImages != null && m.faceImages.length) {
                for (var i = 0; i < m.faceImages.length; ++i)
                    $root.proto.BotMediaMetadata.encode(m.faceImages[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotMemuMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemuMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.faceImages && m.faceImages.length))
                            m.faceImages = [];
                        m.faceImages.push($root.proto.BotMediaMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemuMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMemuMetadata)
                return d;
            var m = new $root.proto.BotMemuMetadata();
            if (d.faceImages) {
                if (!Array.isArray(d.faceImages))
                    throw TypeError(".proto.BotMemuMetadata.faceImages: array expected");
                m.faceImages = [];
                for (var i = 0; i < d.faceImages.length; ++i) {
                    if (typeof d.faceImages[i] !== "object")
                        throw TypeError(".proto.BotMemuMetadata.faceImages: object expected");
                    m.faceImages[i] = $root.proto.BotMediaMetadata.fromObject(d.faceImages[i]);
                }
            }
            return m;
        };

        BotMemuMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.faceImages = [];
            }
            if (m.faceImages && m.faceImages.length) {
                d.faceImages = [];
                for (var j = 0; j < m.faceImages.length; ++j) {
                    d.faceImages[j] = $root.proto.BotMediaMetadata.toObject(m.faceImages[j], o);
                }
            }
            return d;
        };

        BotMemuMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMemuMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemuMetadata";
        };

        return BotMemuMetadata;
    })();

    proto.BotMessageOrigin = (function() {

        function BotMessageOrigin(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMessageOrigin.prototype.type = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMessageOrigin.prototype, "_type", {
            get: $util.oneOfGetter($oneOfFields = ["type"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMessageOrigin.create = function create(properties) {
            return new BotMessageOrigin(properties);
        };

        BotMessageOrigin.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                w.uint32(8).int32(m.type);
            return w;
        };

        BotMessageOrigin.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMessageOrigin();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.type = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMessageOrigin.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMessageOrigin)
                return d;
            var m = new $root.proto.BotMessageOrigin();
            switch (d.type) {
            default:
                if (typeof d.type === "number") {
                    m.type = d.type;
                    break;
                }
                break;
            case "BOT_MESSAGE_ORIGIN_TYPE_AI_INITIATED":
            case 0:
                m.type = 0;
                break;
            }
            return m;
        };

        BotMessageOrigin.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.type != null && m.hasOwnProperty("type")) {
                d.type = o.enums === String ? $root.proto.BotMessageOrigin.BotMessageOriginType[m.type] === undefined ? m.type : $root.proto.BotMessageOrigin.BotMessageOriginType[m.type] : m.type;
                if (o.oneofs)
                    d._type = "type";
            }
            return d;
        };

        BotMessageOrigin.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMessageOrigin.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMessageOrigin";
        };

        BotMessageOrigin.BotMessageOriginType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "BOT_MESSAGE_ORIGIN_TYPE_AI_INITIATED"] = 0;
            return values;
        })();

        return BotMessageOrigin;
    })();

    proto.BotMessageOriginMetadata = (function() {

        function BotMessageOriginMetadata(p) {
            this.origins = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMessageOriginMetadata.prototype.origins = $util.emptyArray;

        BotMessageOriginMetadata.create = function create(properties) {
            return new BotMessageOriginMetadata(properties);
        };

        BotMessageOriginMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.origins != null && m.origins.length) {
                for (var i = 0; i < m.origins.length; ++i)
                    $root.proto.BotMessageOrigin.encode(m.origins[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotMessageOriginMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMessageOriginMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.origins && m.origins.length))
                            m.origins = [];
                        m.origins.push($root.proto.BotMessageOrigin.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMessageOriginMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMessageOriginMetadata)
                return d;
            var m = new $root.proto.BotMessageOriginMetadata();
            if (d.origins) {
                if (!Array.isArray(d.origins))
                    throw TypeError(".proto.BotMessageOriginMetadata.origins: array expected");
                m.origins = [];
                for (var i = 0; i < d.origins.length; ++i) {
                    if (typeof d.origins[i] !== "object")
                        throw TypeError(".proto.BotMessageOriginMetadata.origins: object expected");
                    m.origins[i] = $root.proto.BotMessageOrigin.fromObject(d.origins[i]);
                }
            }
            return m;
        };

        BotMessageOriginMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.origins = [];
            }
            if (m.origins && m.origins.length) {
                d.origins = [];
                for (var j = 0; j < m.origins.length; ++j) {
                    d.origins[j] = $root.proto.BotMessageOrigin.toObject(m.origins[j], o);
                }
            }
            return d;
        };

        BotMessageOriginMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMessageOriginMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMessageOriginMetadata";
        };

        return BotMessageOriginMetadata;
    })();

    proto.BotMessageSharingInfo = (function() {

        function BotMessageSharingInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMessageSharingInfo.prototype.botEntryPointOrigin = null;
        BotMessageSharingInfo.prototype.forwardScore = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMessageSharingInfo.prototype, "_botEntryPointOrigin", {
            get: $util.oneOfGetter($oneOfFields = ["botEntryPointOrigin"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMessageSharingInfo.prototype, "_forwardScore", {
            get: $util.oneOfGetter($oneOfFields = ["forwardScore"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMessageSharingInfo.create = function create(properties) {
            return new BotMessageSharingInfo(properties);
        };

        BotMessageSharingInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.botEntryPointOrigin != null && Object.hasOwnProperty.call(m, "botEntryPointOrigin"))
                w.uint32(8).int32(m.botEntryPointOrigin);
            if (m.forwardScore != null && Object.hasOwnProperty.call(m, "forwardScore"))
                w.uint32(16).uint32(m.forwardScore);
            return w;
        };

        BotMessageSharingInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMessageSharingInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.botEntryPointOrigin = r.int32();
                        break;
                    }
                case 2: {
                        m.forwardScore = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMessageSharingInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMessageSharingInfo)
                return d;
            var m = new $root.proto.BotMessageSharingInfo();
            switch (d.botEntryPointOrigin) {
            default:
                if (typeof d.botEntryPointOrigin === "number") {
                    m.botEntryPointOrigin = d.botEntryPointOrigin;
                    break;
                }
                break;
            case "UNDEFINED_ENTRY_POINT":
            case 0:
                m.botEntryPointOrigin = 0;
                break;
            case "FAVICON":
            case 1:
                m.botEntryPointOrigin = 1;
                break;
            case "CHATLIST":
            case 2:
                m.botEntryPointOrigin = 2;
                break;
            case "AISEARCH_NULL_STATE_PAPER_PLANE":
            case 3:
                m.botEntryPointOrigin = 3;
                break;
            case "AISEARCH_NULL_STATE_SUGGESTION":
            case 4:
                m.botEntryPointOrigin = 4;
                break;
            case "AISEARCH_TYPE_AHEAD_SUGGESTION":
            case 5:
                m.botEntryPointOrigin = 5;
                break;
            case "AISEARCH_TYPE_AHEAD_PAPER_PLANE":
            case 6:
                m.botEntryPointOrigin = 6;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST":
            case 7:
                m.botEntryPointOrigin = 7;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES":
            case 8:
                m.botEntryPointOrigin = 8;
                break;
            case "AIVOICE_SEARCH_BAR":
            case 9:
                m.botEntryPointOrigin = 9;
                break;
            case "AIVOICE_FAVICON":
            case 10:
                m.botEntryPointOrigin = 10;
                break;
            case "AISTUDIO":
            case 11:
                m.botEntryPointOrigin = 11;
                break;
            case "DEEPLINK":
            case 12:
                m.botEntryPointOrigin = 12;
                break;
            case "NOTIFICATION":
            case 13:
                m.botEntryPointOrigin = 13;
                break;
            case "PROFILE_MESSAGE_BUTTON":
            case 14:
                m.botEntryPointOrigin = 14;
                break;
            case "FORWARD":
            case 15:
                m.botEntryPointOrigin = 15;
                break;
            case "APP_SHORTCUT":
            case 16:
                m.botEntryPointOrigin = 16;
                break;
            case "FF_FAMILY":
            case 17:
                m.botEntryPointOrigin = 17;
                break;
            case "AI_TAB":
            case 18:
                m.botEntryPointOrigin = 18;
                break;
            case "AI_HOME":
            case 19:
                m.botEntryPointOrigin = 19;
                break;
            case "AI_DEEPLINK_IMMERSIVE":
            case 20:
                m.botEntryPointOrigin = 20;
                break;
            case "AI_DEEPLINK":
            case 21:
                m.botEntryPointOrigin = 21;
                break;
            case "META_AI_CHAT_SHORTCUT_AI_STUDIO":
            case 22:
                m.botEntryPointOrigin = 22;
                break;
            case "UGC_CHAT_SHORTCUT_AI_STUDIO":
            case 23:
                m.botEntryPointOrigin = 23;
                break;
            case "NEW_CHAT_AI_STUDIO":
            case 24:
                m.botEntryPointOrigin = 24;
                break;
            case "AIVOICE_FAVICON_CALL_HISTORY":
            case 25:
                m.botEntryPointOrigin = 25;
                break;
            case "ASK_META_AI_CONTEXT_MENU":
            case 26:
                m.botEntryPointOrigin = 26;
                break;
            case "ASK_META_AI_CONTEXT_MENU_1ON1":
            case 27:
                m.botEntryPointOrigin = 27;
                break;
            case "ASK_META_AI_CONTEXT_MENU_GROUP":
            case 28:
                m.botEntryPointOrigin = 28;
                break;
            case "INVOKE_META_AI_1ON1":
            case 29:
                m.botEntryPointOrigin = 29;
                break;
            case "INVOKE_META_AI_GROUP":
            case 30:
                m.botEntryPointOrigin = 30;
                break;
            case "META_AI_FORWARD":
            case 31:
                m.botEntryPointOrigin = 31;
                break;
            case "NEW_CHAT_AI_CONTACT":
            case 32:
                m.botEntryPointOrigin = 32;
                break;
            case "MESSAGE_QUICK_ACTION_1_ON_1_CHAT":
            case 33:
                m.botEntryPointOrigin = 33;
                break;
            case "MESSAGE_QUICK_ACTION_GROUP_CHAT":
            case 34:
                m.botEntryPointOrigin = 34;
                break;
            case "ATTACHMENT_TRAY_1_ON_1_CHAT":
            case 35:
                m.botEntryPointOrigin = 35;
                break;
            case "ATTACHMENT_TRAY_GROUP_CHAT":
            case 36:
                m.botEntryPointOrigin = 36;
                break;
            case "ASK_META_AI_MEDIA_VIEWER_1ON1":
            case 37:
                m.botEntryPointOrigin = 37;
                break;
            case "ASK_META_AI_MEDIA_VIEWER_GROUP":
            case 38:
                m.botEntryPointOrigin = 38;
                break;
            }
            if (d.forwardScore != null) {
                m.forwardScore = d.forwardScore >>> 0;
            }
            return m;
        };

        BotMessageSharingInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.botEntryPointOrigin != null && m.hasOwnProperty("botEntryPointOrigin")) {
                d.botEntryPointOrigin = o.enums === String ? $root.proto.BotMetricsEntryPoint[m.botEntryPointOrigin] === undefined ? m.botEntryPointOrigin : $root.proto.BotMetricsEntryPoint[m.botEntryPointOrigin] : m.botEntryPointOrigin;
                if (o.oneofs)
                    d._botEntryPointOrigin = "botEntryPointOrigin";
            }
            if (m.forwardScore != null && m.hasOwnProperty("forwardScore")) {
                d.forwardScore = m.forwardScore;
                if (o.oneofs)
                    d._forwardScore = "forwardScore";
            }
            return d;
        };

        BotMessageSharingInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMessageSharingInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMessageSharingInfo";
        };

        return BotMessageSharingInfo;
    })();

    proto.BotMetadata = (function() {

        function BotMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMetadata.prototype.avatarMetadata = null;
        BotMetadata.prototype.personaId = null;
        BotMetadata.prototype.pluginMetadata = null;
        BotMetadata.prototype.suggestedPromptMetadata = null;
        BotMetadata.prototype.invokerJid = null;
        BotMetadata.prototype.sessionMetadata = null;
        BotMetadata.prototype.memuMetadata = null;
        BotMetadata.prototype.timezone = null;
        BotMetadata.prototype.reminderMetadata = null;
        BotMetadata.prototype.modelMetadata = null;
        BotMetadata.prototype.messageDisclaimerText = null;
        BotMetadata.prototype.progressIndicatorMetadata = null;
        BotMetadata.prototype.capabilityMetadata = null;
        BotMetadata.prototype.imagineMetadata = null;
        BotMetadata.prototype.memoryMetadata = null;
        BotMetadata.prototype.renderingMetadata = null;
        BotMetadata.prototype.botMetricsMetadata = null;
        BotMetadata.prototype.botLinkedAccountsMetadata = null;
        BotMetadata.prototype.richResponseSourcesMetadata = null;
        BotMetadata.prototype.aiConversationContext = null;
        BotMetadata.prototype.botPromotionMessageMetadata = null;
        BotMetadata.prototype.botModeSelectionMetadata = null;
        BotMetadata.prototype.botQuotaMetadata = null;
        BotMetadata.prototype.botAgeCollectionMetadata = null;
        BotMetadata.prototype.conversationStarterPromptId = null;
        BotMetadata.prototype.botResponseId = null;
        BotMetadata.prototype.verificationMetadata = null;
        BotMetadata.prototype.unifiedResponseMutation = null;
        BotMetadata.prototype.botMessageOriginMetadata = null;
        BotMetadata.prototype.inThreadSurveyMetadata = null;
        BotMetadata.prototype.botThreadInfo = null;
        BotMetadata.prototype.regenerateMetadata = null;
        BotMetadata.prototype.sessionTransparencyMetadata = null;
        BotMetadata.prototype.internalMetadata = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_avatarMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["avatarMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_personaId", {
            get: $util.oneOfGetter($oneOfFields = ["personaId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_pluginMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["pluginMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_suggestedPromptMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["suggestedPromptMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_invokerJid", {
            get: $util.oneOfGetter($oneOfFields = ["invokerJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_sessionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["sessionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_memuMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["memuMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_timezone", {
            get: $util.oneOfGetter($oneOfFields = ["timezone"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_reminderMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["reminderMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_modelMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["modelMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_messageDisclaimerText", {
            get: $util.oneOfGetter($oneOfFields = ["messageDisclaimerText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_progressIndicatorMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["progressIndicatorMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_capabilityMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["capabilityMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_imagineMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["imagineMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_memoryMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["memoryMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_renderingMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["renderingMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botMetricsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botMetricsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botLinkedAccountsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botLinkedAccountsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_richResponseSourcesMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["richResponseSourcesMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_aiConversationContext", {
            get: $util.oneOfGetter($oneOfFields = ["aiConversationContext"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botPromotionMessageMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botPromotionMessageMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botModeSelectionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botModeSelectionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botQuotaMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botQuotaMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botAgeCollectionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botAgeCollectionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_conversationStarterPromptId", {
            get: $util.oneOfGetter($oneOfFields = ["conversationStarterPromptId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botResponseId", {
            get: $util.oneOfGetter($oneOfFields = ["botResponseId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_verificationMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["verificationMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_unifiedResponseMutation", {
            get: $util.oneOfGetter($oneOfFields = ["unifiedResponseMutation"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botMessageOriginMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botMessageOriginMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_inThreadSurveyMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["inThreadSurveyMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botThreadInfo", {
            get: $util.oneOfGetter($oneOfFields = ["botThreadInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_regenerateMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["regenerateMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_sessionTransparencyMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["sessionTransparencyMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_internalMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["internalMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMetadata.create = function create(properties) {
            return new BotMetadata(properties);
        };

        BotMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.avatarMetadata != null && Object.hasOwnProperty.call(m, "avatarMetadata"))
                $root.proto.BotAvatarMetadata.encode(m.avatarMetadata, w.uint32(10).fork()).ldelim();
            if (m.personaId != null && Object.hasOwnProperty.call(m, "personaId"))
                w.uint32(18).string(m.personaId);
            if (m.pluginMetadata != null && Object.hasOwnProperty.call(m, "pluginMetadata"))
                $root.proto.BotPluginMetadata.encode(m.pluginMetadata, w.uint32(26).fork()).ldelim();
            if (m.suggestedPromptMetadata != null && Object.hasOwnProperty.call(m, "suggestedPromptMetadata"))
                $root.proto.BotSuggestedPromptMetadata.encode(m.suggestedPromptMetadata, w.uint32(34).fork()).ldelim();
            if (m.invokerJid != null && Object.hasOwnProperty.call(m, "invokerJid"))
                w.uint32(42).string(m.invokerJid);
            if (m.sessionMetadata != null && Object.hasOwnProperty.call(m, "sessionMetadata"))
                $root.proto.BotSessionMetadata.encode(m.sessionMetadata, w.uint32(50).fork()).ldelim();
            if (m.memuMetadata != null && Object.hasOwnProperty.call(m, "memuMetadata"))
                $root.proto.BotMemuMetadata.encode(m.memuMetadata, w.uint32(58).fork()).ldelim();
            if (m.timezone != null && Object.hasOwnProperty.call(m, "timezone"))
                w.uint32(66).string(m.timezone);
            if (m.reminderMetadata != null && Object.hasOwnProperty.call(m, "reminderMetadata"))
                $root.proto.BotReminderMetadata.encode(m.reminderMetadata, w.uint32(74).fork()).ldelim();
            if (m.modelMetadata != null && Object.hasOwnProperty.call(m, "modelMetadata"))
                $root.proto.BotModelMetadata.encode(m.modelMetadata, w.uint32(82).fork()).ldelim();
            if (m.messageDisclaimerText != null && Object.hasOwnProperty.call(m, "messageDisclaimerText"))
                w.uint32(90).string(m.messageDisclaimerText);
            if (m.progressIndicatorMetadata != null && Object.hasOwnProperty.call(m, "progressIndicatorMetadata"))
                $root.proto.BotProgressIndicatorMetadata.encode(m.progressIndicatorMetadata, w.uint32(98).fork()).ldelim();
            if (m.capabilityMetadata != null && Object.hasOwnProperty.call(m, "capabilityMetadata"))
                $root.proto.BotCapabilityMetadata.encode(m.capabilityMetadata, w.uint32(106).fork()).ldelim();
            if (m.imagineMetadata != null && Object.hasOwnProperty.call(m, "imagineMetadata"))
                $root.proto.BotImagineMetadata.encode(m.imagineMetadata, w.uint32(114).fork()).ldelim();
            if (m.memoryMetadata != null && Object.hasOwnProperty.call(m, "memoryMetadata"))
                $root.proto.BotMemoryMetadata.encode(m.memoryMetadata, w.uint32(122).fork()).ldelim();
            if (m.renderingMetadata != null && Object.hasOwnProperty.call(m, "renderingMetadata"))
                $root.proto.BotRenderingMetadata.encode(m.renderingMetadata, w.uint32(130).fork()).ldelim();
            if (m.botMetricsMetadata != null && Object.hasOwnProperty.call(m, "botMetricsMetadata"))
                $root.proto.BotMetricsMetadata.encode(m.botMetricsMetadata, w.uint32(138).fork()).ldelim();
            if (m.botLinkedAccountsMetadata != null && Object.hasOwnProperty.call(m, "botLinkedAccountsMetadata"))
                $root.proto.BotLinkedAccountsMetadata.encode(m.botLinkedAccountsMetadata, w.uint32(146).fork()).ldelim();
            if (m.richResponseSourcesMetadata != null && Object.hasOwnProperty.call(m, "richResponseSourcesMetadata"))
                $root.proto.BotSourcesMetadata.encode(m.richResponseSourcesMetadata, w.uint32(154).fork()).ldelim();
            if (m.aiConversationContext != null && Object.hasOwnProperty.call(m, "aiConversationContext"))
                w.uint32(162).bytes(m.aiConversationContext);
            if (m.botPromotionMessageMetadata != null && Object.hasOwnProperty.call(m, "botPromotionMessageMetadata"))
                $root.proto.BotPromotionMessageMetadata.encode(m.botPromotionMessageMetadata, w.uint32(170).fork()).ldelim();
            if (m.botModeSelectionMetadata != null && Object.hasOwnProperty.call(m, "botModeSelectionMetadata"))
                $root.proto.BotModeSelectionMetadata.encode(m.botModeSelectionMetadata, w.uint32(178).fork()).ldelim();
            if (m.botQuotaMetadata != null && Object.hasOwnProperty.call(m, "botQuotaMetadata"))
                $root.proto.BotQuotaMetadata.encode(m.botQuotaMetadata, w.uint32(186).fork()).ldelim();
            if (m.botAgeCollectionMetadata != null && Object.hasOwnProperty.call(m, "botAgeCollectionMetadata"))
                $root.proto.BotAgeCollectionMetadata.encode(m.botAgeCollectionMetadata, w.uint32(194).fork()).ldelim();
            if (m.conversationStarterPromptId != null && Object.hasOwnProperty.call(m, "conversationStarterPromptId"))
                w.uint32(202).string(m.conversationStarterPromptId);
            if (m.botResponseId != null && Object.hasOwnProperty.call(m, "botResponseId"))
                w.uint32(210).string(m.botResponseId);
            if (m.verificationMetadata != null && Object.hasOwnProperty.call(m, "verificationMetadata"))
                $root.proto.BotSignatureVerificationMetadata.encode(m.verificationMetadata, w.uint32(218).fork()).ldelim();
            if (m.unifiedResponseMutation != null && Object.hasOwnProperty.call(m, "unifiedResponseMutation"))
                $root.proto.BotUnifiedResponseMutation.encode(m.unifiedResponseMutation, w.uint32(226).fork()).ldelim();
            if (m.botMessageOriginMetadata != null && Object.hasOwnProperty.call(m, "botMessageOriginMetadata"))
                $root.proto.BotMessageOriginMetadata.encode(m.botMessageOriginMetadata, w.uint32(234).fork()).ldelim();
            if (m.inThreadSurveyMetadata != null && Object.hasOwnProperty.call(m, "inThreadSurveyMetadata"))
                $root.proto.InThreadSurveyMetadata.encode(m.inThreadSurveyMetadata, w.uint32(242).fork()).ldelim();
            if (m.botThreadInfo != null && Object.hasOwnProperty.call(m, "botThreadInfo"))
                $root.proto.AIThreadInfo.encode(m.botThreadInfo, w.uint32(250).fork()).ldelim();
            if (m.regenerateMetadata != null && Object.hasOwnProperty.call(m, "regenerateMetadata"))
                $root.proto.AIRegenerateMetadata.encode(m.regenerateMetadata, w.uint32(258).fork()).ldelim();
            if (m.sessionTransparencyMetadata != null && Object.hasOwnProperty.call(m, "sessionTransparencyMetadata"))
                $root.proto.SessionTransparencyMetadata.encode(m.sessionTransparencyMetadata, w.uint32(266).fork()).ldelim();
            if (m.internalMetadata != null && Object.hasOwnProperty.call(m, "internalMetadata"))
                w.uint32(7994).bytes(m.internalMetadata);
            return w;
        };

        BotMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.avatarMetadata = $root.proto.BotAvatarMetadata.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.personaId = r.string();
                        break;
                    }
                case 3: {
                        m.pluginMetadata = $root.proto.BotPluginMetadata.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.decode(r, r.uint32());
                        break;
                    }
                case 5: {
                        m.invokerJid = r.string();
                        break;
                    }
                case 6: {
                        m.sessionMetadata = $root.proto.BotSessionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.memuMetadata = $root.proto.BotMemuMetadata.decode(r, r.uint32());
                        break;
                    }
                case 8: {
                        m.timezone = r.string();
                        break;
                    }
                case 9: {
                        m.reminderMetadata = $root.proto.BotReminderMetadata.decode(r, r.uint32());
                        break;
                    }
                case 10: {
                        m.modelMetadata = $root.proto.BotModelMetadata.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.messageDisclaimerText = r.string();
                        break;
                    }
                case 12: {
                        m.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.decode(r, r.uint32());
                        break;
                    }
                case 13: {
                        m.capabilityMetadata = $root.proto.BotCapabilityMetadata.decode(r, r.uint32());
                        break;
                    }
                case 14: {
                        m.imagineMetadata = $root.proto.BotImagineMetadata.decode(r, r.uint32());
                        break;
                    }
                case 15: {
                        m.memoryMetadata = $root.proto.BotMemoryMetadata.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.renderingMetadata = $root.proto.BotRenderingMetadata.decode(r, r.uint32());
                        break;
                    }
                case 17: {
                        m.botMetricsMetadata = $root.proto.BotMetricsMetadata.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.decode(r, r.uint32());
                        break;
                    }
                case 19: {
                        m.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.aiConversationContext = r.bytes();
                        break;
                    }
                case 21: {
                        m.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.decode(r, r.uint32());
                        break;
                    }
                case 22: {
                        m.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 23: {
                        m.botQuotaMetadata = $root.proto.BotQuotaMetadata.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 25: {
                        m.conversationStarterPromptId = r.string();
                        break;
                    }
                case 26: {
                        m.botResponseId = r.string();
                        break;
                    }
                case 27: {
                        m.verificationMetadata = $root.proto.BotSignatureVerificationMetadata.decode(r, r.uint32());
                        break;
                    }
                case 28: {
                        m.unifiedResponseMutation = $root.proto.BotUnifiedResponseMutation.decode(r, r.uint32());
                        break;
                    }
                case 29: {
                        m.botMessageOriginMetadata = $root.proto.BotMessageOriginMetadata.decode(r, r.uint32());
                        break;
                    }
                case 30: {
                        m.inThreadSurveyMetadata = $root.proto.InThreadSurveyMetadata.decode(r, r.uint32());
                        break;
                    }
                case 31: {
                        m.botThreadInfo = $root.proto.AIThreadInfo.decode(r, r.uint32());
                        break;
                    }
                case 32: {
                        m.regenerateMetadata = $root.proto.AIRegenerateMetadata.decode(r, r.uint32());
                        break;
                    }
                case 33: {
                        m.sessionTransparencyMetadata = $root.proto.SessionTransparencyMetadata.decode(r, r.uint32());
                        break;
                    }
                case 999: {
                        m.internalMetadata = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMetadata)
                return d;
            var m = new $root.proto.BotMetadata();
            if (d.avatarMetadata != null) {
                if (typeof d.avatarMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.avatarMetadata: object expected");
                m.avatarMetadata = $root.proto.BotAvatarMetadata.fromObject(d.avatarMetadata);
            }
            if (d.personaId != null) {
                m.personaId = String(d.personaId);
            }
            if (d.pluginMetadata != null) {
                if (typeof d.pluginMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.pluginMetadata: object expected");
                m.pluginMetadata = $root.proto.BotPluginMetadata.fromObject(d.pluginMetadata);
            }
            if (d.suggestedPromptMetadata != null) {
                if (typeof d.suggestedPromptMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.suggestedPromptMetadata: object expected");
                m.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.fromObject(d.suggestedPromptMetadata);
            }
            if (d.invokerJid != null) {
                m.invokerJid = String(d.invokerJid);
            }
            if (d.sessionMetadata != null) {
                if (typeof d.sessionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.sessionMetadata: object expected");
                m.sessionMetadata = $root.proto.BotSessionMetadata.fromObject(d.sessionMetadata);
            }
            if (d.memuMetadata != null) {
                if (typeof d.memuMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.memuMetadata: object expected");
                m.memuMetadata = $root.proto.BotMemuMetadata.fromObject(d.memuMetadata);
            }
            if (d.timezone != null) {
                m.timezone = String(d.timezone);
            }
            if (d.reminderMetadata != null) {
                if (typeof d.reminderMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.reminderMetadata: object expected");
                m.reminderMetadata = $root.proto.BotReminderMetadata.fromObject(d.reminderMetadata);
            }
            if (d.modelMetadata != null) {
                if (typeof d.modelMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.modelMetadata: object expected");
                m.modelMetadata = $root.proto.BotModelMetadata.fromObject(d.modelMetadata);
            }
            if (d.messageDisclaimerText != null) {
                m.messageDisclaimerText = String(d.messageDisclaimerText);
            }
            if (d.progressIndicatorMetadata != null) {
                if (typeof d.progressIndicatorMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.progressIndicatorMetadata: object expected");
                m.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.fromObject(d.progressIndicatorMetadata);
            }
            if (d.capabilityMetadata != null) {
                if (typeof d.capabilityMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.capabilityMetadata: object expected");
                m.capabilityMetadata = $root.proto.BotCapabilityMetadata.fromObject(d.capabilityMetadata);
            }
            if (d.imagineMetadata != null) {
                if (typeof d.imagineMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.imagineMetadata: object expected");
                m.imagineMetadata = $root.proto.BotImagineMetadata.fromObject(d.imagineMetadata);
            }
            if (d.memoryMetadata != null) {
                if (typeof d.memoryMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.memoryMetadata: object expected");
                m.memoryMetadata = $root.proto.BotMemoryMetadata.fromObject(d.memoryMetadata);
            }
            if (d.renderingMetadata != null) {
                if (typeof d.renderingMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.renderingMetadata: object expected");
                m.renderingMetadata = $root.proto.BotRenderingMetadata.fromObject(d.renderingMetadata);
            }
            if (d.botMetricsMetadata != null) {
                if (typeof d.botMetricsMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botMetricsMetadata: object expected");
                m.botMetricsMetadata = $root.proto.BotMetricsMetadata.fromObject(d.botMetricsMetadata);
            }
            if (d.botLinkedAccountsMetadata != null) {
                if (typeof d.botLinkedAccountsMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botLinkedAccountsMetadata: object expected");
                m.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.fromObject(d.botLinkedAccountsMetadata);
            }
            if (d.richResponseSourcesMetadata != null) {
                if (typeof d.richResponseSourcesMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.richResponseSourcesMetadata: object expected");
                m.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.fromObject(d.richResponseSourcesMetadata);
            }
            if (d.aiConversationContext != null) {
                if (typeof d.aiConversationContext === "string")
                    $util.base64.decode(d.aiConversationContext, m.aiConversationContext = $util.newBuffer($util.base64.length(d.aiConversationContext)), 0);
                else if (d.aiConversationContext.length >= 0)
                    m.aiConversationContext = d.aiConversationContext;
            }
            if (d.botPromotionMessageMetadata != null) {
                if (typeof d.botPromotionMessageMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botPromotionMessageMetadata: object expected");
                m.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.fromObject(d.botPromotionMessageMetadata);
            }
            if (d.botModeSelectionMetadata != null) {
                if (typeof d.botModeSelectionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botModeSelectionMetadata: object expected");
                m.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.fromObject(d.botModeSelectionMetadata);
            }
            if (d.botQuotaMetadata != null) {
                if (typeof d.botQuotaMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botQuotaMetadata: object expected");
                m.botQuotaMetadata = $root.proto.BotQuotaMetadata.fromObject(d.botQuotaMetadata);
            }
            if (d.botAgeCollectionMetadata != null) {
                if (typeof d.botAgeCollectionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botAgeCollectionMetadata: object expected");
                m.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.fromObject(d.botAgeCollectionMetadata);
            }
            if (d.conversationStarterPromptId != null) {
                m.conversationStarterPromptId = String(d.conversationStarterPromptId);
            }
            if (d.botResponseId != null) {
                m.botResponseId = String(d.botResponseId);
            }
            if (d.verificationMetadata != null) {
                if (typeof d.verificationMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.verificationMetadata: object expected");
                m.verificationMetadata = $root.proto.BotSignatureVerificationMetadata.fromObject(d.verificationMetadata);
            }
            if (d.unifiedResponseMutation != null) {
                if (typeof d.unifiedResponseMutation !== "object")
                    throw TypeError(".proto.BotMetadata.unifiedResponseMutation: object expected");
                m.unifiedResponseMutation = $root.proto.BotUnifiedResponseMutation.fromObject(d.unifiedResponseMutation);
            }
            if (d.botMessageOriginMetadata != null) {
                if (typeof d.botMessageOriginMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botMessageOriginMetadata: object expected");
                m.botMessageOriginMetadata = $root.proto.BotMessageOriginMetadata.fromObject(d.botMessageOriginMetadata);
            }
            if (d.inThreadSurveyMetadata != null) {
                if (typeof d.inThreadSurveyMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.inThreadSurveyMetadata: object expected");
                m.inThreadSurveyMetadata = $root.proto.InThreadSurveyMetadata.fromObject(d.inThreadSurveyMetadata);
            }
            if (d.botThreadInfo != null) {
                if (typeof d.botThreadInfo !== "object")
                    throw TypeError(".proto.BotMetadata.botThreadInfo: object expected");
                m.botThreadInfo = $root.proto.AIThreadInfo.fromObject(d.botThreadInfo);
            }
            if (d.regenerateMetadata != null) {
                if (typeof d.regenerateMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.regenerateMetadata: object expected");
                m.regenerateMetadata = $root.proto.AIRegenerateMetadata.fromObject(d.regenerateMetadata);
            }
            if (d.sessionTransparencyMetadata != null) {
                if (typeof d.sessionTransparencyMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.sessionTransparencyMetadata: object expected");
                m.sessionTransparencyMetadata = $root.proto.SessionTransparencyMetadata.fromObject(d.sessionTransparencyMetadata);
            }
            if (d.internalMetadata != null) {
                if (typeof d.internalMetadata === "string")
                    $util.base64.decode(d.internalMetadata, m.internalMetadata = $util.newBuffer($util.base64.length(d.internalMetadata)), 0);
                else if (d.internalMetadata.length >= 0)
                    m.internalMetadata = d.internalMetadata;
            }
            return m;
        };

        BotMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.avatarMetadata != null && m.hasOwnProperty("avatarMetadata")) {
                d.avatarMetadata = $root.proto.BotAvatarMetadata.toObject(m.avatarMetadata, o);
                if (o.oneofs)
                    d._avatarMetadata = "avatarMetadata";
            }
            if (m.personaId != null && m.hasOwnProperty("personaId")) {
                d.personaId = m.personaId;
                if (o.oneofs)
                    d._personaId = "personaId";
            }
            if (m.pluginMetadata != null && m.hasOwnProperty("pluginMetadata")) {
                d.pluginMetadata = $root.proto.BotPluginMetadata.toObject(m.pluginMetadata, o);
                if (o.oneofs)
                    d._pluginMetadata = "pluginMetadata";
            }
            if (m.suggestedPromptMetadata != null && m.hasOwnProperty("suggestedPromptMetadata")) {
                d.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.toObject(m.suggestedPromptMetadata, o);
                if (o.oneofs)
                    d._suggestedPromptMetadata = "suggestedPromptMetadata";
            }
            if (m.invokerJid != null && m.hasOwnProperty("invokerJid")) {
                d.invokerJid = m.invokerJid;
                if (o.oneofs)
                    d._invokerJid = "invokerJid";
            }
            if (m.sessionMetadata != null && m.hasOwnProperty("sessionMetadata")) {
                d.sessionMetadata = $root.proto.BotSessionMetadata.toObject(m.sessionMetadata, o);
                if (o.oneofs)
                    d._sessionMetadata = "sessionMetadata";
            }
            if (m.memuMetadata != null && m.hasOwnProperty("memuMetadata")) {
                d.memuMetadata = $root.proto.BotMemuMetadata.toObject(m.memuMetadata, o);
                if (o.oneofs)
                    d._memuMetadata = "memuMetadata";
            }
            if (m.timezone != null && m.hasOwnProperty("timezone")) {
                d.timezone = m.timezone;
                if (o.oneofs)
                    d._timezone = "timezone";
            }
            if (m.reminderMetadata != null && m.hasOwnProperty("reminderMetadata")) {
                d.reminderMetadata = $root.proto.BotReminderMetadata.toObject(m.reminderMetadata, o);
                if (o.oneofs)
                    d._reminderMetadata = "reminderMetadata";
            }
            if (m.modelMetadata != null && m.hasOwnProperty("modelMetadata")) {
                d.modelMetadata = $root.proto.BotModelMetadata.toObject(m.modelMetadata, o);
                if (o.oneofs)
                    d._modelMetadata = "modelMetadata";
            }
            if (m.messageDisclaimerText != null && m.hasOwnProperty("messageDisclaimerText")) {
                d.messageDisclaimerText = m.messageDisclaimerText;
                if (o.oneofs)
                    d._messageDisclaimerText = "messageDisclaimerText";
            }
            if (m.progressIndicatorMetadata != null && m.hasOwnProperty("progressIndicatorMetadata")) {
                d.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.toObject(m.progressIndicatorMetadata, o);
                if (o.oneofs)
                    d._progressIndicatorMetadata = "progressIndicatorMetadata";
            }
            if (m.capabilityMetadata != null && m.hasOwnProperty("capabilityMetadata")) {
                d.capabilityMetadata = $root.proto.BotCapabilityMetadata.toObject(m.capabilityMetadata, o);
                if (o.oneofs)
                    d._capabilityMetadata = "capabilityMetadata";
            }
            if (m.imagineMetadata != null && m.hasOwnProperty("imagineMetadata")) {
                d.imagineMetadata = $root.proto.BotImagineMetadata.toObject(m.imagineMetadata, o);
                if (o.oneofs)
                    d._imagineMetadata = "imagineMetadata";
            }
            if (m.memoryMetadata != null && m.hasOwnProperty("memoryMetadata")) {
                d.memoryMetadata = $root.proto.BotMemoryMetadata.toObject(m.memoryMetadata, o);
                if (o.oneofs)
                    d._memoryMetadata = "memoryMetadata";
            }
            if (m.renderingMetadata != null && m.hasOwnProperty("renderingMetadata")) {
                d.renderingMetadata = $root.proto.BotRenderingMetadata.toObject(m.renderingMetadata, o);
                if (o.oneofs)
                    d._renderingMetadata = "renderingMetadata";
            }
            if (m.botMetricsMetadata != null && m.hasOwnProperty("botMetricsMetadata")) {
                d.botMetricsMetadata = $root.proto.BotMetricsMetadata.toObject(m.botMetricsMetadata, o);
                if (o.oneofs)
                    d._botMetricsMetadata = "botMetricsMetadata";
            }
            if (m.botLinkedAccountsMetadata != null && m.hasOwnProperty("botLinkedAccountsMetadata")) {
                d.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.toObject(m.botLinkedAccountsMetadata, o);
                if (o.oneofs)
                    d._botLinkedAccountsMetadata = "botLinkedAccountsMetadata";
            }
            if (m.richResponseSourcesMetadata != null && m.hasOwnProperty("richResponseSourcesMetadata")) {
                d.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.toObject(m.richResponseSourcesMetadata, o);
                if (o.oneofs)
                    d._richResponseSourcesMetadata = "richResponseSourcesMetadata";
            }
            if (m.aiConversationContext != null && m.hasOwnProperty("aiConversationContext")) {
                d.aiConversationContext = o.bytes === String ? $util.base64.encode(m.aiConversationContext, 0, m.aiConversationContext.length) : o.bytes === Array ? Array.prototype.slice.call(m.aiConversationContext) : m.aiConversationContext;
                if (o.oneofs)
                    d._aiConversationContext = "aiConversationContext";
            }
            if (m.botPromotionMessageMetadata != null && m.hasOwnProperty("botPromotionMessageMetadata")) {
                d.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.toObject(m.botPromotionMessageMetadata, o);
                if (o.oneofs)
                    d._botPromotionMessageMetadata = "botPromotionMessageMetadata";
            }
            if (m.botModeSelectionMetadata != null && m.hasOwnProperty("botModeSelectionMetadata")) {
                d.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.toObject(m.botModeSelectionMetadata, o);
                if (o.oneofs)
                    d._botModeSelectionMetadata = "botModeSelectionMetadata";
            }
            if (m.botQuotaMetadata != null && m.hasOwnProperty("botQuotaMetadata")) {
                d.botQuotaMetadata = $root.proto.BotQuotaMetadata.toObject(m.botQuotaMetadata, o);
                if (o.oneofs)
                    d._botQuotaMetadata = "botQuotaMetadata";
            }
            if (m.botAgeCollectionMetadata != null && m.hasOwnProperty("botAgeCollectionMetadata")) {
                d.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.toObject(m.botAgeCollectionMetadata, o);
                if (o.oneofs)
                    d._botAgeCollectionMetadata = "botAgeCollectionMetadata";
            }
            if (m.conversationStarterPromptId != null && m.hasOwnProperty("conversationStarterPromptId")) {
                d.conversationStarterPromptId = m.conversationStarterPromptId;
                if (o.oneofs)
                    d._conversationStarterPromptId = "conversationStarterPromptId";
            }
            if (m.botResponseId != null && m.hasOwnProperty("botResponseId")) {
                d.botResponseId = m.botResponseId;
                if (o.oneofs)
                    d._botResponseId = "botResponseId";
            }
            if (m.verificationMetadata != null && m.hasOwnProperty("verificationMetadata")) {
                d.verificationMetadata = $root.proto.BotSignatureVerificationMetadata.toObject(m.verificationMetadata, o);
                if (o.oneofs)
                    d._verificationMetadata = "verificationMetadata";
            }
            if (m.unifiedResponseMutation != null && m.hasOwnProperty("unifiedResponseMutation")) {
                d.unifiedResponseMutation = $root.proto.BotUnifiedResponseMutation.toObject(m.unifiedResponseMutation, o);
                if (o.oneofs)
                    d._unifiedResponseMutation = "unifiedResponseMutation";
            }
            if (m.botMessageOriginMetadata != null && m.hasOwnProperty("botMessageOriginMetadata")) {
                d.botMessageOriginMetadata = $root.proto.BotMessageOriginMetadata.toObject(m.botMessageOriginMetadata, o);
                if (o.oneofs)
                    d._botMessageOriginMetadata = "botMessageOriginMetadata";
            }
            if (m.inThreadSurveyMetadata != null && m.hasOwnProperty("inThreadSurveyMetadata")) {
                d.inThreadSurveyMetadata = $root.proto.InThreadSurveyMetadata.toObject(m.inThreadSurveyMetadata, o);
                if (o.oneofs)
                    d._inThreadSurveyMetadata = "inThreadSurveyMetadata";
            }
            if (m.botThreadInfo != null && m.hasOwnProperty("botThreadInfo")) {
                d.botThreadInfo = $root.proto.AIThreadInfo.toObject(m.botThreadInfo, o);
                if (o.oneofs)
                    d._botThreadInfo = "botThreadInfo";
            }
            if (m.regenerateMetadata != null && m.hasOwnProperty("regenerateMetadata")) {
                d.regenerateMetadata = $root.proto.AIRegenerateMetadata.toObject(m.regenerateMetadata, o);
                if (o.oneofs)
                    d._regenerateMetadata = "regenerateMetadata";
            }
            if (m.sessionTransparencyMetadata != null && m.hasOwnProperty("sessionTransparencyMetadata")) {
                d.sessionTransparencyMetadata = $root.proto.SessionTransparencyMetadata.toObject(m.sessionTransparencyMetadata, o);
                if (o.oneofs)
                    d._sessionTransparencyMetadata = "sessionTransparencyMetadata";
            }
            if (m.internalMetadata != null && m.hasOwnProperty("internalMetadata")) {
                d.internalMetadata = o.bytes === String ? $util.base64.encode(m.internalMetadata, 0, m.internalMetadata.length) : o.bytes === Array ? Array.prototype.slice.call(m.internalMetadata) : m.internalMetadata;
                if (o.oneofs)
                    d._internalMetadata = "internalMetadata";
            }
            return d;
        };

        BotMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetadata";
        };

        return BotMetadata;
    })();

    proto.BotMetricsEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "UNDEFINED_ENTRY_POINT"] = 0;
        values[valuesById[1] = "FAVICON"] = 1;
        values[valuesById[2] = "CHATLIST"] = 2;
        values[valuesById[3] = "AISEARCH_NULL_STATE_PAPER_PLANE"] = 3;
        values[valuesById[4] = "AISEARCH_NULL_STATE_SUGGESTION"] = 4;
        values[valuesById[5] = "AISEARCH_TYPE_AHEAD_SUGGESTION"] = 5;
        values[valuesById[6] = "AISEARCH_TYPE_AHEAD_PAPER_PLANE"] = 6;
        values[valuesById[7] = "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST"] = 7;
        values[valuesById[8] = "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES"] = 8;
        values[valuesById[9] = "AIVOICE_SEARCH_BAR"] = 9;
        values[valuesById[10] = "AIVOICE_FAVICON"] = 10;
        values[valuesById[11] = "AISTUDIO"] = 11;
        values[valuesById[12] = "DEEPLINK"] = 12;
        values[valuesById[13] = "NOTIFICATION"] = 13;
        values[valuesById[14] = "PROFILE_MESSAGE_BUTTON"] = 14;
        values[valuesById[15] = "FORWARD"] = 15;
        values[valuesById[16] = "APP_SHORTCUT"] = 16;
        values[valuesById[17] = "FF_FAMILY"] = 17;
        values[valuesById[18] = "AI_TAB"] = 18;
        values[valuesById[19] = "AI_HOME"] = 19;
        values[valuesById[20] = "AI_DEEPLINK_IMMERSIVE"] = 20;
        values[valuesById[21] = "AI_DEEPLINK"] = 21;
        values[valuesById[22] = "META_AI_CHAT_SHORTCUT_AI_STUDIO"] = 22;
        values[valuesById[23] = "UGC_CHAT_SHORTCUT_AI_STUDIO"] = 23;
        values[valuesById[24] = "NEW_CHAT_AI_STUDIO"] = 24;
        values[valuesById[25] = "AIVOICE_FAVICON_CALL_HISTORY"] = 25;
        values[valuesById[26] = "ASK_META_AI_CONTEXT_MENU"] = 26;
        values[valuesById[27] = "ASK_META_AI_CONTEXT_MENU_1ON1"] = 27;
        values[valuesById[28] = "ASK_META_AI_CONTEXT_MENU_GROUP"] = 28;
        values[valuesById[29] = "INVOKE_META_AI_1ON1"] = 29;
        values[valuesById[30] = "INVOKE_META_AI_GROUP"] = 30;
        values[valuesById[31] = "META_AI_FORWARD"] = 31;
        values[valuesById[32] = "NEW_CHAT_AI_CONTACT"] = 32;
        values[valuesById[33] = "MESSAGE_QUICK_ACTION_1_ON_1_CHAT"] = 33;
        values[valuesById[34] = "MESSAGE_QUICK_ACTION_GROUP_CHAT"] = 34;
        values[valuesById[35] = "ATTACHMENT_TRAY_1_ON_1_CHAT"] = 35;
        values[valuesById[36] = "ATTACHMENT_TRAY_GROUP_CHAT"] = 36;
        values[valuesById[37] = "ASK_META_AI_MEDIA_VIEWER_1ON1"] = 37;
        values[valuesById[38] = "ASK_META_AI_MEDIA_VIEWER_GROUP"] = 38;
        return values;
    })();

    proto.BotMetricsMetadata = (function() {

        function BotMetricsMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMetricsMetadata.prototype.destinationId = null;
        BotMetricsMetadata.prototype.destinationEntryPoint = null;
        BotMetricsMetadata.prototype.threadOrigin = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_destinationId", {
            get: $util.oneOfGetter($oneOfFields = ["destinationId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_destinationEntryPoint", {
            get: $util.oneOfGetter($oneOfFields = ["destinationEntryPoint"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_threadOrigin", {
            get: $util.oneOfGetter($oneOfFields = ["threadOrigin"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMetricsMetadata.create = function create(properties) {
            return new BotMetricsMetadata(properties);
        };

        BotMetricsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.destinationId != null && Object.hasOwnProperty.call(m, "destinationId"))
                w.uint32(10).string(m.destinationId);
            if (m.destinationEntryPoint != null && Object.hasOwnProperty.call(m, "destinationEntryPoint"))
                w.uint32(16).int32(m.destinationEntryPoint);
            if (m.threadOrigin != null && Object.hasOwnProperty.call(m, "threadOrigin"))
                w.uint32(24).int32(m.threadOrigin);
            return w;
        };

        BotMetricsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMetricsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.destinationId = r.string();
                        break;
                    }
                case 2: {
                        m.destinationEntryPoint = r.int32();
                        break;
                    }
                case 3: {
                        m.threadOrigin = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMetricsMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMetricsMetadata)
                return d;
            var m = new $root.proto.BotMetricsMetadata();
            if (d.destinationId != null) {
                m.destinationId = String(d.destinationId);
            }
            switch (d.destinationEntryPoint) {
            default:
                if (typeof d.destinationEntryPoint === "number") {
                    m.destinationEntryPoint = d.destinationEntryPoint;
                    break;
                }
                break;
            case "UNDEFINED_ENTRY_POINT":
            case 0:
                m.destinationEntryPoint = 0;
                break;
            case "FAVICON":
            case 1:
                m.destinationEntryPoint = 1;
                break;
            case "CHATLIST":
            case 2:
                m.destinationEntryPoint = 2;
                break;
            case "AISEARCH_NULL_STATE_PAPER_PLANE":
            case 3:
                m.destinationEntryPoint = 3;
                break;
            case "AISEARCH_NULL_STATE_SUGGESTION":
            case 4:
                m.destinationEntryPoint = 4;
                break;
            case "AISEARCH_TYPE_AHEAD_SUGGESTION":
            case 5:
                m.destinationEntryPoint = 5;
                break;
            case "AISEARCH_TYPE_AHEAD_PAPER_PLANE":
            case 6:
                m.destinationEntryPoint = 6;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST":
            case 7:
                m.destinationEntryPoint = 7;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES":
            case 8:
                m.destinationEntryPoint = 8;
                break;
            case "AIVOICE_SEARCH_BAR":
            case 9:
                m.destinationEntryPoint = 9;
                break;
            case "AIVOICE_FAVICON":
            case 10:
                m.destinationEntryPoint = 10;
                break;
            case "AISTUDIO":
            case 11:
                m.destinationEntryPoint = 11;
                break;
            case "DEEPLINK":
            case 12:
                m.destinationEntryPoint = 12;
                break;
            case "NOTIFICATION":
            case 13:
                m.destinationEntryPoint = 13;
                break;
            case "PROFILE_MESSAGE_BUTTON":
            case 14:
                m.destinationEntryPoint = 14;
                break;
            case "FORWARD":
            case 15:
                m.destinationEntryPoint = 15;
                break;
            case "APP_SHORTCUT":
            case 16:
                m.destinationEntryPoint = 16;
                break;
            case "FF_FAMILY":
            case 17:
                m.destinationEntryPoint = 17;
                break;
            case "AI_TAB":
            case 18:
                m.destinationEntryPoint = 18;
                break;
            case "AI_HOME":
            case 19:
                m.destinationEntryPoint = 19;
                break;
            case "AI_DEEPLINK_IMMERSIVE":
            case 20:
                m.destinationEntryPoint = 20;
                break;
            case "AI_DEEPLINK":
            case 21:
                m.destinationEntryPoint = 21;
                break;
            case "META_AI_CHAT_SHORTCUT_AI_STUDIO":
            case 22:
                m.destinationEntryPoint = 22;
                break;
            case "UGC_CHAT_SHORTCUT_AI_STUDIO":
            case 23:
                m.destinationEntryPoint = 23;
                break;
            case "NEW_CHAT_AI_STUDIO":
            case 24:
                m.destinationEntryPoint = 24;
                break;
            case "AIVOICE_FAVICON_CALL_HISTORY":
            case 25:
                m.destinationEntryPoint = 25;
                break;
            case "ASK_META_AI_CONTEXT_MENU":
            case 26:
                m.destinationEntryPoint = 26;
                break;
            case "ASK_META_AI_CONTEXT_MENU_1ON1":
            case 27:
                m.destinationEntryPoint = 27;
                break;
            case "ASK_META_AI_CONTEXT_MENU_GROUP":
            case 28:
                m.destinationEntryPoint = 28;
                break;
            case "INVOKE_META_AI_1ON1":
            case 29:
                m.destinationEntryPoint = 29;
                break;
            case "INVOKE_META_AI_GROUP":
            case 30:
                m.destinationEntryPoint = 30;
                break;
            case "META_AI_FORWARD":
            case 31:
                m.destinationEntryPoint = 31;
                break;
            case "NEW_CHAT_AI_CONTACT":
            case 32:
                m.destinationEntryPoint = 32;
                break;
            case "MESSAGE_QUICK_ACTION_1_ON_1_CHAT":
            case 33:
                m.destinationEntryPoint = 33;
                break;
            case "MESSAGE_QUICK_ACTION_GROUP_CHAT":
            case 34:
                m.destinationEntryPoint = 34;
                break;
            case "ATTACHMENT_TRAY_1_ON_1_CHAT":
            case 35:
                m.destinationEntryPoint = 35;
                break;
            case "ATTACHMENT_TRAY_GROUP_CHAT":
            case 36:
                m.destinationEntryPoint = 36;
                break;
            case "ASK_META_AI_MEDIA_VIEWER_1ON1":
            case 37:
                m.destinationEntryPoint = 37;
                break;
            case "ASK_META_AI_MEDIA_VIEWER_GROUP":
            case 38:
                m.destinationEntryPoint = 38;
                break;
            }
            switch (d.threadOrigin) {
            default:
                if (typeof d.threadOrigin === "number") {
                    m.threadOrigin = d.threadOrigin;
                    break;
                }
                break;
            case "AI_TAB_THREAD":
            case 1:
                m.threadOrigin = 1;
                break;
            case "AI_HOME_THREAD":
            case 2:
                m.threadOrigin = 2;
                break;
            case "AI_DEEPLINK_IMMERSIVE_THREAD":
            case 3:
                m.threadOrigin = 3;
                break;
            case "AI_DEEPLINK_THREAD":
            case 4:
                m.threadOrigin = 4;
                break;
            case "ASK_META_AI_CONTEXT_MENU_THREAD":
            case 5:
                m.threadOrigin = 5;
                break;
            }
            return m;
        };

        BotMetricsMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.destinationId != null && m.hasOwnProperty("destinationId")) {
                d.destinationId = m.destinationId;
                if (o.oneofs)
                    d._destinationId = "destinationId";
            }
            if (m.destinationEntryPoint != null && m.hasOwnProperty("destinationEntryPoint")) {
                d.destinationEntryPoint = o.enums === String ? $root.proto.BotMetricsEntryPoint[m.destinationEntryPoint] === undefined ? m.destinationEntryPoint : $root.proto.BotMetricsEntryPoint[m.destinationEntryPoint] : m.destinationEntryPoint;
                if (o.oneofs)
                    d._destinationEntryPoint = "destinationEntryPoint";
            }
            if (m.threadOrigin != null && m.hasOwnProperty("threadOrigin")) {
                d.threadOrigin = o.enums === String ? $root.proto.BotMetricsThreadEntryPoint[m.threadOrigin] === undefined ? m.threadOrigin : $root.proto.BotMetricsThreadEntryPoint[m.threadOrigin] : m.threadOrigin;
                if (o.oneofs)
                    d._threadOrigin = "threadOrigin";
            }
            return d;
        };

        BotMetricsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMetricsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetricsMetadata";
        };

        return BotMetricsMetadata;
    })();

    proto.BotMetricsThreadEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "AI_TAB_THREAD"] = 1;
        values[valuesById[2] = "AI_HOME_THREAD"] = 2;
        values[valuesById[3] = "AI_DEEPLINK_IMMERSIVE_THREAD"] = 3;
        values[valuesById[4] = "AI_DEEPLINK_THREAD"] = 4;
        values[valuesById[5] = "ASK_META_AI_CONTEXT_MENU_THREAD"] = 5;
        return values;
    })();

    proto.BotModeSelectionMetadata = (function() {

        function BotModeSelectionMetadata(p) {
            this.mode = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotModeSelectionMetadata.prototype.mode = $util.emptyArray;

        BotModeSelectionMetadata.create = function create(properties) {
            return new BotModeSelectionMetadata(properties);
        };

        BotModeSelectionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.mode != null && m.mode.length) {
                w.uint32(10).fork();
                for (var i = 0; i < m.mode.length; ++i)
                    w.int32(m.mode[i]);
                w.ldelim();
            }
            return w;
        };

        BotModeSelectionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotModeSelectionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.mode && m.mode.length))
                            m.mode = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.mode.push(r.int32());
                        } else
                            m.mode.push(r.int32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotModeSelectionMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotModeSelectionMetadata)
                return d;
            var m = new $root.proto.BotModeSelectionMetadata();
            if (d.mode) {
                if (!Array.isArray(d.mode))
                    throw TypeError(".proto.BotModeSelectionMetadata.mode: array expected");
                m.mode = [];
                for (var i = 0; i < d.mode.length; ++i) {
                    switch (d.mode[i]) {
                    default:
                        if (typeof d.mode[i] === "number") {
                            m.mode[i] = d.mode[i];
                            break;
                        }
                    case "UNKNOWN_MODE":
                    case 0:
                        m.mode[i] = 0;
                        break;
                    case "REASONING_MODE":
                    case 1:
                        m.mode[i] = 1;
                        break;
                    }
                }
            }
            return m;
        };

        BotModeSelectionMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.mode = [];
            }
            if (m.mode && m.mode.length) {
                d.mode = [];
                for (var j = 0; j < m.mode.length; ++j) {
                    d.mode[j] = o.enums === String ? $root.proto.BotModeSelectionMetadata.BotUserSelectionMode[m.mode[j]] === undefined ? m.mode[j] : $root.proto.BotModeSelectionMetadata.BotUserSelectionMode[m.mode[j]] : m.mode[j];
                }
            }
            return d;
        };

        BotModeSelectionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotModeSelectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModeSelectionMetadata";
        };

        BotModeSelectionMetadata.BotUserSelectionMode = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_MODE"] = 0;
            values[valuesById[1] = "REASONING_MODE"] = 1;
            return values;
        })();

        return BotModeSelectionMetadata;
    })();

    proto.BotModelMetadata = (function() {

        function BotModelMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotModelMetadata.prototype.modelType = null;
        BotModelMetadata.prototype.premiumModelStatus = null;
        BotModelMetadata.prototype.modelNameOverride = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_modelType", {
            get: $util.oneOfGetter($oneOfFields = ["modelType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_premiumModelStatus", {
            get: $util.oneOfGetter($oneOfFields = ["premiumModelStatus"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_modelNameOverride", {
            get: $util.oneOfGetter($oneOfFields = ["modelNameOverride"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotModelMetadata.create = function create(properties) {
            return new BotModelMetadata(properties);
        };

        BotModelMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.modelType != null && Object.hasOwnProperty.call(m, "modelType"))
                w.uint32(8).int32(m.modelType);
            if (m.premiumModelStatus != null && Object.hasOwnProperty.call(m, "premiumModelStatus"))
                w.uint32(16).int32(m.premiumModelStatus);
            if (m.modelNameOverride != null && Object.hasOwnProperty.call(m, "modelNameOverride"))
                w.uint32(26).string(m.modelNameOverride);
            return w;
        };

        BotModelMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotModelMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.modelType = r.int32();
                        break;
                    }
                case 2: {
                        m.premiumModelStatus = r.int32();
                        break;
                    }
                case 3: {
                        m.modelNameOverride = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotModelMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotModelMetadata)
                return d;
            var m = new $root.proto.BotModelMetadata();
            switch (d.modelType) {
            default:
                if (typeof d.modelType === "number") {
                    m.modelType = d.modelType;
                    break;
                }
                break;
            case "UNKNOWN_TYPE":
            case 0:
                m.modelType = 0;
                break;
            case "LLAMA_PROD":
            case 1:
                m.modelType = 1;
                break;
            case "LLAMA_PROD_PREMIUM":
            case 2:
                m.modelType = 2;
                break;
            }
            switch (d.premiumModelStatus) {
            default:
                if (typeof d.premiumModelStatus === "number") {
                    m.premiumModelStatus = d.premiumModelStatus;
                    break;
                }
                break;
            case "UNKNOWN_STATUS":
            case 0:
                m.premiumModelStatus = 0;
                break;
            case "AVAILABLE":
            case 1:
                m.premiumModelStatus = 1;
                break;
            case "QUOTA_EXCEED_LIMIT":
            case 2:
                m.premiumModelStatus = 2;
                break;
            }
            if (d.modelNameOverride != null) {
                m.modelNameOverride = String(d.modelNameOverride);
            }
            return m;
        };

        BotModelMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.modelType != null && m.hasOwnProperty("modelType")) {
                d.modelType = o.enums === String ? $root.proto.BotModelMetadata.ModelType[m.modelType] === undefined ? m.modelType : $root.proto.BotModelMetadata.ModelType[m.modelType] : m.modelType;
                if (o.oneofs)
                    d._modelType = "modelType";
            }
            if (m.premiumModelStatus != null && m.hasOwnProperty("premiumModelStatus")) {
                d.premiumModelStatus = o.enums === String ? $root.proto.BotModelMetadata.PremiumModelStatus[m.premiumModelStatus] === undefined ? m.premiumModelStatus : $root.proto.BotModelMetadata.PremiumModelStatus[m.premiumModelStatus] : m.premiumModelStatus;
                if (o.oneofs)
                    d._premiumModelStatus = "premiumModelStatus";
            }
            if (m.modelNameOverride != null && m.hasOwnProperty("modelNameOverride")) {
                d.modelNameOverride = m.modelNameOverride;
                if (o.oneofs)
                    d._modelNameOverride = "modelNameOverride";
            }
            return d;
        };

        BotModelMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotModelMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModelMetadata";
        };

        BotModelMetadata.ModelType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "LLAMA_PROD"] = 1;
            values[valuesById[2] = "LLAMA_PROD_PREMIUM"] = 2;
            return values;
        })();

        BotModelMetadata.PremiumModelStatus = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_STATUS"] = 0;
            values[valuesById[1] = "AVAILABLE"] = 1;
            values[valuesById[2] = "QUOTA_EXCEED_LIMIT"] = 2;
            return values;
        })();

        return BotModelMetadata;
    })();

    proto.BotPluginMetadata = (function() {

        function BotPluginMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPluginMetadata.prototype.provider = null;
        BotPluginMetadata.prototype.pluginType = null;
        BotPluginMetadata.prototype.thumbnailCdnUrl = null;
        BotPluginMetadata.prototype.profilePhotoCdnUrl = null;
        BotPluginMetadata.prototype.searchProviderUrl = null;
        BotPluginMetadata.prototype.referenceIndex = null;
        BotPluginMetadata.prototype.expectedLinksCount = null;
        BotPluginMetadata.prototype.searchQuery = null;
        BotPluginMetadata.prototype.parentPluginMessageKey = null;
        BotPluginMetadata.prototype.deprecatedField = null;
        BotPluginMetadata.prototype.parentPluginType = null;
        BotPluginMetadata.prototype.faviconCdnUrl = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_provider", {
            get: $util.oneOfGetter($oneOfFields = ["provider"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_pluginType", {
            get: $util.oneOfGetter($oneOfFields = ["pluginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_thumbnailCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["thumbnailCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_profilePhotoCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["profilePhotoCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_searchProviderUrl", {
            get: $util.oneOfGetter($oneOfFields = ["searchProviderUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_referenceIndex", {
            get: $util.oneOfGetter($oneOfFields = ["referenceIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_expectedLinksCount", {
            get: $util.oneOfGetter($oneOfFields = ["expectedLinksCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_searchQuery", {
            get: $util.oneOfGetter($oneOfFields = ["searchQuery"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_parentPluginMessageKey", {
            get: $util.oneOfGetter($oneOfFields = ["parentPluginMessageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_deprecatedField", {
            get: $util.oneOfGetter($oneOfFields = ["deprecatedField"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_parentPluginType", {
            get: $util.oneOfGetter($oneOfFields = ["parentPluginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_faviconCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["faviconCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotPluginMetadata.create = function create(properties) {
            return new BotPluginMetadata(properties);
        };

        BotPluginMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                w.uint32(8).int32(m.provider);
            if (m.pluginType != null && Object.hasOwnProperty.call(m, "pluginType"))
                w.uint32(16).int32(m.pluginType);
            if (m.thumbnailCdnUrl != null && Object.hasOwnProperty.call(m, "thumbnailCdnUrl"))
                w.uint32(26).string(m.thumbnailCdnUrl);
            if (m.profilePhotoCdnUrl != null && Object.hasOwnProperty.call(m, "profilePhotoCdnUrl"))
                w.uint32(34).string(m.profilePhotoCdnUrl);
            if (m.searchProviderUrl != null && Object.hasOwnProperty.call(m, "searchProviderUrl"))
                w.uint32(42).string(m.searchProviderUrl);
            if (m.referenceIndex != null && Object.hasOwnProperty.call(m, "referenceIndex"))
                w.uint32(48).uint32(m.referenceIndex);
            if (m.expectedLinksCount != null && Object.hasOwnProperty.call(m, "expectedLinksCount"))
                w.uint32(56).uint32(m.expectedLinksCount);
            if (m.searchQuery != null && Object.hasOwnProperty.call(m, "searchQuery"))
                w.uint32(74).string(m.searchQuery);
            if (m.parentPluginMessageKey != null && Object.hasOwnProperty.call(m, "parentPluginMessageKey"))
                $root.proto.MessageKey.encode(m.parentPluginMessageKey, w.uint32(82).fork()).ldelim();
            if (m.deprecatedField != null && Object.hasOwnProperty.call(m, "deprecatedField"))
                w.uint32(88).int32(m.deprecatedField);
            if (m.parentPluginType != null && Object.hasOwnProperty.call(m, "parentPluginType"))
                w.uint32(96).int32(m.parentPluginType);
            if (m.faviconCdnUrl != null && Object.hasOwnProperty.call(m, "faviconCdnUrl"))
                w.uint32(106).string(m.faviconCdnUrl);
            return w;
        };

        BotPluginMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPluginMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.provider = r.int32();
                        break;
                    }
                case 2: {
                        m.pluginType = r.int32();
                        break;
                    }
                case 3: {
                        m.thumbnailCdnUrl = r.string();
                        break;
                    }
                case 4: {
                        m.profilePhotoCdnUrl = r.string();
                        break;
                    }
                case 5: {
                        m.searchProviderUrl = r.string();
                        break;
                    }
                case 6: {
                        m.referenceIndex = r.uint32();
                        break;
                    }
                case 7: {
                        m.expectedLinksCount = r.uint32();
                        break;
                    }
                case 9: {
                        m.searchQuery = r.string();
                        break;
                    }
                case 10: {
                        m.parentPluginMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.deprecatedField = r.int32();
                        break;
                    }
                case 12: {
                        m.parentPluginType = r.int32();
                        break;
                    }
                case 13: {
                        m.faviconCdnUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPluginMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPluginMetadata)
                return d;
            var m = new $root.proto.BotPluginMetadata();
            switch (d.provider) {
            default:
                if (typeof d.provider === "number") {
                    m.provider = d.provider;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.provider = 0;
                break;
            case "BING":
            case 1:
                m.provider = 1;
                break;
            case "GOOGLE":
            case 2:
                m.provider = 2;
                break;
            case "SUPPORT":
            case 3:
                m.provider = 3;
                break;
            }
            switch (d.pluginType) {
            default:
                if (typeof d.pluginType === "number") {
                    m.pluginType = d.pluginType;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                m.pluginType = 0;
                break;
            case "REELS":
            case 1:
                m.pluginType = 1;
                break;
            case "SEARCH":
            case 2:
                m.pluginType = 2;
                break;
            }
            if (d.thumbnailCdnUrl != null) {
                m.thumbnailCdnUrl = String(d.thumbnailCdnUrl);
            }
            if (d.profilePhotoCdnUrl != null) {
                m.profilePhotoCdnUrl = String(d.profilePhotoCdnUrl);
            }
            if (d.searchProviderUrl != null) {
                m.searchProviderUrl = String(d.searchProviderUrl);
            }
            if (d.referenceIndex != null) {
                m.referenceIndex = d.referenceIndex >>> 0;
            }
            if (d.expectedLinksCount != null) {
                m.expectedLinksCount = d.expectedLinksCount >>> 0;
            }
            if (d.searchQuery != null) {
                m.searchQuery = String(d.searchQuery);
            }
            if (d.parentPluginMessageKey != null) {
                if (typeof d.parentPluginMessageKey !== "object")
                    throw TypeError(".proto.BotPluginMetadata.parentPluginMessageKey: object expected");
                m.parentPluginMessageKey = $root.proto.MessageKey.fromObject(d.parentPluginMessageKey);
            }
            switch (d.deprecatedField) {
            default:
                if (typeof d.deprecatedField === "number") {
                    m.deprecatedField = d.deprecatedField;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                m.deprecatedField = 0;
                break;
            case "REELS":
            case 1:
                m.deprecatedField = 1;
                break;
            case "SEARCH":
            case 2:
                m.deprecatedField = 2;
                break;
            }
            switch (d.parentPluginType) {
            default:
                if (typeof d.parentPluginType === "number") {
                    m.parentPluginType = d.parentPluginType;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                m.parentPluginType = 0;
                break;
            case "REELS":
            case 1:
                m.parentPluginType = 1;
                break;
            case "SEARCH":
            case 2:
                m.parentPluginType = 2;
                break;
            }
            if (d.faviconCdnUrl != null) {
                m.faviconCdnUrl = String(d.faviconCdnUrl);
            }
            return m;
        };

        BotPluginMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.provider != null && m.hasOwnProperty("provider")) {
                d.provider = o.enums === String ? $root.proto.BotPluginMetadata.SearchProvider[m.provider] === undefined ? m.provider : $root.proto.BotPluginMetadata.SearchProvider[m.provider] : m.provider;
                if (o.oneofs)
                    d._provider = "provider";
            }
            if (m.pluginType != null && m.hasOwnProperty("pluginType")) {
                d.pluginType = o.enums === String ? $root.proto.BotPluginMetadata.PluginType[m.pluginType] === undefined ? m.pluginType : $root.proto.BotPluginMetadata.PluginType[m.pluginType] : m.pluginType;
                if (o.oneofs)
                    d._pluginType = "pluginType";
            }
            if (m.thumbnailCdnUrl != null && m.hasOwnProperty("thumbnailCdnUrl")) {
                d.thumbnailCdnUrl = m.thumbnailCdnUrl;
                if (o.oneofs)
                    d._thumbnailCdnUrl = "thumbnailCdnUrl";
            }
            if (m.profilePhotoCdnUrl != null && m.hasOwnProperty("profilePhotoCdnUrl")) {
                d.profilePhotoCdnUrl = m.profilePhotoCdnUrl;
                if (o.oneofs)
                    d._profilePhotoCdnUrl = "profilePhotoCdnUrl";
            }
            if (m.searchProviderUrl != null && m.hasOwnProperty("searchProviderUrl")) {
                d.searchProviderUrl = m.searchProviderUrl;
                if (o.oneofs)
                    d._searchProviderUrl = "searchProviderUrl";
            }
            if (m.referenceIndex != null && m.hasOwnProperty("referenceIndex")) {
                d.referenceIndex = m.referenceIndex;
                if (o.oneofs)
                    d._referenceIndex = "referenceIndex";
            }
            if (m.expectedLinksCount != null && m.hasOwnProperty("expectedLinksCount")) {
                d.expectedLinksCount = m.expectedLinksCount;
                if (o.oneofs)
                    d._expectedLinksCount = "expectedLinksCount";
            }
            if (m.searchQuery != null && m.hasOwnProperty("searchQuery")) {
                d.searchQuery = m.searchQuery;
                if (o.oneofs)
                    d._searchQuery = "searchQuery";
            }
            if (m.parentPluginMessageKey != null && m.hasOwnProperty("parentPluginMessageKey")) {
                d.parentPluginMessageKey = $root.proto.MessageKey.toObject(m.parentPluginMessageKey, o);
                if (o.oneofs)
                    d._parentPluginMessageKey = "parentPluginMessageKey";
            }
            if (m.deprecatedField != null && m.hasOwnProperty("deprecatedField")) {
                d.deprecatedField = o.enums === String ? $root.proto.BotPluginMetadata.PluginType[m.deprecatedField] === undefined ? m.deprecatedField : $root.proto.BotPluginMetadata.PluginType[m.deprecatedField] : m.deprecatedField;
                if (o.oneofs)
                    d._deprecatedField = "deprecatedField";
            }
            if (m.parentPluginType != null && m.hasOwnProperty("parentPluginType")) {
                d.parentPluginType = o.enums === String ? $root.proto.BotPluginMetadata.PluginType[m.parentPluginType] === undefined ? m.parentPluginType : $root.proto.BotPluginMetadata.PluginType[m.parentPluginType] : m.parentPluginType;
                if (o.oneofs)
                    d._parentPluginType = "parentPluginType";
            }
            if (m.faviconCdnUrl != null && m.hasOwnProperty("faviconCdnUrl")) {
                d.faviconCdnUrl = m.faviconCdnUrl;
                if (o.oneofs)
                    d._faviconCdnUrl = "faviconCdnUrl";
            }
            return d;
        };

        BotPluginMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPluginMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPluginMetadata";
        };

        BotPluginMetadata.PluginType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_PLUGIN"] = 0;
            values[valuesById[1] = "REELS"] = 1;
            values[valuesById[2] = "SEARCH"] = 2;
            return values;
        })();

        BotPluginMetadata.SearchProvider = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "BING"] = 1;
            values[valuesById[2] = "GOOGLE"] = 2;
            values[valuesById[3] = "SUPPORT"] = 3;
            return values;
        })();

        return BotPluginMetadata;
    })();

    proto.BotProgressIndicatorMetadata = (function() {

        function BotProgressIndicatorMetadata(p) {
            this.stepsMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotProgressIndicatorMetadata.prototype.progressDescription = null;
        BotProgressIndicatorMetadata.prototype.stepsMetadata = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotProgressIndicatorMetadata.prototype, "_progressDescription", {
            get: $util.oneOfGetter($oneOfFields = ["progressDescription"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotProgressIndicatorMetadata.create = function create(properties) {
            return new BotProgressIndicatorMetadata(properties);
        };

        BotProgressIndicatorMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.progressDescription != null && Object.hasOwnProperty.call(m, "progressDescription"))
                w.uint32(10).string(m.progressDescription);
            if (m.stepsMetadata != null && m.stepsMetadata.length) {
                for (var i = 0; i < m.stepsMetadata.length; ++i)
                    $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.encode(m.stepsMetadata[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        BotProgressIndicatorMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.progressDescription = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.stepsMetadata && m.stepsMetadata.length))
                            m.stepsMetadata = [];
                        m.stepsMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotProgressIndicatorMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotProgressIndicatorMetadata)
                return d;
            var m = new $root.proto.BotProgressIndicatorMetadata();
            if (d.progressDescription != null) {
                m.progressDescription = String(d.progressDescription);
            }
            if (d.stepsMetadata) {
                if (!Array.isArray(d.stepsMetadata))
                    throw TypeError(".proto.BotProgressIndicatorMetadata.stepsMetadata: array expected");
                m.stepsMetadata = [];
                for (var i = 0; i < d.stepsMetadata.length; ++i) {
                    if (typeof d.stepsMetadata[i] !== "object")
                        throw TypeError(".proto.BotProgressIndicatorMetadata.stepsMetadata: object expected");
                    m.stepsMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.fromObject(d.stepsMetadata[i]);
                }
            }
            return m;
        };

        BotProgressIndicatorMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.stepsMetadata = [];
            }
            if (m.progressDescription != null && m.hasOwnProperty("progressDescription")) {
                d.progressDescription = m.progressDescription;
                if (o.oneofs)
                    d._progressDescription = "progressDescription";
            }
            if (m.stepsMetadata && m.stepsMetadata.length) {
                d.stepsMetadata = [];
                for (var j = 0; j < m.stepsMetadata.length; ++j) {
                    d.stepsMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.toObject(m.stepsMetadata[j], o);
                }
            }
            return d;
        };

        BotProgressIndicatorMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotProgressIndicatorMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata";
        };

        BotProgressIndicatorMetadata.BotPlanningStepMetadata = (function() {

            function BotPlanningStepMetadata(p) {
                this.sourcesMetadata = [];
                this.sections = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotPlanningStepMetadata.prototype.statusTitle = null;
            BotPlanningStepMetadata.prototype.statusBody = null;
            BotPlanningStepMetadata.prototype.sourcesMetadata = $util.emptyArray;
            BotPlanningStepMetadata.prototype.status = null;
            BotPlanningStepMetadata.prototype.isReasoning = null;
            BotPlanningStepMetadata.prototype.isEnhancedSearch = null;
            BotPlanningStepMetadata.prototype.sections = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_statusTitle", {
                get: $util.oneOfGetter($oneOfFields = ["statusTitle"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_statusBody", {
                get: $util.oneOfGetter($oneOfFields = ["statusBody"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_status", {
                get: $util.oneOfGetter($oneOfFields = ["status"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_isReasoning", {
                get: $util.oneOfGetter($oneOfFields = ["isReasoning"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_isEnhancedSearch", {
                get: $util.oneOfGetter($oneOfFields = ["isEnhancedSearch"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BotPlanningStepMetadata.create = function create(properties) {
                return new BotPlanningStepMetadata(properties);
            };

            BotPlanningStepMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.statusTitle != null && Object.hasOwnProperty.call(m, "statusTitle"))
                    w.uint32(10).string(m.statusTitle);
                if (m.statusBody != null && Object.hasOwnProperty.call(m, "statusBody"))
                    w.uint32(18).string(m.statusBody);
                if (m.sourcesMetadata != null && m.sourcesMetadata.length) {
                    for (var i = 0; i < m.sourcesMetadata.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.encode(m.sourcesMetadata[i], w.uint32(26).fork()).ldelim();
                }
                if (m.status != null && Object.hasOwnProperty.call(m, "status"))
                    w.uint32(32).int32(m.status);
                if (m.isReasoning != null && Object.hasOwnProperty.call(m, "isReasoning"))
                    w.uint32(40).bool(m.isReasoning);
                if (m.isEnhancedSearch != null && Object.hasOwnProperty.call(m, "isEnhancedSearch"))
                    w.uint32(48).bool(m.isEnhancedSearch);
                if (m.sections != null && m.sections.length) {
                    for (var i = 0; i < m.sections.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.encode(m.sections[i], w.uint32(58).fork()).ldelim();
                }
                return w;
            };

            BotPlanningStepMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.statusTitle = r.string();
                            break;
                        }
                    case 2: {
                            m.statusBody = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.sourcesMetadata && m.sourcesMetadata.length))
                                m.sourcesMetadata = [];
                            m.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.decode(r, r.uint32()));
                            break;
                        }
                    case 4: {
                            m.status = r.int32();
                            break;
                        }
                    case 5: {
                            m.isReasoning = r.bool();
                            break;
                        }
                    case 6: {
                            m.isEnhancedSearch = r.bool();
                            break;
                        }
                    case 7: {
                            if (!(m.sections && m.sections.length))
                                m.sections = [];
                            m.sections.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotPlanningStepMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata)
                    return d;
                var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                if (d.statusTitle != null) {
                    m.statusTitle = String(d.statusTitle);
                }
                if (d.statusBody != null) {
                    m.statusBody = String(d.statusBody);
                }
                if (d.sourcesMetadata) {
                    if (!Array.isArray(d.sourcesMetadata))
                        throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sourcesMetadata: array expected");
                    m.sourcesMetadata = [];
                    for (var i = 0; i < d.sourcesMetadata.length; ++i) {
                        if (typeof d.sourcesMetadata[i] !== "object")
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sourcesMetadata: object expected");
                        m.sourcesMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.fromObject(d.sourcesMetadata[i]);
                    }
                }
                switch (d.status) {
                default:
                    if (typeof d.status === "number") {
                        m.status = d.status;
                        break;
                    }
                    break;
                case "UNKNOWN":
                case 0:
                    m.status = 0;
                    break;
                case "PLANNED":
                case 1:
                    m.status = 1;
                    break;
                case "EXECUTING":
                case 2:
                    m.status = 2;
                    break;
                case "FINISHED":
                case 3:
                    m.status = 3;
                    break;
                }
                if (d.isReasoning != null) {
                    m.isReasoning = Boolean(d.isReasoning);
                }
                if (d.isEnhancedSearch != null) {
                    m.isEnhancedSearch = Boolean(d.isEnhancedSearch);
                }
                if (d.sections) {
                    if (!Array.isArray(d.sections))
                        throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sections: array expected");
                    m.sections = [];
                    for (var i = 0; i < d.sections.length; ++i) {
                        if (typeof d.sections[i] !== "object")
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sections: object expected");
                        m.sections[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.fromObject(d.sections[i]);
                    }
                }
                return m;
            };

            BotPlanningStepMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.sourcesMetadata = [];
                    d.sections = [];
                }
                if (m.statusTitle != null && m.hasOwnProperty("statusTitle")) {
                    d.statusTitle = m.statusTitle;
                    if (o.oneofs)
                        d._statusTitle = "statusTitle";
                }
                if (m.statusBody != null && m.hasOwnProperty("statusBody")) {
                    d.statusBody = m.statusBody;
                    if (o.oneofs)
                        d._statusBody = "statusBody";
                }
                if (m.sourcesMetadata && m.sourcesMetadata.length) {
                    d.sourcesMetadata = [];
                    for (var j = 0; j < m.sourcesMetadata.length; ++j) {
                        d.sourcesMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.toObject(m.sourcesMetadata[j], o);
                    }
                }
                if (m.status != null && m.hasOwnProperty("status")) {
                    d.status = o.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus[m.status] === undefined ? m.status : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus[m.status] : m.status;
                    if (o.oneofs)
                        d._status = "status";
                }
                if (m.isReasoning != null && m.hasOwnProperty("isReasoning")) {
                    d.isReasoning = m.isReasoning;
                    if (o.oneofs)
                        d._isReasoning = "isReasoning";
                }
                if (m.isEnhancedSearch != null && m.hasOwnProperty("isEnhancedSearch")) {
                    d.isEnhancedSearch = m.isEnhancedSearch;
                    if (o.oneofs)
                        d._isEnhancedSearch = "isEnhancedSearch";
                }
                if (m.sections && m.sections.length) {
                    d.sections = [];
                    for (var j = 0; j < m.sections.length; ++j) {
                        d.sections[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.toObject(m.sections[j], o);
                    }
                }
                return d;
            };

            BotPlanningStepMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BotPlanningStepMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata";
            };

            BotPlanningStepMetadata.BotPlanningSearchSourceMetadata = (function() {

                function BotPlanningSearchSourceMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningSearchSourceMetadata.prototype.title = null;
                BotPlanningSearchSourceMetadata.prototype.provider = null;
                BotPlanningSearchSourceMetadata.prototype.sourceUrl = null;
                BotPlanningSearchSourceMetadata.prototype.favIconUrl = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_provider", {
                    get: $util.oneOfGetter($oneOfFields = ["provider"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_favIconUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["favIconUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                BotPlanningSearchSourceMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourceMetadata(properties);
                };

                BotPlanningSearchSourceMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                        w.uint32(16).int32(m.provider);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    if (m.favIconUrl != null && Object.hasOwnProperty.call(m, "favIconUrl"))
                        w.uint32(34).string(m.favIconUrl);
                    return w;
                };

                BotPlanningSearchSourceMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.provider = r.int32();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.favIconUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningSearchSourceMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata)
                        return d;
                    var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    if (d.title != null) {
                        m.title = String(d.title);
                    }
                    switch (d.provider) {
                    default:
                        if (typeof d.provider === "number") {
                            m.provider = d.provider;
                            break;
                        }
                        break;
                    case "UNKNOWN_PROVIDER":
                    case 0:
                        m.provider = 0;
                        break;
                    case "OTHER":
                    case 1:
                        m.provider = 1;
                        break;
                    case "GOOGLE":
                    case 2:
                        m.provider = 2;
                        break;
                    case "BING":
                    case 3:
                        m.provider = 3;
                        break;
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    if (d.favIconUrl != null) {
                        m.favIconUrl = String(d.favIconUrl);
                    }
                    return m;
                };

                BotPlanningSearchSourceMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.title != null && m.hasOwnProperty("title")) {
                        d.title = m.title;
                        if (o.oneofs)
                            d._title = "title";
                    }
                    if (m.provider != null && m.hasOwnProperty("provider")) {
                        d.provider = o.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider[m.provider] === undefined ? m.provider : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider[m.provider] : m.provider;
                        if (o.oneofs)
                            d._provider = "provider";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    if (m.favIconUrl != null && m.hasOwnProperty("favIconUrl")) {
                        d.favIconUrl = m.favIconUrl;
                        if (o.oneofs)
                            d._favIconUrl = "favIconUrl";
                    }
                    return d;
                };

                BotPlanningSearchSourceMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                BotPlanningSearchSourceMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata";
                };

                return BotPlanningSearchSourceMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata = (function() {

                function BotPlanningSearchSourcesMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningSearchSourcesMetadata.prototype.sourceTitle = null;
                BotPlanningSearchSourcesMetadata.prototype.provider = null;
                BotPlanningSearchSourcesMetadata.prototype.sourceUrl = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_sourceTitle", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceTitle"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_provider", {
                    get: $util.oneOfGetter($oneOfFields = ["provider"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                BotPlanningSearchSourcesMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourcesMetadata(properties);
                };

                BotPlanningSearchSourcesMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.sourceTitle != null && Object.hasOwnProperty.call(m, "sourceTitle"))
                        w.uint32(10).string(m.sourceTitle);
                    if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                        w.uint32(16).int32(m.provider);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    return w;
                };

                BotPlanningSearchSourcesMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.sourceTitle = r.string();
                                break;
                            }
                        case 2: {
                                m.provider = r.int32();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningSearchSourcesMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata)
                        return d;
                    var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    if (d.sourceTitle != null) {
                        m.sourceTitle = String(d.sourceTitle);
                    }
                    switch (d.provider) {
                    default:
                        if (typeof d.provider === "number") {
                            m.provider = d.provider;
                            break;
                        }
                        break;
                    case "UNKNOWN":
                    case 0:
                        m.provider = 0;
                        break;
                    case "OTHER":
                    case 1:
                        m.provider = 1;
                        break;
                    case "GOOGLE":
                    case 2:
                        m.provider = 2;
                        break;
                    case "BING":
                    case 3:
                        m.provider = 3;
                        break;
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    return m;
                };

                BotPlanningSearchSourcesMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.sourceTitle != null && m.hasOwnProperty("sourceTitle")) {
                        d.sourceTitle = m.sourceTitle;
                        if (o.oneofs)
                            d._sourceTitle = "sourceTitle";
                    }
                    if (m.provider != null && m.hasOwnProperty("provider")) {
                        d.provider = o.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider[m.provider] === undefined ? m.provider : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider[m.provider] : m.provider;
                        if (o.oneofs)
                            d._provider = "provider";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    return d;
                };

                BotPlanningSearchSourcesMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                BotPlanningSearchSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata";
                };

                BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "OTHER"] = 1;
                    values[valuesById[2] = "GOOGLE"] = 2;
                    values[valuesById[3] = "BING"] = 3;
                    return values;
                })();

                return BotPlanningSearchSourcesMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningStepSectionMetadata = (function() {

                function BotPlanningStepSectionMetadata(p) {
                    this.sourcesMetadata = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningStepSectionMetadata.prototype.sectionTitle = null;
                BotPlanningStepSectionMetadata.prototype.sectionBody = null;
                BotPlanningStepSectionMetadata.prototype.sourcesMetadata = $util.emptyArray;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningStepSectionMetadata.prototype, "_sectionTitle", {
                    get: $util.oneOfGetter($oneOfFields = ["sectionTitle"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningStepSectionMetadata.prototype, "_sectionBody", {
                    get: $util.oneOfGetter($oneOfFields = ["sectionBody"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                BotPlanningStepSectionMetadata.create = function create(properties) {
                    return new BotPlanningStepSectionMetadata(properties);
                };

                BotPlanningStepSectionMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.sectionTitle != null && Object.hasOwnProperty.call(m, "sectionTitle"))
                        w.uint32(10).string(m.sectionTitle);
                    if (m.sectionBody != null && Object.hasOwnProperty.call(m, "sectionBody"))
                        w.uint32(18).string(m.sectionBody);
                    if (m.sourcesMetadata != null && m.sourcesMetadata.length) {
                        for (var i = 0; i < m.sourcesMetadata.length; ++i)
                            $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.encode(m.sourcesMetadata[i], w.uint32(26).fork()).ldelim();
                    }
                    return w;
                };

                BotPlanningStepSectionMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.sectionTitle = r.string();
                                break;
                            }
                        case 2: {
                                m.sectionBody = r.string();
                                break;
                            }
                        case 3: {
                                if (!(m.sourcesMetadata && m.sourcesMetadata.length))
                                    m.sourcesMetadata = [];
                                m.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.decode(r, r.uint32()));
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningStepSectionMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata)
                        return d;
                    var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    if (d.sectionTitle != null) {
                        m.sectionTitle = String(d.sectionTitle);
                    }
                    if (d.sectionBody != null) {
                        m.sectionBody = String(d.sectionBody);
                    }
                    if (d.sourcesMetadata) {
                        if (!Array.isArray(d.sourcesMetadata))
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.sourcesMetadata: array expected");
                        m.sourcesMetadata = [];
                        for (var i = 0; i < d.sourcesMetadata.length; ++i) {
                            if (typeof d.sourcesMetadata[i] !== "object")
                                throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.sourcesMetadata: object expected");
                            m.sourcesMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.fromObject(d.sourcesMetadata[i]);
                        }
                    }
                    return m;
                };

                BotPlanningStepSectionMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (o.arrays || o.defaults) {
                        d.sourcesMetadata = [];
                    }
                    if (m.sectionTitle != null && m.hasOwnProperty("sectionTitle")) {
                        d.sectionTitle = m.sectionTitle;
                        if (o.oneofs)
                            d._sectionTitle = "sectionTitle";
                    }
                    if (m.sectionBody != null && m.hasOwnProperty("sectionBody")) {
                        d.sectionBody = m.sectionBody;
                        if (o.oneofs)
                            d._sectionBody = "sectionBody";
                    }
                    if (m.sourcesMetadata && m.sourcesMetadata.length) {
                        d.sourcesMetadata = [];
                        for (var j = 0; j < m.sourcesMetadata.length; ++j) {
                            d.sourcesMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.toObject(m.sourcesMetadata[j], o);
                        }
                    }
                    return d;
                };

                BotPlanningStepSectionMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                BotPlanningStepSectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata";
                };

                return BotPlanningStepSectionMetadata;
            })();

            BotPlanningStepMetadata.BotSearchSourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_PROVIDER"] = 0;
                values[valuesById[1] = "OTHER"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "BING"] = 3;
                return values;
            })();

            BotPlanningStepMetadata.PlanningStepStatus = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "PLANNED"] = 1;
                values[valuesById[2] = "EXECUTING"] = 2;
                values[valuesById[3] = "FINISHED"] = 3;
                return values;
            })();

            return BotPlanningStepMetadata;
        })();

        return BotProgressIndicatorMetadata;
    })();

    proto.BotPromotionMessageMetadata = (function() {

        function BotPromotionMessageMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromotionMessageMetadata.prototype.promotionType = null;
        BotPromotionMessageMetadata.prototype.buttonTitle = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromotionMessageMetadata.prototype, "_promotionType", {
            get: $util.oneOfGetter($oneOfFields = ["promotionType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromotionMessageMetadata.prototype, "_buttonTitle", {
            get: $util.oneOfGetter($oneOfFields = ["buttonTitle"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotPromotionMessageMetadata.create = function create(properties) {
            return new BotPromotionMessageMetadata(properties);
        };

        BotPromotionMessageMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.promotionType != null && Object.hasOwnProperty.call(m, "promotionType"))
                w.uint32(8).int32(m.promotionType);
            if (m.buttonTitle != null && Object.hasOwnProperty.call(m, "buttonTitle"))
                w.uint32(18).string(m.buttonTitle);
            return w;
        };

        BotPromotionMessageMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromotionMessageMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.promotionType = r.int32();
                        break;
                    }
                case 2: {
                        m.buttonTitle = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromotionMessageMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPromotionMessageMetadata)
                return d;
            var m = new $root.proto.BotPromotionMessageMetadata();
            switch (d.promotionType) {
            default:
                if (typeof d.promotionType === "number") {
                    m.promotionType = d.promotionType;
                    break;
                }
                break;
            case "UNKNOWN_TYPE":
            case 0:
                m.promotionType = 0;
                break;
            case "C50":
            case 1:
                m.promotionType = 1;
                break;
            case "SURVEY_PLATFORM":
            case 2:
                m.promotionType = 2;
                break;
            }
            if (d.buttonTitle != null) {
                m.buttonTitle = String(d.buttonTitle);
            }
            return m;
        };

        BotPromotionMessageMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.promotionType != null && m.hasOwnProperty("promotionType")) {
                d.promotionType = o.enums === String ? $root.proto.BotPromotionMessageMetadata.BotPromotionType[m.promotionType] === undefined ? m.promotionType : $root.proto.BotPromotionMessageMetadata.BotPromotionType[m.promotionType] : m.promotionType;
                if (o.oneofs)
                    d._promotionType = "promotionType";
            }
            if (m.buttonTitle != null && m.hasOwnProperty("buttonTitle")) {
                d.buttonTitle = m.buttonTitle;
                if (o.oneofs)
                    d._buttonTitle = "buttonTitle";
            }
            return d;
        };

        BotPromotionMessageMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPromotionMessageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromotionMessageMetadata";
        };

        BotPromotionMessageMetadata.BotPromotionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "C50"] = 1;
            values[valuesById[2] = "SURVEY_PLATFORM"] = 2;
            return values;
        })();

        return BotPromotionMessageMetadata;
    })();

    proto.BotPromptSuggestion = (function() {

        function BotPromptSuggestion(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromptSuggestion.prototype.prompt = null;
        BotPromptSuggestion.prototype.promptId = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromptSuggestion.prototype, "_prompt", {
            get: $util.oneOfGetter($oneOfFields = ["prompt"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromptSuggestion.prototype, "_promptId", {
            get: $util.oneOfGetter($oneOfFields = ["promptId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotPromptSuggestion.create = function create(properties) {
            return new BotPromptSuggestion(properties);
        };

        BotPromptSuggestion.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.prompt != null && Object.hasOwnProperty.call(m, "prompt"))
                w.uint32(10).string(m.prompt);
            if (m.promptId != null && Object.hasOwnProperty.call(m, "promptId"))
                w.uint32(18).string(m.promptId);
            return w;
        };

        BotPromptSuggestion.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromptSuggestion();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.prompt = r.string();
                        break;
                    }
                case 2: {
                        m.promptId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromptSuggestion.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPromptSuggestion)
                return d;
            var m = new $root.proto.BotPromptSuggestion();
            if (d.prompt != null) {
                m.prompt = String(d.prompt);
            }
            if (d.promptId != null) {
                m.promptId = String(d.promptId);
            }
            return m;
        };

        BotPromptSuggestion.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.prompt != null && m.hasOwnProperty("prompt")) {
                d.prompt = m.prompt;
                if (o.oneofs)
                    d._prompt = "prompt";
            }
            if (m.promptId != null && m.hasOwnProperty("promptId")) {
                d.promptId = m.promptId;
                if (o.oneofs)
                    d._promptId = "promptId";
            }
            return d;
        };

        BotPromptSuggestion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPromptSuggestion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestion";
        };

        return BotPromptSuggestion;
    })();

    proto.BotPromptSuggestions = (function() {

        function BotPromptSuggestions(p) {
            this.suggestions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromptSuggestions.prototype.suggestions = $util.emptyArray;

        BotPromptSuggestions.create = function create(properties) {
            return new BotPromptSuggestions(properties);
        };

        BotPromptSuggestions.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.suggestions != null && m.suggestions.length) {
                for (var i = 0; i < m.suggestions.length; ++i)
                    $root.proto.BotPromptSuggestion.encode(m.suggestions[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotPromptSuggestions.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromptSuggestions();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.suggestions && m.suggestions.length))
                            m.suggestions = [];
                        m.suggestions.push($root.proto.BotPromptSuggestion.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromptSuggestions.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPromptSuggestions)
                return d;
            var m = new $root.proto.BotPromptSuggestions();
            if (d.suggestions) {
                if (!Array.isArray(d.suggestions))
                    throw TypeError(".proto.BotPromptSuggestions.suggestions: array expected");
                m.suggestions = [];
                for (var i = 0; i < d.suggestions.length; ++i) {
                    if (typeof d.suggestions[i] !== "object")
                        throw TypeError(".proto.BotPromptSuggestions.suggestions: object expected");
                    m.suggestions[i] = $root.proto.BotPromptSuggestion.fromObject(d.suggestions[i]);
                }
            }
            return m;
        };

        BotPromptSuggestions.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.suggestions = [];
            }
            if (m.suggestions && m.suggestions.length) {
                d.suggestions = [];
                for (var j = 0; j < m.suggestions.length; ++j) {
                    d.suggestions[j] = $root.proto.BotPromptSuggestion.toObject(m.suggestions[j], o);
                }
            }
            return d;
        };

        BotPromptSuggestions.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPromptSuggestions.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestions";
        };

        return BotPromptSuggestions;
    })();

    proto.BotQuotaMetadata = (function() {

        function BotQuotaMetadata(p) {
            this.botFeatureQuotaMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotQuotaMetadata.prototype.botFeatureQuotaMetadata = $util.emptyArray;

        BotQuotaMetadata.create = function create(properties) {
            return new BotQuotaMetadata(properties);
        };

        BotQuotaMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.botFeatureQuotaMetadata != null && m.botFeatureQuotaMetadata.length) {
                for (var i = 0; i < m.botFeatureQuotaMetadata.length; ++i)
                    $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.encode(m.botFeatureQuotaMetadata[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotQuotaMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotQuotaMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.botFeatureQuotaMetadata && m.botFeatureQuotaMetadata.length))
                            m.botFeatureQuotaMetadata = [];
                        m.botFeatureQuotaMetadata.push($root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotQuotaMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotQuotaMetadata)
                return d;
            var m = new $root.proto.BotQuotaMetadata();
            if (d.botFeatureQuotaMetadata) {
                if (!Array.isArray(d.botFeatureQuotaMetadata))
                    throw TypeError(".proto.BotQuotaMetadata.botFeatureQuotaMetadata: array expected");
                m.botFeatureQuotaMetadata = [];
                for (var i = 0; i < d.botFeatureQuotaMetadata.length; ++i) {
                    if (typeof d.botFeatureQuotaMetadata[i] !== "object")
                        throw TypeError(".proto.BotQuotaMetadata.botFeatureQuotaMetadata: object expected");
                    m.botFeatureQuotaMetadata[i] = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.fromObject(d.botFeatureQuotaMetadata[i]);
                }
            }
            return m;
        };

        BotQuotaMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.botFeatureQuotaMetadata = [];
            }
            if (m.botFeatureQuotaMetadata && m.botFeatureQuotaMetadata.length) {
                d.botFeatureQuotaMetadata = [];
                for (var j = 0; j < m.botFeatureQuotaMetadata.length; ++j) {
                    d.botFeatureQuotaMetadata[j] = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.toObject(m.botFeatureQuotaMetadata[j], o);
                }
            }
            return d;
        };

        BotQuotaMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotQuotaMetadata";
        };

        BotQuotaMetadata.BotFeatureQuotaMetadata = (function() {

            function BotFeatureQuotaMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotFeatureQuotaMetadata.prototype.featureType = null;
            BotFeatureQuotaMetadata.prototype.remainingQuota = null;
            BotFeatureQuotaMetadata.prototype.expirationTimestamp = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_featureType", {
                get: $util.oneOfGetter($oneOfFields = ["featureType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_remainingQuota", {
                get: $util.oneOfGetter($oneOfFields = ["remainingQuota"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_expirationTimestamp", {
                get: $util.oneOfGetter($oneOfFields = ["expirationTimestamp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BotFeatureQuotaMetadata.create = function create(properties) {
                return new BotFeatureQuotaMetadata(properties);
            };

            BotFeatureQuotaMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.featureType != null && Object.hasOwnProperty.call(m, "featureType"))
                    w.uint32(8).int32(m.featureType);
                if (m.remainingQuota != null && Object.hasOwnProperty.call(m, "remainingQuota"))
                    w.uint32(16).uint32(m.remainingQuota);
                if (m.expirationTimestamp != null && Object.hasOwnProperty.call(m, "expirationTimestamp"))
                    w.uint32(24).uint64(m.expirationTimestamp);
                return w;
            };

            BotFeatureQuotaMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.featureType = r.int32();
                            break;
                        }
                    case 2: {
                            m.remainingQuota = r.uint32();
                            break;
                        }
                    case 3: {
                            m.expirationTimestamp = r.uint64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotFeatureQuotaMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata)
                    return d;
                var m = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                switch (d.featureType) {
                default:
                    if (typeof d.featureType === "number") {
                        m.featureType = d.featureType;
                        break;
                    }
                    break;
                case "UNKNOWN_FEATURE":
                case 0:
                    m.featureType = 0;
                    break;
                case "REASONING_FEATURE":
                case 1:
                    m.featureType = 1;
                    break;
                }
                if (d.remainingQuota != null) {
                    m.remainingQuota = d.remainingQuota >>> 0;
                }
                if (d.expirationTimestamp != null) {
                    if ($util.Long)
                        (m.expirationTimestamp = $util.Long.fromValue(d.expirationTimestamp)).unsigned = true;
                    else if (typeof d.expirationTimestamp === "string")
                        m.expirationTimestamp = parseInt(d.expirationTimestamp, 10);
                    else if (typeof d.expirationTimestamp === "number")
                        m.expirationTimestamp = d.expirationTimestamp;
                    else if (typeof d.expirationTimestamp === "object")
                        m.expirationTimestamp = new $util.LongBits(d.expirationTimestamp.low >>> 0, d.expirationTimestamp.high >>> 0).toNumber(true);
                }
                return m;
            };

            BotFeatureQuotaMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.featureType != null && m.hasOwnProperty("featureType")) {
                    d.featureType = o.enums === String ? $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType[m.featureType] === undefined ? m.featureType : $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType[m.featureType] : m.featureType;
                    if (o.oneofs)
                        d._featureType = "featureType";
                }
                if (m.remainingQuota != null && m.hasOwnProperty("remainingQuota")) {
                    d.remainingQuota = m.remainingQuota;
                    if (o.oneofs)
                        d._remainingQuota = "remainingQuota";
                }
                if (m.expirationTimestamp != null && m.hasOwnProperty("expirationTimestamp")) {
                    if (typeof m.expirationTimestamp === "number")
                        d.expirationTimestamp = o.longs === String ? String(m.expirationTimestamp) : m.expirationTimestamp;
                    else
                        d.expirationTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.expirationTimestamp) : o.longs === Number ? new $util.LongBits(m.expirationTimestamp.low >>> 0, m.expirationTimestamp.high >>> 0).toNumber(true) : m.expirationTimestamp;
                    if (o.oneofs)
                        d._expirationTimestamp = "expirationTimestamp";
                }
                return d;
            };

            BotFeatureQuotaMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BotFeatureQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotQuotaMetadata.BotFeatureQuotaMetadata";
            };

            BotFeatureQuotaMetadata.BotFeatureType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_FEATURE"] = 0;
                values[valuesById[1] = "REASONING_FEATURE"] = 1;
                return values;
            })();

            return BotFeatureQuotaMetadata;
        })();

        return BotQuotaMetadata;
    })();

    proto.BotReminderMetadata = (function() {

        function BotReminderMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotReminderMetadata.prototype.requestMessageKey = null;
        BotReminderMetadata.prototype.action = null;
        BotReminderMetadata.prototype.name = null;
        BotReminderMetadata.prototype.nextTriggerTimestamp = null;
        BotReminderMetadata.prototype.frequency = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_requestMessageKey", {
            get: $util.oneOfGetter($oneOfFields = ["requestMessageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_action", {
            get: $util.oneOfGetter($oneOfFields = ["action"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_name", {
            get: $util.oneOfGetter($oneOfFields = ["name"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_nextTriggerTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["nextTriggerTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_frequency", {
            get: $util.oneOfGetter($oneOfFields = ["frequency"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotReminderMetadata.create = function create(properties) {
            return new BotReminderMetadata(properties);
        };

        BotReminderMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.requestMessageKey != null && Object.hasOwnProperty.call(m, "requestMessageKey"))
                $root.proto.MessageKey.encode(m.requestMessageKey, w.uint32(10).fork()).ldelim();
            if (m.action != null && Object.hasOwnProperty.call(m, "action"))
                w.uint32(16).int32(m.action);
            if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                w.uint32(26).string(m.name);
            if (m.nextTriggerTimestamp != null && Object.hasOwnProperty.call(m, "nextTriggerTimestamp"))
                w.uint32(32).uint64(m.nextTriggerTimestamp);
            if (m.frequency != null && Object.hasOwnProperty.call(m, "frequency"))
                w.uint32(40).int32(m.frequency);
            return w;
        };

        BotReminderMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotReminderMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.requestMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.action = r.int32();
                        break;
                    }
                case 3: {
                        m.name = r.string();
                        break;
                    }
                case 4: {
                        m.nextTriggerTimestamp = r.uint64();
                        break;
                    }
                case 5: {
                        m.frequency = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotReminderMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotReminderMetadata)
                return d;
            var m = new $root.proto.BotReminderMetadata();
            if (d.requestMessageKey != null) {
                if (typeof d.requestMessageKey !== "object")
                    throw TypeError(".proto.BotReminderMetadata.requestMessageKey: object expected");
                m.requestMessageKey = $root.proto.MessageKey.fromObject(d.requestMessageKey);
            }
            switch (d.action) {
            default:
                if (typeof d.action === "number") {
                    m.action = d.action;
                    break;
                }
                break;
            case "NOTIFY":
            case 1:
                m.action = 1;
                break;
            case "CREATE":
            case 2:
                m.action = 2;
                break;
            case "DELETE":
            case 3:
                m.action = 3;
                break;
            case "UPDATE":
            case 4:
                m.action = 4;
                break;
            }
            if (d.name != null) {
                m.name = String(d.name);
            }
            if (d.nextTriggerTimestamp != null) {
                if ($util.Long)
                    (m.nextTriggerTimestamp = $util.Long.fromValue(d.nextTriggerTimestamp)).unsigned = true;
                else if (typeof d.nextTriggerTimestamp === "string")
                    m.nextTriggerTimestamp = parseInt(d.nextTriggerTimestamp, 10);
                else if (typeof d.nextTriggerTimestamp === "number")
                    m.nextTriggerTimestamp = d.nextTriggerTimestamp;
                else if (typeof d.nextTriggerTimestamp === "object")
                    m.nextTriggerTimestamp = new $util.LongBits(d.nextTriggerTimestamp.low >>> 0, d.nextTriggerTimestamp.high >>> 0).toNumber(true);
            }
            switch (d.frequency) {
            default:
                if (typeof d.frequency === "number") {
                    m.frequency = d.frequency;
                    break;
                }
                break;
            case "ONCE":
            case 1:
                m.frequency = 1;
                break;
            case "DAILY":
            case 2:
                m.frequency = 2;
                break;
            case "WEEKLY":
            case 3:
                m.frequency = 3;
                break;
            case "BIWEEKLY":
            case 4:
                m.frequency = 4;
                break;
            case "MONTHLY":
            case 5:
                m.frequency = 5;
                break;
            }
            return m;
        };

        BotReminderMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.requestMessageKey != null && m.hasOwnProperty("requestMessageKey")) {
                d.requestMessageKey = $root.proto.MessageKey.toObject(m.requestMessageKey, o);
                if (o.oneofs)
                    d._requestMessageKey = "requestMessageKey";
            }
            if (m.action != null && m.hasOwnProperty("action")) {
                d.action = o.enums === String ? $root.proto.BotReminderMetadata.ReminderAction[m.action] === undefined ? m.action : $root.proto.BotReminderMetadata.ReminderAction[m.action] : m.action;
                if (o.oneofs)
                    d._action = "action";
            }
            if (m.name != null && m.hasOwnProperty("name")) {
                d.name = m.name;
                if (o.oneofs)
                    d._name = "name";
            }
            if (m.nextTriggerTimestamp != null && m.hasOwnProperty("nextTriggerTimestamp")) {
                if (typeof m.nextTriggerTimestamp === "number")
                    d.nextTriggerTimestamp = o.longs === String ? String(m.nextTriggerTimestamp) : m.nextTriggerTimestamp;
                else
                    d.nextTriggerTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.nextTriggerTimestamp) : o.longs === Number ? new $util.LongBits(m.nextTriggerTimestamp.low >>> 0, m.nextTriggerTimestamp.high >>> 0).toNumber(true) : m.nextTriggerTimestamp;
                if (o.oneofs)
                    d._nextTriggerTimestamp = "nextTriggerTimestamp";
            }
            if (m.frequency != null && m.hasOwnProperty("frequency")) {
                d.frequency = o.enums === String ? $root.proto.BotReminderMetadata.ReminderFrequency[m.frequency] === undefined ? m.frequency : $root.proto.BotReminderMetadata.ReminderFrequency[m.frequency] : m.frequency;
                if (o.oneofs)
                    d._frequency = "frequency";
            }
            return d;
        };

        BotReminderMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotReminderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotReminderMetadata";
        };

        BotReminderMetadata.ReminderAction = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "NOTIFY"] = 1;
            values[valuesById[2] = "CREATE"] = 2;
            values[valuesById[3] = "DELETE"] = 3;
            values[valuesById[4] = "UPDATE"] = 4;
            return values;
        })();

        BotReminderMetadata.ReminderFrequency = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "ONCE"] = 1;
            values[valuesById[2] = "DAILY"] = 2;
            values[valuesById[3] = "WEEKLY"] = 3;
            values[valuesById[4] = "BIWEEKLY"] = 4;
            values[valuesById[5] = "MONTHLY"] = 5;
            return values;
        })();

        return BotReminderMetadata;
    })();

    proto.BotRenderingMetadata = (function() {

        function BotRenderingMetadata(p) {
            this.keywords = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotRenderingMetadata.prototype.keywords = $util.emptyArray;

        BotRenderingMetadata.create = function create(properties) {
            return new BotRenderingMetadata(properties);
        };

        BotRenderingMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.keywords != null && m.keywords.length) {
                for (var i = 0; i < m.keywords.length; ++i)
                    $root.proto.BotRenderingMetadata.Keyword.encode(m.keywords[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotRenderingMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotRenderingMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.keywords && m.keywords.length))
                            m.keywords = [];
                        m.keywords.push($root.proto.BotRenderingMetadata.Keyword.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotRenderingMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotRenderingMetadata)
                return d;
            var m = new $root.proto.BotRenderingMetadata();
            if (d.keywords) {
                if (!Array.isArray(d.keywords))
                    throw TypeError(".proto.BotRenderingMetadata.keywords: array expected");
                m.keywords = [];
                for (var i = 0; i < d.keywords.length; ++i) {
                    if (typeof d.keywords[i] !== "object")
                        throw TypeError(".proto.BotRenderingMetadata.keywords: object expected");
                    m.keywords[i] = $root.proto.BotRenderingMetadata.Keyword.fromObject(d.keywords[i]);
                }
            }
            return m;
        };

        BotRenderingMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.keywords = [];
            }
            if (m.keywords && m.keywords.length) {
                d.keywords = [];
                for (var j = 0; j < m.keywords.length; ++j) {
                    d.keywords[j] = $root.proto.BotRenderingMetadata.Keyword.toObject(m.keywords[j], o);
                }
            }
            return d;
        };

        BotRenderingMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotRenderingMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotRenderingMetadata";
        };

        BotRenderingMetadata.Keyword = (function() {

            function Keyword(p) {
                this.associatedPrompts = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            Keyword.prototype.value = null;
            Keyword.prototype.associatedPrompts = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(Keyword.prototype, "_value", {
                get: $util.oneOfGetter($oneOfFields = ["value"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            Keyword.create = function create(properties) {
                return new Keyword(properties);
            };

            Keyword.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.value != null && Object.hasOwnProperty.call(m, "value"))
                    w.uint32(10).string(m.value);
                if (m.associatedPrompts != null && m.associatedPrompts.length) {
                    for (var i = 0; i < m.associatedPrompts.length; ++i)
                        w.uint32(18).string(m.associatedPrompts[i]);
                }
                return w;
            };

            Keyword.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotRenderingMetadata.Keyword();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.value = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.associatedPrompts && m.associatedPrompts.length))
                                m.associatedPrompts = [];
                            m.associatedPrompts.push(r.string());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            Keyword.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotRenderingMetadata.Keyword)
                    return d;
                var m = new $root.proto.BotRenderingMetadata.Keyword();
                if (d.value != null) {
                    m.value = String(d.value);
                }
                if (d.associatedPrompts) {
                    if (!Array.isArray(d.associatedPrompts))
                        throw TypeError(".proto.BotRenderingMetadata.Keyword.associatedPrompts: array expected");
                    m.associatedPrompts = [];
                    for (var i = 0; i < d.associatedPrompts.length; ++i) {
                        m.associatedPrompts[i] = String(d.associatedPrompts[i]);
                    }
                }
                return m;
            };

            Keyword.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.associatedPrompts = [];
                }
                if (m.value != null && m.hasOwnProperty("value")) {
                    d.value = m.value;
                    if (o.oneofs)
                        d._value = "value";
                }
                if (m.associatedPrompts && m.associatedPrompts.length) {
                    d.associatedPrompts = [];
                    for (var j = 0; j < m.associatedPrompts.length; ++j) {
                        d.associatedPrompts[j] = m.associatedPrompts[j];
                    }
                }
                return d;
            };

            Keyword.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            Keyword.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotRenderingMetadata.Keyword";
            };

            return Keyword;
        })();

        return BotRenderingMetadata;
    })();

    proto.BotSessionMetadata = (function() {

        function BotSessionMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSessionMetadata.prototype.sessionId = null;
        BotSessionMetadata.prototype.sessionSource = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSessionMetadata.prototype, "_sessionId", {
            get: $util.oneOfGetter($oneOfFields = ["sessionId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSessionMetadata.prototype, "_sessionSource", {
            get: $util.oneOfGetter($oneOfFields = ["sessionSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotSessionMetadata.create = function create(properties) {
            return new BotSessionMetadata(properties);
        };

        BotSessionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                w.uint32(10).string(m.sessionId);
            if (m.sessionSource != null && Object.hasOwnProperty.call(m, "sessionSource"))
                w.uint32(16).int32(m.sessionSource);
            return w;
        };

        BotSessionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSessionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sessionId = r.string();
                        break;
                    }
                case 2: {
                        m.sessionSource = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSessionMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSessionMetadata)
                return d;
            var m = new $root.proto.BotSessionMetadata();
            if (d.sessionId != null) {
                m.sessionId = String(d.sessionId);
            }
            switch (d.sessionSource) {
            default:
                if (typeof d.sessionSource === "number") {
                    m.sessionSource = d.sessionSource;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.sessionSource = 0;
                break;
            case "NULL_STATE":
            case 1:
                m.sessionSource = 1;
                break;
            case "TYPEAHEAD":
            case 2:
                m.sessionSource = 2;
                break;
            case "USER_INPUT":
            case 3:
                m.sessionSource = 3;
                break;
            case "EMU_FLASH":
            case 4:
                m.sessionSource = 4;
                break;
            case "EMU_FLASH_FOLLOWUP":
            case 5:
                m.sessionSource = 5;
                break;
            case "VOICE":
            case 6:
                m.sessionSource = 6;
                break;
            }
            return m;
        };

        BotSessionMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.sessionId != null && m.hasOwnProperty("sessionId")) {
                d.sessionId = m.sessionId;
                if (o.oneofs)
                    d._sessionId = "sessionId";
            }
            if (m.sessionSource != null && m.hasOwnProperty("sessionSource")) {
                d.sessionSource = o.enums === String ? $root.proto.BotSessionSource[m.sessionSource] === undefined ? m.sessionSource : $root.proto.BotSessionSource[m.sessionSource] : m.sessionSource;
                if (o.oneofs)
                    d._sessionSource = "sessionSource";
            }
            return d;
        };

        BotSessionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSessionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSessionMetadata";
        };

        return BotSessionMetadata;
    })();

    proto.BotSessionSource = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "NONE"] = 0;
        values[valuesById[1] = "NULL_STATE"] = 1;
        values[valuesById[2] = "TYPEAHEAD"] = 2;
        values[valuesById[3] = "USER_INPUT"] = 3;
        values[valuesById[4] = "EMU_FLASH"] = 4;
        values[valuesById[5] = "EMU_FLASH_FOLLOWUP"] = 5;
        values[valuesById[6] = "VOICE"] = 6;
        return values;
    })();

    proto.BotSignatureVerificationMetadata = (function() {

        function BotSignatureVerificationMetadata(p) {
            this.proofs = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSignatureVerificationMetadata.prototype.proofs = $util.emptyArray;

        BotSignatureVerificationMetadata.create = function create(properties) {
            return new BotSignatureVerificationMetadata(properties);
        };

        BotSignatureVerificationMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.proofs != null && m.proofs.length) {
                for (var i = 0; i < m.proofs.length; ++i)
                    $root.proto.BotSignatureVerificationUseCaseProof.encode(m.proofs[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotSignatureVerificationMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSignatureVerificationMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.proofs && m.proofs.length))
                            m.proofs = [];
                        m.proofs.push($root.proto.BotSignatureVerificationUseCaseProof.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSignatureVerificationMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSignatureVerificationMetadata)
                return d;
            var m = new $root.proto.BotSignatureVerificationMetadata();
            if (d.proofs) {
                if (!Array.isArray(d.proofs))
                    throw TypeError(".proto.BotSignatureVerificationMetadata.proofs: array expected");
                m.proofs = [];
                for (var i = 0; i < d.proofs.length; ++i) {
                    if (typeof d.proofs[i] !== "object")
                        throw TypeError(".proto.BotSignatureVerificationMetadata.proofs: object expected");
                    m.proofs[i] = $root.proto.BotSignatureVerificationUseCaseProof.fromObject(d.proofs[i]);
                }
            }
            return m;
        };

        BotSignatureVerificationMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.proofs = [];
            }
            if (m.proofs && m.proofs.length) {
                d.proofs = [];
                for (var j = 0; j < m.proofs.length; ++j) {
                    d.proofs[j] = $root.proto.BotSignatureVerificationUseCaseProof.toObject(m.proofs[j], o);
                }
            }
            return d;
        };

        BotSignatureVerificationMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSignatureVerificationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSignatureVerificationMetadata";
        };

        return BotSignatureVerificationMetadata;
    })();

    proto.BotSignatureVerificationUseCaseProof = (function() {

        function BotSignatureVerificationUseCaseProof(p) {
            this.certificateChain = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSignatureVerificationUseCaseProof.prototype.version = null;
        BotSignatureVerificationUseCaseProof.prototype.useCase = null;
        BotSignatureVerificationUseCaseProof.prototype.signature = null;
        BotSignatureVerificationUseCaseProof.prototype.certificateChain = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSignatureVerificationUseCaseProof.prototype, "_version", {
            get: $util.oneOfGetter($oneOfFields = ["version"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSignatureVerificationUseCaseProof.prototype, "_useCase", {
            get: $util.oneOfGetter($oneOfFields = ["useCase"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSignatureVerificationUseCaseProof.prototype, "_signature", {
            get: $util.oneOfGetter($oneOfFields = ["signature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotSignatureVerificationUseCaseProof.create = function create(properties) {
            return new BotSignatureVerificationUseCaseProof(properties);
        };

        BotSignatureVerificationUseCaseProof.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                w.uint32(8).int32(m.version);
            if (m.useCase != null && Object.hasOwnProperty.call(m, "useCase"))
                w.uint32(16).int32(m.useCase);
            if (m.signature != null && Object.hasOwnProperty.call(m, "signature"))
                w.uint32(26).bytes(m.signature);
            if (m.certificateChain != null && m.certificateChain.length) {
                for (var i = 0; i < m.certificateChain.length; ++i)
                    w.uint32(34).bytes(m.certificateChain[i]);
            }
            return w;
        };

        BotSignatureVerificationUseCaseProof.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSignatureVerificationUseCaseProof();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.version = r.int32();
                        break;
                    }
                case 2: {
                        m.useCase = r.int32();
                        break;
                    }
                case 3: {
                        m.signature = r.bytes();
                        break;
                    }
                case 4: {
                        if (!(m.certificateChain && m.certificateChain.length))
                            m.certificateChain = [];
                        m.certificateChain.push(r.bytes());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSignatureVerificationUseCaseProof.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSignatureVerificationUseCaseProof)
                return d;
            var m = new $root.proto.BotSignatureVerificationUseCaseProof();
            if (d.version != null) {
                m.version = d.version | 0;
            }
            switch (d.useCase) {
            default:
                if (typeof d.useCase === "number") {
                    m.useCase = d.useCase;
                    break;
                }
                break;
            case "UNSPECIFIED":
            case 0:
                m.useCase = 0;
                break;
            case "WA_BOT_MSG":
            case 1:
                m.useCase = 1;
                break;
            }
            if (d.signature != null) {
                if (typeof d.signature === "string")
                    $util.base64.decode(d.signature, m.signature = $util.newBuffer($util.base64.length(d.signature)), 0);
                else if (d.signature.length >= 0)
                    m.signature = d.signature;
            }
            if (d.certificateChain) {
                if (!Array.isArray(d.certificateChain))
                    throw TypeError(".proto.BotSignatureVerificationUseCaseProof.certificateChain: array expected");
                m.certificateChain = [];
                for (var i = 0; i < d.certificateChain.length; ++i) {
                    if (typeof d.certificateChain[i] === "string")
                        $util.base64.decode(d.certificateChain[i], m.certificateChain[i] = $util.newBuffer($util.base64.length(d.certificateChain[i])), 0);
                    else if (d.certificateChain[i].length >= 0)
                        m.certificateChain[i] = d.certificateChain[i];
                }
            }
            return m;
        };

        BotSignatureVerificationUseCaseProof.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.certificateChain = [];
            }
            if (m.version != null && m.hasOwnProperty("version")) {
                d.version = m.version;
                if (o.oneofs)
                    d._version = "version";
            }
            if (m.useCase != null && m.hasOwnProperty("useCase")) {
                d.useCase = o.enums === String ? $root.proto.BotSignatureVerificationUseCaseProof.BotSignatureUseCase[m.useCase] === undefined ? m.useCase : $root.proto.BotSignatureVerificationUseCaseProof.BotSignatureUseCase[m.useCase] : m.useCase;
                if (o.oneofs)
                    d._useCase = "useCase";
            }
            if (m.signature != null && m.hasOwnProperty("signature")) {
                d.signature = o.bytes === String ? $util.base64.encode(m.signature, 0, m.signature.length) : o.bytes === Array ? Array.prototype.slice.call(m.signature) : m.signature;
                if (o.oneofs)
                    d._signature = "signature";
            }
            if (m.certificateChain && m.certificateChain.length) {
                d.certificateChain = [];
                for (var j = 0; j < m.certificateChain.length; ++j) {
                    d.certificateChain[j] = o.bytes === String ? $util.base64.encode(m.certificateChain[j], 0, m.certificateChain[j].length) : o.bytes === Array ? Array.prototype.slice.call(m.certificateChain[j]) : m.certificateChain[j];
                }
            }
            return d;
        };

        BotSignatureVerificationUseCaseProof.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSignatureVerificationUseCaseProof.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSignatureVerificationUseCaseProof";
        };

        BotSignatureVerificationUseCaseProof.BotSignatureUseCase = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNSPECIFIED"] = 0;
            values[valuesById[1] = "WA_BOT_MSG"] = 1;
            return values;
        })();

        return BotSignatureVerificationUseCaseProof;
    })();

    proto.BotSourcesMetadata = (function() {

        function BotSourcesMetadata(p) {
            this.sources = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSourcesMetadata.prototype.sources = $util.emptyArray;

        BotSourcesMetadata.create = function create(properties) {
            return new BotSourcesMetadata(properties);
        };

        BotSourcesMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sources != null && m.sources.length) {
                for (var i = 0; i < m.sources.length; ++i)
                    $root.proto.BotSourcesMetadata.BotSourceItem.encode(m.sources[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotSourcesMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSourcesMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.sources && m.sources.length))
                            m.sources = [];
                        m.sources.push($root.proto.BotSourcesMetadata.BotSourceItem.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSourcesMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSourcesMetadata)
                return d;
            var m = new $root.proto.BotSourcesMetadata();
            if (d.sources) {
                if (!Array.isArray(d.sources))
                    throw TypeError(".proto.BotSourcesMetadata.sources: array expected");
                m.sources = [];
                for (var i = 0; i < d.sources.length; ++i) {
                    if (typeof d.sources[i] !== "object")
                        throw TypeError(".proto.BotSourcesMetadata.sources: object expected");
                    m.sources[i] = $root.proto.BotSourcesMetadata.BotSourceItem.fromObject(d.sources[i]);
                }
            }
            return m;
        };

        BotSourcesMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.sources = [];
            }
            if (m.sources && m.sources.length) {
                d.sources = [];
                for (var j = 0; j < m.sources.length; ++j) {
                    d.sources[j] = $root.proto.BotSourcesMetadata.BotSourceItem.toObject(m.sources[j], o);
                }
            }
            return d;
        };

        BotSourcesMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSourcesMetadata";
        };

        BotSourcesMetadata.BotSourceItem = (function() {

            function BotSourceItem(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotSourceItem.prototype.provider = null;
            BotSourceItem.prototype.thumbnailCdnUrl = null;
            BotSourceItem.prototype.sourceProviderUrl = null;
            BotSourceItem.prototype.sourceQuery = null;
            BotSourceItem.prototype.faviconCdnUrl = null;
            BotSourceItem.prototype.citationNumber = null;
            BotSourceItem.prototype.sourceTitle = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_provider", {
                get: $util.oneOfGetter($oneOfFields = ["provider"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_thumbnailCdnUrl", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnailCdnUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_sourceProviderUrl", {
                get: $util.oneOfGetter($oneOfFields = ["sourceProviderUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_sourceQuery", {
                get: $util.oneOfGetter($oneOfFields = ["sourceQuery"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_faviconCdnUrl", {
                get: $util.oneOfGetter($oneOfFields = ["faviconCdnUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_citationNumber", {
                get: $util.oneOfGetter($oneOfFields = ["citationNumber"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_sourceTitle", {
                get: $util.oneOfGetter($oneOfFields = ["sourceTitle"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BotSourceItem.create = function create(properties) {
                return new BotSourceItem(properties);
            };

            BotSourceItem.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                    w.uint32(8).int32(m.provider);
                if (m.thumbnailCdnUrl != null && Object.hasOwnProperty.call(m, "thumbnailCdnUrl"))
                    w.uint32(18).string(m.thumbnailCdnUrl);
                if (m.sourceProviderUrl != null && Object.hasOwnProperty.call(m, "sourceProviderUrl"))
                    w.uint32(26).string(m.sourceProviderUrl);
                if (m.sourceQuery != null && Object.hasOwnProperty.call(m, "sourceQuery"))
                    w.uint32(34).string(m.sourceQuery);
                if (m.faviconCdnUrl != null && Object.hasOwnProperty.call(m, "faviconCdnUrl"))
                    w.uint32(42).string(m.faviconCdnUrl);
                if (m.citationNumber != null && Object.hasOwnProperty.call(m, "citationNumber"))
                    w.uint32(48).uint32(m.citationNumber);
                if (m.sourceTitle != null && Object.hasOwnProperty.call(m, "sourceTitle"))
                    w.uint32(58).string(m.sourceTitle);
                return w;
            };

            BotSourceItem.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSourcesMetadata.BotSourceItem();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.provider = r.int32();
                            break;
                        }
                    case 2: {
                            m.thumbnailCdnUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.sourceProviderUrl = r.string();
                            break;
                        }
                    case 4: {
                            m.sourceQuery = r.string();
                            break;
                        }
                    case 5: {
                            m.faviconCdnUrl = r.string();
                            break;
                        }
                    case 6: {
                            m.citationNumber = r.uint32();
                            break;
                        }
                    case 7: {
                            m.sourceTitle = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotSourceItem.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotSourcesMetadata.BotSourceItem)
                    return d;
                var m = new $root.proto.BotSourcesMetadata.BotSourceItem();
                switch (d.provider) {
                default:
                    if (typeof d.provider === "number") {
                        m.provider = d.provider;
                        break;
                    }
                    break;
                case "UNKNOWN":
                case 0:
                    m.provider = 0;
                    break;
                case "BING":
                case 1:
                    m.provider = 1;
                    break;
                case "GOOGLE":
                case 2:
                    m.provider = 2;
                    break;
                case "SUPPORT":
                case 3:
                    m.provider = 3;
                    break;
                case "OTHER":
                case 4:
                    m.provider = 4;
                    break;
                }
                if (d.thumbnailCdnUrl != null) {
                    m.thumbnailCdnUrl = String(d.thumbnailCdnUrl);
                }
                if (d.sourceProviderUrl != null) {
                    m.sourceProviderUrl = String(d.sourceProviderUrl);
                }
                if (d.sourceQuery != null) {
                    m.sourceQuery = String(d.sourceQuery);
                }
                if (d.faviconCdnUrl != null) {
                    m.faviconCdnUrl = String(d.faviconCdnUrl);
                }
                if (d.citationNumber != null) {
                    m.citationNumber = d.citationNumber >>> 0;
                }
                if (d.sourceTitle != null) {
                    m.sourceTitle = String(d.sourceTitle);
                }
                return m;
            };

            BotSourceItem.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.provider != null && m.hasOwnProperty("provider")) {
                    d.provider = o.enums === String ? $root.proto.BotSourcesMetadata.BotSourceItem.SourceProvider[m.provider] === undefined ? m.provider : $root.proto.BotSourcesMetadata.BotSourceItem.SourceProvider[m.provider] : m.provider;
                    if (o.oneofs)
                        d._provider = "provider";
                }
                if (m.thumbnailCdnUrl != null && m.hasOwnProperty("thumbnailCdnUrl")) {
                    d.thumbnailCdnUrl = m.thumbnailCdnUrl;
                    if (o.oneofs)
                        d._thumbnailCdnUrl = "thumbnailCdnUrl";
                }
                if (m.sourceProviderUrl != null && m.hasOwnProperty("sourceProviderUrl")) {
                    d.sourceProviderUrl = m.sourceProviderUrl;
                    if (o.oneofs)
                        d._sourceProviderUrl = "sourceProviderUrl";
                }
                if (m.sourceQuery != null && m.hasOwnProperty("sourceQuery")) {
                    d.sourceQuery = m.sourceQuery;
                    if (o.oneofs)
                        d._sourceQuery = "sourceQuery";
                }
                if (m.faviconCdnUrl != null && m.hasOwnProperty("faviconCdnUrl")) {
                    d.faviconCdnUrl = m.faviconCdnUrl;
                    if (o.oneofs)
                        d._faviconCdnUrl = "faviconCdnUrl";
                }
                if (m.citationNumber != null && m.hasOwnProperty("citationNumber")) {
                    d.citationNumber = m.citationNumber;
                    if (o.oneofs)
                        d._citationNumber = "citationNumber";
                }
                if (m.sourceTitle != null && m.hasOwnProperty("sourceTitle")) {
                    d.sourceTitle = m.sourceTitle;
                    if (o.oneofs)
                        d._sourceTitle = "sourceTitle";
                }
                return d;
            };

            BotSourceItem.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BotSourceItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotSourcesMetadata.BotSourceItem";
            };

            BotSourceItem.SourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "BING"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "SUPPORT"] = 3;
                values[valuesById[4] = "OTHER"] = 4;
                return values;
            })();

            return BotSourceItem;
        })();

        return BotSourcesMetadata;
    })();

    proto.BotSuggestedPromptMetadata = (function() {

        function BotSuggestedPromptMetadata(p) {
            this.suggestedPrompts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSuggestedPromptMetadata.prototype.suggestedPrompts = $util.emptyArray;
        BotSuggestedPromptMetadata.prototype.selectedPromptIndex = null;
        BotSuggestedPromptMetadata.prototype.promptSuggestions = null;
        BotSuggestedPromptMetadata.prototype.selectedPromptId = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSuggestedPromptMetadata.prototype, "_selectedPromptIndex", {
            get: $util.oneOfGetter($oneOfFields = ["selectedPromptIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSuggestedPromptMetadata.prototype, "_promptSuggestions", {
            get: $util.oneOfGetter($oneOfFields = ["promptSuggestions"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSuggestedPromptMetadata.prototype, "_selectedPromptId", {
            get: $util.oneOfGetter($oneOfFields = ["selectedPromptId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotSuggestedPromptMetadata.create = function create(properties) {
            return new BotSuggestedPromptMetadata(properties);
        };

        BotSuggestedPromptMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.suggestedPrompts != null && m.suggestedPrompts.length) {
                for (var i = 0; i < m.suggestedPrompts.length; ++i)
                    w.uint32(10).string(m.suggestedPrompts[i]);
            }
            if (m.selectedPromptIndex != null && Object.hasOwnProperty.call(m, "selectedPromptIndex"))
                w.uint32(16).uint32(m.selectedPromptIndex);
            if (m.promptSuggestions != null && Object.hasOwnProperty.call(m, "promptSuggestions"))
                $root.proto.BotPromptSuggestions.encode(m.promptSuggestions, w.uint32(26).fork()).ldelim();
            if (m.selectedPromptId != null && Object.hasOwnProperty.call(m, "selectedPromptId"))
                w.uint32(34).string(m.selectedPromptId);
            return w;
        };

        BotSuggestedPromptMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSuggestedPromptMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.suggestedPrompts && m.suggestedPrompts.length))
                            m.suggestedPrompts = [];
                        m.suggestedPrompts.push(r.string());
                        break;
                    }
                case 2: {
                        m.selectedPromptIndex = r.uint32();
                        break;
                    }
                case 3: {
                        m.promptSuggestions = $root.proto.BotPromptSuggestions.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.selectedPromptId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSuggestedPromptMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSuggestedPromptMetadata)
                return d;
            var m = new $root.proto.BotSuggestedPromptMetadata();
            if (d.suggestedPrompts) {
                if (!Array.isArray(d.suggestedPrompts))
                    throw TypeError(".proto.BotSuggestedPromptMetadata.suggestedPrompts: array expected");
                m.suggestedPrompts = [];
                for (var i = 0; i < d.suggestedPrompts.length; ++i) {
                    m.suggestedPrompts[i] = String(d.suggestedPrompts[i]);
                }
            }
            if (d.selectedPromptIndex != null) {
                m.selectedPromptIndex = d.selectedPromptIndex >>> 0;
            }
            if (d.promptSuggestions != null) {
                if (typeof d.promptSuggestions !== "object")
                    throw TypeError(".proto.BotSuggestedPromptMetadata.promptSuggestions: object expected");
                m.promptSuggestions = $root.proto.BotPromptSuggestions.fromObject(d.promptSuggestions);
            }
            if (d.selectedPromptId != null) {
                m.selectedPromptId = String(d.selectedPromptId);
            }
            return m;
        };

        BotSuggestedPromptMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.suggestedPrompts = [];
            }
            if (m.suggestedPrompts && m.suggestedPrompts.length) {
                d.suggestedPrompts = [];
                for (var j = 0; j < m.suggestedPrompts.length; ++j) {
                    d.suggestedPrompts[j] = m.suggestedPrompts[j];
                }
            }
            if (m.selectedPromptIndex != null && m.hasOwnProperty("selectedPromptIndex")) {
                d.selectedPromptIndex = m.selectedPromptIndex;
                if (o.oneofs)
                    d._selectedPromptIndex = "selectedPromptIndex";
            }
            if (m.promptSuggestions != null && m.hasOwnProperty("promptSuggestions")) {
                d.promptSuggestions = $root.proto.BotPromptSuggestions.toObject(m.promptSuggestions, o);
                if (o.oneofs)
                    d._promptSuggestions = "promptSuggestions";
            }
            if (m.selectedPromptId != null && m.hasOwnProperty("selectedPromptId")) {
                d.selectedPromptId = m.selectedPromptId;
                if (o.oneofs)
                    d._selectedPromptId = "selectedPromptId";
            }
            return d;
        };

        BotSuggestedPromptMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSuggestedPromptMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSuggestedPromptMetadata";
        };

        return BotSuggestedPromptMetadata;
    })();

    proto.BotUnifiedResponseMutation = (function() {

        function BotUnifiedResponseMutation(p) {
            this.mediaDetailsMetadataList = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotUnifiedResponseMutation.prototype.sbsMetadata = null;
        BotUnifiedResponseMutation.prototype.mediaDetailsMetadataList = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotUnifiedResponseMutation.prototype, "_sbsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["sbsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotUnifiedResponseMutation.create = function create(properties) {
            return new BotUnifiedResponseMutation(properties);
        };

        BotUnifiedResponseMutation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sbsMetadata != null && Object.hasOwnProperty.call(m, "sbsMetadata"))
                $root.proto.BotUnifiedResponseMutation.SideBySideMetadata.encode(m.sbsMetadata, w.uint32(10).fork()).ldelim();
            if (m.mediaDetailsMetadataList != null && m.mediaDetailsMetadataList.length) {
                for (var i = 0; i < m.mediaDetailsMetadataList.length; ++i)
                    $root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata.encode(m.mediaDetailsMetadataList[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        BotUnifiedResponseMutation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotUnifiedResponseMutation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sbsMetadata = $root.proto.BotUnifiedResponseMutation.SideBySideMetadata.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        if (!(m.mediaDetailsMetadataList && m.mediaDetailsMetadataList.length))
                            m.mediaDetailsMetadataList = [];
                        m.mediaDetailsMetadataList.push($root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotUnifiedResponseMutation.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotUnifiedResponseMutation)
                return d;
            var m = new $root.proto.BotUnifiedResponseMutation();
            if (d.sbsMetadata != null) {
                if (typeof d.sbsMetadata !== "object")
                    throw TypeError(".proto.BotUnifiedResponseMutation.sbsMetadata: object expected");
                m.sbsMetadata = $root.proto.BotUnifiedResponseMutation.SideBySideMetadata.fromObject(d.sbsMetadata);
            }
            if (d.mediaDetailsMetadataList) {
                if (!Array.isArray(d.mediaDetailsMetadataList))
                    throw TypeError(".proto.BotUnifiedResponseMutation.mediaDetailsMetadataList: array expected");
                m.mediaDetailsMetadataList = [];
                for (var i = 0; i < d.mediaDetailsMetadataList.length; ++i) {
                    if (typeof d.mediaDetailsMetadataList[i] !== "object")
                        throw TypeError(".proto.BotUnifiedResponseMutation.mediaDetailsMetadataList: object expected");
                    m.mediaDetailsMetadataList[i] = $root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata.fromObject(d.mediaDetailsMetadataList[i]);
                }
            }
            return m;
        };

        BotUnifiedResponseMutation.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.mediaDetailsMetadataList = [];
            }
            if (m.sbsMetadata != null && m.hasOwnProperty("sbsMetadata")) {
                d.sbsMetadata = $root.proto.BotUnifiedResponseMutation.SideBySideMetadata.toObject(m.sbsMetadata, o);
                if (o.oneofs)
                    d._sbsMetadata = "sbsMetadata";
            }
            if (m.mediaDetailsMetadataList && m.mediaDetailsMetadataList.length) {
                d.mediaDetailsMetadataList = [];
                for (var j = 0; j < m.mediaDetailsMetadataList.length; ++j) {
                    d.mediaDetailsMetadataList[j] = $root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata.toObject(m.mediaDetailsMetadataList[j], o);
                }
            }
            return d;
        };

        BotUnifiedResponseMutation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotUnifiedResponseMutation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotUnifiedResponseMutation";
        };

        BotUnifiedResponseMutation.MediaDetailsMetadata = (function() {

            function MediaDetailsMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            MediaDetailsMetadata.prototype.id = null;
            MediaDetailsMetadata.prototype.highResMedia = null;
            MediaDetailsMetadata.prototype.previewMedia = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(MediaDetailsMetadata.prototype, "_id", {
                get: $util.oneOfGetter($oneOfFields = ["id"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(MediaDetailsMetadata.prototype, "_highResMedia", {
                get: $util.oneOfGetter($oneOfFields = ["highResMedia"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(MediaDetailsMetadata.prototype, "_previewMedia", {
                get: $util.oneOfGetter($oneOfFields = ["previewMedia"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            MediaDetailsMetadata.create = function create(properties) {
                return new MediaDetailsMetadata(properties);
            };

            MediaDetailsMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                    w.uint32(10).string(m.id);
                if (m.highResMedia != null && Object.hasOwnProperty.call(m, "highResMedia"))
                    $root.proto.BotMediaMetadata.encode(m.highResMedia, w.uint32(18).fork()).ldelim();
                if (m.previewMedia != null && Object.hasOwnProperty.call(m, "previewMedia"))
                    $root.proto.BotMediaMetadata.encode(m.previewMedia, w.uint32(26).fork()).ldelim();
                return w;
            };

            MediaDetailsMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.id = r.string();
                            break;
                        }
                    case 2: {
                            m.highResMedia = $root.proto.BotMediaMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.previewMedia = $root.proto.BotMediaMetadata.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            MediaDetailsMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata)
                    return d;
                var m = new $root.proto.BotUnifiedResponseMutation.MediaDetailsMetadata();
                if (d.id != null) {
                    m.id = String(d.id);
                }
                if (d.highResMedia != null) {
                    if (typeof d.highResMedia !== "object")
                        throw TypeError(".proto.BotUnifiedResponseMutation.MediaDetailsMetadata.highResMedia: object expected");
                    m.highResMedia = $root.proto.BotMediaMetadata.fromObject(d.highResMedia);
                }
                if (d.previewMedia != null) {
                    if (typeof d.previewMedia !== "object")
                        throw TypeError(".proto.BotUnifiedResponseMutation.MediaDetailsMetadata.previewMedia: object expected");
                    m.previewMedia = $root.proto.BotMediaMetadata.fromObject(d.previewMedia);
                }
                return m;
            };

            MediaDetailsMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.id != null && m.hasOwnProperty("id")) {
                    d.id = m.id;
                    if (o.oneofs)
                        d._id = "id";
                }
                if (m.highResMedia != null && m.hasOwnProperty("highResMedia")) {
                    d.highResMedia = $root.proto.BotMediaMetadata.toObject(m.highResMedia, o);
                    if (o.oneofs)
                        d._highResMedia = "highResMedia";
                }
                if (m.previewMedia != null && m.hasOwnProperty("previewMedia")) {
                    d.previewMedia = $root.proto.BotMediaMetadata.toObject(m.previewMedia, o);
                    if (o.oneofs)
                        d._previewMedia = "previewMedia";
                }
                return d;
            };

            MediaDetailsMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            MediaDetailsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotUnifiedResponseMutation.MediaDetailsMetadata";
            };

            return MediaDetailsMetadata;
        })();

        BotUnifiedResponseMutation.SideBySideMetadata = (function() {

            function SideBySideMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            SideBySideMetadata.prototype.primaryResponseId = null;
            SideBySideMetadata.prototype.surveyCtaHasRendered = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideMetadata.prototype, "_primaryResponseId", {
                get: $util.oneOfGetter($oneOfFields = ["primaryResponseId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(SideBySideMetadata.prototype, "_surveyCtaHasRendered", {
                get: $util.oneOfGetter($oneOfFields = ["surveyCtaHasRendered"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            SideBySideMetadata.create = function create(properties) {
                return new SideBySideMetadata(properties);
            };

            SideBySideMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.primaryResponseId != null && Object.hasOwnProperty.call(m, "primaryResponseId"))
                    w.uint32(10).string(m.primaryResponseId);
                if (m.surveyCtaHasRendered != null && Object.hasOwnProperty.call(m, "surveyCtaHasRendered"))
                    w.uint32(16).bool(m.surveyCtaHasRendered);
                return w;
            };

            SideBySideMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotUnifiedResponseMutation.SideBySideMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.primaryResponseId = r.string();
                            break;
                        }
                    case 2: {
                            m.surveyCtaHasRendered = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            SideBySideMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotUnifiedResponseMutation.SideBySideMetadata)
                    return d;
                var m = new $root.proto.BotUnifiedResponseMutation.SideBySideMetadata();
                if (d.primaryResponseId != null) {
                    m.primaryResponseId = String(d.primaryResponseId);
                }
                if (d.surveyCtaHasRendered != null) {
                    m.surveyCtaHasRendered = Boolean(d.surveyCtaHasRendered);
                }
                return m;
            };

            SideBySideMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.primaryResponseId != null && m.hasOwnProperty("primaryResponseId")) {
                    d.primaryResponseId = m.primaryResponseId;
                    if (o.oneofs)
                        d._primaryResponseId = "primaryResponseId";
                }
                if (m.surveyCtaHasRendered != null && m.hasOwnProperty("surveyCtaHasRendered")) {
                    d.surveyCtaHasRendered = m.surveyCtaHasRendered;
                    if (o.oneofs)
                        d._surveyCtaHasRendered = "surveyCtaHasRendered";
                }
                return d;
            };

            SideBySideMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            SideBySideMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotUnifiedResponseMutation.SideBySideMetadata";
            };

            return SideBySideMetadata;
        })();

        return BotUnifiedResponseMutation;
    })();

    proto.CallLogRecord = (function() {

        function CallLogRecord(p) {
            this.participants = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CallLogRecord.prototype.callResult = null;
        CallLogRecord.prototype.isDndMode = null;
        CallLogRecord.prototype.silenceReason = null;
        CallLogRecord.prototype.duration = null;
        CallLogRecord.prototype.startTime = null;
        CallLogRecord.prototype.isIncoming = null;
        CallLogRecord.prototype.isVideo = null;
        CallLogRecord.prototype.isCallLink = null;
        CallLogRecord.prototype.callLinkToken = null;
        CallLogRecord.prototype.scheduledCallId = null;
        CallLogRecord.prototype.callId = null;
        CallLogRecord.prototype.callCreatorJid = null;
        CallLogRecord.prototype.groupJid = null;
        CallLogRecord.prototype.participants = $util.emptyArray;
        CallLogRecord.prototype.callType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callResult", {
            get: $util.oneOfGetter($oneOfFields = ["callResult"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isDndMode", {
            get: $util.oneOfGetter($oneOfFields = ["isDndMode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_silenceReason", {
            get: $util.oneOfGetter($oneOfFields = ["silenceReason"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_duration", {
            get: $util.oneOfGetter($oneOfFields = ["duration"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_startTime", {
            get: $util.oneOfGetter($oneOfFields = ["startTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isIncoming", {
            get: $util.oneOfGetter($oneOfFields = ["isIncoming"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isVideo", {
            get: $util.oneOfGetter($oneOfFields = ["isVideo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isCallLink", {
            get: $util.oneOfGetter($oneOfFields = ["isCallLink"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callLinkToken", {
            get: $util.oneOfGetter($oneOfFields = ["callLinkToken"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_scheduledCallId", {
            get: $util.oneOfGetter($oneOfFields = ["scheduledCallId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callId", {
            get: $util.oneOfGetter($oneOfFields = ["callId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callCreatorJid", {
            get: $util.oneOfGetter($oneOfFields = ["callCreatorJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_groupJid", {
            get: $util.oneOfGetter($oneOfFields = ["groupJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callType", {
            get: $util.oneOfGetter($oneOfFields = ["callType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CallLogRecord.create = function create(properties) {
            return new CallLogRecord(properties);
        };

        CallLogRecord.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.callResult != null && Object.hasOwnProperty.call(m, "callResult"))
                w.uint32(8).int32(m.callResult);
            if (m.isDndMode != null && Object.hasOwnProperty.call(m, "isDndMode"))
                w.uint32(16).bool(m.isDndMode);
            if (m.silenceReason != null && Object.hasOwnProperty.call(m, "silenceReason"))
                w.uint32(24).int32(m.silenceReason);
            if (m.duration != null && Object.hasOwnProperty.call(m, "duration"))
                w.uint32(32).int64(m.duration);
            if (m.startTime != null && Object.hasOwnProperty.call(m, "startTime"))
                w.uint32(40).int64(m.startTime);
            if (m.isIncoming != null && Object.hasOwnProperty.call(m, "isIncoming"))
                w.uint32(48).bool(m.isIncoming);
            if (m.isVideo != null && Object.hasOwnProperty.call(m, "isVideo"))
                w.uint32(56).bool(m.isVideo);
            if (m.isCallLink != null && Object.hasOwnProperty.call(m, "isCallLink"))
                w.uint32(64).bool(m.isCallLink);
            if (m.callLinkToken != null && Object.hasOwnProperty.call(m, "callLinkToken"))
                w.uint32(74).string(m.callLinkToken);
            if (m.scheduledCallId != null && Object.hasOwnProperty.call(m, "scheduledCallId"))
                w.uint32(82).string(m.scheduledCallId);
            if (m.callId != null && Object.hasOwnProperty.call(m, "callId"))
                w.uint32(90).string(m.callId);
            if (m.callCreatorJid != null && Object.hasOwnProperty.call(m, "callCreatorJid"))
                w.uint32(98).string(m.callCreatorJid);
            if (m.groupJid != null && Object.hasOwnProperty.call(m, "groupJid"))
                w.uint32(106).string(m.groupJid);
            if (m.participants != null && m.participants.length) {
                for (var i = 0; i < m.participants.length; ++i)
                    $root.proto.CallLogRecord.ParticipantInfo.encode(m.participants[i], w.uint32(114).fork()).ldelim();
            }
            if (m.callType != null && Object.hasOwnProperty.call(m, "callType"))
                w.uint32(120).int32(m.callType);
            return w;
        };

        CallLogRecord.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CallLogRecord();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.callResult = r.int32();
                        break;
                    }
                case 2: {
                        m.isDndMode = r.bool();
                        break;
                    }
                case 3: {
                        m.silenceReason = r.int32();
                        break;
                    }
                case 4: {
                        m.duration = r.int64();
                        break;
                    }
                case 5: {
                        m.startTime = r.int64();
                        break;
                    }
                case 6: {
                        m.isIncoming = r.bool();
                        break;
                    }
                case 7: {
                        m.isVideo = r.bool();
                        break;
                    }
                case 8: {
                        m.isCallLink = r.bool();
                        break;
                    }
                case 9: {
                        m.callLinkToken = r.string();
                        break;
                    }
                case 10: {
                        m.scheduledCallId = r.string();
                        break;
                    }
                case 11: {
                        m.callId = r.string();
                        break;
                    }
                case 12: {
                        m.callCreatorJid = r.string();
                        break;
                    }
                case 13: {
                        m.groupJid = r.string();
                        break;
                    }
                case 14: {
                        if (!(m.participants && m.participants.length))
                            m.participants = [];
                        m.participants.push($root.proto.CallLogRecord.ParticipantInfo.decode(r, r.uint32()));
                        break;
                    }
                case 15: {
                        m.callType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CallLogRecord.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CallLogRecord)
                return d;
            var m = new $root.proto.CallLogRecord();
            switch (d.callResult) {
            default:
                if (typeof d.callResult === "number") {
                    m.callResult = d.callResult;
                    break;
                }
                break;
            case "CONNECTED":
            case 0:
                m.callResult = 0;
                break;
            case "REJECTED":
            case 1:
                m.callResult = 1;
                break;
            case "CANCELLED":
            case 2:
                m.callResult = 2;
                break;
            case "ACCEPTEDELSEWHERE":
            case 3:
                m.callResult = 3;
                break;
            case "MISSED":
            case 4:
                m.callResult = 4;
                break;
            case "INVALID":
            case 5:
                m.callResult = 5;
                break;
            case "UNAVAILABLE":
            case 6:
                m.callResult = 6;
                break;
            case "UPCOMING":
            case 7:
                m.callResult = 7;
                break;
            case "FAILED":
            case 8:
                m.callResult = 8;
                break;
            case "ABANDONED":
            case 9:
                m.callResult = 9;
                break;
            case "ONGOING":
            case 10:
                m.callResult = 10;
                break;
            }
            if (d.isDndMode != null) {
                m.isDndMode = Boolean(d.isDndMode);
            }
            switch (d.silenceReason) {
            default:
                if (typeof d.silenceReason === "number") {
                    m.silenceReason = d.silenceReason;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.silenceReason = 0;
                break;
            case "SCHEDULED":
            case 1:
                m.silenceReason = 1;
                break;
            case "PRIVACY":
            case 2:
                m.silenceReason = 2;
                break;
            case "LIGHTWEIGHT":
            case 3:
                m.silenceReason = 3;
                break;
            }
            if (d.duration != null) {
                if ($util.Long)
                    (m.duration = $util.Long.fromValue(d.duration)).unsigned = false;
                else if (typeof d.duration === "string")
                    m.duration = parseInt(d.duration, 10);
                else if (typeof d.duration === "number")
                    m.duration = d.duration;
                else if (typeof d.duration === "object")
                    m.duration = new $util.LongBits(d.duration.low >>> 0, d.duration.high >>> 0).toNumber();
            }
            if (d.startTime != null) {
                if ($util.Long)
                    (m.startTime = $util.Long.fromValue(d.startTime)).unsigned = false;
                else if (typeof d.startTime === "string")
                    m.startTime = parseInt(d.startTime, 10);
                else if (typeof d.startTime === "number")
                    m.startTime = d.startTime;
                else if (typeof d.startTime === "object")
                    m.startTime = new $util.LongBits(d.startTime.low >>> 0, d.startTime.high >>> 0).toNumber();
            }
            if (d.isIncoming != null) {
                m.isIncoming = Boolean(d.isIncoming);
            }
            if (d.isVideo != null) {
                m.isVideo = Boolean(d.isVideo);
            }
            if (d.isCallLink != null) {
                m.isCallLink = Boolean(d.isCallLink);
            }
            if (d.callLinkToken != null) {
                m.callLinkToken = String(d.callLinkToken);
            }
            if (d.scheduledCallId != null) {
                m.scheduledCallId = String(d.scheduledCallId);
            }
            if (d.callId != null) {
                m.callId = String(d.callId);
            }
            if (d.callCreatorJid != null) {
                m.callCreatorJid = String(d.callCreatorJid);
            }
            if (d.groupJid != null) {
                m.groupJid = String(d.groupJid);
            }
            if (d.participants) {
                if (!Array.isArray(d.participants))
                    throw TypeError(".proto.CallLogRecord.participants: array expected");
                m.participants = [];
                for (var i = 0; i < d.participants.length; ++i) {
                    if (typeof d.participants[i] !== "object")
                        throw TypeError(".proto.CallLogRecord.participants: object expected");
                    m.participants[i] = $root.proto.CallLogRecord.ParticipantInfo.fromObject(d.participants[i]);
                }
            }
            switch (d.callType) {
            default:
                if (typeof d.callType === "number") {
                    m.callType = d.callType;
                    break;
                }
                break;
            case "REGULAR":
            case 0:
                m.callType = 0;
                break;
            case "SCHEDULED_CALL":
            case 1:
                m.callType = 1;
                break;
            case "VOICE_CHAT":
            case 2:
                m.callType = 2;
                break;
            }
            return m;
        };

        CallLogRecord.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.participants = [];
            }
            if (m.callResult != null && m.hasOwnProperty("callResult")) {
                d.callResult = o.enums === String ? $root.proto.CallLogRecord.CallResult[m.callResult] === undefined ? m.callResult : $root.proto.CallLogRecord.CallResult[m.callResult] : m.callResult;
                if (o.oneofs)
                    d._callResult = "callResult";
            }
            if (m.isDndMode != null && m.hasOwnProperty("isDndMode")) {
                d.isDndMode = m.isDndMode;
                if (o.oneofs)
                    d._isDndMode = "isDndMode";
            }
            if (m.silenceReason != null && m.hasOwnProperty("silenceReason")) {
                d.silenceReason = o.enums === String ? $root.proto.CallLogRecord.SilenceReason[m.silenceReason] === undefined ? m.silenceReason : $root.proto.CallLogRecord.SilenceReason[m.silenceReason] : m.silenceReason;
                if (o.oneofs)
                    d._silenceReason = "silenceReason";
            }
            if (m.duration != null && m.hasOwnProperty("duration")) {
                if (typeof m.duration === "number")
                    d.duration = o.longs === String ? String(m.duration) : m.duration;
                else
                    d.duration = o.longs === String ? $util.Long.prototype.toString.call(m.duration) : o.longs === Number ? new $util.LongBits(m.duration.low >>> 0, m.duration.high >>> 0).toNumber() : m.duration;
                if (o.oneofs)
                    d._duration = "duration";
            }
            if (m.startTime != null && m.hasOwnProperty("startTime")) {
                if (typeof m.startTime === "number")
                    d.startTime = o.longs === String ? String(m.startTime) : m.startTime;
                else
                    d.startTime = o.longs === String ? $util.Long.prototype.toString.call(m.startTime) : o.longs === Number ? new $util.LongBits(m.startTime.low >>> 0, m.startTime.high >>> 0).toNumber() : m.startTime;
                if (o.oneofs)
                    d._startTime = "startTime";
            }
            if (m.isIncoming != null && m.hasOwnProperty("isIncoming")) {
                d.isIncoming = m.isIncoming;
                if (o.oneofs)
                    d._isIncoming = "isIncoming";
            }
            if (m.isVideo != null && m.hasOwnProperty("isVideo")) {
                d.isVideo = m.isVideo;
                if (o.oneofs)
                    d._isVideo = "isVideo";
            }
            if (m.isCallLink != null && m.hasOwnProperty("isCallLink")) {
                d.isCallLink = m.isCallLink;
                if (o.oneofs)
                    d._isCallLink = "isCallLink";
            }
            if (m.callLinkToken != null && m.hasOwnProperty("callLinkToken")) {
                d.callLinkToken = m.callLinkToken;
                if (o.oneofs)
                    d._callLinkToken = "callLinkToken";
            }
            if (m.scheduledCallId != null && m.hasOwnProperty("scheduledCallId")) {
                d.scheduledCallId = m.scheduledCallId;
                if (o.oneofs)
                    d._scheduledCallId = "scheduledCallId";
            }
            if (m.callId != null && m.hasOwnProperty("callId")) {
                d.callId = m.callId;
                if (o.oneofs)
                    d._callId = "callId";
            }
            if (m.callCreatorJid != null && m.hasOwnProperty("callCreatorJid")) {
                d.callCreatorJid = m.callCreatorJid;
                if (o.oneofs)
                    d._callCreatorJid = "callCreatorJid";
            }
            if (m.groupJid != null && m.hasOwnProperty("groupJid")) {
                d.groupJid = m.groupJid;
                if (o.oneofs)
                    d._groupJid = "groupJid";
            }
            if (m.participants && m.participants.length) {
                d.participants = [];
                for (var j = 0; j < m.participants.length; ++j) {
                    d.participants[j] = $root.proto.CallLogRecord.ParticipantInfo.toObject(m.participants[j], o);
                }
            }
            if (m.callType != null && m.hasOwnProperty("callType")) {
                d.callType = o.enums === String ? $root.proto.CallLogRecord.CallType[m.callType] === undefined ? m.callType : $root.proto.CallLogRecord.CallType[m.callType] : m.callType;
                if (o.oneofs)
                    d._callType = "callType";
            }
            return d;
        };

        CallLogRecord.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CallLogRecord.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CallLogRecord";
        };

        CallLogRecord.CallResult = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CONNECTED"] = 0;
            values[valuesById[1] = "REJECTED"] = 1;
            values[valuesById[2] = "CANCELLED"] = 2;
            values[valuesById[3] = "ACCEPTEDELSEWHERE"] = 3;
            values[valuesById[4] = "MISSED"] = 4;
            values[valuesById[5] = "INVALID"] = 5;
            values[valuesById[6] = "UNAVAILABLE"] = 6;
            values[valuesById[7] = "UPCOMING"] = 7;
            values[valuesById[8] = "FAILED"] = 8;
            values[valuesById[9] = "ABANDONED"] = 9;
            values[valuesById[10] = "ONGOING"] = 10;
            return values;
        })();

        CallLogRecord.CallType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "REGULAR"] = 0;
            values[valuesById[1] = "SCHEDULED_CALL"] = 1;
            values[valuesById[2] = "VOICE_CHAT"] = 2;
            return values;
        })();

        CallLogRecord.ParticipantInfo = (function() {

            function ParticipantInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ParticipantInfo.prototype.userJid = null;
            ParticipantInfo.prototype.callResult = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ParticipantInfo.prototype, "_userJid", {
                get: $util.oneOfGetter($oneOfFields = ["userJid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ParticipantInfo.prototype, "_callResult", {
                get: $util.oneOfGetter($oneOfFields = ["callResult"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ParticipantInfo.create = function create(properties) {
                return new ParticipantInfo(properties);
            };

            ParticipantInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.userJid != null && Object.hasOwnProperty.call(m, "userJid"))
                    w.uint32(10).string(m.userJid);
                if (m.callResult != null && Object.hasOwnProperty.call(m, "callResult"))
                    w.uint32(16).int32(m.callResult);
                return w;
            };

            ParticipantInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CallLogRecord.ParticipantInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.userJid = r.string();
                            break;
                        }
                    case 2: {
                            m.callResult = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ParticipantInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.CallLogRecord.ParticipantInfo)
                    return d;
                var m = new $root.proto.CallLogRecord.ParticipantInfo();
                if (d.userJid != null) {
                    m.userJid = String(d.userJid);
                }
                switch (d.callResult) {
                default:
                    if (typeof d.callResult === "number") {
                        m.callResult = d.callResult;
                        break;
                    }
                    break;
                case "CONNECTED":
                case 0:
                    m.callResult = 0;
                    break;
                case "REJECTED":
                case 1:
                    m.callResult = 1;
                    break;
                case "CANCELLED":
                case 2:
                    m.callResult = 2;
                    break;
                case "ACCEPTEDELSEWHERE":
                case 3:
                    m.callResult = 3;
                    break;
                case "MISSED":
                case 4:
                    m.callResult = 4;
                    break;
                case "INVALID":
                case 5:
                    m.callResult = 5;
                    break;
                case "UNAVAILABLE":
                case 6:
                    m.callResult = 6;
                    break;
                case "UPCOMING":
                case 7:
                    m.callResult = 7;
                    break;
                case "FAILED":
                case 8:
                    m.callResult = 8;
                    break;
                case "ABANDONED":
                case 9:
                    m.callResult = 9;
                    break;
                case "ONGOING":
                case 10:
                    m.callResult = 10;
                    break;
                }
                return m;
            };

            ParticipantInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.userJid != null && m.hasOwnProperty("userJid")) {
                    d.userJid = m.userJid;
                    if (o.oneofs)
                        d._userJid = "userJid";
                }
                if (m.callResult != null && m.hasOwnProperty("callResult")) {
                    d.callResult = o.enums === String ? $root.proto.CallLogRecord.CallResult[m.callResult] === undefined ? m.callResult : $root.proto.CallLogRecord.CallResult[m.callResult] : m.callResult;
                    if (o.oneofs)
                        d._callResult = "callResult";
                }
                return d;
            };

            ParticipantInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            ParticipantInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.CallLogRecord.ParticipantInfo";
            };

            return ParticipantInfo;
        })();

        CallLogRecord.SilenceReason = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "SCHEDULED"] = 1;
            values[valuesById[2] = "PRIVACY"] = 2;
            values[valuesById[3] = "LIGHTWEIGHT"] = 3;
            return values;
        })();

        return CallLogRecord;
    })();

    proto.CertChain = (function() {

        function CertChain(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CertChain.prototype.leaf = null;
        CertChain.prototype.intermediate = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CertChain.prototype, "_leaf", {
            get: $util.oneOfGetter($oneOfFields = ["leaf"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CertChain.prototype, "_intermediate", {
            get: $util.oneOfGetter($oneOfFields = ["intermediate"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CertChain.create = function create(properties) {
            return new CertChain(properties);
        };

        CertChain.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.leaf != null && Object.hasOwnProperty.call(m, "leaf"))
                $root.proto.CertChain.NoiseCertificate.encode(m.leaf, w.uint32(10).fork()).ldelim();
            if (m.intermediate != null && Object.hasOwnProperty.call(m, "intermediate"))
                $root.proto.CertChain.NoiseCertificate.encode(m.intermediate, w.uint32(18).fork()).ldelim();
            return w;
        };

        CertChain.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.leaf = $root.proto.CertChain.NoiseCertificate.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.intermediate = $root.proto.CertChain.NoiseCertificate.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CertChain.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CertChain)
                return d;
            var m = new $root.proto.CertChain();
            if (d.leaf != null) {
                if (typeof d.leaf !== "object")
                    throw TypeError(".proto.CertChain.leaf: object expected");
                m.leaf = $root.proto.CertChain.NoiseCertificate.fromObject(d.leaf);
            }
            if (d.intermediate != null) {
                if (typeof d.intermediate !== "object")
                    throw TypeError(".proto.CertChain.intermediate: object expected");
                m.intermediate = $root.proto.CertChain.NoiseCertificate.fromObject(d.intermediate);
            }
            return m;
        };

        CertChain.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.leaf != null && m.hasOwnProperty("leaf")) {
                d.leaf = $root.proto.CertChain.NoiseCertificate.toObject(m.leaf, o);
                if (o.oneofs)
                    d._leaf = "leaf";
            }
            if (m.intermediate != null && m.hasOwnProperty("intermediate")) {
                d.intermediate = $root.proto.CertChain.NoiseCertificate.toObject(m.intermediate, o);
                if (o.oneofs)
                    d._intermediate = "intermediate";
            }
            return d;
        };

        CertChain.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CertChain.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CertChain";
        };

        CertChain.NoiseCertificate = (function() {

            function NoiseCertificate(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            NoiseCertificate.prototype.details = null;
            NoiseCertificate.prototype.signature = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(NoiseCertificate.prototype, "_details", {
                get: $util.oneOfGetter($oneOfFields = ["details"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(NoiseCertificate.prototype, "_signature", {
                get: $util.oneOfGetter($oneOfFields = ["signature"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            NoiseCertificate.create = function create(properties) {
                return new NoiseCertificate(properties);
            };

            NoiseCertificate.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                    w.uint32(10).bytes(m.details);
                if (m.signature != null && Object.hasOwnProperty.call(m, "signature"))
                    w.uint32(18).bytes(m.signature);
                return w;
            };

            NoiseCertificate.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain.NoiseCertificate();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.details = r.bytes();
                            break;
                        }
                    case 2: {
                            m.signature = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            NoiseCertificate.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.CertChain.NoiseCertificate)
                    return d;
                var m = new $root.proto.CertChain.NoiseCertificate();
                if (d.details != null) {
                    if (typeof d.details === "string")
                        $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                    else if (d.details.length >= 0)
                        m.details = d.details;
                }
                if (d.signature != null) {
                    if (typeof d.signature === "string")
                        $util.base64.decode(d.signature, m.signature = $util.newBuffer($util.base64.length(d.signature)), 0);
                    else if (d.signature.length >= 0)
                        m.signature = d.signature;
                }
                return m;
            };

            NoiseCertificate.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.details != null && m.hasOwnProperty("details")) {
                    d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                    if (o.oneofs)
                        d._details = "details";
                }
                if (m.signature != null && m.hasOwnProperty("signature")) {
                    d.signature = o.bytes === String ? $util.base64.encode(m.signature, 0, m.signature.length) : o.bytes === Array ? Array.prototype.slice.call(m.signature) : m.signature;
                    if (o.oneofs)
                        d._signature = "signature";
                }
                return d;
            };

            NoiseCertificate.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            NoiseCertificate.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.CertChain.NoiseCertificate";
            };

            NoiseCertificate.Details = (function() {

                function Details(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Details.prototype.serial = null;
                Details.prototype.issuerSerial = null;
                Details.prototype.key = null;
                Details.prototype.notBefore = null;
                Details.prototype.notAfter = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_serial", {
                    get: $util.oneOfGetter($oneOfFields = ["serial"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_issuerSerial", {
                    get: $util.oneOfGetter($oneOfFields = ["issuerSerial"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_key", {
                    get: $util.oneOfGetter($oneOfFields = ["key"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_notBefore", {
                    get: $util.oneOfGetter($oneOfFields = ["notBefore"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_notAfter", {
                    get: $util.oneOfGetter($oneOfFields = ["notAfter"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                Details.create = function create(properties) {
                    return new Details(properties);
                };

                Details.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.serial != null && Object.hasOwnProperty.call(m, "serial"))
                        w.uint32(8).uint32(m.serial);
                    if (m.issuerSerial != null && Object.hasOwnProperty.call(m, "issuerSerial"))
                        w.uint32(16).uint32(m.issuerSerial);
                    if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                        w.uint32(26).bytes(m.key);
                    if (m.notBefore != null && Object.hasOwnProperty.call(m, "notBefore"))
                        w.uint32(32).uint64(m.notBefore);
                    if (m.notAfter != null && Object.hasOwnProperty.call(m, "notAfter"))
                        w.uint32(40).uint64(m.notAfter);
                    return w;
                };

                Details.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain.NoiseCertificate.Details();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.serial = r.uint32();
                                break;
                            }
                        case 2: {
                                m.issuerSerial = r.uint32();
                                break;
                            }
                        case 3: {
                                m.key = r.bytes();
                                break;
                            }
                        case 4: {
                                m.notBefore = r.uint64();
                                break;
                            }
                        case 5: {
                                m.notAfter = r.uint64();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Details.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.CertChain.NoiseCertificate.Details)
                        return d;
                    var m = new $root.proto.CertChain.NoiseCertificate.Details();
                    if (d.serial != null) {
                        m.serial = d.serial >>> 0;
                    }
                    if (d.issuerSerial != null) {
                        m.issuerSerial = d.issuerSerial >>> 0;
                    }
                    if (d.key != null) {
                        if (typeof d.key === "string")
                            $util.base64.decode(d.key, m.key = $util.newBuffer($util.base64.length(d.key)), 0);
                        else if (d.key.length >= 0)
                            m.key = d.key;
                    }
                    if (d.notBefore != null) {
                        if ($util.Long)
                            (m.notBefore = $util.Long.fromValue(d.notBefore)).unsigned = true;
                        else if (typeof d.notBefore === "string")
                            m.notBefore = parseInt(d.notBefore, 10);
                        else if (typeof d.notBefore === "number")
                            m.notBefore = d.notBefore;
                        else if (typeof d.notBefore === "object")
                            m.notBefore = new $util.LongBits(d.notBefore.low >>> 0, d.notBefore.high >>> 0).toNumber(true);
                    }
                    if (d.notAfter != null) {
                        if ($util.Long)
                            (m.notAfter = $util.Long.fromValue(d.notAfter)).unsigned = true;
                        else if (typeof d.notAfter === "string")
                            m.notAfter = parseInt(d.notAfter, 10);
                        else if (typeof d.notAfter === "number")
                            m.notAfter = d.notAfter;
                        else if (typeof d.notAfter === "object")
                            m.notAfter = new $util.LongBits(d.notAfter.low >>> 0, d.notAfter.high >>> 0).toNumber(true);
                    }
                    return m;
                };

                Details.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.serial != null && m.hasOwnProperty("serial")) {
                        d.serial = m.serial;
                        if (o.oneofs)
                            d._serial = "serial";
                    }
                    if (m.issuerSerial != null && m.hasOwnProperty("issuerSerial")) {
                        d.issuerSerial = m.issuerSerial;
                        if (o.oneofs)
                            d._issuerSerial = "issuerSerial";
                    }
                    if (m.key != null && m.hasOwnProperty("key")) {
                        d.key = o.bytes === String ? $util.base64.encode(m.key, 0, m.key.length) : o.bytes === Array ? Array.prototype.slice.call(m.key) : m.key;
                        if (o.oneofs)
                            d._key = "key";
                    }
                    if (m.notBefore != null && m.hasOwnProperty("notBefore")) {
                        if (typeof m.notBefore === "number")
                            d.notBefore = o.longs === String ? String(m.notBefore) : m.notBefore;
                        else
                            d.notBefore = o.longs === String ? $util.Long.prototype.toString.call(m.notBefore) : o.longs === Number ? new $util.LongBits(m.notBefore.low >>> 0, m.notBefore.high >>> 0).toNumber(true) : m.notBefore;
                        if (o.oneofs)
                            d._notBefore = "notBefore";
                    }
                    if (m.notAfter != null && m.hasOwnProperty("notAfter")) {
                        if (typeof m.notAfter === "number")
                            d.notAfter = o.longs === String ? String(m.notAfter) : m.notAfter;
                        else
                            d.notAfter = o.longs === String ? $util.Long.prototype.toString.call(m.notAfter) : o.longs === Number ? new $util.LongBits(m.notAfter.low >>> 0, m.notAfter.high >>> 0).toNumber(true) : m.notAfter;
                        if (o.oneofs)
                            d._notAfter = "notAfter";
                    }
                    return d;
                };

                Details.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                Details.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.CertChain.NoiseCertificate.Details";
                };

                return Details;
            })();

            return NoiseCertificate;
        })();

        return CertChain;
    })();

    proto.ChatLockSettings = (function() {

        function ChatLockSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ChatLockSettings.prototype.hideLockedChats = null;
        ChatLockSettings.prototype.secretCode = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ChatLockSettings.prototype, "_hideLockedChats", {
            get: $util.oneOfGetter($oneOfFields = ["hideLockedChats"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ChatLockSettings.prototype, "_secretCode", {
            get: $util.oneOfGetter($oneOfFields = ["secretCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ChatLockSettings.create = function create(properties) {
            return new ChatLockSettings(properties);
        };

        ChatLockSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.hideLockedChats != null && Object.hasOwnProperty.call(m, "hideLockedChats"))
                w.uint32(8).bool(m.hideLockedChats);
            if (m.secretCode != null && Object.hasOwnProperty.call(m, "secretCode"))
                $root.proto.UserPassword.encode(m.secretCode, w.uint32(18).fork()).ldelim();
            return w;
        };

        ChatLockSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatLockSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.hideLockedChats = r.bool();
                        break;
                    }
                case 2: {
                        m.secretCode = $root.proto.UserPassword.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ChatLockSettings.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ChatLockSettings)
                return d;
            var m = new $root.proto.ChatLockSettings();
            if (d.hideLockedChats != null) {
                m.hideLockedChats = Boolean(d.hideLockedChats);
            }
            if (d.secretCode != null) {
                if (typeof d.secretCode !== "object")
                    throw TypeError(".proto.ChatLockSettings.secretCode: object expected");
                m.secretCode = $root.proto.UserPassword.fromObject(d.secretCode);
            }
            return m;
        };

        ChatLockSettings.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.hideLockedChats != null && m.hasOwnProperty("hideLockedChats")) {
                d.hideLockedChats = m.hideLockedChats;
                if (o.oneofs)
                    d._hideLockedChats = "hideLockedChats";
            }
            if (m.secretCode != null && m.hasOwnProperty("secretCode")) {
                d.secretCode = $root.proto.UserPassword.toObject(m.secretCode, o);
                if (o.oneofs)
                    d._secretCode = "secretCode";
            }
            return d;
        };

        ChatLockSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ChatLockSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ChatLockSettings";
        };

        return ChatLockSettings;
    })();

    proto.ChatRowOpaqueData = (function() {

        function ChatRowOpaqueData(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ChatRowOpaqueData.prototype.draftMessage = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ChatRowOpaqueData.prototype, "_draftMessage", {
            get: $util.oneOfGetter($oneOfFields = ["draftMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ChatRowOpaqueData.create = function create(properties) {
            return new ChatRowOpaqueData(properties);
        };

        ChatRowOpaqueData.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.draftMessage != null && Object.hasOwnProperty.call(m, "draftMessage"))
                $root.proto.ChatRowOpaqueData.DraftMessage.encode(m.draftMessage, w.uint32(10).fork()).ldelim();
            return w;
        };

        ChatRowOpaqueData.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ChatRowOpaqueData.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ChatRowOpaqueData)
                return d;
            var m = new $root.proto.ChatRowOpaqueData();
            if (d.draftMessage != null) {
                if (typeof d.draftMessage !== "object")
                    throw TypeError(".proto.ChatRowOpaqueData.draftMessage: object expected");
                m.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.fromObject(d.draftMessage);
            }
            return m;
        };

        ChatRowOpaqueData.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.draftMessage != null && m.hasOwnProperty("draftMessage")) {
                d.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.toObject(m.draftMessage, o);
                if (o.oneofs)
                    d._draftMessage = "draftMessage";
            }
            return d;
        };

        ChatRowOpaqueData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ChatRowOpaqueData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ChatRowOpaqueData";
        };

        ChatRowOpaqueData.DraftMessage = (function() {

            function DraftMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DraftMessage.prototype.text = null;
            DraftMessage.prototype.omittedUrl = null;
            DraftMessage.prototype.ctwaContextLinkData = null;
            DraftMessage.prototype.ctwaContext = null;
            DraftMessage.prototype.timestamp = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_text", {
                get: $util.oneOfGetter($oneOfFields = ["text"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_omittedUrl", {
                get: $util.oneOfGetter($oneOfFields = ["omittedUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_ctwaContextLinkData", {
                get: $util.oneOfGetter($oneOfFields = ["ctwaContextLinkData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_ctwaContext", {
                get: $util.oneOfGetter($oneOfFields = ["ctwaContext"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_timestamp", {
                get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DraftMessage.create = function create(properties) {
                return new DraftMessage(properties);
            };

            DraftMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.omittedUrl != null && Object.hasOwnProperty.call(m, "omittedUrl"))
                    w.uint32(18).string(m.omittedUrl);
                if (m.ctwaContextLinkData != null && Object.hasOwnProperty.call(m, "ctwaContextLinkData"))
                    $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.encode(m.ctwaContextLinkData, w.uint32(26).fork()).ldelim();
                if (m.ctwaContext != null && Object.hasOwnProperty.call(m, "ctwaContext"))
                    $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.encode(m.ctwaContext, w.uint32(34).fork()).ldelim();
                if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                    w.uint32(40).int64(m.timestamp);
                return w;
            };

            DraftMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            m.omittedUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.timestamp = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DraftMessage.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ChatRowOpaqueData.DraftMessage)
                    return d;
                var m = new $root.proto.ChatRowOpaqueData.DraftMessage();
                if (d.text != null) {
                    m.text = String(d.text);
                }
                if (d.omittedUrl != null) {
                    m.omittedUrl = String(d.omittedUrl);
                }
                if (d.ctwaContextLinkData != null) {
                    if (typeof d.ctwaContextLinkData !== "object")
                        throw TypeError(".proto.ChatRowOpaqueData.DraftMessage.ctwaContextLinkData: object expected");
                    m.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.fromObject(d.ctwaContextLinkData);
                }
                if (d.ctwaContext != null) {
                    if (typeof d.ctwaContext !== "object")
                        throw TypeError(".proto.ChatRowOpaqueData.DraftMessage.ctwaContext: object expected");
                    m.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.fromObject(d.ctwaContext);
                }
                if (d.timestamp != null) {
                    if ($util.Long)
                        (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = false;
                    else if (typeof d.timestamp === "string")
                        m.timestamp = parseInt(d.timestamp, 10);
                    else if (typeof d.timestamp === "number")
                        m.timestamp = d.timestamp;
                    else if (typeof d.timestamp === "object")
                        m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber();
                }
                return m;
            };

            DraftMessage.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.text != null && m.hasOwnProperty("text")) {
                    d.text = m.text;
                    if (o.oneofs)
                        d._text = "text";
                }
                if (m.omittedUrl != null && m.hasOwnProperty("omittedUrl")) {
                    d.omittedUrl = m.omittedUrl;
                    if (o.oneofs)
                        d._omittedUrl = "omittedUrl";
                }
                if (m.ctwaContextLinkData != null && m.hasOwnProperty("ctwaContextLinkData")) {
                    d.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.toObject(m.ctwaContextLinkData, o);
                    if (o.oneofs)
                        d._ctwaContextLinkData = "ctwaContextLinkData";
                }
                if (m.ctwaContext != null && m.hasOwnProperty("ctwaContext")) {
                    d.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.toObject(m.ctwaContext, o);
                    if (o.oneofs)
                        d._ctwaContext = "ctwaContext";
                }
                if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                    if (typeof m.timestamp === "number")
                        d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                    else
                        d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber() : m.timestamp;
                    if (o.oneofs)
                        d._timestamp = "timestamp";
                }
                return d;
            };

            DraftMessage.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DraftMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage";
            };

            DraftMessage.CtwaContextData = (function() {

                function CtwaContextData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CtwaContextData.prototype.conversionSource = null;
                CtwaContextData.prototype.conversionData = null;
                CtwaContextData.prototype.sourceUrl = null;
                CtwaContextData.prototype.sourceId = null;
                CtwaContextData.prototype.sourceType = null;
                CtwaContextData.prototype.title = null;
                CtwaContextData.prototype.description = null;
                CtwaContextData.prototype.thumbnail = null;
                CtwaContextData.prototype.thumbnailUrl = null;
                CtwaContextData.prototype.mediaType = null;
                CtwaContextData.prototype.mediaUrl = null;
                CtwaContextData.prototype.isSuspiciousLink = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_conversionSource", {
                    get: $util.oneOfGetter($oneOfFields = ["conversionSource"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_conversionData", {
                    get: $util.oneOfGetter($oneOfFields = ["conversionData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_sourceId", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_sourceType", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_description", {
                    get: $util.oneOfGetter($oneOfFields = ["description"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_thumbnail", {
                    get: $util.oneOfGetter($oneOfFields = ["thumbnail"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_thumbnailUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_mediaType", {
                    get: $util.oneOfGetter($oneOfFields = ["mediaType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_mediaUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["mediaUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_isSuspiciousLink", {
                    get: $util.oneOfGetter($oneOfFields = ["isSuspiciousLink"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                CtwaContextData.create = function create(properties) {
                    return new CtwaContextData(properties);
                };

                CtwaContextData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                        w.uint32(10).string(m.conversionSource);
                    if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                        w.uint32(18).bytes(m.conversionData);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    if (m.sourceId != null && Object.hasOwnProperty.call(m, "sourceId"))
                        w.uint32(34).string(m.sourceId);
                    if (m.sourceType != null && Object.hasOwnProperty.call(m, "sourceType"))
                        w.uint32(42).string(m.sourceType);
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(50).string(m.title);
                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                        w.uint32(58).string(m.description);
                    if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                        w.uint32(66).string(m.thumbnail);
                    if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                        w.uint32(74).string(m.thumbnailUrl);
                    if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                        w.uint32(80).int32(m.mediaType);
                    if (m.mediaUrl != null && Object.hasOwnProperty.call(m, "mediaUrl"))
                        w.uint32(90).string(m.mediaUrl);
                    if (m.isSuspiciousLink != null && Object.hasOwnProperty.call(m, "isSuspiciousLink"))
                        w.uint32(96).bool(m.isSuspiciousLink);
                    return w;
                };

                CtwaContextData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.conversionSource = r.string();
                                break;
                            }
                        case 2: {
                                m.conversionData = r.bytes();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.sourceId = r.string();
                                break;
                            }
                        case 5: {
                                m.sourceType = r.string();
                                break;
                            }
                        case 6: {
                                m.title = r.string();
                                break;
                            }
                        case 7: {
                                m.description = r.string();
                                break;
                            }
                        case 8: {
                                m.thumbnail = r.string();
                                break;
                            }
                        case 9: {
                                m.thumbnailUrl = r.string();
                                break;
                            }
                        case 10: {
                                m.mediaType = r.int32();
                                break;
                            }
                        case 11: {
                                m.mediaUrl = r.string();
                                break;
                            }
                        case 12: {
                                m.isSuspiciousLink = r.bool();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CtwaContextData.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData)
                        return d;
                    var m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData();
                    if (d.conversionSource != null) {
                        m.conversionSource = String(d.conversionSource);
                    }
                    if (d.conversionData != null) {
                        if (typeof d.conversionData === "string")
                            $util.base64.decode(d.conversionData, m.conversionData = $util.newBuffer($util.base64.length(d.conversionData)), 0);
                        else if (d.conversionData.length >= 0)
                            m.conversionData = d.conversionData;
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    if (d.sourceId != null) {
                        m.sourceId = String(d.sourceId);
                    }
                    if (d.sourceType != null) {
                        m.sourceType = String(d.sourceType);
                    }
                    if (d.title != null) {
                        m.title = String(d.title);
                    }
                    if (d.description != null) {
                        m.description = String(d.description);
                    }
                    if (d.thumbnail != null) {
                        m.thumbnail = String(d.thumbnail);
                    }
                    if (d.thumbnailUrl != null) {
                        m.thumbnailUrl = String(d.thumbnailUrl);
                    }
                    switch (d.mediaType) {
                    default:
                        if (typeof d.mediaType === "number") {
                            m.mediaType = d.mediaType;
                            break;
                        }
                        break;
                    case "NONE":
                    case 0:
                        m.mediaType = 0;
                        break;
                    case "IMAGE":
                    case 1:
                        m.mediaType = 1;
                        break;
                    case "VIDEO":
                    case 2:
                        m.mediaType = 2;
                        break;
                    }
                    if (d.mediaUrl != null) {
                        m.mediaUrl = String(d.mediaUrl);
                    }
                    if (d.isSuspiciousLink != null) {
                        m.isSuspiciousLink = Boolean(d.isSuspiciousLink);
                    }
                    return m;
                };

                CtwaContextData.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.conversionSource != null && m.hasOwnProperty("conversionSource")) {
                        d.conversionSource = m.conversionSource;
                        if (o.oneofs)
                            d._conversionSource = "conversionSource";
                    }
                    if (m.conversionData != null && m.hasOwnProperty("conversionData")) {
                        d.conversionData = o.bytes === String ? $util.base64.encode(m.conversionData, 0, m.conversionData.length) : o.bytes === Array ? Array.prototype.slice.call(m.conversionData) : m.conversionData;
                        if (o.oneofs)
                            d._conversionData = "conversionData";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    if (m.sourceId != null && m.hasOwnProperty("sourceId")) {
                        d.sourceId = m.sourceId;
                        if (o.oneofs)
                            d._sourceId = "sourceId";
                    }
                    if (m.sourceType != null && m.hasOwnProperty("sourceType")) {
                        d.sourceType = m.sourceType;
                        if (o.oneofs)
                            d._sourceType = "sourceType";
                    }
                    if (m.title != null && m.hasOwnProperty("title")) {
                        d.title = m.title;
                        if (o.oneofs)
                            d._title = "title";
                    }
                    if (m.description != null && m.hasOwnProperty("description")) {
                        d.description = m.description;
                        if (o.oneofs)
                            d._description = "description";
                    }
                    if (m.thumbnail != null && m.hasOwnProperty("thumbnail")) {
                        d.thumbnail = m.thumbnail;
                        if (o.oneofs)
                            d._thumbnail = "thumbnail";
                    }
                    if (m.thumbnailUrl != null && m.hasOwnProperty("thumbnailUrl")) {
                        d.thumbnailUrl = m.thumbnailUrl;
                        if (o.oneofs)
                            d._thumbnailUrl = "thumbnailUrl";
                    }
                    if (m.mediaType != null && m.hasOwnProperty("mediaType")) {
                        d.mediaType = o.enums === String ? $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.ContextInfoExternalAdReplyInfoMediaType[m.mediaType] === undefined ? m.mediaType : $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.ContextInfoExternalAdReplyInfoMediaType[m.mediaType] : m.mediaType;
                        if (o.oneofs)
                            d._mediaType = "mediaType";
                    }
                    if (m.mediaUrl != null && m.hasOwnProperty("mediaUrl")) {
                        d.mediaUrl = m.mediaUrl;
                        if (o.oneofs)
                            d._mediaUrl = "mediaUrl";
                    }
                    if (m.isSuspiciousLink != null && m.hasOwnProperty("isSuspiciousLink")) {
                        d.isSuspiciousLink = m.isSuspiciousLink;
                        if (o.oneofs)
                            d._isSuspiciousLink = "isSuspiciousLink";
                    }
                    return d;
                };

                CtwaContextData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                CtwaContextData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage.CtwaContextData";
                };

                CtwaContextData.ContextInfoExternalAdReplyInfoMediaType = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "NONE"] = 0;
                    values[valuesById[1] = "IMAGE"] = 1;
                    values[valuesById[2] = "VIDEO"] = 2;
                    return values;
                })();

                return CtwaContextData;
            })();

            DraftMessage.CtwaContextLinkData = (function() {

                function CtwaContextLinkData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CtwaContextLinkData.prototype.context = null;
                CtwaContextLinkData.prototype.sourceUrl = null;
                CtwaContextLinkData.prototype.icebreaker = null;
                CtwaContextLinkData.prototype.phone = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_context", {
                    get: $util.oneOfGetter($oneOfFields = ["context"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_icebreaker", {
                    get: $util.oneOfGetter($oneOfFields = ["icebreaker"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_phone", {
                    get: $util.oneOfGetter($oneOfFields = ["phone"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                CtwaContextLinkData.create = function create(properties) {
                    return new CtwaContextLinkData(properties);
                };

                CtwaContextLinkData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.context != null && Object.hasOwnProperty.call(m, "context"))
                        w.uint32(10).string(m.context);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(18).string(m.sourceUrl);
                    if (m.icebreaker != null && Object.hasOwnProperty.call(m, "icebreaker"))
                        w.uint32(26).string(m.icebreaker);
                    if (m.phone != null && Object.hasOwnProperty.call(m, "phone"))
                        w.uint32(34).string(m.phone);
                    return w;
                };

                CtwaContextLinkData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.context = r.string();
                                break;
                            }
                        case 2: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 3: {
                                m.icebreaker = r.string();
                                break;
                            }
                        case 4: {
                                m.phone = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CtwaContextLinkData.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData)
                        return d;
                    var m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData();
                    if (d.context != null) {
                        m.context = String(d.context);
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    if (d.icebreaker != null) {
                        m.icebreaker = String(d.icebreaker);
                    }
                    if (d.phone != null) {
                        m.phone = String(d.phone);
                    }
                    return m;
                };

                CtwaContextLinkData.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.context != null && m.hasOwnProperty("context")) {
                        d.context = m.context;
                        if (o.oneofs)
                            d._context = "context";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    if (m.icebreaker != null && m.hasOwnProperty("icebreaker")) {
                        d.icebreaker = m.icebreaker;
                        if (o.oneofs)
                            d._icebreaker = "icebreaker";
                    }
                    if (m.phone != null && m.hasOwnProperty("phone")) {
                        d.phone = m.phone;
                        if (o.oneofs)
                            d._phone = "phone";
                    }
                    return d;
                };

                CtwaContextLinkData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                CtwaContextLinkData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData";
                };

                return CtwaContextLinkData;
            })();

            return DraftMessage;
        })();

        return ChatRowOpaqueData;
    })();

    proto.Citation = (function() {

        function Citation(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Citation.prototype.title = "";
        Citation.prototype.subtitle = "";
        Citation.prototype.cmsId = "";
        Citation.prototype.imageUrl = "";

        Citation.create = function create(properties) {
            return new Citation(properties);
        };

        Citation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                w.uint32(10).string(m.title);
            if (m.subtitle != null && Object.hasOwnProperty.call(m, "subtitle"))
                w.uint32(18).string(m.subtitle);
            if (m.cmsId != null && Object.hasOwnProperty.call(m, "cmsId"))
                w.uint32(26).string(m.cmsId);
            if (m.imageUrl != null && Object.hasOwnProperty.call(m, "imageUrl"))
                w.uint32(34).string(m.imageUrl);
            return w;
        };

        Citation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Citation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.title = r.string();
                        break;
                    }
                case 2: {
                        m.subtitle = r.string();
                        break;
                    }
                case 3: {
                        m.cmsId = r.string();
                        break;
                    }
                case 4: {
                        m.imageUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Citation.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Citation)
                return d;
            var m = new $root.proto.Citation();
            if (d.title != null) {
                m.title = String(d.title);
            }
            if (d.subtitle != null) {
                m.subtitle = String(d.subtitle);
            }
            if (d.cmsId != null) {
                m.cmsId = String(d.cmsId);
            }
            if (d.imageUrl != null) {
                m.imageUrl = String(d.imageUrl);
            }
            return m;
        };

        Citation.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.defaults) {
                d.title = "";
                d.subtitle = "";
                d.cmsId = "";
                d.imageUrl = "";
            }
            if (m.title != null && m.hasOwnProperty("title")) {
                d.title = m.title;
            }
            if (m.subtitle != null && m.hasOwnProperty("subtitle")) {
                d.subtitle = m.subtitle;
            }
            if (m.cmsId != null && m.hasOwnProperty("cmsId")) {
                d.cmsId = m.cmsId;
            }
            if (m.imageUrl != null && m.hasOwnProperty("imageUrl")) {
                d.imageUrl = m.imageUrl;
            }
            return d;
        };

        Citation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Citation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Citation";
        };

        return Citation;
    })();

    proto.ClientPairingProps = (function() {

        function ClientPairingProps(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ClientPairingProps.prototype.isChatDbLidMigrated = null;
        ClientPairingProps.prototype.isSyncdPureLidSession = null;
        ClientPairingProps.prototype.isSyncdSnapshotRecoveryEnabled = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPairingProps.prototype, "_isChatDbLidMigrated", {
            get: $util.oneOfGetter($oneOfFields = ["isChatDbLidMigrated"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPairingProps.prototype, "_isSyncdPureLidSession", {
            get: $util.oneOfGetter($oneOfFields = ["isSyncdPureLidSession"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPairingProps.prototype, "_isSyncdSnapshotRecoveryEnabled", {
            get: $util.oneOfGetter($oneOfFields = ["isSyncdSnapshotRecoveryEnabled"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ClientPairingProps.create = function create(properties) {
            return new ClientPairingProps(properties);
        };

        ClientPairingProps.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.isChatDbLidMigrated != null && Object.hasOwnProperty.call(m, "isChatDbLidMigrated"))
                w.uint32(8).bool(m.isChatDbLidMigrated);
            if (m.isSyncdPureLidSession != null && Object.hasOwnProperty.call(m, "isSyncdPureLidSession"))
                w.uint32(16).bool(m.isSyncdPureLidSession);
            if (m.isSyncdSnapshotRecoveryEnabled != null && Object.hasOwnProperty.call(m, "isSyncdSnapshotRecoveryEnabled"))
                w.uint32(24).bool(m.isSyncdSnapshotRecoveryEnabled);
            return w;
        };

        ClientPairingProps.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPairingProps();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.isChatDbLidMigrated = r.bool();
                        break;
                    }
                case 2: {
                        m.isSyncdPureLidSession = r.bool();
                        break;
                    }
                case 3: {
                        m.isSyncdSnapshotRecoveryEnabled = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ClientPairingProps.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ClientPairingProps)
                return d;
            var m = new $root.proto.ClientPairingProps();
            if (d.isChatDbLidMigrated != null) {
                m.isChatDbLidMigrated = Boolean(d.isChatDbLidMigrated);
            }
            if (d.isSyncdPureLidSession != null) {
                m.isSyncdPureLidSession = Boolean(d.isSyncdPureLidSession);
            }
            if (d.isSyncdSnapshotRecoveryEnabled != null) {
                m.isSyncdSnapshotRecoveryEnabled = Boolean(d.isSyncdSnapshotRecoveryEnabled);
            }
            return m;
        };

        ClientPairingProps.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.isChatDbLidMigrated != null && m.hasOwnProperty("isChatDbLidMigrated")) {
                d.isChatDbLidMigrated = m.isChatDbLidMigrated;
                if (o.oneofs)
                    d._isChatDbLidMigrated = "isChatDbLidMigrated";
            }
            if (m.isSyncdPureLidSession != null && m.hasOwnProperty("isSyncdPureLidSession")) {
                d.isSyncdPureLidSession = m.isSyncdPureLidSession;
                if (o.oneofs)
                    d._isSyncdPureLidSession = "isSyncdPureLidSession";
            }
            if (m.isSyncdSnapshotRecoveryEnabled != null && m.hasOwnProperty("isSyncdSnapshotRecoveryEnabled")) {
                d.isSyncdSnapshotRecoveryEnabled = m.isSyncdSnapshotRecoveryEnabled;
                if (o.oneofs)
                    d._isSyncdSnapshotRecoveryEnabled = "isSyncdSnapshotRecoveryEnabled";
            }
            return d;
        };

        ClientPairingProps.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ClientPairingProps.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ClientPairingProps";
        };

        return ClientPairingProps;
    })();

    proto.ClientPayload = (function() {

        function ClientPayload(p) {
            this.shards = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ClientPayload.prototype.username = null;
        ClientPayload.prototype.passive = null;
        ClientPayload.prototype.userAgent = null;
        ClientPayload.prototype.webInfo = null;
        ClientPayload.prototype.pushName = null;
        ClientPayload.prototype.sessionId = null;
        ClientPayload.prototype.shortConnect = null;
        ClientPayload.prototype.connectType = null;
        ClientPayload.prototype.connectReason = null;
        ClientPayload.prototype.shards = $util.emptyArray;
        ClientPayload.prototype.dnsSource = null;
        ClientPayload.prototype.connectAttemptCount = null;
        ClientPayload.prototype.device = null;
        ClientPayload.prototype.devicePairingData = null;
        ClientPayload.prototype.product = null;
        ClientPayload.prototype.fbCat = null;
        ClientPayload.prototype.fbUserAgent = null;
        ClientPayload.prototype.oc = null;
        ClientPayload.prototype.lc = null;
        ClientPayload.prototype.iosAppExtension = null;
        ClientPayload.prototype.fbAppId = null;
        ClientPayload.prototype.fbDeviceId = null;
        ClientPayload.prototype.pull = null;
        ClientPayload.prototype.paddingBytes = null;
        ClientPayload.prototype.yearClass = null;
        ClientPayload.prototype.memClass = null;
        ClientPayload.prototype.interopData = null;
        ClientPayload.prototype.trafficAnonymization = null;
        ClientPayload.prototype.lidDbMigrated = null;
        ClientPayload.prototype.accountType = null;
        ClientPayload.prototype.connectionSequenceInfo = null;
        ClientPayload.prototype.paaLink = null;
        ClientPayload.prototype.preacksCount = null;
        ClientPayload.prototype.processingQueueSize = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_username", {
            get: $util.oneOfGetter($oneOfFields = ["username"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_passive", {
            get: $util.oneOfGetter($oneOfFields = ["passive"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_userAgent", {
            get: $util.oneOfGetter($oneOfFields = ["userAgent"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_webInfo", {
            get: $util.oneOfGetter($oneOfFields = ["webInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_pushName", {
            get: $util.oneOfGetter($oneOfFields = ["pushName"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_sessionId", {
            get: $util.oneOfGetter($oneOfFields = ["sessionId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_shortConnect", {
            get: $util.oneOfGetter($oneOfFields = ["shortConnect"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectType", {
            get: $util.oneOfGetter($oneOfFields = ["connectType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectReason", {
            get: $util.oneOfGetter($oneOfFields = ["connectReason"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_dnsSource", {
            get: $util.oneOfGetter($oneOfFields = ["dnsSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectAttemptCount", {
            get: $util.oneOfGetter($oneOfFields = ["connectAttemptCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_device", {
            get: $util.oneOfGetter($oneOfFields = ["device"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_devicePairingData", {
            get: $util.oneOfGetter($oneOfFields = ["devicePairingData"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_product", {
            get: $util.oneOfGetter($oneOfFields = ["product"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbCat", {
            get: $util.oneOfGetter($oneOfFields = ["fbCat"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbUserAgent", {
            get: $util.oneOfGetter($oneOfFields = ["fbUserAgent"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_oc", {
            get: $util.oneOfGetter($oneOfFields = ["oc"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_lc", {
            get: $util.oneOfGetter($oneOfFields = ["lc"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_iosAppExtension", {
            get: $util.oneOfGetter($oneOfFields = ["iosAppExtension"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbAppId", {
            get: $util.oneOfGetter($oneOfFields = ["fbAppId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbDeviceId", {
            get: $util.oneOfGetter($oneOfFields = ["fbDeviceId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_pull", {
            get: $util.oneOfGetter($oneOfFields = ["pull"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_paddingBytes", {
            get: $util.oneOfGetter($oneOfFields = ["paddingBytes"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_yearClass", {
            get: $util.oneOfGetter($oneOfFields = ["yearClass"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_memClass", {
            get: $util.oneOfGetter($oneOfFields = ["memClass"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_interopData", {
            get: $util.oneOfGetter($oneOfFields = ["interopData"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_trafficAnonymization", {
            get: $util.oneOfGetter($oneOfFields = ["trafficAnonymization"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_lidDbMigrated", {
            get: $util.oneOfGetter($oneOfFields = ["lidDbMigrated"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectionSequenceInfo", {
            get: $util.oneOfGetter($oneOfFields = ["connectionSequenceInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_paaLink", {
            get: $util.oneOfGetter($oneOfFields = ["paaLink"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_preacksCount", {
            get: $util.oneOfGetter($oneOfFields = ["preacksCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_processingQueueSize", {
            get: $util.oneOfGetter($oneOfFields = ["processingQueueSize"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ClientPayload.create = function create(properties) {
            return new ClientPayload(properties);
        };

        ClientPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(8).uint64(m.username);
            if (m.passive != null && Object.hasOwnProperty.call(m, "passive"))
                w.uint32(24).bool(m.passive);
            if (m.userAgent != null && Object.hasOwnProperty.call(m, "userAgent"))
                $root.proto.ClientPayload.UserAgent.encode(m.userAgent, w.uint32(42).fork()).ldelim();
            if (m.webInfo != null && Object.hasOwnProperty.call(m, "webInfo"))
                $root.proto.ClientPayload.WebInfo.encode(m.webInfo, w.uint32(50).fork()).ldelim();
            if (m.pushName != null && Object.hasOwnProperty.call(m, "pushName"))
                w.uint32(58).string(m.pushName);
            if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                w.uint32(77).sfixed32(m.sessionId);
            if (m.shortConnect != null && Object.hasOwnProperty.call(m, "shortConnect"))
                w.uint32(80).bool(m.shortConnect);
            if (m.connectType != null && Object.hasOwnProperty.call(m, "connectType"))
                w.uint32(96).int32(m.connectType);
            if (m.connectReason != null && Object.hasOwnProperty.call(m, "connectReason"))
                w.uint32(104).int32(m.connectReason);
            if (m.shards != null && m.shards.length) {
                w.uint32(114).fork();
                for (var i = 0; i < m.shards.length; ++i)
                    w.int32(m.shards[i]);
                w.ldelim();
            }
            if (m.dnsSource != null && Object.hasOwnProperty.call(m, "dnsSource"))
                $root.proto.ClientPayload.DNSSource.encode(m.dnsSource, w.uint32(122).fork()).ldelim();
            if (m.connectAttemptCount != null && Object.hasOwnProperty.call(m, "connectAttemptCount"))
                w.uint32(128).uint32(m.connectAttemptCount);
            if (m.device != null && Object.hasOwnProperty.call(m, "device"))
                w.uint32(144).uint32(m.device);
            if (m.devicePairingData != null && Object.hasOwnProperty.call(m, "devicePairingData"))
                $root.proto.ClientPayload.DevicePairingRegistrationData.encode(m.devicePairingData, w.uint32(154).fork()).ldelim();
            if (m.product != null && Object.hasOwnProperty.call(m, "product"))
                w.uint32(160).int32(m.product);
            if (m.fbCat != null && Object.hasOwnProperty.call(m, "fbCat"))
                w.uint32(170).bytes(m.fbCat);
            if (m.fbUserAgent != null && Object.hasOwnProperty.call(m, "fbUserAgent"))
                w.uint32(178).bytes(m.fbUserAgent);
            if (m.oc != null && Object.hasOwnProperty.call(m, "oc"))
                w.uint32(184).bool(m.oc);
            if (m.lc != null && Object.hasOwnProperty.call(m, "lc"))
                w.uint32(192).int32(m.lc);
            if (m.iosAppExtension != null && Object.hasOwnProperty.call(m, "iosAppExtension"))
                w.uint32(240).int32(m.iosAppExtension);
            if (m.fbAppId != null && Object.hasOwnProperty.call(m, "fbAppId"))
                w.uint32(248).uint64(m.fbAppId);
            if (m.fbDeviceId != null && Object.hasOwnProperty.call(m, "fbDeviceId"))
                w.uint32(258).bytes(m.fbDeviceId);
            if (m.pull != null && Object.hasOwnProperty.call(m, "pull"))
                w.uint32(264).bool(m.pull);
            if (m.paddingBytes != null && Object.hasOwnProperty.call(m, "paddingBytes"))
                w.uint32(274).bytes(m.paddingBytes);
            if (m.yearClass != null && Object.hasOwnProperty.call(m, "yearClass"))
                w.uint32(288).int32(m.yearClass);
            if (m.memClass != null && Object.hasOwnProperty.call(m, "memClass"))
                w.uint32(296).int32(m.memClass);
            if (m.interopData != null && Object.hasOwnProperty.call(m, "interopData"))
                $root.proto.ClientPayload.InteropData.encode(m.interopData, w.uint32(306).fork()).ldelim();
            if (m.trafficAnonymization != null && Object.hasOwnProperty.call(m, "trafficAnonymization"))
                w.uint32(320).int32(m.trafficAnonymization);
            if (m.lidDbMigrated != null && Object.hasOwnProperty.call(m, "lidDbMigrated"))
                w.uint32(328).bool(m.lidDbMigrated);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(336).int32(m.accountType);
            if (m.connectionSequenceInfo != null && Object.hasOwnProperty.call(m, "connectionSequenceInfo"))
                w.uint32(349).sfixed32(m.connectionSequenceInfo);
            if (m.paaLink != null && Object.hasOwnProperty.call(m, "paaLink"))
                w.uint32(352).bool(m.paaLink);
            if (m.preacksCount != null && Object.hasOwnProperty.call(m, "preacksCount"))
                w.uint32(360).int32(m.preacksCount);
            if (m.processingQueueSize != null && Object.hasOwnProperty.call(m, "processingQueueSize"))
                w.uint32(368).int32(m.processingQueueSize);
            return w;
        };

        ClientPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.username = r.uint64();
                        break;
                    }
                case 3: {
                        m.passive = r.bool();
                        break;
                    }
                case 5: {
                        m.userAgent = $root.proto.ClientPayload.UserAgent.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.webInfo = $root.proto.ClientPayload.WebInfo.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.pushName = r.string();
                        break;
                    }
                case 9: {
                        m.sessionId = r.sfixed32();
                        break;
                    }
                case 10: {
                        m.shortConnect = r.bool();
                        break;
                    }
                case 12: {
                        m.connectType = r.int32();
                        break;
                    }
                case 13: {
                        m.connectReason = r.int32();
                        break;
                    }
                case 14: {
                        if (!(m.shards && m.shards.length))
                            m.shards = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.shards.push(r.int32());
                        } else
                            m.shards.push(r.int32());
                        break;
                    }
                case 15: {
                        m.dnsSource = $root.proto.ClientPayload.DNSSource.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.connectAttemptCount = r.uint32();
                        break;
                    }
                case 18: {
                        m.device = r.uint32();
                        break;
                    }
                case 19: {
                        m.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.product = r.int32();
                        break;
                    }
                case 21: {
                        m.fbCat = r.bytes();
                        break;
                    }
                case 22: {
                        m.fbUserAgent = r.bytes();
                        break;
                    }
                case 23: {
                        m.oc = r.bool();
                        break;
                    }
                case 24: {
                        m.lc = r.int32();
                        break;
                    }
                case 30: {
                        m.iosAppExtension = r.int32();
                        break;
                    }
                case 31: {
                        m.fbAppId = r.uint64();
                        break;
                    }
                case 32: {
                        m.fbDeviceId = r.bytes();
                        break;
                    }
                case 33: {
                        m.pull = r.bool();
                        break;
                    }
                case 34: {
                        m.paddingBytes = r.bytes();
                        break;
                    }
                case 36: {
                        m.yearClass = r.int32();
                        break;
                    }
                case 37: {
                        m.memClass = r.int32();
                        break;
                    }
                case 38: {
                        m.interopData = $root.proto.ClientPayload.InteropData.decode(r, r.uint32());
                        break;
                    }
                case 40: {
                        m.trafficAnonymization = r.int32();
                        break;
                    }
                case 41: {
                        m.lidDbMigrated = r.bool();
                        break;
                    }
                case 42: {
                        m.accountType = r.int32();
                        break;
                    }
                case 43: {
                        m.connectionSequenceInfo = r.sfixed32();
                        break;
                    }
                case 44: {
                        m.paaLink = r.bool();
                        break;
                    }
                case 45: {
                        m.preacksCount = r.int32();
                        break;
                    }
                case 46: {
                        m.processingQueueSize = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ClientPayload.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ClientPayload)
                return d;
            var m = new $root.proto.ClientPayload();
            if (d.username != null) {
                if ($util.Long)
                    (m.username = $util.Long.fromValue(d.username)).unsigned = true;
                else if (typeof d.username === "string")
                    m.username = parseInt(d.username, 10);
                else if (typeof d.username === "number")
                    m.username = d.username;
                else if (typeof d.username === "object")
                    m.username = new $util.LongBits(d.username.low >>> 0, d.username.high >>> 0).toNumber(true);
            }
            if (d.passive != null) {
                m.passive = Boolean(d.passive);
            }
            if (d.userAgent != null) {
                if (typeof d.userAgent !== "object")
                    throw TypeError(".proto.ClientPayload.userAgent: object expected");
                m.userAgent = $root.proto.ClientPayload.UserAgent.fromObject(d.userAgent);
            }
            if (d.webInfo != null) {
                if (typeof d.webInfo !== "object")
                    throw TypeError(".proto.ClientPayload.webInfo: object expected");
                m.webInfo = $root.proto.ClientPayload.WebInfo.fromObject(d.webInfo);
            }
            if (d.pushName != null) {
                m.pushName = String(d.pushName);
            }
            if (d.sessionId != null) {
                m.sessionId = d.sessionId | 0;
            }
            if (d.shortConnect != null) {
                m.shortConnect = Boolean(d.shortConnect);
            }
            switch (d.connectType) {
            default:
                if (typeof d.connectType === "number") {
                    m.connectType = d.connectType;
                    break;
                }
                break;
            case "CELLULAR_UNKNOWN":
            case 0:
                m.connectType = 0;
                break;
            case "WIFI_UNKNOWN":
            case 1:
                m.connectType = 1;
                break;
            case "CELLULAR_EDGE":
            case 100:
                m.connectType = 100;
                break;
            case "CELLULAR_IDEN":
            case 101:
                m.connectType = 101;
                break;
            case "CELLULAR_UMTS":
            case 102:
                m.connectType = 102;
                break;
            case "CELLULAR_EVDO":
            case 103:
                m.connectType = 103;
                break;
            case "CELLULAR_GPRS":
            case 104:
                m.connectType = 104;
                break;
            case "CELLULAR_HSDPA":
            case 105:
                m.connectType = 105;
                break;
            case "CELLULAR_HSUPA":
            case 106:
                m.connectType = 106;
                break;
            case "CELLULAR_HSPA":
            case 107:
                m.connectType = 107;
                break;
            case "CELLULAR_CDMA":
            case 108:
                m.connectType = 108;
                break;
            case "CELLULAR_1XRTT":
            case 109:
                m.connectType = 109;
                break;
            case "CELLULAR_EHRPD":
            case 110:
                m.connectType = 110;
                break;
            case "CELLULAR_LTE":
            case 111:
                m.connectType = 111;
                break;
            case "CELLULAR_HSPAP":
            case 112:
                m.connectType = 112;
                break;
            }
            switch (d.connectReason) {
            default:
                if (typeof d.connectReason === "number") {
                    m.connectReason = d.connectReason;
                    break;
                }
                break;
            case "PUSH":
            case 0:
                m.connectReason = 0;
                break;
            case "USER_ACTIVATED":
            case 1:
                m.connectReason = 1;
                break;
            case "SCHEDULED":
            case 2:
                m.connectReason = 2;
                break;
            case "ERROR_RECONNECT":
            case 3:
                m.connectReason = 3;
                break;
            case "NETWORK_SWITCH":
            case 4:
                m.connectReason = 4;
                break;
            case "PING_RECONNECT":
            case 5:
                m.connectReason = 5;
                break;
            case "UNKNOWN":
            case 6:
                m.connectReason = 6;
                break;
            }
            if (d.shards) {
                if (!Array.isArray(d.shards))
                    throw TypeError(".proto.ClientPayload.shards: array expected");
                m.shards = [];
                for (var i = 0; i < d.shards.length; ++i) {
                    m.shards[i] = d.shards[i] | 0;
                }
            }
            if (d.dnsSource != null) {
                if (typeof d.dnsSource !== "object")
                    throw TypeError(".proto.ClientPayload.dnsSource: object expected");
                m.dnsSource = $root.proto.ClientPayload.DNSSource.fromObject(d.dnsSource);
            }
            if (d.connectAttemptCount != null) {
                m.connectAttemptCount = d.connectAttemptCount >>> 0;
            }
            if (d.device != null) {
                m.device = d.device >>> 0;
            }
            if (d.devicePairingData != null) {
                if (typeof d.devicePairingData !== "object")
                    throw TypeError(".proto.ClientPayload.devicePairingData: object expected");
                m.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.fromObject(d.devicePairingData);
            }
            switch (d.product) {
            default:
                if (typeof d.product === "number") {
                    m.product = d.product;
                    break;
                }
                break;
            case "WHATSAPP":
            case 0:
                m.product = 0;
                break;
            case "MESSENGER":
            case 1:
                m.product = 1;
                break;
            case "INTEROP":
            case 2:
                m.product = 2;
                break;
            case "INTEROP_MSGR":
            case 3:
                m.product = 3;
                break;
            case "WHATSAPP_LID":
            case 4:
                m.product = 4;
                break;
            }
            if (d.fbCat != null) {
                if (typeof d.fbCat === "string")
                    $util.base64.decode(d.fbCat, m.fbCat = $util.newBuffer($util.base64.length(d.fbCat)), 0);
                else if (d.fbCat.length >= 0)
                    m.fbCat = d.fbCat;
            }
            if (d.fbUserAgent != null) {
                if (typeof d.fbUserAgent === "string")
                    $util.base64.decode(d.fbUserAgent, m.fbUserAgent = $util.newBuffer($util.base64.length(d.fbUserAgent)), 0);
                else if (d.fbUserAgent.length >= 0)
                    m.fbUserAgent = d.fbUserAgent;
            }
            if (d.oc != null) {
                m.oc = Boolean(d.oc);
            }
            if (d.lc != null) {
                m.lc = d.lc | 0;
            }
            switch (d.iosAppExtension) {
            default:
                if (typeof d.iosAppExtension === "number") {
                    m.iosAppExtension = d.iosAppExtension;
                    break;
                }
                break;
            case "SHARE_EXTENSION":
            case 0:
                m.iosAppExtension = 0;
                break;
            case "SERVICE_EXTENSION":
            case 1:
                m.iosAppExtension = 1;
                break;
            case "INTENTS_EXTENSION":
            case 2:
                m.iosAppExtension = 2;
                break;
            }
            if (d.fbAppId != null) {
                if ($util.Long)
                    (m.fbAppId = $util.Long.fromValue(d.fbAppId)).unsigned = true;
                else if (typeof d.fbAppId === "string")
                    m.fbAppId = parseInt(d.fbAppId, 10);
                else if (typeof d.fbAppId === "number")
                    m.fbAppId = d.fbAppId;
                else if (typeof d.fbAppId === "object")
                    m.fbAppId = new $util.LongBits(d.fbAppId.low >>> 0, d.fbAppId.high >>> 0).toNumber(true);
            }
            if (d.fbDeviceId != null) {
                if (typeof d.fbDeviceId === "string")
                    $util.base64.decode(d.fbDeviceId, m.fbDeviceId = $util.newBuffer($util.base64.length(d.fbDeviceId)), 0);
                else if (d.fbDeviceId.length >= 0)
                    m.fbDeviceId = d.fbDeviceId;
            }
            if (d.pull != null) {
                m.pull = Boolean(d.pull);
            }
            if (d.paddingBytes != null) {
                if (typeof d.paddingBytes === "string")
                    $util.base64.decode(d.paddingBytes, m.paddingBytes = $util.newBuffer($util.base64.length(d.paddingBytes)), 0);
                else if (d.paddingBytes.length >= 0)
                    m.paddingBytes = d.paddingBytes;
            }
            if (d.yearClass != null) {
                m.yearClass = d.yearClass | 0;
            }
            if (d.memClass != null) {
                m.memClass = d.memClass | 0;
            }
            if (d.interopData != null) {
                if (typeof d.interopData !== "object")
                    throw TypeError(".proto.ClientPayload.interopData: object expected");
                m.interopData = $root.proto.ClientPayload.InteropData.fromObject(d.interopData);
            }
            switch (d.trafficAnonymization) {
            default:
                if (typeof d.trafficAnonymization === "number") {
                    m.trafficAnonymization = d.trafficAnonymization;
                    break;
                }
                break;
            case "OFF":
            case 0:
                m.trafficAnonymization = 0;
                break;
            case "STANDARD":
            case 1:
                m.trafficAnonymization = 1;
                break;
            }
            if (d.lidDbMigrated != null) {
                m.lidDbMigrated = Boolean(d.lidDbMigrated);
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "DEFAULT":
            case 0:
                m.accountType = 0;
                break;
            case "GUEST":
            case 1:
                m.accountType = 1;
                break;
            }
            if (d.connectionSequenceInfo != null) {
                m.connectionSequenceInfo = d.connectionSequenceInfo | 0;
            }
            if (d.paaLink != null) {
                m.paaLink = Boolean(d.paaLink);
            }
            if (d.preacksCount != null) {
                m.preacksCount = d.preacksCount | 0;
            }
            if (d.processingQueueSize != null) {
                m.processingQueueSize = d.processingQueueSize | 0;
            }
            return m;
        };

        ClientPayload.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.shards = [];
            }
            if (m.username != null && m.hasOwnProperty("username")) {
                if (typeof m.username === "number")
                    d.username = o.longs === String ? String(m.username) : m.username;
                else
                    d.username = o.longs === String ? $util.Long.prototype.toString.call(m.username) : o.longs === Number ? new $util.LongBits(m.username.low >>> 0, m.username.high >>> 0).toNumber(true) : m.username;
                if (o.oneofs)
                    d._username = "username";
            }
            if (m.passive != null && m.hasOwnProperty("passive")) {
                d.passive = m.passive;
                if (o.oneofs)
                    d._passive = "passive";
            }
            if (m.userAgent != null && m.hasOwnProperty("userAgent")) {
                d.userAgent = $root.proto.ClientPayload.UserAgent.toObject(m.userAgent, o);
                if (o.oneofs)
                    d._userAgent = "userAgent";
            }
            if (m.webInfo != null && m.hasOwnProperty("webInfo")) {
                d.webInfo = $root.proto.ClientPayload.WebInfo.toObject(m.webInfo, o);
                if (o.oneofs)
                    d._webInfo = "webInfo";
            }
            if (m.pushName != null && m.hasOwnProperty("pushName")) {
                d.pushName = m.pushName;
                if (o.oneofs)
                    d._pushName = "pushName";
            }
            if (m.sessionId != null && m.hasOwnProperty("sessionId")) {
                d.sessionId = m.sessionId;
                if (o.oneofs)
                    d._sessionId = "sessionId";
            }
            if (m.shortConnect != null && m.hasOwnProperty("shortConnect")) {
                d.shortConnect = m.shortConnect;
                if (o.oneofs)
                    d._shortConnect = "shortConnect";
            }
            if (m.connectType != null && m.hasOwnProperty("connectType")) {
                d.connectType = o.enums === String ? $root.proto.ClientPayload.ConnectType[m.connectType] === undefined ? m.connectType : $root.proto.ClientPayload.ConnectType[m.connectType] : m.connectType;
                if (o.oneofs)
                    d._connectType = "connectType";
            }
            if (m.connectReason != null && m.hasOwnProperty("connectReason")) {
                d.connectReason = o.enums === String ? $root.proto.ClientPayload.ConnectReason[m.connectReason] === undefined ? m.connectReason : $root.proto.ClientPayload.ConnectReason[m.connectReason] : m.connectReason;
                if (o.oneofs)
                    d._connectReason = "connectReason";
            }
            if (m.shards && m.shards.length) {
                d.shards = [];
                for (var j = 0; j < m.shards.length; ++j) {
                    d.shards[j] = m.shards[j];
                }
            }
            if (m.dnsSource != null && m.hasOwnProperty("dnsSource")) {
                d.dnsSource = $root.proto.ClientPayload.DNSSource.toObject(m.dnsSource, o);
                if (o.oneofs)
                    d._dnsSource = "dnsSource";
            }
            if (m.connectAttemptCount != null && m.hasOwnProperty("connectAttemptCount")) {
                d.connectAttemptCount = m.connectAttemptCount;
                if (o.oneofs)
                    d._connectAttemptCount = "connectAttemptCount";
            }
            if (m.device != null && m.hasOwnProperty("device")) {
                d.device = m.device;
                if (o.oneofs)
                    d._device = "device";
            }
            if (m.devicePairingData != null && m.hasOwnProperty("devicePairingData")) {
                d.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.toObject(m.devicePairingData, o);
                if (o.oneofs)
                    d._devicePairingData = "devicePairingData";
            }
            if (m.product != null && m.hasOwnProperty("product")) {
                d.product = o.enums === String ? $root.proto.ClientPayload.Product[m.product] === undefined ? m.product : $root.proto.ClientPayload.Product[m.product] : m.product;
                if (o.oneofs)
                    d._product = "product";
            }
            if (m.fbCat != null && m.hasOwnProperty("fbCat")) {
                d.fbCat = o.bytes === String ? $util.base64.encode(m.fbCat, 0, m.fbCat.length) : o.bytes === Array ? Array.prototype.slice.call(m.fbCat) : m.fbCat;
                if (o.oneofs)
                    d._fbCat = "fbCat";
            }
            if (m.fbUserAgent != null && m.hasOwnProperty("fbUserAgent")) {
                d.fbUserAgent = o.bytes === String ? $util.base64.encode(m.fbUserAgent, 0, m.fbUserAgent.length) : o.bytes === Array ? Array.prototype.slice.call(m.fbUserAgent) : m.fbUserAgent;
                if (o.oneofs)
                    d._fbUserAgent = "fbUserAgent";
            }
            if (m.oc != null && m.hasOwnProperty("oc")) {
                d.oc = m.oc;
                if (o.oneofs)
                    d._oc = "oc";
            }
            if (m.lc != null && m.hasOwnProperty("lc")) {
                d.lc = m.lc;
                if (o.oneofs)
                    d._lc = "lc";
            }
            if (m.iosAppExtension != null && m.hasOwnProperty("iosAppExtension")) {
                d.iosAppExtension = o.enums === String ? $root.proto.ClientPayload.IOSAppExtension[m.iosAppExtension] === undefined ? m.iosAppExtension : $root.proto.ClientPayload.IOSAppExtension[m.iosAppExtension] : m.iosAppExtension;
                if (o.oneofs)
                    d._iosAppExtension = "iosAppExtension";
            }
            if (m.fbAppId != null && m.hasOwnProperty("fbAppId")) {
                if (typeof m.fbAppId === "number")
                    d.fbAppId = o.longs === String ? String(m.fbAppId) : m.fbAppId;
                else
                    d.fbAppId = o.longs === String ? $util.Long.prototype.toString.call(m.fbAppId) : o.longs === Number ? new $util.LongBits(m.fbAppId.low >>> 0, m.fbAppId.high >>> 0).toNumber(true) : m.fbAppId;
                if (o.oneofs)
                    d._fbAppId = "fbAppId";
            }
            if (m.fbDeviceId != null && m.hasOwnProperty("fbDeviceId")) {
                d.fbDeviceId = o.bytes === String ? $util.base64.encode(m.fbDeviceId, 0, m.fbDeviceId.length) : o.bytes === Array ? Array.prototype.slice.call(m.fbDeviceId) : m.fbDeviceId;
                if (o.oneofs)
                    d._fbDeviceId = "fbDeviceId";
            }
            if (m.pull != null && m.hasOwnProperty("pull")) {
                d.pull = m.pull;
                if (o.oneofs)
                    d._pull = "pull";
            }
            if (m.paddingBytes != null && m.hasOwnProperty("paddingBytes")) {
                d.paddingBytes = o.bytes === String ? $util.base64.encode(m.paddingBytes, 0, m.paddingBytes.length) : o.bytes === Array ? Array.prototype.slice.call(m.paddingBytes) : m.paddingBytes;
                if (o.oneofs)
                    d._paddingBytes = "paddingBytes";
            }
            if (m.yearClass != null && m.hasOwnProperty("yearClass")) {
                d.yearClass = m.yearClass;
                if (o.oneofs)
                    d._yearClass = "yearClass";
            }
            if (m.memClass != null && m.hasOwnProperty("memClass")) {
                d.memClass = m.memClass;
                if (o.oneofs)
                    d._memClass = "memClass";
            }
            if (m.interopData != null && m.hasOwnProperty("interopData")) {
                d.interopData = $root.proto.ClientPayload.InteropData.toObject(m.interopData, o);
                if (o.oneofs)
                    d._interopData = "interopData";
            }
            if (m.trafficAnonymization != null && m.hasOwnProperty("trafficAnonymization")) {
                d.trafficAnonymization = o.enums === String ? $root.proto.ClientPayload.TrafficAnonymization[m.trafficAnonymization] === undefined ? m.trafficAnonymization : $root.proto.ClientPayload.TrafficAnonymization[m.trafficAnonymization] : m.trafficAnonymization;
                if (o.oneofs)
                    d._trafficAnonymization = "trafficAnonymization";
            }
            if (m.lidDbMigrated != null && m.hasOwnProperty("lidDbMigrated")) {
                d.lidDbMigrated = m.lidDbMigrated;
                if (o.oneofs)
                    d._lidDbMigrated = "lidDbMigrated";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ClientPayload.AccountType[m.accountType] === undefined ? m.accountType : $root.proto.ClientPayload.AccountType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            if (m.connectionSequenceInfo != null && m.hasOwnProperty("connectionSequenceInfo")) {
                d.connectionSequenceInfo = m.connectionSequenceInfo;
                if (o.oneofs)
                    d._connectionSequenceInfo = "connectionSequenceInfo";
            }
            if (m.paaLink != null && m.hasOwnProperty("paaLink")) {
                d.paaLink = m.paaLink;
                if (o.oneofs)
                    d._paaLink = "paaLink";
            }
            if (m.preacksCount != null && m.hasOwnProperty("preacksCount")) {
                d.preacksCount = m.preacksCount;
                if (o.oneofs)
                    d._preacksCount = "preacksCount";
            }
            if (m.processingQueueSize != null && m.hasOwnProperty("processingQueueSize")) {
                d.processingQueueSize = m.processingQueueSize;
                if (o.oneofs)
                    d._processingQueueSize = "processingQueueSize";
            }
            return d;
        };

        ClientPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ClientPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ClientPayload";
        };

        ClientPayload.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "GUEST"] = 1;
            return values;
        })();

        ClientPayload.ConnectReason = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "PUSH"] = 0;
            values[valuesById[1] = "USER_ACTIVATED"] = 1;
            values[valuesById[2] = "SCHEDULED"] = 2;
            values[valuesById[3] = "ERROR_RECONNECT"] = 3;
            values[valuesById[4] = "NETWORK_SWITCH"] = 4;
            values[valuesById[5] = "PING_RECONNECT"] = 5;
            values[valuesById[6] = "UNKNOWN"] = 6;
            return values;
        })();

        ClientPayload.ConnectType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CELLULAR_UNKNOWN"] = 0;
            values[valuesById[1] = "WIFI_UNKNOWN"] = 1;
            values[valuesById[100] = "CELLULAR_EDGE"] = 100;
            values[valuesById[101] = "CELLULAR_IDEN"] = 101;
            values[valuesById[102] = "CELLULAR_UMTS"] = 102;
            values[valuesById[103] = "CELLULAR_EVDO"] = 103;
            values[valuesById[104] = "CELLULAR_GPRS"] = 104;
            values[valuesById[105] = "CELLULAR_HSDPA"] = 105;
            values[valuesById[106] = "CELLULAR_HSUPA"] = 106;
            values[valuesById[107] = "CELLULAR_HSPA"] = 107;
            values[valuesById[108] = "CELLULAR_CDMA"] = 108;
            values[valuesById[109] = "CELLULAR_1XRTT"] = 109;
            values[valuesById[110] = "CELLULAR_EHRPD"] = 110;
            values[valuesById[111] = "CELLULAR_LTE"] = 111;
            values[valuesById[112] = "CELLULAR_HSPAP"] = 112;
            return values;
        })();

        ClientPayload.DNSSource = (function() {

            function DNSSource(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DNSSource.prototype.dnsMethod = null;
            DNSSource.prototype.appCached = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DNSSource.prototype, "_dnsMethod", {
                get: $util.oneOfGetter($oneOfFields = ["dnsMethod"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DNSSource.prototype, "_appCached", {
                get: $util.oneOfGetter($oneOfFields = ["appCached"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DNSSource.create = function create(properties) {
                return new DNSSource(properties);
            };

            DNSSource.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.dnsMethod != null && Object.hasOwnProperty.call(m, "dnsMethod"))
                    w.uint32(120).int32(m.dnsMethod);
                if (m.appCached != null && Object.hasOwnProperty.call(m, "appCached"))
                    w.uint32(128).bool(m.appCached);
                return w;
            };

            DNSSource.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.DNSSource();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 15: {
                            m.dnsMethod = r.int32();
                            break;
                        }
                    case 16: {
                            m.appCached = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DNSSource.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.DNSSource)
                    return d;
                var m = new $root.proto.ClientPayload.DNSSource();
                switch (d.dnsMethod) {
                default:
                    if (typeof d.dnsMethod === "number") {
                        m.dnsMethod = d.dnsMethod;
                        break;
                    }
                    break;
                case "SYSTEM":
                case 0:
                    m.dnsMethod = 0;
                    break;
                case "GOOGLE":
                case 1:
                    m.dnsMethod = 1;
                    break;
                case "HARDCODED":
                case 2:
                    m.dnsMethod = 2;
                    break;
                case "OVERRIDE":
                case 3:
                    m.dnsMethod = 3;
                    break;
                case "FALLBACK":
                case 4:
                    m.dnsMethod = 4;
                    break;
                case "MNS":
                case 5:
                    m.dnsMethod = 5;
                    break;
                }
                if (d.appCached != null) {
                    m.appCached = Boolean(d.appCached);
                }
                return m;
            };

            DNSSource.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.dnsMethod != null && m.hasOwnProperty("dnsMethod")) {
                    d.dnsMethod = o.enums === String ? $root.proto.ClientPayload.DNSSource.DNSResolutionMethod[m.dnsMethod] === undefined ? m.dnsMethod : $root.proto.ClientPayload.DNSSource.DNSResolutionMethod[m.dnsMethod] : m.dnsMethod;
                    if (o.oneofs)
                        d._dnsMethod = "dnsMethod";
                }
                if (m.appCached != null && m.hasOwnProperty("appCached")) {
                    d.appCached = m.appCached;
                    if (o.oneofs)
                        d._appCached = "appCached";
                }
                return d;
            };

            DNSSource.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DNSSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.DNSSource";
            };

            DNSSource.DNSResolutionMethod = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "SYSTEM"] = 0;
                values[valuesById[1] = "GOOGLE"] = 1;
                values[valuesById[2] = "HARDCODED"] = 2;
                values[valuesById[3] = "OVERRIDE"] = 3;
                values[valuesById[4] = "FALLBACK"] = 4;
                values[valuesById[5] = "MNS"] = 5;
                return values;
            })();

            return DNSSource;
        })();

        ClientPayload.DevicePairingRegistrationData = (function() {

            function DevicePairingRegistrationData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DevicePairingRegistrationData.prototype.eRegid = null;
            DevicePairingRegistrationData.prototype.eKeytype = null;
            DevicePairingRegistrationData.prototype.eIdent = null;
            DevicePairingRegistrationData.prototype.eSkeyId = null;
            DevicePairingRegistrationData.prototype.eSkeyVal = null;
            DevicePairingRegistrationData.prototype.eSkeySig = null;
            DevicePairingRegistrationData.prototype.buildHash = null;
            DevicePairingRegistrationData.prototype.deviceProps = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eRegid", {
                get: $util.oneOfGetter($oneOfFields = ["eRegid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eKeytype", {
                get: $util.oneOfGetter($oneOfFields = ["eKeytype"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eIdent", {
                get: $util.oneOfGetter($oneOfFields = ["eIdent"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eSkeyId", {
                get: $util.oneOfGetter($oneOfFields = ["eSkeyId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eSkeyVal", {
                get: $util.oneOfGetter($oneOfFields = ["eSkeyVal"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eSkeySig", {
                get: $util.oneOfGetter($oneOfFields = ["eSkeySig"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_buildHash", {
                get: $util.oneOfGetter($oneOfFields = ["buildHash"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_deviceProps", {
                get: $util.oneOfGetter($oneOfFields = ["deviceProps"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DevicePairingRegistrationData.create = function create(properties) {
                return new DevicePairingRegistrationData(properties);
            };

            DevicePairingRegistrationData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.eRegid != null && Object.hasOwnProperty.call(m, "eRegid"))
                    w.uint32(10).bytes(m.eRegid);
                if (m.eKeytype != null && Object.hasOwnProperty.call(m, "eKeytype"))
                    w.uint32(18).bytes(m.eKeytype);
                if (m.eIdent != null && Object.hasOwnProperty.call(m, "eIdent"))
                    w.uint32(26).bytes(m.eIdent);
                if (m.eSkeyId != null && Object.hasOwnProperty.call(m, "eSkeyId"))
                    w.uint32(34).bytes(m.eSkeyId);
                if (m.eSkeyVal != null && Object.hasOwnProperty.call(m, "eSkeyVal"))
                    w.uint32(42).bytes(m.eSkeyVal);
                if (m.eSkeySig != null && Object.hasOwnProperty.call(m, "eSkeySig"))
                    w.uint32(50).bytes(m.eSkeySig);
                if (m.buildHash != null && Object.hasOwnProperty.call(m, "buildHash"))
                    w.uint32(58).bytes(m.buildHash);
                if (m.deviceProps != null && Object.hasOwnProperty.call(m, "deviceProps"))
                    w.uint32(66).bytes(m.deviceProps);
                return w;
            };

            DevicePairingRegistrationData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.eRegid = r.bytes();
                            break;
                        }
                    case 2: {
                            m.eKeytype = r.bytes();
                            break;
                        }
                    case 3: {
                            m.eIdent = r.bytes();
                            break;
                        }
                    case 4: {
                            m.eSkeyId = r.bytes();
                            break;
                        }
                    case 5: {
                            m.eSkeyVal = r.bytes();
                            break;
                        }
                    case 6: {
                            m.eSkeySig = r.bytes();
                            break;
                        }
                    case 7: {
                            m.buildHash = r.bytes();
                            break;
                        }
                    case 8: {
                            m.deviceProps = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DevicePairingRegistrationData.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.DevicePairingRegistrationData)
                    return d;
                var m = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                if (d.eRegid != null) {
                    if (typeof d.eRegid === "string")
                        $util.base64.decode(d.eRegid, m.eRegid = $util.newBuffer($util.base64.length(d.eRegid)), 0);
                    else if (d.eRegid.length >= 0)
                        m.eRegid = d.eRegid;
                }
                if (d.eKeytype != null) {
                    if (typeof d.eKeytype === "string")
                        $util.base64.decode(d.eKeytype, m.eKeytype = $util.newBuffer($util.base64.length(d.eKeytype)), 0);
                    else if (d.eKeytype.length >= 0)
                        m.eKeytype = d.eKeytype;
                }
                if (d.eIdent != null) {
                    if (typeof d.eIdent === "string")
                        $util.base64.decode(d.eIdent, m.eIdent = $util.newBuffer($util.base64.length(d.eIdent)), 0);
                    else if (d.eIdent.length >= 0)
                        m.eIdent = d.eIdent;
                }
                if (d.eSkeyId != null) {
                    if (typeof d.eSkeyId === "string")
                        $util.base64.decode(d.eSkeyId, m.eSkeyId = $util.newBuffer($util.base64.length(d.eSkeyId)), 0);
                    else if (d.eSkeyId.length >= 0)
                        m.eSkeyId = d.eSkeyId;
                }
                if (d.eSkeyVal != null) {
                    if (typeof d.eSkeyVal === "string")
                        $util.base64.decode(d.eSkeyVal, m.eSkeyVal = $util.newBuffer($util.base64.length(d.eSkeyVal)), 0);
                    else if (d.eSkeyVal.length >= 0)
                        m.eSkeyVal = d.eSkeyVal;
                }
                if (d.eSkeySig != null) {
                    if (typeof d.eSkeySig === "string")
                        $util.base64.decode(d.eSkeySig, m.eSkeySig = $util.newBuffer($util.base64.length(d.eSkeySig)), 0);
                    else if (d.eSkeySig.length >= 0)
                        m.eSkeySig = d.eSkeySig;
                }
                if (d.buildHash != null) {
                    if (typeof d.buildHash === "string")
                        $util.base64.decode(d.buildHash, m.buildHash = $util.newBuffer($util.base64.length(d.buildHash)), 0);
                    else if (d.buildHash.length >= 0)
                        m.buildHash = d.buildHash;
                }
                if (d.deviceProps != null) {
                    if (typeof d.deviceProps === "string")
                        $util.base64.decode(d.deviceProps, m.deviceProps = $util.newBuffer($util.base64.length(d.deviceProps)), 0);
                    else if (d.deviceProps.length >= 0)
                        m.deviceProps = d.deviceProps;
                }
                return m;
            };

            DevicePairingRegistrationData.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.eRegid != null && m.hasOwnProperty("eRegid")) {
                    d.eRegid = o.bytes === String ? $util.base64.encode(m.eRegid, 0, m.eRegid.length) : o.bytes === Array ? Array.prototype.slice.call(m.eRegid) : m.eRegid;
                    if (o.oneofs)
                        d._eRegid = "eRegid";
                }
                if (m.eKeytype != null && m.hasOwnProperty("eKeytype")) {
                    d.eKeytype = o.bytes === String ? $util.base64.encode(m.eKeytype, 0, m.eKeytype.length) : o.bytes === Array ? Array.prototype.slice.call(m.eKeytype) : m.eKeytype;
                    if (o.oneofs)
                        d._eKeytype = "eKeytype";
                }
                if (m.eIdent != null && m.hasOwnProperty("eIdent")) {
                    d.eIdent = o.bytes === String ? $util.base64.encode(m.eIdent, 0, m.eIdent.length) : o.bytes === Array ? Array.prototype.slice.call(m.eIdent) : m.eIdent;
                    if (o.oneofs)
                        d._eIdent = "eIdent";
                }
                if (m.eSkeyId != null && m.hasOwnProperty("eSkeyId")) {
                    d.eSkeyId = o.bytes === String ? $util.base64.encode(m.eSkeyId, 0, m.eSkeyId.length) : o.bytes === Array ? Array.prototype.slice.call(m.eSkeyId) : m.eSkeyId;
                    if (o.oneofs)
                        d._eSkeyId = "eSkeyId";
                }
                if (m.eSkeyVal != null && m.hasOwnProperty("eSkeyVal")) {
                    d.eSkeyVal = o.bytes === String ? $util.base64.encode(m.eSkeyVal, 0, m.eSkeyVal.length) : o.bytes === Array ? Array.prototype.slice.call(m.eSkeyVal) : m.eSkeyVal;
                    if (o.oneofs)
                        d._eSkeyVal = "eSkeyVal";
                }
                if (m.eSkeySig != null && m.hasOwnProperty("eSkeySig")) {
                    d.eSkeySig = o.bytes === String ? $util.base64.encode(m.eSkeySig, 0, m.eSkeySig.length) : o.bytes === Array ? Array.prototype.slice.call(m.eSkeySig) : m.eSkeySig;
                    if (o.oneofs)
                        d._eSkeySig = "eSkeySig";
                }
                if (m.buildHash != null && m.hasOwnProperty("buildHash")) {
                    d.buildHash = o.bytes === String ? $util.base64.encode(m.buildHash, 0, m.buildHash.length) : o.bytes === Array ? Array.prototype.slice.call(m.buildHash) : m.buildHash;
                    if (o.oneofs)
                        d._buildHash = "buildHash";
                }
                if (m.deviceProps != null && m.hasOwnProperty("deviceProps")) {
                    d.deviceProps = o.bytes === String ? $util.base64.encode(m.deviceProps, 0, m.deviceProps.length) : o.bytes === Array ? Array.prototype.slice.call(m.deviceProps) : m.deviceProps;
                    if (o.oneofs)
                        d._deviceProps = "deviceProps";
                }
                return d;
            };

            DevicePairingRegistrationData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DevicePairingRegistrationData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.DevicePairingRegistrationData";
            };

            return DevicePairingRegistrationData;
        })();

        ClientPayload.IOSAppExtension = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SHARE_EXTENSION"] = 0;
            values[valuesById[1] = "SERVICE_EXTENSION"] = 1;
            values[valuesById[2] = "INTENTS_EXTENSION"] = 2;
            return values;
        })();

        ClientPayload.InteropData = (function() {

            function InteropData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InteropData.prototype.accountId = null;
            InteropData.prototype.token = null;
            InteropData.prototype.enableReadReceipts = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(InteropData.prototype, "_accountId", {
                get: $util.oneOfGetter($oneOfFields = ["accountId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(InteropData.prototype, "_token", {
                get: $util.oneOfGetter($oneOfFields = ["token"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(InteropData.prototype, "_enableReadReceipts", {
                get: $util.oneOfGetter($oneOfFields = ["enableReadReceipts"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            InteropData.create = function create(properties) {
                return new InteropData(properties);
            };

            InteropData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.accountId != null && Object.hasOwnProperty.call(m, "accountId"))
                    w.uint32(8).uint64(m.accountId);
                if (m.token != null && Object.hasOwnProperty.call(m, "token"))
                    w.uint32(18).bytes(m.token);
                if (m.enableReadReceipts != null && Object.hasOwnProperty.call(m, "enableReadReceipts"))
                    w.uint32(24).bool(m.enableReadReceipts);
                return w;
            };

            InteropData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.InteropData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.accountId = r.uint64();
                            break;
                        }
                    case 2: {
                            m.token = r.bytes();
                            break;
                        }
                    case 3: {
                            m.enableReadReceipts = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InteropData.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.InteropData)
                    return d;
                var m = new $root.proto.ClientPayload.InteropData();
                if (d.accountId != null) {
                    if ($util.Long)
                        (m.accountId = $util.Long.fromValue(d.accountId)).unsigned = true;
                    else if (typeof d.accountId === "string")
                        m.accountId = parseInt(d.accountId, 10);
                    else if (typeof d.accountId === "number")
                        m.accountId = d.accountId;
                    else if (typeof d.accountId === "object")
                        m.accountId = new $util.LongBits(d.accountId.low >>> 0, d.accountId.high >>> 0).toNumber(true);
                }
                if (d.token != null) {
                    if (typeof d.token === "string")
                        $util.base64.decode(d.token, m.token = $util.newBuffer($util.base64.length(d.token)), 0);
                    else if (d.token.length >= 0)
                        m.token = d.token;
                }
                if (d.enableReadReceipts != null) {
                    m.enableReadReceipts = Boolean(d.enableReadReceipts);
                }
                return m;
            };

            InteropData.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.accountId != null && m.hasOwnProperty("accountId")) {
                    if (typeof m.accountId === "number")
                        d.accountId = o.longs === String ? String(m.accountId) : m.accountId;
                    else
                        d.accountId = o.longs === String ? $util.Long.prototype.toString.call(m.accountId) : o.longs === Number ? new $util.LongBits(m.accountId.low >>> 0, m.accountId.high >>> 0).toNumber(true) : m.accountId;
                    if (o.oneofs)
                        d._accountId = "accountId";
                }
                if (m.token != null && m.hasOwnProperty("token")) {
                    d.token = o.bytes === String ? $util.base64.encode(m.token, 0, m.token.length) : o.bytes === Array ? Array.prototype.slice.call(m.token) : m.token;
                    if (o.oneofs)
                        d._token = "token";
                }
                if (m.enableReadReceipts != null && m.hasOwnProperty("enableReadReceipts")) {
                    d.enableReadReceipts = m.enableReadReceipts;
                    if (o.oneofs)
                        d._enableReadReceipts = "enableReadReceipts";
                }
                return d;
            };

            InteropData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            InteropData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.InteropData";
            };

            return InteropData;
        })();

        ClientPayload.Product = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WHATSAPP"] = 0;
            values[valuesById[1] = "MESSENGER"] = 1;
            values[valuesById[2] = "INTEROP"] = 2;
            values[valuesById[3] = "INTEROP_MSGR"] = 3;
            values[valuesById[4] = "WHATSAPP_LID"] = 4;
            return values;
        })();

        ClientPayload.TrafficAnonymization = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "OFF"] = 0;
            values[valuesById[1] = "STANDARD"] = 1;
            return values;
        })();

        ClientPayload.UserAgent = (function() {

            function UserAgent(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            UserAgent.prototype.platform = null;
            UserAgent.prototype.appVersion = null;
            UserAgent.prototype.mcc = null;
            UserAgent.prototype.mnc = null;
            UserAgent.prototype.osVersion = null;
            UserAgent.prototype.manufacturer = null;
            UserAgent.prototype.device = null;
            UserAgent.prototype.osBuildNumber = null;
            UserAgent.prototype.phoneId = null;
            UserAgent.prototype.releaseChannel = null;
            UserAgent.prototype.localeLanguageIso6391 = null;
            UserAgent.prototype.localeCountryIso31661Alpha2 = null;
            UserAgent.prototype.deviceBoard = null;
            UserAgent.prototype.deviceExpId = null;
            UserAgent.prototype.deviceType = null;
            UserAgent.prototype.deviceModelType = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_platform", {
                get: $util.oneOfGetter($oneOfFields = ["platform"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_appVersion", {
                get: $util.oneOfGetter($oneOfFields = ["appVersion"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_mcc", {
                get: $util.oneOfGetter($oneOfFields = ["mcc"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_mnc", {
                get: $util.oneOfGetter($oneOfFields = ["mnc"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_osVersion", {
                get: $util.oneOfGetter($oneOfFields = ["osVersion"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_manufacturer", {
                get: $util.oneOfGetter($oneOfFields = ["manufacturer"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_device", {
                get: $util.oneOfGetter($oneOfFields = ["device"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_osBuildNumber", {
                get: $util.oneOfGetter($oneOfFields = ["osBuildNumber"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_phoneId", {
                get: $util.oneOfGetter($oneOfFields = ["phoneId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_releaseChannel", {
                get: $util.oneOfGetter($oneOfFields = ["releaseChannel"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_localeLanguageIso6391", {
                get: $util.oneOfGetter($oneOfFields = ["localeLanguageIso6391"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_localeCountryIso31661Alpha2", {
                get: $util.oneOfGetter($oneOfFields = ["localeCountryIso31661Alpha2"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceBoard", {
                get: $util.oneOfGetter($oneOfFields = ["deviceBoard"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceExpId", {
                get: $util.oneOfGetter($oneOfFields = ["deviceExpId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceType", {
                get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceModelType", {
                get: $util.oneOfGetter($oneOfFields = ["deviceModelType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            UserAgent.create = function create(properties) {
                return new UserAgent(properties);
            };

            UserAgent.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.platform != null && Object.hasOwnProperty.call(m, "platform"))
                    w.uint32(8).int32(m.platform);
                if (m.appVersion != null && Object.hasOwnProperty.call(m, "appVersion"))
                    $root.proto.ClientPayload.UserAgent.AppVersion.encode(m.appVersion, w.uint32(18).fork()).ldelim();
                if (m.mcc != null && Object.hasOwnProperty.call(m, "mcc"))
                    w.uint32(26).string(m.mcc);
                if (m.mnc != null && Object.hasOwnProperty.call(m, "mnc"))
                    w.uint32(34).string(m.mnc);
                if (m.osVersion != null && Object.hasOwnProperty.call(m, "osVersion"))
                    w.uint32(42).string(m.osVersion);
                if (m.manufacturer != null && Object.hasOwnProperty.call(m, "manufacturer"))
                    w.uint32(50).string(m.manufacturer);
                if (m.device != null && Object.hasOwnProperty.call(m, "device"))
                    w.uint32(58).string(m.device);
                if (m.osBuildNumber != null && Object.hasOwnProperty.call(m, "osBuildNumber"))
                    w.uint32(66).string(m.osBuildNumber);
                if (m.phoneId != null && Object.hasOwnProperty.call(m, "phoneId"))
                    w.uint32(74).string(m.phoneId);
                if (m.releaseChannel != null && Object.hasOwnProperty.call(m, "releaseChannel"))
                    w.uint32(80).int32(m.releaseChannel);
                if (m.localeLanguageIso6391 != null && Object.hasOwnProperty.call(m, "localeLanguageIso6391"))
                    w.uint32(90).string(m.localeLanguageIso6391);
                if (m.localeCountryIso31661Alpha2 != null && Object.hasOwnProperty.call(m, "localeCountryIso31661Alpha2"))
                    w.uint32(98).string(m.localeCountryIso31661Alpha2);
                if (m.deviceBoard != null && Object.hasOwnProperty.call(m, "deviceBoard"))
                    w.uint32(106).string(m.deviceBoard);
                if (m.deviceExpId != null && Object.hasOwnProperty.call(m, "deviceExpId"))
                    w.uint32(114).string(m.deviceExpId);
                if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                    w.uint32(120).int32(m.deviceType);
                if (m.deviceModelType != null && Object.hasOwnProperty.call(m, "deviceModelType"))
                    w.uint32(130).string(m.deviceModelType);
                return w;
            };

            UserAgent.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.UserAgent();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.platform = r.int32();
                            break;
                        }
                    case 2: {
                            m.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.mcc = r.string();
                            break;
                        }
                    case 4: {
                            m.mnc = r.string();
                            break;
                        }
                    case 5: {
                            m.osVersion = r.string();
                            break;
                        }
                    case 6: {
                            m.manufacturer = r.string();
                            break;
                        }
                    case 7: {
                            m.device = r.string();
                            break;
                        }
                    case 8: {
                            m.osBuildNumber = r.string();
                            break;
                        }
                    case 9: {
                            m.phoneId = r.string();
                            break;
                        }
                    case 10: {
                            m.releaseChannel = r.int32();
                            break;
                        }
                    case 11: {
                            m.localeLanguageIso6391 = r.string();
                            break;
                        }
                    case 12: {
                            m.localeCountryIso31661Alpha2 = r.string();
                            break;
                        }
                    case 13: {
                            m.deviceBoard = r.string();
                            break;
                        }
                    case 14: {
                            m.deviceExpId = r.string();
                            break;
                        }
                    case 15: {
                            m.deviceType = r.int32();
                            break;
                        }
                    case 16: {
                            m.deviceModelType = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            UserAgent.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.UserAgent)
                    return d;
                var m = new $root.proto.ClientPayload.UserAgent();
                switch (d.platform) {
                default:
                    if (typeof d.platform === "number") {
                        m.platform = d.platform;
                        break;
                    }
                    break;
                case "ANDROID":
                case 0:
                    m.platform = 0;
                    break;
                case "IOS":
                case 1:
                    m.platform = 1;
                    break;
                case "WINDOWS_PHONE":
                case 2:
                    m.platform = 2;
                    break;
                case "BLACKBERRY":
                case 3:
                    m.platform = 3;
                    break;
                case "BLACKBERRYX":
                case 4:
                    m.platform = 4;
                    break;
                case "S40":
                case 5:
                    m.platform = 5;
                    break;
                case "S60":
                case 6:
                    m.platform = 6;
                    break;
                case "PYTHON_CLIENT":
                case 7:
                    m.platform = 7;
                    break;
                case "TIZEN":
                case 8:
                    m.platform = 8;
                    break;
                case "ENTERPRISE":
                case 9:
                    m.platform = 9;
                    break;
                case "SMB_ANDROID":
                case 10:
                    m.platform = 10;
                    break;
                case "KAIOS":
                case 11:
                    m.platform = 11;
                    break;
                case "SMB_IOS":
                case 12:
                    m.platform = 12;
                    break;
                case "WINDOWS":
                case 13:
                    m.platform = 13;
                    break;
                case "WEB":
                case 14:
                    m.platform = 14;
                    break;
                case "PORTAL":
                case 15:
                    m.platform = 15;
                    break;
                case "GREEN_ANDROID":
                case 16:
                    m.platform = 16;
                    break;
                case "GREEN_IPHONE":
                case 17:
                    m.platform = 17;
                    break;
                case "BLUE_ANDROID":
                case 18:
                    m.platform = 18;
                    break;
                case "BLUE_IPHONE":
                case 19:
                    m.platform = 19;
                    break;
                case "FBLITE_ANDROID":
                case 20:
                    m.platform = 20;
                    break;
                case "MLITE_ANDROID":
                case 21:
                    m.platform = 21;
                    break;
                case "IGLITE_ANDROID":
                case 22:
                    m.platform = 22;
                    break;
                case "PAGE":
                case 23:
                    m.platform = 23;
                    break;
                case "MACOS":
                case 24:
                    m.platform = 24;
                    break;
                case "OCULUS_MSG":
                case 25:
                    m.platform = 25;
                    break;
                case "OCULUS_CALL":
                case 26:
                    m.platform = 26;
                    break;
                case "MILAN":
                case 27:
                    m.platform = 27;
                    break;
                case "CAPI":
                case 28:
                    m.platform = 28;
                    break;
                case "WEAROS":
                case 29:
                    m.platform = 29;
                    break;
                case "ARDEVICE":
                case 30:
                    m.platform = 30;
                    break;
                case "VRDEVICE":
                case 31:
                    m.platform = 31;
                    break;
                case "BLUE_WEB":
                case 32:
                    m.platform = 32;
                    break;
                case "IPAD":
                case 33:
                    m.platform = 33;
                    break;
                case "TEST":
                case 34:
                    m.platform = 34;
                    break;
                case "SMART_GLASSES":
                case 35:
                    m.platform = 35;
                    break;
                case "BLUE_VR":
                case 36:
                    m.platform = 36;
                    break;
                case "AR_WRIST":
                case 37:
                    m.platform = 37;
                    break;
                }
                if (d.appVersion != null) {
                    if (typeof d.appVersion !== "object")
                        throw TypeError(".proto.ClientPayload.UserAgent.appVersion: object expected");
                    m.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.fromObject(d.appVersion);
                }
                if (d.mcc != null) {
                    m.mcc = String(d.mcc);
                }
                if (d.mnc != null) {
                    m.mnc = String(d.mnc);
                }
                if (d.osVersion != null) {
                    m.osVersion = String(d.osVersion);
                }
                if (d.manufacturer != null) {
                    m.manufacturer = String(d.manufacturer);
                }
                if (d.device != null) {
                    m.device = String(d.device);
                }
                if (d.osBuildNumber != null) {
                    m.osBuildNumber = String(d.osBuildNumber);
                }
                if (d.phoneId != null) {
                    m.phoneId = String(d.phoneId);
                }
                switch (d.releaseChannel) {
                default:
                    if (typeof d.releaseChannel === "number") {
                        m.releaseChannel = d.releaseChannel;
                        break;
                    }
                    break;
                case "RELEASE":
                case 0:
                    m.releaseChannel = 0;
                    break;
                case "BETA":
                case 1:
                    m.releaseChannel = 1;
                    break;
                case "ALPHA":
                case 2:
                    m.releaseChannel = 2;
                    break;
                case "DEBUG":
                case 3:
                    m.releaseChannel = 3;
                    break;
                }
                if (d.localeLanguageIso6391 != null) {
                    m.localeLanguageIso6391 = String(d.localeLanguageIso6391);
                }
                if (d.localeCountryIso31661Alpha2 != null) {
                    m.localeCountryIso31661Alpha2 = String(d.localeCountryIso31661Alpha2);
                }
                if (d.deviceBoard != null) {
                    m.deviceBoard = String(d.deviceBoard);
                }
                if (d.deviceExpId != null) {
                    m.deviceExpId = String(d.deviceExpId);
                }
                switch (d.deviceType) {
                default:
                    if (typeof d.deviceType === "number") {
                        m.deviceType = d.deviceType;
                        break;
                    }
                    break;
                case "PHONE":
                case 0:
                    m.deviceType = 0;
                    break;
                case "TABLET":
                case 1:
                    m.deviceType = 1;
                    break;
                case "DESKTOP":
                case 2:
                    m.deviceType = 2;
                    break;
                case "WEARABLE":
                case 3:
                    m.deviceType = 3;
                    break;
                case "VR":
                case 4:
                    m.deviceType = 4;
                    break;
                }
                if (d.deviceModelType != null) {
                    m.deviceModelType = String(d.deviceModelType);
                }
                return m;
            };

            UserAgent.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.platform != null && m.hasOwnProperty("platform")) {
                    d.platform = o.enums === String ? $root.proto.ClientPayload.UserAgent.Platform[m.platform] === undefined ? m.platform : $root.proto.ClientPayload.UserAgent.Platform[m.platform] : m.platform;
                    if (o.oneofs)
                        d._platform = "platform";
                }
                if (m.appVersion != null && m.hasOwnProperty("appVersion")) {
                    d.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.toObject(m.appVersion, o);
                    if (o.oneofs)
                        d._appVersion = "appVersion";
                }
                if (m.mcc != null && m.hasOwnProperty("mcc")) {
                    d.mcc = m.mcc;
                    if (o.oneofs)
                        d._mcc = "mcc";
                }
                if (m.mnc != null && m.hasOwnProperty("mnc")) {
                    d.mnc = m.mnc;
                    if (o.oneofs)
                        d._mnc = "mnc";
                }
                if (m.osVersion != null && m.hasOwnProperty("osVersion")) {
                    d.osVersion = m.osVersion;
                    if (o.oneofs)
                        d._osVersion = "osVersion";
                }
                if (m.manufacturer != null && m.hasOwnProperty("manufacturer")) {
                    d.manufacturer = m.manufacturer;
                    if (o.oneofs)
                        d._manufacturer = "manufacturer";
                }
                if (m.device != null && m.hasOwnProperty("device")) {
                    d.device = m.device;
                    if (o.oneofs)
                        d._device = "device";
                }
                if (m.osBuildNumber != null && m.hasOwnProperty("osBuildNumber")) {
                    d.osBuildNumber = m.osBuildNumber;
                    if (o.oneofs)
                        d._osBuildNumber = "osBuildNumber";
                }
                if (m.phoneId != null && m.hasOwnProperty("phoneId")) {
                    d.phoneId = m.phoneId;
                    if (o.oneofs)
                        d._phoneId = "phoneId";
                }
                if (m.releaseChannel != null && m.hasOwnProperty("releaseChannel")) {
                    d.releaseChannel = o.enums === String ? $root.proto.ClientPayload.UserAgent.ReleaseChannel[m.releaseChannel] === undefined ? m.releaseChannel : $root.proto.ClientPayload.UserAgent.ReleaseChannel[m.releaseChannel] : m.releaseChannel;
                    if (o.oneofs)
                        d._releaseChannel = "releaseChannel";
                }
                if (m.localeLanguageIso6391 != null && m.hasOwnProperty("localeLanguageIso6391")) {
                    d.localeLanguageIso6391 = m.localeLanguageIso6391;
                    if (o.oneofs)
                        d._localeLanguageIso6391 = "localeLanguageIso6391";
                }
                if (m.localeCountryIso31661Alpha2 != null && m.hasOwnProperty("localeCountryIso31661Alpha2")) {
                    d.localeCountryIso31661Alpha2 = m.localeCountryIso31661Alpha2;
                    if (o.oneofs)
                        d._localeCountryIso31661Alpha2 = "localeCountryIso31661Alpha2";
                }
                if (m.deviceBoard != null && m.hasOwnProperty("deviceBoard")) {
                    d.deviceBoard = m.deviceBoard;
                    if (o.oneofs)
                        d._deviceBoard = "deviceBoard";
                }
                if (m.deviceExpId != null && m.hasOwnProperty("deviceExpId")) {
                    d.deviceExpId = m.deviceExpId;
                    if (o.oneofs)
                        d._deviceExpId = "deviceExpId";
                }
                if (m.deviceType != null && m.hasOwnProperty("deviceType")) {
                    d.deviceType = o.enums === String ? $root.proto.ClientPayload.UserAgent.DeviceType[m.deviceType] === undefined ? m.deviceType : $root.proto.ClientPayload.UserAgent.DeviceType[m.deviceType] : m.deviceType;
                    if (o.oneofs)
                        d._deviceType = "deviceType";
                }
                if (m.deviceModelType != null && m.hasOwnProperty("deviceModelType")) {
                    d.deviceModelType = m.deviceModelType;
                    if (o.oneofs)
                        d._deviceModelType = "deviceModelType";
                }
                return d;
            };

            UserAgent.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            UserAgent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.UserAgent";
            };

            UserAgent.AppVersion = (function() {

                function AppVersion(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AppVersion.prototype.primary = null;
                AppVersion.prototype.secondary = null;
                AppVersion.prototype.tertiary = null;
                AppVersion.prototype.quaternary = null;
                AppVersion.prototype.quinary = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_primary", {
                    get: $util.oneOfGetter($oneOfFields = ["primary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_secondary", {
                    get: $util.oneOfGetter($oneOfFields = ["secondary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_tertiary", {
                    get: $util.oneOfGetter($oneOfFields = ["tertiary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_quaternary", {
                    get: $util.oneOfGetter($oneOfFields = ["quaternary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_quinary", {
                    get: $util.oneOfGetter($oneOfFields = ["quinary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AppVersion.create = function create(properties) {
                    return new AppVersion(properties);
                };

                AppVersion.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.primary != null && Object.hasOwnProperty.call(m, "primary"))
                        w.uint32(8).uint32(m.primary);
                    if (m.secondary != null && Object.hasOwnProperty.call(m, "secondary"))
                        w.uint32(16).uint32(m.secondary);
                    if (m.tertiary != null && Object.hasOwnProperty.call(m, "tertiary"))
                        w.uint32(24).uint32(m.tertiary);
                    if (m.quaternary != null && Object.hasOwnProperty.call(m, "quaternary"))
                        w.uint32(32).uint32(m.quaternary);
                    if (m.quinary != null && Object.hasOwnProperty.call(m, "quinary"))
                        w.uint32(40).uint32(m.quinary);
                    return w;
                };

                AppVersion.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.primary = r.uint32();
                                break;
                            }
                        case 2: {
                                m.secondary = r.uint32();
                                break;
                            }
                        case 3: {
                                m.tertiary = r.uint32();
                                break;
                            }
                        case 4: {
                                m.quaternary = r.uint32();
                                break;
                            }
                        case 5: {
                                m.quinary = r.uint32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AppVersion.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ClientPayload.UserAgent.AppVersion)
                        return d;
                    var m = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    if (d.primary != null) {
                        m.primary = d.primary >>> 0;
                    }
                    if (d.secondary != null) {
                        m.secondary = d.secondary >>> 0;
                    }
                    if (d.tertiary != null) {
                        m.tertiary = d.tertiary >>> 0;
                    }
                    if (d.quaternary != null) {
                        m.quaternary = d.quaternary >>> 0;
                    }
                    if (d.quinary != null) {
                        m.quinary = d.quinary >>> 0;
                    }
                    return m;
                };

                AppVersion.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.primary != null && m.hasOwnProperty("primary")) {
                        d.primary = m.primary;
                        if (o.oneofs)
                            d._primary = "primary";
                    }
                    if (m.secondary != null && m.hasOwnProperty("secondary")) {
                        d.secondary = m.secondary;
                        if (o.oneofs)
                            d._secondary = "secondary";
                    }
                    if (m.tertiary != null && m.hasOwnProperty("tertiary")) {
                        d.tertiary = m.tertiary;
                        if (o.oneofs)
                            d._tertiary = "tertiary";
                    }
                    if (m.quaternary != null && m.hasOwnProperty("quaternary")) {
                        d.quaternary = m.quaternary;
                        if (o.oneofs)
                            d._quaternary = "quaternary";
                    }
                    if (m.quinary != null && m.hasOwnProperty("quinary")) {
                        d.quinary = m.quinary;
                        if (o.oneofs)
                            d._quinary = "quinary";
                    }
                    return d;
                };

                AppVersion.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AppVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ClientPayload.UserAgent.AppVersion";
                };

                return AppVersion;
            })();

            UserAgent.DeviceType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "PHONE"] = 0;
                values[valuesById[1] = "TABLET"] = 1;
                values[valuesById[2] = "DESKTOP"] = 2;
                values[valuesById[3] = "WEARABLE"] = 3;
                values[valuesById[4] = "VR"] = 4;
                return values;
            })();

            UserAgent.Platform = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "ANDROID"] = 0;
                values[valuesById[1] = "IOS"] = 1;
                values[valuesById[2] = "WINDOWS_PHONE"] = 2;
                values[valuesById[3] = "BLACKBERRY"] = 3;
                values[valuesById[4] = "BLACKBERRYX"] = 4;
                values[valuesById[5] = "S40"] = 5;
                values[valuesById[6] = "S60"] = 6;
                values[valuesById[7] = "PYTHON_CLIENT"] = 7;
                values[valuesById[8] = "TIZEN"] = 8;
                values[valuesById[9] = "ENTERPRISE"] = 9;
                values[valuesById[10] = "SMB_ANDROID"] = 10;
                values[valuesById[11] = "KAIOS"] = 11;
                values[valuesById[12] = "SMB_IOS"] = 12;
                values[valuesById[13] = "WINDOWS"] = 13;
                values[valuesById[14] = "WEB"] = 14;
                values[valuesById[15] = "PORTAL"] = 15;
                values[valuesById[16] = "GREEN_ANDROID"] = 16;
                values[valuesById[17] = "GREEN_IPHONE"] = 17;
                values[valuesById[18] = "BLUE_ANDROID"] = 18;
                values[valuesById[19] = "BLUE_IPHONE"] = 19;
                values[valuesById[20] = "FBLITE_ANDROID"] = 20;
                values[valuesById[21] = "MLITE_ANDROID"] = 21;
                values[valuesById[22] = "IGLITE_ANDROID"] = 22;
                values[valuesById[23] = "PAGE"] = 23;
                values[valuesById[24] = "MACOS"] = 24;
                values[valuesById[25] = "OCULUS_MSG"] = 25;
                values[valuesById[26] = "OCULUS_CALL"] = 26;
                values[valuesById[27] = "MILAN"] = 27;
                values[valuesById[28] = "CAPI"] = 28;
                values[valuesById[29] = "WEAROS"] = 29;
                values[valuesById[30] = "ARDEVICE"] = 30;
                values[valuesById[31] = "VRDEVICE"] = 31;
                values[valuesById[32] = "BLUE_WEB"] = 32;
                values[valuesById[33] = "IPAD"] = 33;
                values[valuesById[34] = "TEST"] = 34;
                values[valuesById[35] = "SMART_GLASSES"] = 35;
                values[valuesById[36] = "BLUE_VR"] = 36;
                values[valuesById[37] = "AR_WRIST"] = 37;
                return values;
            })();

            UserAgent.ReleaseChannel = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "RELEASE"] = 0;
                values[valuesById[1] = "BETA"] = 1;
                values[valuesById[2] = "ALPHA"] = 2;
                values[valuesById[3] = "DEBUG"] = 3;
                return values;
            })();

            return UserAgent;
        })();

        ClientPayload.WebInfo = (function() {

            function WebInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            WebInfo.prototype.refToken = null;
            WebInfo.prototype.version = null;
            WebInfo.prototype.webdPayload = null;
            WebInfo.prototype.webSubPlatform = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_refToken", {
                get: $util.oneOfGetter($oneOfFields = ["refToken"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_version", {
                get: $util.oneOfGetter($oneOfFields = ["version"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_webdPayload", {
                get: $util.oneOfGetter($oneOfFields = ["webdPayload"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_webSubPlatform", {
                get: $util.oneOfGetter($oneOfFields = ["webSubPlatform"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            WebInfo.create = function create(properties) {
                return new WebInfo(properties);
            };

            WebInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.refToken != null && Object.hasOwnProperty.call(m, "refToken"))
                    w.uint32(10).string(m.refToken);
                if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                    w.uint32(18).string(m.version);
                if (m.webdPayload != null && Object.hasOwnProperty.call(m, "webdPayload"))
                    $root.proto.ClientPayload.WebInfo.WebdPayload.encode(m.webdPayload, w.uint32(26).fork()).ldelim();
                if (m.webSubPlatform != null && Object.hasOwnProperty.call(m, "webSubPlatform"))
                    w.uint32(32).int32(m.webSubPlatform);
                return w;
            };

            WebInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.WebInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.refToken = r.string();
                            break;
                        }
                    case 2: {
                            m.version = r.string();
                            break;
                        }
                    case 3: {
                            m.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.webSubPlatform = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            WebInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.WebInfo)
                    return d;
                var m = new $root.proto.ClientPayload.WebInfo();
                if (d.refToken != null) {
                    m.refToken = String(d.refToken);
                }
                if (d.version != null) {
                    m.version = String(d.version);
                }
                if (d.webdPayload != null) {
                    if (typeof d.webdPayload !== "object")
                        throw TypeError(".proto.ClientPayload.WebInfo.webdPayload: object expected");
                    m.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.fromObject(d.webdPayload);
                }
                switch (d.webSubPlatform) {
                default:
                    if (typeof d.webSubPlatform === "number") {
                        m.webSubPlatform = d.webSubPlatform;
                        break;
                    }
                    break;
                case "WEB_BROWSER":
                case 0:
                    m.webSubPlatform = 0;
                    break;
                case "APP_STORE":
                case 1:
                    m.webSubPlatform = 1;
                    break;
                case "WIN_STORE":
                case 2:
                    m.webSubPlatform = 2;
                    break;
                case "DARWIN":
                case 3:
                    m.webSubPlatform = 3;
                    break;
                case "WIN32":
                case 4:
                    m.webSubPlatform = 4;
                    break;
                case "WIN_HYBRID":
                case 5:
                    m.webSubPlatform = 5;
                    break;
                }
                return m;
            };

            WebInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.refToken != null && m.hasOwnProperty("refToken")) {
                    d.refToken = m.refToken;
                    if (o.oneofs)
                        d._refToken = "refToken";
                }
                if (m.version != null && m.hasOwnProperty("version")) {
                    d.version = m.version;
                    if (o.oneofs)
                        d._version = "version";
                }
                if (m.webdPayload != null && m.hasOwnProperty("webdPayload")) {
                    d.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.toObject(m.webdPayload, o);
                    if (o.oneofs)
                        d._webdPayload = "webdPayload";
                }
                if (m.webSubPlatform != null && m.hasOwnProperty("webSubPlatform")) {
                    d.webSubPlatform = o.enums === String ? $root.proto.ClientPayload.WebInfo.WebSubPlatform[m.webSubPlatform] === undefined ? m.webSubPlatform : $root.proto.ClientPayload.WebInfo.WebSubPlatform[m.webSubPlatform] : m.webSubPlatform;
                    if (o.oneofs)
                        d._webSubPlatform = "webSubPlatform";
                }
                return d;
            };

            WebInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            WebInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.WebInfo";
            };

            WebInfo.WebSubPlatform = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "WEB_BROWSER"] = 0;
                values[valuesById[1] = "APP_STORE"] = 1;
                values[valuesById[2] = "WIN_STORE"] = 2;
                values[valuesById[3] = "DARWIN"] = 3;
                values[valuesById[4] = "WIN32"] = 4;
                values[valuesById[5] = "WIN_HYBRID"] = 5;
                return values;
            })();

            WebInfo.WebdPayload = (function() {

                function WebdPayload(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                WebdPayload.prototype.usesParticipantInKey = null;
                WebdPayload.prototype.supportsStarredMessages = null;
                WebdPayload.prototype.supportsDocumentMessages = null;
                WebdPayload.prototype.supportsUrlMessages = null;
                WebdPayload.prototype.supportsMediaRetry = null;
                WebdPayload.prototype.supportsE2EImage = null;
                WebdPayload.prototype.supportsE2EVideo = null;
                WebdPayload.prototype.supportsE2EAudio = null;
                WebdPayload.prototype.supportsE2EDocument = null;
                WebdPayload.prototype.documentTypes = null;
                WebdPayload.prototype.features = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_usesParticipantInKey", {
                    get: $util.oneOfGetter($oneOfFields = ["usesParticipantInKey"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsStarredMessages", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsStarredMessages"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsDocumentMessages", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsDocumentMessages"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsUrlMessages", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsUrlMessages"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsMediaRetry", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsMediaRetry"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EImage", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EImage"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EVideo", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EVideo"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EAudio", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EAudio"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EDocument", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EDocument"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_documentTypes", {
                    get: $util.oneOfGetter($oneOfFields = ["documentTypes"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_features", {
                    get: $util.oneOfGetter($oneOfFields = ["features"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                WebdPayload.create = function create(properties) {
                    return new WebdPayload(properties);
                };

                WebdPayload.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.usesParticipantInKey != null && Object.hasOwnProperty.call(m, "usesParticipantInKey"))
                        w.uint32(8).bool(m.usesParticipantInKey);
                    if (m.supportsStarredMessages != null && Object.hasOwnProperty.call(m, "supportsStarredMessages"))
                        w.uint32(16).bool(m.supportsStarredMessages);
                    if (m.supportsDocumentMessages != null && Object.hasOwnProperty.call(m, "supportsDocumentMessages"))
                        w.uint32(24).bool(m.supportsDocumentMessages);
                    if (m.supportsUrlMessages != null && Object.hasOwnProperty.call(m, "supportsUrlMessages"))
                        w.uint32(32).bool(m.supportsUrlMessages);
                    if (m.supportsMediaRetry != null && Object.hasOwnProperty.call(m, "supportsMediaRetry"))
                        w.uint32(40).bool(m.supportsMediaRetry);
                    if (m.supportsE2EImage != null && Object.hasOwnProperty.call(m, "supportsE2EImage"))
                        w.uint32(48).bool(m.supportsE2EImage);
                    if (m.supportsE2EVideo != null && Object.hasOwnProperty.call(m, "supportsE2EVideo"))
                        w.uint32(56).bool(m.supportsE2EVideo);
                    if (m.supportsE2EAudio != null && Object.hasOwnProperty.call(m, "supportsE2EAudio"))
                        w.uint32(64).bool(m.supportsE2EAudio);
                    if (m.supportsE2EDocument != null && Object.hasOwnProperty.call(m, "supportsE2EDocument"))
                        w.uint32(72).bool(m.supportsE2EDocument);
                    if (m.documentTypes != null && Object.hasOwnProperty.call(m, "documentTypes"))
                        w.uint32(82).string(m.documentTypes);
                    if (m.features != null && Object.hasOwnProperty.call(m, "features"))
                        w.uint32(90).bytes(m.features);
                    return w;
                };

                WebdPayload.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.usesParticipantInKey = r.bool();
                                break;
                            }
                        case 2: {
                                m.supportsStarredMessages = r.bool();
                                break;
                            }
                        case 3: {
                                m.supportsDocumentMessages = r.bool();
                                break;
                            }
                        case 4: {
                                m.supportsUrlMessages = r.bool();
                                break;
                            }
                        case 5: {
                                m.supportsMediaRetry = r.bool();
                                break;
                            }
                        case 6: {
                                m.supportsE2EImage = r.bool();
                                break;
                            }
                        case 7: {
                                m.supportsE2EVideo = r.bool();
                                break;
                            }
                        case 8: {
                                m.supportsE2EAudio = r.bool();
                                break;
                            }
                        case 9: {
                                m.supportsE2EDocument = r.bool();
                                break;
                            }
                        case 10: {
                                m.documentTypes = r.string();
                                break;
                            }
                        case 11: {
                                m.features = r.bytes();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                WebdPayload.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ClientPayload.WebInfo.WebdPayload)
                        return d;
                    var m = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    if (d.usesParticipantInKey != null) {
                        m.usesParticipantInKey = Boolean(d.usesParticipantInKey);
                    }
                    if (d.supportsStarredMessages != null) {
                        m.supportsStarredMessages = Boolean(d.supportsStarredMessages);
                    }
                    if (d.supportsDocumentMessages != null) {
                        m.supportsDocumentMessages = Boolean(d.supportsDocumentMessages);
                    }
                    if (d.supportsUrlMessages != null) {
                        m.supportsUrlMessages = Boolean(d.supportsUrlMessages);
                    }
                    if (d.supportsMediaRetry != null) {
                        m.supportsMediaRetry = Boolean(d.supportsMediaRetry);
                    }
                    if (d.supportsE2EImage != null) {
                        m.supportsE2EImage = Boolean(d.supportsE2EImage);
                    }
                    if (d.supportsE2EVideo != null) {
                        m.supportsE2EVideo = Boolean(d.supportsE2EVideo);
                    }
                    if (d.supportsE2EAudio != null) {
                        m.supportsE2EAudio = Boolean(d.supportsE2EAudio);
                    }
                    if (d.supportsE2EDocument != null) {
                        m.supportsE2EDocument = Boolean(d.supportsE2EDocument);
                    }
                    if (d.documentTypes != null) {
                        m.documentTypes = String(d.documentTypes);
                    }
                    if (d.features != null) {
                        if (typeof d.features === "string")
                            $util.base64.decode(d.features, m.features = $util.newBuffer($util.base64.length(d.features)), 0);
                        else if (d.features.length >= 0)
                            m.features = d.features;
                    }
                    return m;
                };

                WebdPayload.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.usesParticipantInKey != null && m.hasOwnProperty("usesParticipantInKey")) {
                        d.usesParticipantInKey = m.usesParticipantInKey;
                        if (o.oneofs)
                            d._usesParticipantInKey = "usesParticipantInKey";
                    }
                    if (m.supportsStarredMessages != null && m.hasOwnProperty("supportsStarredMessages")) {
                        d.supportsStarredMessages = m.supportsStarredMessages;
                        if (o.oneofs)
                            d._supportsStarredMessages = "supportsStarredMessages";
                    }
                    if (m.supportsDocumentMessages != null && m.hasOwnProperty("supportsDocumentMessages")) {
                        d.supportsDocumentMessages = m.supportsDocumentMessages;
                        if (o.oneofs)
                            d._supportsDocumentMessages = "supportsDocumentMessages";
                    }
                    if (m.supportsUrlMessages != null && m.hasOwnProperty("supportsUrlMessages")) {
                        d.supportsUrlMessages = m.supportsUrlMessages;
                        if (o.oneofs)
                            d._supportsUrlMessages = "supportsUrlMessages";
                    }
                    if (m.supportsMediaRetry != null && m.hasOwnProperty("supportsMediaRetry")) {
                        d.supportsMediaRetry = m.supportsMediaRetry;
                        if (o.oneofs)
                            d._supportsMediaRetry = "supportsMediaRetry";
                    }
                    if (m.supportsE2EImage != null && m.hasOwnProperty("supportsE2EImage")) {
                        d.supportsE2EImage = m.supportsE2EImage;
                        if (o.oneofs)
                            d._supportsE2EImage = "supportsE2EImage";
                    }
                    if (m.supportsE2EVideo != null && m.hasOwnProperty("supportsE2EVideo")) {
                        d.supportsE2EVideo = m.supportsE2EVideo;
                        if (o.oneofs)
                            d._supportsE2EVideo = "supportsE2EVideo";
                    }
                    if (m.supportsE2EAudio != null && m.hasOwnProperty("supportsE2EAudio")) {
                        d.supportsE2EAudio = m.supportsE2EAudio;
                        if (o.oneofs)
                            d._supportsE2EAudio = "supportsE2EAudio";
                    }
                    if (m.supportsE2EDocument != null && m.hasOwnProperty("supportsE2EDocument")) {
                        d.supportsE2EDocument = m.supportsE2EDocument;
                        if (o.oneofs)
                            d._supportsE2EDocument = "supportsE2EDocument";
                    }
                    if (m.documentTypes != null && m.hasOwnProperty("documentTypes")) {
                        d.documentTypes = m.documentTypes;
                        if (o.oneofs)
                            d._documentTypes = "documentTypes";
                    }
                    if (m.features != null && m.hasOwnProperty("features")) {
                        d.features = o.bytes === String ? $util.base64.encode(m.features, 0, m.features.length) : o.bytes === Array ? Array.prototype.slice.call(m.features) : m.features;
                        if (o.oneofs)
                            d._features = "features";
                    }
                    return d;
                };

                WebdPayload.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                WebdPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ClientPayload.WebInfo.WebdPayload";
                };

                return WebdPayload;
            })();

            return WebInfo;
        })();

        return ClientPayload;
    })();

    proto.CollectionName = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "COLLECTION_NAME_UNKNOWN"] = 0;
        values[valuesById[1] = "REGULAR"] = 1;
        values[valuesById[2] = "REGULAR_LOW"] = 2;
        values[valuesById[3] = "REGULAR_HIGH"] = 3;
        values[valuesById[4] = "CRITICAL_BLOCK"] = 4;
        values[valuesById[5] = "CRITICAL_UNBLOCK_LOW"] = 5;
        return values;
    })();

    proto.CommentMetadata = (function() {

        function CommentMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CommentMetadata.prototype.commentParentKey = null;
        CommentMetadata.prototype.replyCount = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CommentMetadata.prototype, "_commentParentKey", {
            get: $util.oneOfGetter($oneOfFields = ["commentParentKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CommentMetadata.prototype, "_replyCount", {
            get: $util.oneOfGetter($oneOfFields = ["replyCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CommentMetadata.create = function create(properties) {
            return new CommentMetadata(properties);
        };

        CommentMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.commentParentKey != null && Object.hasOwnProperty.call(m, "commentParentKey"))
                $root.proto.MessageKey.encode(m.commentParentKey, w.uint32(10).fork()).ldelim();
            if (m.replyCount != null && Object.hasOwnProperty.call(m, "replyCount"))
                w.uint32(16).uint32(m.replyCount);
            return w;
        };

        CommentMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CommentMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.commentParentKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.replyCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CommentMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CommentMetadata)
                return d;
            var m = new $root.proto.CommentMetadata();
            if (d.commentParentKey != null) {
                if (typeof d.commentParentKey !== "object")
                    throw TypeError(".proto.CommentMetadata.commentParentKey: object expected");
                m.commentParentKey = $root.proto.MessageKey.fromObject(d.commentParentKey);
            }
            if (d.replyCount != null) {
                m.replyCount = d.replyCount >>> 0;
            }
            return m;
        };

        CommentMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.commentParentKey != null && m.hasOwnProperty("commentParentKey")) {
                d.commentParentKey = $root.proto.MessageKey.toObject(m.commentParentKey, o);
                if (o.oneofs)
                    d._commentParentKey = "commentParentKey";
            }
            if (m.replyCount != null && m.hasOwnProperty("replyCount")) {
                d.replyCount = m.replyCount;
                if (o.oneofs)
                    d._replyCount = "replyCount";
            }
            return d;
        };

        CommentMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CommentMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CommentMetadata";
        };

        return CommentMetadata;
    })();

    proto.CompanionCommitment = (function() {

        function CompanionCommitment(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CompanionCommitment.prototype.hash = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionCommitment.prototype, "_hash", {
            get: $util.oneOfGetter($oneOfFields = ["hash"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CompanionCommitment.create = function create(properties) {
            return new CompanionCommitment(properties);
        };

        CompanionCommitment.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.hash != null && Object.hasOwnProperty.call(m, "hash"))
                w.uint32(10).bytes(m.hash);
            return w;
        };

        CompanionCommitment.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CompanionCommitment();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.hash = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CompanionCommitment.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CompanionCommitment)
                return d;
            var m = new $root.proto.CompanionCommitment();
            if (d.hash != null) {
                if (typeof d.hash === "string")
                    $util.base64.decode(d.hash, m.hash = $util.newBuffer($util.base64.length(d.hash)), 0);
                else if (d.hash.length >= 0)
                    m.hash = d.hash;
            }
            return m;
        };

        CompanionCommitment.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.hash != null && m.hasOwnProperty("hash")) {
                d.hash = o.bytes === String ? $util.base64.encode(m.hash, 0, m.hash.length) : o.bytes === Array ? Array.prototype.slice.call(m.hash) : m.hash;
                if (o.oneofs)
                    d._hash = "hash";
            }
            return d;
        };

        CompanionCommitment.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CompanionCommitment.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CompanionCommitment";
        };

        return CompanionCommitment;
    })();

    proto.CompanionEphemeralIdentity = (function() {

        function CompanionEphemeralIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CompanionEphemeralIdentity.prototype.publicKey = null;
        CompanionEphemeralIdentity.prototype.deviceType = null;
        CompanionEphemeralIdentity.prototype.ref = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionEphemeralIdentity.prototype, "_publicKey", {
            get: $util.oneOfGetter($oneOfFields = ["publicKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionEphemeralIdentity.prototype, "_deviceType", {
            get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionEphemeralIdentity.prototype, "_ref", {
            get: $util.oneOfGetter($oneOfFields = ["ref"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CompanionEphemeralIdentity.create = function create(properties) {
            return new CompanionEphemeralIdentity(properties);
        };

        CompanionEphemeralIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.publicKey != null && Object.hasOwnProperty.call(m, "publicKey"))
                w.uint32(10).bytes(m.publicKey);
            if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                w.uint32(16).int32(m.deviceType);
            if (m.ref != null && Object.hasOwnProperty.call(m, "ref"))
                w.uint32(26).string(m.ref);
            return w;
        };

        CompanionEphemeralIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CompanionEphemeralIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.publicKey = r.bytes();
                        break;
                    }
                case 2: {
                        m.deviceType = r.int32();
                        break;
                    }
                case 3: {
                        m.ref = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CompanionEphemeralIdentity.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CompanionEphemeralIdentity)
                return d;
            var m = new $root.proto.CompanionEphemeralIdentity();
            if (d.publicKey != null) {
                if (typeof d.publicKey === "string")
                    $util.base64.decode(d.publicKey, m.publicKey = $util.newBuffer($util.base64.length(d.publicKey)), 0);
                else if (d.publicKey.length >= 0)
                    m.publicKey = d.publicKey;
            }
            switch (d.deviceType) {
            default:
                if (typeof d.deviceType === "number") {
                    m.deviceType = d.deviceType;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.deviceType = 0;
                break;
            case "CHROME":
            case 1:
                m.deviceType = 1;
                break;
            case "FIREFOX":
            case 2:
                m.deviceType = 2;
                break;
            case "IE":
            case 3:
                m.deviceType = 3;
                break;
            case "OPERA":
            case 4:
                m.deviceType = 4;
                break;
            case "SAFARI":
            case 5:
                m.deviceType = 5;
                break;
            case "EDGE":
            case 6:
                m.deviceType = 6;
                break;
            case "DESKTOP":
            case 7:
                m.deviceType = 7;
                break;
            case "IPAD":
            case 8:
                m.deviceType = 8;
                break;
            case "ANDROID_TABLET":
            case 9:
                m.deviceType = 9;
                break;
            case "OHANA":
            case 10:
                m.deviceType = 10;
                break;
            case "ALOHA":
            case 11:
                m.deviceType = 11;
                break;
            case "CATALINA":
            case 12:
                m.deviceType = 12;
                break;
            case "TCL_TV":
            case 13:
                m.deviceType = 13;
                break;
            case "IOS_PHONE":
            case 14:
                m.deviceType = 14;
                break;
            case "IOS_CATALYST":
            case 15:
                m.deviceType = 15;
                break;
            case "ANDROID_PHONE":
            case 16:
                m.deviceType = 16;
                break;
            case "ANDROID_AMBIGUOUS":
            case 17:
                m.deviceType = 17;
                break;
            case "WEAR_OS":
            case 18:
                m.deviceType = 18;
                break;
            case "AR_WRIST":
            case 19:
                m.deviceType = 19;
                break;
            case "AR_DEVICE":
            case 20:
                m.deviceType = 20;
                break;
            case "UWP":
            case 21:
                m.deviceType = 21;
                break;
            case "VR":
            case 22:
                m.deviceType = 22;
                break;
            case "CLOUD_API":
            case 23:
                m.deviceType = 23;
                break;
            case "SMARTGLASSES":
            case 24:
                m.deviceType = 24;
                break;
            }
            if (d.ref != null) {
                m.ref = String(d.ref);
            }
            return m;
        };

        CompanionEphemeralIdentity.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.publicKey != null && m.hasOwnProperty("publicKey")) {
                d.publicKey = o.bytes === String ? $util.base64.encode(m.publicKey, 0, m.publicKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.publicKey) : m.publicKey;
                if (o.oneofs)
                    d._publicKey = "publicKey";
            }
            if (m.deviceType != null && m.hasOwnProperty("deviceType")) {
                d.deviceType = o.enums === String ? $root.proto.DeviceProps.PlatformType[m.deviceType] === undefined ? m.deviceType : $root.proto.DeviceProps.PlatformType[m.deviceType] : m.deviceType;
                if (o.oneofs)
                    d._deviceType = "deviceType";
            }
            if (m.ref != null && m.hasOwnProperty("ref")) {
                d.ref = m.ref;
                if (o.oneofs)
                    d._ref = "ref";
            }
            return d;
        };

        CompanionEphemeralIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CompanionEphemeralIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CompanionEphemeralIdentity";
        };

        return CompanionEphemeralIdentity;
    })();

    proto.Config = (function() {

        function Config(p) {
            this.field = {};
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Config.prototype.field = $util.emptyObject;
        Config.prototype.version = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Config.prototype, "_version", {
            get: $util.oneOfGetter($oneOfFields = ["version"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        Config.create = function create(properties) {
            return new Config(properties);
        };

        Config.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.field != null && Object.hasOwnProperty.call(m, "field")) {
                for (var ks = Object.keys(m.field), i = 0; i < ks.length; ++i) {
                    w.uint32(10).fork().uint32(8).uint32(ks[i]);
                    $root.proto.Field.encode(m.field[ks[i]], w.uint32(18).fork()).ldelim().ldelim();
                }
            }
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                w.uint32(16).uint32(m.version);
            return w;
        };

        Config.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Config(), k, value;
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (m.field === $util.emptyObject)
                            m.field = {};
                        var c2 = r.uint32() + r.pos;
                        k = 0;
                        value = null;
                        while (r.pos < c2) {
                            var tag2 = r.uint32();
                            switch (tag2 >>> 3) {
                            case 1:
                                k = r.uint32();
                                break;
                            case 2:
                                value = $root.proto.Field.decode(r, r.uint32());
                                break;
                            default:
                                r.skipType(tag2 & 7);
                                break;
                            }
                        }
                        m.field[k] = value;
                        break;
                    }
                case 2: {
                        m.version = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Config.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Config)
                return d;
            var m = new $root.proto.Config();
            if (d.field) {
                if (typeof d.field !== "object")
                    throw TypeError(".proto.Config.field: object expected");
                m.field = {};
                for (var ks = Object.keys(d.field), i = 0; i < ks.length; ++i) {
                    if (typeof d.field[ks[i]] !== "object")
                        throw TypeError(".proto.Config.field: object expected");
                    m.field[ks[i]] = $root.proto.Field.fromObject(d.field[ks[i]]);
                }
            }
            if (d.version != null) {
                m.version = d.version >>> 0;
            }
            return m;
        };

        Config.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.objects || o.defaults) {
                d.field = {};
            }
            var ks2;
            if (m.field && (ks2 = Object.keys(m.field)).length) {
                d.field = {};
                for (var j = 0; j < ks2.length; ++j) {
                    d.field[ks2[j]] = $root.proto.Field.toObject(m.field[ks2[j]], o);
                }
            }
            if (m.version != null && m.hasOwnProperty("version")) {
                d.version = m.version;
                if (o.oneofs)
                    d._version = "version";
            }
            return d;
        };

        Config.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Config.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Config";
        };

        return Config;
    })();

    proto.ContextInfo = (function() {

        function ContextInfo(p) {
            this.mentionedJid = [];
            this.groupMentions = [];
            this.statusAttributions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ContextInfo.prototype.stanzaId = null;
        ContextInfo.prototype.participant = null;
        ContextInfo.prototype.quotedMessage = null;
        ContextInfo.prototype.remoteJid = null;
        ContextInfo.prototype.mentionedJid = $util.emptyArray;
        ContextInfo.prototype.conversionSource = null;
        ContextInfo.prototype.conversionData = null;
        ContextInfo.prototype.conversionDelaySeconds = null;
        ContextInfo.prototype.forwardingScore = null;
        ContextInfo.prototype.isForwarded = null;
        ContextInfo.prototype.quotedAd = null;
        ContextInfo.prototype.placeholderKey = null;
        ContextInfo.prototype.expiration = null;
        ContextInfo.prototype.ephemeralSettingTimestamp = null;
        ContextInfo.prototype.ephemeralSharedSecret = null;
        ContextInfo.prototype.externalAdReply = null;
        ContextInfo.prototype.entryPointConversionSource = null;
        ContextInfo.prototype.entryPointConversionApp = null;
        ContextInfo.prototype.entryPointConversionDelaySeconds = null;
        ContextInfo.prototype.disappearingMode = null;
        ContextInfo.prototype.actionLink = null;
        ContextInfo.prototype.groupSubject = null;
        ContextInfo.prototype.parentGroupJid = null;
        ContextInfo.prototype.trustBannerType = null;
        ContextInfo.prototype.trustBannerAction = null;
        ContextInfo.prototype.isSampled = null;
        ContextInfo.prototype.groupMentions = $util.emptyArray;
        ContextInfo.prototype.utm = null;
        ContextInfo.prototype.forwardedNewsletterMessageInfo = null;
        ContextInfo.prototype.businessMessageForwardInfo = null;
        ContextInfo.prototype.smbClientCampaignId = null;
        ContextInfo.prototype.smbServerCampaignId = null;
        ContextInfo.prototype.dataSharingContext = null;
        ContextInfo.prototype.alwaysShowAdAttribution = null;
        ContextInfo.prototype.featureEligibilities = null;
        ContextInfo.prototype.entryPointConversionExternalSource = null;
        ContextInfo.prototype.entryPointConversionExternalMedium = null;
        ContextInfo.prototype.ctwaSignals = null;
        ContextInfo.prototype.ctwaPayload = null;
        ContextInfo.prototype.forwardedAiBotMessageInfo = null;
        ContextInfo.prototype.statusAttributionType = null;
        ContextInfo.prototype.urlTrackingMap = null;
        ContextInfo.prototype.pairedMediaType = null;
        ContextInfo.prototype.rankingVersion = null;
        ContextInfo.prototype.memberLabel = null;
        ContextInfo.prototype.isQuestion = null;
        ContextInfo.prototype.statusSourceType = null;
        ContextInfo.prototype.statusAttributions = $util.emptyArray;
        ContextInfo.prototype.isGroupStatus = null;
        ContextInfo.prototype.forwardOrigin = null;
        ContextInfo.prototype.questionReplyQuotedMessage = null;
        ContextInfo.prototype.statusAudienceMetadata = null;
        ContextInfo.prototype.nonJidMentions = null;
        ContextInfo.prototype.quotedType = null;
        ContextInfo.prototype.botMessageSharingInfo = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_stanzaId", {
            get: $util.oneOfGetter($oneOfFields = ["stanzaId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_participant", {
            get: $util.oneOfGetter($oneOfFields = ["participant"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_quotedMessage", {
            get: $util.oneOfGetter($oneOfFields = ["quotedMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_remoteJid", {
            get: $util.oneOfGetter($oneOfFields = ["remoteJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_conversionSource", {
            get: $util.oneOfGetter($oneOfFields = ["conversionSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_conversionData", {
            get: $util.oneOfGetter($oneOfFields = ["conversionData"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_conversionDelaySeconds", {
            get: $util.oneOfGetter($oneOfFields = ["conversionDelaySeconds"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardingScore", {
            get: $util.oneOfGetter($oneOfFields = ["forwardingScore"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isForwarded", {
            get: $util.oneOfGetter($oneOfFields = ["isForwarded"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_quotedAd", {
            get: $util.oneOfGetter($oneOfFields = ["quotedAd"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_placeholderKey", {
            get: $util.oneOfGetter($oneOfFields = ["placeholderKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_expiration", {
            get: $util.oneOfGetter($oneOfFields = ["expiration"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ephemeralSettingTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["ephemeralSettingTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ephemeralSharedSecret", {
            get: $util.oneOfGetter($oneOfFields = ["ephemeralSharedSecret"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_externalAdReply", {
            get: $util.oneOfGetter($oneOfFields = ["externalAdReply"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionSource", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionApp", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionApp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionDelaySeconds", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionDelaySeconds"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_disappearingMode", {
            get: $util.oneOfGetter($oneOfFields = ["disappearingMode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_actionLink", {
            get: $util.oneOfGetter($oneOfFields = ["actionLink"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_groupSubject", {
            get: $util.oneOfGetter($oneOfFields = ["groupSubject"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_parentGroupJid", {
            get: $util.oneOfGetter($oneOfFields = ["parentGroupJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_trustBannerType", {
            get: $util.oneOfGetter($oneOfFields = ["trustBannerType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_trustBannerAction", {
            get: $util.oneOfGetter($oneOfFields = ["trustBannerAction"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isSampled", {
            get: $util.oneOfGetter($oneOfFields = ["isSampled"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_utm", {
            get: $util.oneOfGetter($oneOfFields = ["utm"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardedNewsletterMessageInfo", {
            get: $util.oneOfGetter($oneOfFields = ["forwardedNewsletterMessageInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_businessMessageForwardInfo", {
            get: $util.oneOfGetter($oneOfFields = ["businessMessageForwardInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_smbClientCampaignId", {
            get: $util.oneOfGetter($oneOfFields = ["smbClientCampaignId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_smbServerCampaignId", {
            get: $util.oneOfGetter($oneOfFields = ["smbServerCampaignId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_dataSharingContext", {
            get: $util.oneOfGetter($oneOfFields = ["dataSharingContext"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_alwaysShowAdAttribution", {
            get: $util.oneOfGetter($oneOfFields = ["alwaysShowAdAttribution"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_featureEligibilities", {
            get: $util.oneOfGetter($oneOfFields = ["featureEligibilities"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionExternalSource", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionExternalSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionExternalMedium", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionExternalMedium"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ctwaSignals", {
            get: $util.oneOfGetter($oneOfFields = ["ctwaSignals"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ctwaPayload", {
            get: $util.oneOfGetter($oneOfFields = ["ctwaPayload"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardedAiBotMessageInfo", {
            get: $util.oneOfGetter($oneOfFields = ["forwardedAiBotMessageInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_statusAttributionType", {
            get: $util.oneOfGetter($oneOfFields = ["statusAttributionType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_urlTrackingMap", {
            get: $util.oneOfGetter($oneOfFields = ["urlTrackingMap"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_pairedMediaType", {
            get: $util.oneOfGetter($oneOfFields = ["pairedMediaType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_rankingVersion", {
            get: $util.oneOfGetter($oneOfFields = ["rankingVersion"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_memberLabel", {
            get: $util.oneOfGetter($oneOfFields = ["memberLabel"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isQuestion", {
            get: $util.oneOfGetter($oneOfFields = ["isQuestion"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_statusSourceType", {
            get: $util.oneOfGetter($oneOfFields = ["statusSourceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isGroupStatus", {
            get: $util.oneOfGetter($oneOfFields = ["isGroupStatus"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardOrigin", {
            get: $util.oneOfGetter($oneOfFields = ["forwardOrigin"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_questionReplyQuotedMessage", {
            get: $util.oneOfGetter($oneOfFields = ["questionReplyQuotedMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_statusAudienceMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["statusAudienceMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_nonJidMentions", {
            get: $util.oneOfGetter($oneOfFields = ["nonJidMentions"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_quotedType", {
            get: $util.oneOfGetter($oneOfFields = ["quotedType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_botMessageSharingInfo", {
            get: $util.oneOfGetter($oneOfFields = ["botMessageSharingInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ContextInfo.create = function create(properties) {
            return new ContextInfo(properties);
        };

        ContextInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                w.uint32(10).string(m.stanzaId);
            if (m.participant != null && Object.hasOwnProperty.call(m, "participant"))
                w.uint32(18).string(m.participant);
            if (m.quotedMessage != null && Object.hasOwnProperty.call(m, "quotedMessage"))
                $root.proto.Message.encode(m.quotedMessage, w.uint32(26).fork()).ldelim();
            if (m.remoteJid != null && Object.hasOwnProperty.call(m, "remoteJid"))
                w.uint32(34).string(m.remoteJid);
            if (m.mentionedJid != null && m.mentionedJid.length) {
                for (var i = 0; i < m.mentionedJid.length; ++i)
                    w.uint32(122).string(m.mentionedJid[i]);
            }
            if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                w.uint32(146).string(m.conversionSource);
            if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                w.uint32(154).bytes(m.conversionData);
            if (m.conversionDelaySeconds != null && Object.hasOwnProperty.call(m, "conversionDelaySeconds"))
                w.uint32(160).uint32(m.conversionDelaySeconds);
            if (m.forwardingScore != null && Object.hasOwnProperty.call(m, "forwardingScore"))
                w.uint32(168).uint32(m.forwardingScore);
            if (m.isForwarded != null && Object.hasOwnProperty.call(m, "isForwarded"))
                w.uint32(176).bool(m.isForwarded);
            if (m.quotedAd != null && Object.hasOwnProperty.call(m, "quotedAd"))
                $root.proto.ContextInfo.AdReplyInfo.encode(m.quotedAd, w.uint32(186).fork()).ldelim();
            if (m.placeholderKey != null && Object.hasOwnProperty.call(m, "placeholderKey"))
                $root.proto.MessageKey.encode(m.placeholderKey, w.uint32(194).fork()).ldelim();
            if (m.expiration != null && Object.hasOwnProperty.call(m, "expiration"))
                w.uint32(200).uint32(m.expiration);
            if (m.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(m, "ephemeralSettingTimestamp"))
                w.uint32(208).int64(m.ephemeralSettingTimestamp);
            if (m.ephemeralSharedSecret != null && Object.hasOwnProperty.call(m, "ephemeralSharedSecret"))
                w.uint32(218).bytes(m.ephemeralSharedSecret);
            if (m.externalAdReply != null && Object.hasOwnProperty.call(m, "externalAdReply"))
                $root.proto.ContextInfo.ExternalAdReplyInfo.encode(m.externalAdReply, w.uint32(226).fork()).ldelim();
            if (m.entryPointConversionSource != null && Object.hasOwnProperty.call(m, "entryPointConversionSource"))
                w.uint32(234).string(m.entryPointConversionSource);
            if (m.entryPointConversionApp != null && Object.hasOwnProperty.call(m, "entryPointConversionApp"))
                w.uint32(242).string(m.entryPointConversionApp);
            if (m.entryPointConversionDelaySeconds != null && Object.hasOwnProperty.call(m, "entryPointConversionDelaySeconds"))
                w.uint32(248).uint32(m.entryPointConversionDelaySeconds);
            if (m.disappearingMode != null && Object.hasOwnProperty.call(m, "disappearingMode"))
                $root.proto.DisappearingMode.encode(m.disappearingMode, w.uint32(258).fork()).ldelim();
            if (m.actionLink != null && Object.hasOwnProperty.call(m, "actionLink"))
                $root.proto.ActionLink.encode(m.actionLink, w.uint32(266).fork()).ldelim();
            if (m.groupSubject != null && Object.hasOwnProperty.call(m, "groupSubject"))
                w.uint32(274).string(m.groupSubject);
            if (m.parentGroupJid != null && Object.hasOwnProperty.call(m, "parentGroupJid"))
                w.uint32(282).string(m.parentGroupJid);
            if (m.trustBannerType != null && Object.hasOwnProperty.call(m, "trustBannerType"))
                w.uint32(298).string(m.trustBannerType);
            if (m.trustBannerAction != null && Object.hasOwnProperty.call(m, "trustBannerAction"))
                w.uint32(304).uint32(m.trustBannerAction);
            if (m.isSampled != null && Object.hasOwnProperty.call(m, "isSampled"))
                w.uint32(312).bool(m.isSampled);
            if (m.groupMentions != null && m.groupMentions.length) {
                for (var i = 0; i < m.groupMentions.length; ++i)
                    $root.proto.GroupMention.encode(m.groupMentions[i], w.uint32(322).fork()).ldelim();
            }
            if (m.utm != null && Object.hasOwnProperty.call(m, "utm"))
                $root.proto.ContextInfo.UTMInfo.encode(m.utm, w.uint32(330).fork()).ldelim();
            if (m.forwardedNewsletterMessageInfo != null && Object.hasOwnProperty.call(m, "forwardedNewsletterMessageInfo"))
                $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.encode(m.forwardedNewsletterMessageInfo, w.uint32(346).fork()).ldelim();
            if (m.businessMessageForwardInfo != null && Object.hasOwnProperty.call(m, "businessMessageForwardInfo"))
                $root.proto.ContextInfo.BusinessMessageForwardInfo.encode(m.businessMessageForwardInfo, w.uint32(354).fork()).ldelim();
            if (m.smbClientCampaignId != null && Object.hasOwnProperty.call(m, "smbClientCampaignId"))
                w.uint32(362).string(m.smbClientCampaignId);
            if (m.smbServerCampaignId != null && Object.hasOwnProperty.call(m, "smbServerCampaignId"))
                w.uint32(370).string(m.smbServerCampaignId);
            if (m.dataSharingContext != null && Object.hasOwnProperty.call(m, "dataSharingContext"))
                $root.proto.ContextInfo.DataSharingContext.encode(m.dataSharingContext, w.uint32(378).fork()).ldelim();
            if (m.alwaysShowAdAttribution != null && Object.hasOwnProperty.call(m, "alwaysShowAdAttribution"))
                w.uint32(384).bool(m.alwaysShowAdAttribution);
            if (m.featureEligibilities != null && Object.hasOwnProperty.call(m, "featureEligibilities"))
                $root.proto.ContextInfo.FeatureEligibilities.encode(m.featureEligibilities, w.uint32(394).fork()).ldelim();
            if (m.entryPointConversionExternalSource != null && Object.hasOwnProperty.call(m, "entryPointConversionExternalSource"))
                w.uint32(402).string(m.entryPointConversionExternalSource);
            if (m.entryPointConversionExternalMedium != null && Object.hasOwnProperty.call(m, "entryPointConversionExternalMedium"))
                w.uint32(410).string(m.entryPointConversionExternalMedium);
            if (m.ctwaSignals != null && Object.hasOwnProperty.call(m, "ctwaSignals"))
                w.uint32(434).string(m.ctwaSignals);
            if (m.ctwaPayload != null && Object.hasOwnProperty.call(m, "ctwaPayload"))
                w.uint32(442).bytes(m.ctwaPayload);
            if (m.forwardedAiBotMessageInfo != null && Object.hasOwnProperty.call(m, "forwardedAiBotMessageInfo"))
                $root.proto.ForwardedAIBotMessageInfo.encode(m.forwardedAiBotMessageInfo, w.uint32(450).fork()).ldelim();
            if (m.statusAttributionType != null && Object.hasOwnProperty.call(m, "statusAttributionType"))
                w.uint32(456).int32(m.statusAttributionType);
            if (m.urlTrackingMap != null && Object.hasOwnProperty.call(m, "urlTrackingMap"))
                $root.proto.UrlTrackingMap.encode(m.urlTrackingMap, w.uint32(466).fork()).ldelim();
            if (m.pairedMediaType != null && Object.hasOwnProperty.call(m, "pairedMediaType"))
                w.uint32(472).int32(m.pairedMediaType);
            if (m.rankingVersion != null && Object.hasOwnProperty.call(m, "rankingVersion"))
                w.uint32(480).uint32(m.rankingVersion);
            if (m.memberLabel != null && Object.hasOwnProperty.call(m, "memberLabel"))
                $root.proto.MemberLabel.encode(m.memberLabel, w.uint32(498).fork()).ldelim();
            if (m.isQuestion != null && Object.hasOwnProperty.call(m, "isQuestion"))
                w.uint32(504).bool(m.isQuestion);
            if (m.statusSourceType != null && Object.hasOwnProperty.call(m, "statusSourceType"))
                w.uint32(512).int32(m.statusSourceType);
            if (m.statusAttributions != null && m.statusAttributions.length) {
                for (var i = 0; i < m.statusAttributions.length; ++i)
                    $root.proto.StatusAttribution.encode(m.statusAttributions[i], w.uint32(522).fork()).ldelim();
            }
            if (m.isGroupStatus != null && Object.hasOwnProperty.call(m, "isGroupStatus"))
                w.uint32(528).bool(m.isGroupStatus);
            if (m.forwardOrigin != null && Object.hasOwnProperty.call(m, "forwardOrigin"))
                w.uint32(536).int32(m.forwardOrigin);
            if (m.questionReplyQuotedMessage != null && Object.hasOwnProperty.call(m, "questionReplyQuotedMessage"))
                $root.proto.ContextInfo.QuestionReplyQuotedMessage.encode(m.questionReplyQuotedMessage, w.uint32(546).fork()).ldelim();
            if (m.statusAudienceMetadata != null && Object.hasOwnProperty.call(m, "statusAudienceMetadata"))
                $root.proto.ContextInfo.StatusAudienceMetadata.encode(m.statusAudienceMetadata, w.uint32(554).fork()).ldelim();
            if (m.nonJidMentions != null && Object.hasOwnProperty.call(m, "nonJidMentions"))
                w.uint32(560).uint32(m.nonJidMentions);
            if (m.quotedType != null && Object.hasOwnProperty.call(m, "quotedType"))
                w.uint32(568).int32(m.quotedType);
            if (m.botMessageSharingInfo != null && Object.hasOwnProperty.call(m, "botMessageSharingInfo"))
                $root.proto.BotMessageSharingInfo.encode(m.botMessageSharingInfo, w.uint32(578).fork()).ldelim();
            return w;
        };

        ContextInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.stanzaId = r.string();
                        break;
                    }
                case 2: {
                        m.participant = r.string();
                        break;
                    }
                case 3: {
                        m.quotedMessage = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.remoteJid = r.string();
                        break;
                    }
                case 15: {
                        if (!(m.mentionedJid && m.mentionedJid.length))
                            m.mentionedJid = [];
                        m.mentionedJid.push(r.string());
                        break;
                    }
                case 18: {
                        m.conversionSource = r.string();
                        break;
                    }
                case 19: {
                        m.conversionData = r.bytes();
                        break;
                    }
                case 20: {
                        m.conversionDelaySeconds = r.uint32();
                        break;
                    }
                case 21: {
                        m.forwardingScore = r.uint32();
                        break;
                    }
                case 22: {
                        m.isForwarded = r.bool();
                        break;
                    }
                case 23: {
                        m.quotedAd = $root.proto.ContextInfo.AdReplyInfo.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.placeholderKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 25: {
                        m.expiration = r.uint32();
                        break;
                    }
                case 26: {
                        m.ephemeralSettingTimestamp = r.int64();
                        break;
                    }
                case 27: {
                        m.ephemeralSharedSecret = r.bytes();
                        break;
                    }
                case 28: {
                        m.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.decode(r, r.uint32());
                        break;
                    }
                case 29: {
                        m.entryPointConversionSource = r.string();
                        break;
                    }
                case 30: {
                        m.entryPointConversionApp = r.string();
                        break;
                    }
                case 31: {
                        m.entryPointConversionDelaySeconds = r.uint32();
                        break;
                    }
                case 32: {
                        m.disappearingMode = $root.proto.DisappearingMode.decode(r, r.uint32());
                        break;
                    }
                case 33: {
                        m.actionLink = $root.proto.ActionLink.decode(r, r.uint32());
                        break;
                    }
                case 34: {
                        m.groupSubject = r.string();
                        break;
                    }
                case 35: {
                        m.parentGroupJid = r.string();
                        break;
                    }
                case 37: {
                        m.trustBannerType = r.string();
                        break;
                    }
                case 38: {
                        m.trustBannerAction = r.uint32();
                        break;
                    }
                case 39: {
                        m.isSampled = r.bool();
                        break;
                    }
                case 40: {
                        if (!(m.groupMentions && m.groupMentions.length))
                            m.groupMentions = [];
                        m.groupMentions.push($root.proto.GroupMention.decode(r, r.uint32()));
                        break;
                    }
                case 41: {
                        m.utm = $root.proto.ContextInfo.UTMInfo.decode(r, r.uint32());
                        break;
                    }
                case 43: {
                        m.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 44: {
                        m.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.decode(r, r.uint32());
                        break;
                    }
                case 45: {
                        m.smbClientCampaignId = r.string();
                        break;
                    }
                case 46: {
                        m.smbServerCampaignId = r.string();
                        break;
                    }
                case 47: {
                        m.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.decode(r, r.uint32());
                        break;
                    }
                case 48: {
                        m.alwaysShowAdAttribution = r.bool();
                        break;
                    }
                case 49: {
                        m.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.decode(r, r.uint32());
                        break;
                    }
                case 50: {
                        m.entryPointConversionExternalSource = r.string();
                        break;
                    }
                case 51: {
                        m.entryPointConversionExternalMedium = r.string();
                        break;
                    }
                case 54: {
                        m.ctwaSignals = r.string();
                        break;
                    }
                case 55: {
                        m.ctwaPayload = r.bytes();
                        break;
                    }
                case 56: {
                        m.forwardedAiBotMessageInfo = $root.proto.ForwardedAIBotMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 57: {
                        m.statusAttributionType = r.int32();
                        break;
                    }
                case 58: {
                        m.urlTrackingMap = $root.proto.UrlTrackingMap.decode(r, r.uint32());
                        break;
                    }
                case 59: {
                        m.pairedMediaType = r.int32();
                        break;
                    }
                case 60: {
                        m.rankingVersion = r.uint32();
                        break;
                    }
                case 62: {
                        m.memberLabel = $root.proto.MemberLabel.decode(r, r.uint32());
                        break;
                    }
                case 63: {
                        m.isQuestion = r.bool();
                        break;
                    }
                case 64: {
                        m.statusSourceType = r.int32();
                        break;
                    }
                case 65: {
                        if (!(m.statusAttributions && m.statusAttributions.length))
                            m.statusAttributions = [];
                        m.statusAttributions.push($root.proto.StatusAttribution.decode(r, r.uint32()));
                        break;
                    }
                case 66: {
                        m.isGroupStatus = r.bool();
                        break;
                    }
                case 67: {
                        m.forwardOrigin = r.int32();
                        break;
                    }
                case 68: {
                        m.questionReplyQuotedMessage = $root.proto.ContextInfo.QuestionReplyQuotedMessage.decode(r, r.uint32());
                        break;
                    }
                case 69: {
                        m.statusAudienceMetadata = $root.proto.ContextInfo.StatusAudienceMetadata.decode(r, r.uint32());
                        break;
                    }
                case 70: {
                        m.nonJidMentions = r.uint32();
                        break;
                    }
                case 71: {
                        m.quotedType = r.int32();
                        break;
                    }
                case 72: {
                        m.botMessageSharingInfo = $root.proto.BotMessageSharingInfo.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ContextInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ContextInfo)
                return d;
            var m = new $root.proto.ContextInfo();
            if (d.stanzaId != null) {
                m.stanzaId = String(d.stanzaId);
            }
            if (d.participant != null) {
                m.participant = String(d.participant);
            }
            if (d.quotedMessage != null) {
                if (typeof d.quotedMessage !== "object")
                    throw TypeError(".proto.ContextInfo.quotedMessage: object expected");
                m.quotedMessage = $root.proto.Message.fromObject(d.quotedMessage);
            }
            if (d.remoteJid != null) {
                m.remoteJid = String(d.remoteJid);
            }
            if (d.mentionedJid) {
                if (!Array.isArray(d.mentionedJid))
                    throw TypeError(".proto.ContextInfo.mentionedJid: array expected");
                m.mentionedJid = [];
                for (var i = 0; i < d.mentionedJid.length; ++i) {
                    m.mentionedJid[i] = String(d.mentionedJid[i]);
                }
            }
            if (d.conversionSource != null) {
                m.conversionSource = String(d.conversionSource);
            }
            if (d.conversionData != null) {
                if (typeof d.conversionData === "string")
                    $util.base64.decode(d.conversionData, m.conversionData = $util.newBuffer($util.base64.length(d.conversionData)), 0);
                else if (d.conversionData.length >= 0)
                    m.conversionData = d.conversionData;
            }
            if (d.conversionDelaySeconds != null) {
                m.conversionDelaySeconds = d.conversionDelaySeconds >>> 0;
            }
            if (d.forwardingScore != null) {
                m.forwardingScore = d.forwardingScore >>> 0;
            }
            if (d.isForwarded != null) {
                m.isForwarded = Boolean(d.isForwarded);
            }
            if (d.quotedAd != null) {
                if (typeof d.quotedAd !== "object")
                    throw TypeError(".proto.ContextInfo.quotedAd: object expected");
                m.quotedAd = $root.proto.ContextInfo.AdReplyInfo.fromObject(d.quotedAd);
            }
            if (d.placeholderKey != null) {
                if (typeof d.placeholderKey !== "object")
                    throw TypeError(".proto.ContextInfo.placeholderKey: object expected");
                m.placeholderKey = $root.proto.MessageKey.fromObject(d.placeholderKey);
            }
            if (d.expiration != null) {
                m.expiration = d.expiration >>> 0;
            }
            if (d.ephemeralSettingTimestamp != null) {
                if ($util.Long)
                    (m.ephemeralSettingTimestamp = $util.Long.fromValue(d.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof d.ephemeralSettingTimestamp === "string")
                    m.ephemeralSettingTimestamp = parseInt(d.ephemeralSettingTimestamp, 10);
                else if (typeof d.ephemeralSettingTimestamp === "number")
                    m.ephemeralSettingTimestamp = d.ephemeralSettingTimestamp;
                else if (typeof d.ephemeralSettingTimestamp === "object")
                    m.ephemeralSettingTimestamp = new $util.LongBits(d.ephemeralSettingTimestamp.low >>> 0, d.ephemeralSettingTimestamp.high >>> 0).toNumber();
            }
            if (d.ephemeralSharedSecret != null) {
                if (typeof d.ephemeralSharedSecret === "string")
                    $util.base64.decode(d.ephemeralSharedSecret, m.ephemeralSharedSecret = $util.newBuffer($util.base64.length(d.ephemeralSharedSecret)), 0);
                else if (d.ephemeralSharedSecret.length >= 0)
                    m.ephemeralSharedSecret = d.ephemeralSharedSecret;
            }
            if (d.externalAdReply != null) {
                if (typeof d.externalAdReply !== "object")
                    throw TypeError(".proto.ContextInfo.externalAdReply: object expected");
                m.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.fromObject(d.externalAdReply);
            }
            if (d.entryPointConversionSource != null) {
                m.entryPointConversionSource = String(d.entryPointConversionSource);
            }
            if (d.entryPointConversionApp != null) {
                m.entryPointConversionApp = String(d.entryPointConversionApp);
            }
            if (d.entryPointConversionDelaySeconds != null) {
                m.entryPointConversionDelaySeconds = d.entryPointConversionDelaySeconds >>> 0;
            }
            if (d.disappearingMode != null) {
                if (typeof d.disappearingMode !== "object")
                    throw TypeError(".proto.ContextInfo.disappearingMode: object expected");
                m.disappearingMode = $root.proto.DisappearingMode.fromObject(d.disappearingMode);
            }
            if (d.actionLink != null) {
                if (typeof d.actionLink !== "object")
                    throw TypeError(".proto.ContextInfo.actionLink: object expected");
                m.actionLink = $root.proto.ActionLink.fromObject(d.actionLink);
            }
            if (d.groupSubject != null) {
                m.groupSubject = String(d.groupSubject);
            }
            if (d.parentGroupJid != null) {
                m.parentGroupJid = String(d.parentGroupJid);
            }
            if (d.trustBannerType != null) {
                m.trustBannerType = String(d.trustBannerType);
            }
            if (d.trustBannerAction != null) {
                m.trustBannerAction = d.trustBannerAction >>> 0;
            }
            if (d.isSampled != null) {
                m.isSampled = Boolean(d.isSampled);
            }
            if (d.groupMentions) {
                if (!Array.isArray(d.groupMentions))
                    throw TypeError(".proto.ContextInfo.groupMentions: array expected");
                m.groupMentions = [];
                for (var i = 0; i < d.groupMentions.length; ++i) {
                    if (typeof d.groupMentions[i] !== "object")
                        throw TypeError(".proto.ContextInfo.groupMentions: object expected");
                    m.groupMentions[i] = $root.proto.GroupMention.fromObject(d.groupMentions[i]);
                }
            }
            if (d.utm != null) {
                if (typeof d.utm !== "object")
                    throw TypeError(".proto.ContextInfo.utm: object expected");
                m.utm = $root.proto.ContextInfo.UTMInfo.fromObject(d.utm);
            }
            if (d.forwardedNewsletterMessageInfo != null) {
                if (typeof d.forwardedNewsletterMessageInfo !== "object")
                    throw TypeError(".proto.ContextInfo.forwardedNewsletterMessageInfo: object expected");
                m.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.fromObject(d.forwardedNewsletterMessageInfo);
            }
            if (d.businessMessageForwardInfo != null) {
                if (typeof d.businessMessageForwardInfo !== "object")
                    throw TypeError(".proto.ContextInfo.businessMessageForwardInfo: object expected");
                m.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.fromObject(d.businessMessageForwardInfo);
            }
            if (d.smbClientCampaignId != null) {
                m.smbClientCampaignId = String(d.smbClientCampaignId);
            }
            if (d.smbServerCampaignId != null) {
                m.smbServerCampaignId = String(d.smbServerCampaignId);
            }
            if (d.dataSharingContext != null) {
                if (typeof d.dataSharingContext !== "object")
                    throw TypeError(".proto.ContextInfo.dataSharingContext: object expected");
                m.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.fromObject(d.dataSharingContext);
            }
            if (d.alwaysShowAdAttribution != null) {
                m.alwaysShowAdAttribution = Boolean(d.alwaysShowAdAttribution);
            }
            if (d.featureEligibilities != null) {
                if (typeof d.featureEligibilities !== "object")
                    throw TypeError(".proto.ContextInfo.featureEligibilities: object expected");
                m.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.fromObject(d.featureEligibilities);
            }
            if (d.entryPointConversionExternalSource != null) {
                m.entryPointConversionExternalSource = String(d.entryPointConversionExternalSource);
            }
            if (d.entryPointConversionExternalMedium != null) {
                m.entryPointConversionExternalMedium = String(d.entryPointConversionExternalMedium);
            }
            if (d.ctwaSignals != null) {
                m.ctwaSignals = String(d.ctwaSignals);
            }
            if (d.ctwaPayload != null) {
                if (typeof d.ctwaPayload === "string")
                    $util.base64.decode(d.ctwaPayload, m.ctwaPayload = $util.newBuffer($util.base64.length(d.ctwaPayload)), 0);
                else if (d.ctwaPayload.length >= 0)
                    m.ctwaPayload = d.ctwaPayload;
            }
            if (d.forwardedAiBotMessageInfo != null) {
                if (typeof d.forwardedAiBotMessageInfo !== "object")
                    throw TypeError(".proto.ContextInfo.forwardedAiBotMessageInfo: object expected");
                m.forwardedAiBotMessageInfo = $root.proto.ForwardedAIBotMessageInfo.fromObject(d.forwardedAiBotMessageInfo);
            }
            switch (d.statusAttributionType) {
            default:
                if (typeof d.statusAttributionType === "number") {
                    m.statusAttributionType = d.statusAttributionType;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.statusAttributionType = 0;
                break;
            case "RESHARED_FROM_MENTION":
            case 1:
                m.statusAttributionType = 1;
                break;
            case "RESHARED_FROM_POST":
            case 2:
                m.statusAttributionType = 2;
                break;
            case "RESHARED_FROM_POST_MANY_TIMES":
            case 3:
                m.statusAttributionType = 3;
                break;
            case "FORWARDED_FROM_STATUS":
            case 4:
                m.statusAttributionType = 4;
                break;
            }
            if (d.urlTrackingMap != null) {
                if (typeof d.urlTrackingMap !== "object")
                    throw TypeError(".proto.ContextInfo.urlTrackingMap: object expected");
                m.urlTrackingMap = $root.proto.UrlTrackingMap.fromObject(d.urlTrackingMap);
            }
            switch (d.pairedMediaType) {
            default:
                if (typeof d.pairedMediaType === "number") {
                    m.pairedMediaType = d.pairedMediaType;
                    break;
                }
                break;
            case "NOT_PAIRED_MEDIA":
            case 0:
                m.pairedMediaType = 0;
                break;
            case "SD_VIDEO_PARENT":
            case 1:
                m.pairedMediaType = 1;
                break;
            case "HD_VIDEO_CHILD":
            case 2:
                m.pairedMediaType = 2;
                break;
            case "SD_IMAGE_PARENT":
            case 3:
                m.pairedMediaType = 3;
                break;
            case "HD_IMAGE_CHILD":
            case 4:
                m.pairedMediaType = 4;
                break;
            case "MOTION_PHOTO_PARENT":
            case 5:
                m.pairedMediaType = 5;
                break;
            case "MOTION_PHOTO_CHILD":
            case 6:
                m.pairedMediaType = 6;
                break;
            case "HEVC_VIDEO_PARENT":
            case 7:
                m.pairedMediaType = 7;
                break;
            case "HEVC_VIDEO_CHILD":
            case 8:
                m.pairedMediaType = 8;
                break;
            }
            if (d.rankingVersion != null) {
                m.rankingVersion = d.rankingVersion >>> 0;
            }
            if (d.memberLabel != null) {
                if (typeof d.memberLabel !== "object")
                    throw TypeError(".proto.ContextInfo.memberLabel: object expected");
                m.memberLabel = $root.proto.MemberLabel.fromObject(d.memberLabel);
            }
            if (d.isQuestion != null) {
                m.isQuestion = Boolean(d.isQuestion);
            }
            switch (d.statusSourceType) {
            default:
                if (typeof d.statusSourceType === "number") {
                    m.statusSourceType = d.statusSourceType;
                    break;
                }
                break;
            case "IMAGE":
            case 0:
                m.statusSourceType = 0;
                break;
            case "VIDEO":
            case 1:
                m.statusSourceType = 1;
                break;
            case "GIF":
            case 2:
                m.statusSourceType = 2;
                break;
            case "AUDIO":
            case 3:
                m.statusSourceType = 3;
                break;
            case "TEXT":
            case 4:
                m.statusSourceType = 4;
                break;
            case "MUSIC_STANDALONE":
            case 5:
                m.statusSourceType = 5;
                break;
            }
            if (d.statusAttributions) {
                if (!Array.isArray(d.statusAttributions))
                    throw TypeError(".proto.ContextInfo.statusAttributions: array expected");
                m.statusAttributions = [];
                for (var i = 0; i < d.statusAttributions.length; ++i) {
                    if (typeof d.statusAttributions[i] !== "object")
                        throw TypeError(".proto.ContextInfo.statusAttributions: object expected");
                    m.statusAttributions[i] = $root.proto.StatusAttribution.fromObject(d.statusAttributions[i]);
                }
            }
            if (d.isGroupStatus != null) {
                m.isGroupStatus = Boolean(d.isGroupStatus);
            }
            switch (d.forwardOrigin) {
            default:
                if (typeof d.forwardOrigin === "number") {
                    m.forwardOrigin = d.forwardOrigin;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.forwardOrigin = 0;
                break;
            case "CHAT":
            case 1:
                m.forwardOrigin = 1;
                break;
            case "STATUS":
            case 2:
                m.forwardOrigin = 2;
                break;
            case "CHANNELS":
            case 3:
                m.forwardOrigin = 3;
                break;
            case "META_AI":
            case 4:
                m.forwardOrigin = 4;
                break;
            case "UGC":
            case 5:
                m.forwardOrigin = 5;
                break;
            }
            if (d.questionReplyQuotedMessage != null) {
                if (typeof d.questionReplyQuotedMessage !== "object")
                    throw TypeError(".proto.ContextInfo.questionReplyQuotedMessage: object expected");
                m.questionReplyQuotedMessage = $root.proto.ContextInfo.QuestionReplyQuotedMessage.fromObject(d.questionReplyQuotedMessage);
            }
            if (d.statusAudienceMetadata != null) {
                if (typeof d.statusAudienceMetadata !== "object")
                    throw TypeError(".proto.ContextInfo.statusAudienceMetadata: object expected");
                m.statusAudienceMetadata = $root.proto.ContextInfo.StatusAudienceMetadata.fromObject(d.statusAudienceMetadata);
            }
            if (d.nonJidMentions != null) {
                m.nonJidMentions = d.nonJidMentions >>> 0;
            }
            switch (d.quotedType) {
            default:
                if (typeof d.quotedType === "number") {
                    m.quotedType = d.quotedType;
                    break;
                }
                break;
            case "EXPLICIT":
            case 0:
                m.quotedType = 0;
                break;
            case "AUTO":
            case 1:
                m.quotedType = 1;
                break;
            }
            if (d.botMessageSharingInfo != null) {
                if (typeof d.botMessageSharingInfo !== "object")
                    throw TypeError(".proto.ContextInfo.botMessageSharingInfo: object expected");
                m.botMessageSharingInfo = $root.proto.BotMessageSharingInfo.fromObject(d.botMessageSharingInfo);
            }
            return m;
        };

        ContextInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.mentionedJid = [];
                d.groupMentions = [];
                d.statusAttributions = [];
            }
            if (m.stanzaId != null && m.hasOwnProperty("stanzaId")) {
                d.stanzaId = m.stanzaId;
                if (o.oneofs)
                    d._stanzaId = "stanzaId";
            }
            if (m.participant != null && m.hasOwnProperty("participant")) {
                d.participant = m.participant;
                if (o.oneofs)
                    d._participant = "participant";
            }
            if (m.quotedMessage != null && m.hasOwnProperty("quotedMessage")) {
                d.quotedMessage = $root.proto.Message.toObject(m.quotedMessage, o);
                if (o.oneofs)
                    d._quotedMessage = "quotedMessage";
            }
            if (m.remoteJid != null && m.hasOwnProperty("remoteJid")) {
                d.remoteJid = m.remoteJid;
                if (o.oneofs)
                    d._remoteJid = "remoteJid";
            }
            if (m.mentionedJid && m.mentionedJid.length) {
                d.mentionedJid = [];
                for (var j = 0; j < m.mentionedJid.length; ++j) {
                    d.mentionedJid[j] = m.mentionedJid[j];
                }
            }
            if (m.conversionSource != null && m.hasOwnProperty("conversionSource")) {
                d.conversionSource = m.conversionSource;
                if (o.oneofs)
                    d._conversionSource = "conversionSource";
            }
            if (m.conversionData != null && m.hasOwnProperty("conversionData")) {
                d.conversionData = o.bytes === String ? $util.base64.encode(m.conversionData, 0, m.conversionData.length) : o.bytes === Array ? Array.prototype.slice.call(m.conversionData) : m.conversionData;
                if (o.oneofs)
                    d._conversionData = "conversionData";
            }
            if (m.conversionDelaySeconds != null && m.hasOwnProperty("conversionDelaySeconds")) {
                d.conversionDelaySeconds = m.conversionDelaySeconds;
                if (o.oneofs)
                    d._conversionDelaySeconds = "conversionDelaySeconds";
            }
            if (m.forwardingScore != null && m.hasOwnProperty("forwardingScore")) {
                d.forwardingScore = m.forwardingScore;
                if (o.oneofs)
                    d._forwardingScore = "forwardingScore";
            }
            if (m.isForwarded != null && m.hasOwnProperty("isForwarded")) {
                d.isForwarded = m.isForwarded;
                if (o.oneofs)
                    d._isForwarded = "isForwarded";
            }
            if (m.quotedAd != null && m.hasOwnProperty("quotedAd")) {
                d.quotedAd = $root.proto.ContextInfo.AdReplyInfo.toObject(m.quotedAd, o);
                if (o.oneofs)
                    d._quotedAd = "quotedAd";
            }
            if (m.placeholderKey != null && m.hasOwnProperty("placeholderKey")) {
                d.placeholderKey = $root.proto.MessageKey.toObject(m.placeholderKey, o);
                if (o.oneofs)
                    d._placeholderKey = "placeholderKey";
            }
            if (m.expiration != null && m.hasOwnProperty("expiration")) {
                d.expiration = m.expiration;
                if (o.oneofs)
                    d._expiration = "expiration";
            }
            if (m.ephemeralSettingTimestamp != null && m.hasOwnProperty("ephemeralSettingTimestamp")) {
                if (typeof m.ephemeralSettingTimestamp === "number")
                    d.ephemeralSettingTimestamp = o.longs === String ? String(m.ephemeralSettingTimestamp) : m.ephemeralSettingTimestamp;
                else
                    d.ephemeralSettingTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.ephemeralSettingTimestamp) : o.longs === Number ? new $util.LongBits(m.ephemeralSettingTimestamp.low >>> 0, m.ephemeralSettingTimestamp.high >>> 0).toNumber() : m.ephemeralSettingTimestamp;
                if (o.oneofs)
                    d._ephemeralSettingTimestamp = "ephemeralSettingTimestamp";
            }
            if (m.ephemeralSharedSecret != null && m.hasOwnProperty("ephemeralSharedSecret")) {
                d.ephemeralSharedSecret = o.bytes === String ? $util.base64.encode(m.ephemeralSharedSecret, 0, m.ephemeralSharedSecret.length) : o.bytes === Array ? Array.prototype.slice.call(m.ephemeralSharedSecret) : m.ephemeralSharedSecret;
                if (o.oneofs)
                    d._ephemeralSharedSecret = "ephemeralSharedSecret";
            }
            if (m.externalAdReply != null && m.hasOwnProperty("externalAdReply")) {
                d.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.toObject(m.externalAdReply, o);
                if (o.oneofs)
                    d._externalAdReply = "externalAdReply";
            }
            if (m.entryPointConversionSource != null && m.hasOwnProperty("entryPointConversionSource")) {
                d.entryPointConversionSource = m.entryPointConversionSource;
                if (o.oneofs)
                    d._entryPointConversionSource = "entryPointConversionSource";
            }
            if (m.entryPointConversionApp != null && m.hasOwnProperty("entryPointConversionApp")) {
                d.entryPointConversionApp = m.entryPointConversionApp;
                if (o.oneofs)
                    d._entryPointConversionApp = "entryPointConversionApp";
            }
            if (m.entryPointConversionDelaySeconds != null && m.hasOwnProperty("entryPointConversionDelaySeconds")) {
                d.entryPointConversionDelaySeconds = m.entryPointConversionDelaySeconds;
                if (o.oneofs)
                    d._entryPointConversionDelaySeconds = "entryPointConversionDelaySeconds";
            }
            if (m.disappearingMode != null && m.hasOwnProperty("disappearingMode")) {
                d.disappearingMode = $root.proto.DisappearingMode.toObject(m.disappearingMode, o);
                if (o.oneofs)
                    d._disappearingMode = "disappearingMode";
            }
            if (m.actionLink != null && m.hasOwnProperty("actionLink")) {
                d.actionLink = $root.proto.ActionLink.toObject(m.actionLink, o);
                if (o.oneofs)
                    d._actionLink = "actionLink";
            }
            if (m.groupSubject != null && m.hasOwnProperty("groupSubject")) {
                d.groupSubject = m.groupSubject;
                if (o.oneofs)
                    d._groupSubject = "groupSubject";
            }
            if (m.parentGroupJid != null && m.hasOwnProperty("parentGroupJid")) {
                d.parentGroupJid = m.parentGroupJid;
                if (o.oneofs)
                    d._parentGroupJid = "parentGroupJid";
            }
            if (m.trustBannerType != null && m.hasOwnProperty("trustBannerType")) {
                d.trustBannerType = m.trustBannerType;
                if (o.oneofs)
                    d._trustBannerType = "trustBannerType";
            }
            if (m.trustBannerAction != null && m.hasOwnProperty("trustBannerAction")) {
                d.trustBannerAction = m.trustBannerAction;
                if (o.oneofs)
                    d._trustBannerAction = "trustBannerAction";
            }
            if (m.isSampled != null && m.hasOwnProperty("isSampled")) {
                d.isSampled = m.isSampled;
                if (o.oneofs)
                    d._isSampled = "isSampled";
            }
            if (m.groupMentions && m.groupMentions.length) {
                d.groupMentions = [];
                for (var j = 0; j < m.groupMentions.length; ++j) {
                    d.groupMentions[j] = $root.proto.GroupMention.toObject(m.groupMentions[j], o);
                }
            }
            if (m.utm != null && m.hasOwnProperty("utm")) {
                d.utm = $root.proto.ContextInfo.UTMInfo.toObject(m.utm, o);
                if (o.oneofs)
                    d._utm = "utm";
            }
            if (m.forwardedNewsletterMessageInfo != null && m.hasOwnProperty("forwardedNewsletterMessageInfo")) {
                d.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.toObject(m.forwardedNewsletterMessageInfo, o);
                if (o.oneofs)
                    d._forwardedNewsletterMessageInfo = "forwardedNewsletterMessageInfo";
            }
            if (m.businessMessageForwardInfo != null && m.hasOwnProperty("businessMessageForwardInfo")) {
                d.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.toObject(m.businessMessageForwardInfo, o);
                if (o.oneofs)
                    d._businessMessageForwardInfo = "businessMessageForwardInfo";
            }
            if (m.smbClientCampaignId != null && m.hasOwnProperty("smbClientCampaignId")) {
                d.smbClientCampaignId = m.smbClientCampaignId;
                if (o.oneofs)
                    d._smbClientCampaignId = "smbClientCampaignId";
            }
            if (m.smbServerCampaignId != null && m.hasOwnProperty("smbServerCampaignId")) {
                d.smbServerCampaignId = m.smbServerCampaignId;
                if (o.oneofs)
                    d._smbServerCampaignId = "smbServerCampaignId";
            }
            if (m.dataSharingContext != null && m.hasOwnProperty("dataSharingContext")) {
                d.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.toObject(m.dataSharingContext, o);
                if (o.oneofs)
                    d._dataSharingContext = "dataSharingContext";
            }
            if (m.alwaysShowAdAttribution != null && m.hasOwnProperty("alwaysShowAdAttribution")) {
                d.alwaysShowAdAttribution = m.alwaysShowAdAttribution;
                if (o.oneofs)
                    d._alwaysShowAdAttribution = "alwaysShowAdAttribution";
            }
            if (m.featureEligibilities != null && m.hasOwnProperty("featureEligibilities")) {
                d.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.toObject(m.featureEligibilities, o);
                if (o.oneofs)
                    d._featureEligibilities = "featureEligibilities";
            }
            if (m.entryPointConversionExternalSource != null && m.hasOwnProperty("entryPointConversionExternalSource")) {
                d.entryPointConversionExternalSource = m.entryPointConversionExternalSource;
                if (o.oneofs)
                    d._entryPointConversionExternalSource = "entryPointConversionExternalSource";
            }
            if (m.entryPointConversionExternalMedium != null && m.hasOwnProperty("entryPointConversionExternalMedium")) {
                d.entryPointConversionExternalMedium = m.entryPointConversionExternalMedium;
                if (o.oneofs)
                    d._entryPointConversionExternalMedium = "entryPointConversionExternalMedium";
            }
            if (m.ctwaSignals != null && m.hasOwnProperty("ctwaSignals")) {
                d.ctwaSignals = m.ctwaSignals;
                if (o.oneofs)
                    d._ctwaSignals = "ctwaSignals";
            }
            if (m.ctwaPayload != null && m.hasOwnProperty("ctwaPayload")) {
                d.ctwaPayload = o.bytes === String ? $util.base64.encode(m.ctwaPayload, 0, m.ctwaPayload.length) : o.bytes === Array ? Array.prototype.slice.call(m.ctwaPayload) : m.ctwaPayload;
                if (o.oneofs)
                    d._ctwaPayload = "ctwaPayload";
            }
            if (m.forwardedAiBotMessageInfo != null && m.hasOwnProperty("forwardedAiBotMessageInfo")) {
                d.forwardedAiBotMessageInfo = $root.proto.ForwardedAIBotMessageInfo.toObject(m.forwardedAiBotMessageInfo, o);
                if (o.oneofs)
                    d._forwardedAiBotMessageInfo = "forwardedAiBotMessageInfo";
            }
            if (m.statusAttributionType != null && m.hasOwnProperty("statusAttributionType")) {
                d.statusAttributionType = o.enums === String ? $root.proto.ContextInfo.StatusAttributionType[m.statusAttributionType] === undefined ? m.statusAttributionType : $root.proto.ContextInfo.StatusAttributionType[m.statusAttributionType] : m.statusAttributionType;
                if (o.oneofs)
                    d._statusAttributionType = "statusAttributionType";
            }
            if (m.urlTrackingMap != null && m.hasOwnProperty("urlTrackingMap")) {
                d.urlTrackingMap = $root.proto.UrlTrackingMap.toObject(m.urlTrackingMap, o);
                if (o.oneofs)
                    d._urlTrackingMap = "urlTrackingMap";
            }
            if (m.pairedMediaType != null && m.hasOwnProperty("pairedMediaType")) {
                d.pairedMediaType = o.enums === String ? $root.proto.ContextInfo.PairedMediaType[m.pairedMediaType] === undefined ? m.pairedMediaType : $root.proto.ContextInfo.PairedMediaType[m.pairedMediaType] : m.pairedMediaType;
                if (o.oneofs)
                    d._pairedMediaType = "pairedMediaType";
            }
            if (m.rankingVersion != null && m.hasOwnProperty("rankingVersion")) {
                d.rankingVersion = m.rankingVersion;
                if (o.oneofs)
                    d._rankingVersion = "rankingVersion";
            }
            if (m.memberLabel != null && m.hasOwnProperty("memberLabel")) {
                d.memberLabel = $root.proto.MemberLabel.toObject(m.memberLabel, o);
                if (o.oneofs)
                    d._memberLabel = "memberLabel";
            }
            if (m.isQuestion != null && m.hasOwnProperty("isQuestion")) {
                d.isQuestion = m.isQuestion;
                if (o.oneofs)
                    d._isQuestion = "isQuestion";
            }
            if (m.statusSourceType != null && m.hasOwnProperty("statusSourceType")) {
                d.statusSourceType = o.enums === String ? $root.proto.ContextInfo.StatusSourceType[m.statusSourceType] === undefined ? m.statusSourceType : $root.proto.ContextInfo.StatusSourceType[m.statusSourceType] : m.statusSourceType;
                if (o.oneofs)
                    d._statusSourceType = "statusSourceType";
            }
            if (m.statusAttributions && m.statusAttributions.length) {
                d.statusAttributions = [];
                for (var j = 0; j < m.statusAttributions.length; ++j) {
                    d.statusAttributions[j] = $root.proto.StatusAttribution.toObject(m.statusAttributions[j], o);
                }
            }
            if (m.isGroupStatus != null && m.hasOwnProperty("isGroupStatus")) {
                d.isGroupStatus = m.isGroupStatus;
                if (o.oneofs)
                    d._isGroupStatus = "isGroupStatus";
            }
            if (m.forwardOrigin != null && m.hasOwnProperty("forwardOrigin")) {
                d.forwardOrigin = o.enums === String ? $root.proto.ContextInfo.ForwardOrigin[m.forwardOrigin] === undefined ? m.forwardOrigin : $root.proto.ContextInfo.ForwardOrigin[m.forwardOrigin] : m.forwardOrigin;
                if (o.oneofs)
                    d._forwardOrigin = "forwardOrigin";
            }
            if (m.questionReplyQuotedMessage != null && m.hasOwnProperty("questionReplyQuotedMessage")) {
                d.questionReplyQuotedMessage = $root.proto.ContextInfo.QuestionReplyQuotedMessage.toObject(m.questionReplyQuotedMessage, o);
                if (o.oneofs)
                    d._questionReplyQuotedMessage = "questionReplyQuotedMessage";
            }
            if (m.statusAudienceMetadata != null && m.hasOwnProperty("statusAudienceMetadata")) {
                d.statusAudienceMetadata = $root.proto.ContextInfo.StatusAudienceMetadata.toObject(m.statusAudienceMetadata, o);
                if (o.oneofs)
                    d._statusAudienceMetadata = "statusAudienceMetadata";
            }
            if (m.nonJidMentions != null && m.hasOwnProperty("nonJidMentions")) {
                d.nonJidMentions = m.nonJidMentions;
                if (o.oneofs)
                    d._nonJidMentions = "nonJidMentions";
            }
            if (m.quotedType != null && m.hasOwnProperty("quotedType")) {
                d.quotedType = o.enums === String ? $root.proto.ContextInfo.QuotedType[m.quotedType] === undefined ? m.quotedType : $root.proto.ContextInfo.QuotedType[m.quotedType] : m.quotedType;
                if (o.oneofs)
                    d._quotedType = "quotedType";
            }
            if (m.botMessageSharingInfo != null && m.hasOwnProperty("botMessageSharingInfo")) {
                d.botMessageSharingInfo = $root.proto.BotMessageSharingInfo.toObject(m.botMessageSharingInfo, o);
                if (o.oneofs)
                    d._botMessageSharingInfo = "botMessageSharingInfo";
            }
            return d;
        };

        ContextInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ContextInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ContextInfo";
        };

        ContextInfo.AdReplyInfo = (function() {

            function AdReplyInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AdReplyInfo.prototype.advertiserName = null;
            AdReplyInfo.prototype.mediaType = null;
            AdReplyInfo.prototype.jpegThumbnail = null;
            AdReplyInfo.prototype.caption = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_advertiserName", {
                get: $util.oneOfGetter($oneOfFields = ["advertiserName"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_mediaType", {
                get: $util.oneOfGetter($oneOfFields = ["mediaType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_jpegThumbnail", {
                get: $util.oneOfGetter($oneOfFields = ["jpegThumbnail"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_caption", {
                get: $util.oneOfGetter($oneOfFields = ["caption"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AdReplyInfo.create = function create(properties) {
                return new AdReplyInfo(properties);
            };

            AdReplyInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.advertiserName != null && Object.hasOwnProperty.call(m, "advertiserName"))
                    w.uint32(10).string(m.advertiserName);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(16).int32(m.mediaType);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(138).string(m.caption);
                return w;
            };

            AdReplyInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.AdReplyInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.advertiserName = r.string();
                            break;
                        }
                    case 2: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.caption = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AdReplyInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.AdReplyInfo)
                    return d;
                var m = new $root.proto.ContextInfo.AdReplyInfo();
                if (d.advertiserName != null) {
                    m.advertiserName = String(d.advertiserName);
                }
                switch (d.mediaType) {
                default:
                    if (typeof d.mediaType === "number") {
                        m.mediaType = d.mediaType;
                        break;
                    }
                    break;
                case "NONE":
                case 0:
                    m.mediaType = 0;
                    break;
                case "IMAGE":
                case 1:
                    m.mediaType = 1;
                    break;
                case "VIDEO":
                case 2:
                    m.mediaType = 2;
                    break;
                }
                if (d.jpegThumbnail != null) {
                    if (typeof d.jpegThumbnail === "string")
                        $util.base64.decode(d.jpegThumbnail, m.jpegThumbnail = $util.newBuffer($util.base64.length(d.jpegThumbnail)), 0);
                    else if (d.jpegThumbnail.length >= 0)
                        m.jpegThumbnail = d.jpegThumbnail;
                }
                if (d.caption != null) {
                    m.caption = String(d.caption);
                }
                return m;
            };

            AdReplyInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.advertiserName != null && m.hasOwnProperty("advertiserName")) {
                    d.advertiserName = m.advertiserName;
                    if (o.oneofs)
                        d._advertiserName = "advertiserName";
                }
                if (m.mediaType != null && m.hasOwnProperty("mediaType")) {
                    d.mediaType = o.enums === String ? $root.proto.ContextInfo.AdReplyInfo.MediaType[m.mediaType] === undefined ? m.mediaType : $root.proto.ContextInfo.AdReplyInfo.MediaType[m.mediaType] : m.mediaType;
                    if (o.oneofs)
                        d._mediaType = "mediaType";
                }
                if (m.jpegThumbnail != null && m.hasOwnProperty("jpegThumbnail")) {
                    d.jpegThumbnail = o.bytes === String ? $util.base64.encode(m.jpegThumbnail, 0, m.jpegThumbnail.length) : o.bytes === Array ? Array.prototype.slice.call(m.jpegThumbnail) : m.jpegThumbnail;
                    if (o.oneofs)
                        d._jpegThumbnail = "jpegThumbnail";
                }
                if (m.caption != null && m.hasOwnProperty("caption")) {
                    d.caption = m.caption;
                    if (o.oneofs)
                        d._caption = "caption";
                }
                return d;
            };

            AdReplyInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AdReplyInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.AdReplyInfo";
            };

            AdReplyInfo.MediaType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return AdReplyInfo;
        })();

        ContextInfo.BusinessMessageForwardInfo = (function() {

            function BusinessMessageForwardInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BusinessMessageForwardInfo.prototype.businessOwnerJid = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BusinessMessageForwardInfo.prototype, "_businessOwnerJid", {
                get: $util.oneOfGetter($oneOfFields = ["businessOwnerJid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BusinessMessageForwardInfo.create = function create(properties) {
                return new BusinessMessageForwardInfo(properties);
            };

            BusinessMessageForwardInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.businessOwnerJid != null && Object.hasOwnProperty.call(m, "businessOwnerJid"))
                    w.uint32(10).string(m.businessOwnerJid);
                return w;
            };

            BusinessMessageForwardInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.BusinessMessageForwardInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.businessOwnerJid = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BusinessMessageForwardInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.BusinessMessageForwardInfo)
                    return d;
                var m = new $root.proto.ContextInfo.BusinessMessageForwardInfo();
                if (d.businessOwnerJid != null) {
                    m.businessOwnerJid = String(d.businessOwnerJid);
                }
                return m;
            };

            BusinessMessageForwardInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.businessOwnerJid != null && m.hasOwnProperty("businessOwnerJid")) {
                    d.businessOwnerJid = m.businessOwnerJid;
                    if (o.oneofs)
                        d._businessOwnerJid = "businessOwnerJid";
                }
                return d;
            };

            BusinessMessageForwardInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BusinessMessageForwardInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.BusinessMessageForwardInfo";
            };

            return BusinessMessageForwardInfo;
        })();

        ContextInfo.DataSharingContext = (function() {

            function DataSharingContext(p) {
                this.parameters = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DataSharingContext.prototype.showMmDisclosure = null;
            DataSharingContext.prototype.encryptedSignalTokenConsented = null;
            DataSharingContext.prototype.parameters = $util.emptyArray;
            DataSharingContext.prototype.dataSharingFlags = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DataSharingContext.prototype, "_showMmDisclosure", {
                get: $util.oneOfGetter($oneOfFields = ["showMmDisclosure"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DataSharingContext.prototype, "_encryptedSignalTokenConsented", {
                get: $util.oneOfGetter($oneOfFields = ["encryptedSignalTokenConsented"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DataSharingContext.prototype, "_dataSharingFlags", {
                get: $util.oneOfGetter($oneOfFields = ["dataSharingFlags"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DataSharingContext.create = function create(properties) {
                return new DataSharingContext(properties);
            };

            DataSharingContext.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.showMmDisclosure != null && Object.hasOwnProperty.call(m, "showMmDisclosure"))
                    w.uint32(8).bool(m.showMmDisclosure);
                if (m.encryptedSignalTokenConsented != null && Object.hasOwnProperty.call(m, "encryptedSignalTokenConsented"))
                    w.uint32(18).string(m.encryptedSignalTokenConsented);
                if (m.parameters != null && m.parameters.length) {
                    for (var i = 0; i < m.parameters.length; ++i)
                        $root.proto.ContextInfo.DataSharingContext.Parameters.encode(m.parameters[i], w.uint32(26).fork()).ldelim();
                }
                if (m.dataSharingFlags != null && Object.hasOwnProperty.call(m, "dataSharingFlags"))
                    w.uint32(32).int32(m.dataSharingFlags);
                return w;
            };

            DataSharingContext.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.DataSharingContext();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.showMmDisclosure = r.bool();
                            break;
                        }
                    case 2: {
                            m.encryptedSignalTokenConsented = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.parameters && m.parameters.length))
                                m.parameters = [];
                            m.parameters.push($root.proto.ContextInfo.DataSharingContext.Parameters.decode(r, r.uint32()));
                            break;
                        }
                    case 4: {
                            m.dataSharingFlags = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DataSharingContext.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.DataSharingContext)
                    return d;
                var m = new $root.proto.ContextInfo.DataSharingContext();
                if (d.showMmDisclosure != null) {
                    m.showMmDisclosure = Boolean(d.showMmDisclosure);
                }
                if (d.encryptedSignalTokenConsented != null) {
                    m.encryptedSignalTokenConsented = String(d.encryptedSignalTokenConsented);
                }
                if (d.parameters) {
                    if (!Array.isArray(d.parameters))
                        throw TypeError(".proto.ContextInfo.DataSharingContext.parameters: array expected");
                    m.parameters = [];
                    for (var i = 0; i < d.parameters.length; ++i) {
                        if (typeof d.parameters[i] !== "object")
                            throw TypeError(".proto.ContextInfo.DataSharingContext.parameters: object expected");
                        m.parameters[i] = $root.proto.ContextInfo.DataSharingContext.Parameters.fromObject(d.parameters[i]);
                    }
                }
                if (d.dataSharingFlags != null) {
                    m.dataSharingFlags = d.dataSharingFlags | 0;
                }
                return m;
            };

            DataSharingContext.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.parameters = [];
                }
                if (m.showMmDisclosure != null && m.hasOwnProperty("showMmDisclosure")) {
                    d.showMmDisclosure = m.showMmDisclosure;
                    if (o.oneofs)
                        d._showMmDisclosure = "showMmDisclosure";
                }
                if (m.encryptedSignalTokenConsented != null && m.hasOwnProperty("encryptedSignalTokenConsented")) {
                    d.encryptedSignalTokenConsented = m.encryptedSignalTokenConsented;
                    if (o.oneofs)
                        d._encryptedSignalTokenConsented = "encryptedSignalTokenConsented";
                }
                if (m.parameters && m.parameters.length) {
                    d.parameters = [];
                    for (var j = 0; j < m.parameters.length; ++j) {
                        d.parameters[j] = $root.proto.ContextInfo.DataSharingContext.Parameters.toObject(m.parameters[j], o);
                    }
                }
                if (m.dataSharingFlags != null && m.hasOwnProperty("dataSharingFlags")) {
                    d.dataSharingFlags = m.dataSharingFlags;
                    if (o.oneofs)
                        d._dataSharingFlags = "dataSharingFlags";
                }
                return d;
            };

            DataSharingContext.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DataSharingContext.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.DataSharingContext";
            };

            DataSharingContext.DataSharingFlags = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "SHOW_MM_DISCLOSURE_ON_CLICK"] = 1;
                values[valuesById[2] = "SHOW_MM_DISCLOSURE_ON_READ"] = 2;
                return values;
            })();

            DataSharingContext.Parameters = (function() {

                function Parameters(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Parameters.prototype.key = null;
                Parameters.prototype.stringData = null;
                Parameters.prototype.intData = null;
                Parameters.prototype.floatData = null;
                Parameters.prototype.contents = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_key", {
                    get: $util.oneOfGetter($oneOfFields = ["key"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_stringData", {
                    get: $util.oneOfGetter($oneOfFields = ["stringData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_intData", {
                    get: $util.oneOfGetter($oneOfFields = ["intData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_floatData", {
                    get: $util.oneOfGetter($oneOfFields = ["floatData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_contents", {
                    get: $util.oneOfGetter($oneOfFields = ["contents"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                Parameters.create = function create(properties) {
                    return new Parameters(properties);
                };

                Parameters.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                        w.uint32(10).string(m.key);
                    if (m.stringData != null && Object.hasOwnProperty.call(m, "stringData"))
                        w.uint32(18).string(m.stringData);
                    if (m.intData != null && Object.hasOwnProperty.call(m, "intData"))
                        w.uint32(24).int64(m.intData);
                    if (m.floatData != null && Object.hasOwnProperty.call(m, "floatData"))
                        w.uint32(37).float(m.floatData);
                    if (m.contents != null && Object.hasOwnProperty.call(m, "contents"))
                        $root.proto.ContextInfo.DataSharingContext.Parameters.encode(m.contents, w.uint32(42).fork()).ldelim();
                    return w;
                };

                Parameters.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.DataSharingContext.Parameters();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.key = r.string();
                                break;
                            }
                        case 2: {
                                m.stringData = r.string();
                                break;
                            }
                        case 3: {
                                m.intData = r.int64();
                                break;
                            }
                        case 4: {
                                m.floatData = r.float();
                                break;
                            }
                        case 5: {
                                m.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Parameters.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ContextInfo.DataSharingContext.Parameters)
                        return d;
                    var m = new $root.proto.ContextInfo.DataSharingContext.Parameters();
                    if (d.key != null) {
                        m.key = String(d.key);
                    }
                    if (d.stringData != null) {
                        m.stringData = String(d.stringData);
                    }
                    if (d.intData != null) {
                        if ($util.Long)
                            (m.intData = $util.Long.fromValue(d.intData)).unsigned = false;
                        else if (typeof d.intData === "string")
                            m.intData = parseInt(d.intData, 10);
                        else if (typeof d.intData === "number")
                            m.intData = d.intData;
                        else if (typeof d.intData === "object")
                            m.intData = new $util.LongBits(d.intData.low >>> 0, d.intData.high >>> 0).toNumber();
                    }
                    if (d.floatData != null) {
                        m.floatData = Number(d.floatData);
                    }
                    if (d.contents != null) {
                        if (typeof d.contents !== "object")
                            throw TypeError(".proto.ContextInfo.DataSharingContext.Parameters.contents: object expected");
                        m.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.fromObject(d.contents);
                    }
                    return m;
                };

                Parameters.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.key != null && m.hasOwnProperty("key")) {
                        d.key = m.key;
                        if (o.oneofs)
                            d._key = "key";
                    }
                    if (m.stringData != null && m.hasOwnProperty("stringData")) {
                        d.stringData = m.stringData;
                        if (o.oneofs)
                            d._stringData = "stringData";
                    }
                    if (m.intData != null && m.hasOwnProperty("intData")) {
                        if (typeof m.intData === "number")
                            d.intData = o.longs === String ? String(m.intData) : m.intData;
                        else
                            d.intData = o.longs === String ? $util.Long.prototype.toString.call(m.intData) : o.longs === Number ? new $util.LongBits(m.intData.low >>> 0, m.intData.high >>> 0).toNumber() : m.intData;
                        if (o.oneofs)
                            d._intData = "intData";
                    }
                    if (m.floatData != null && m.hasOwnProperty("floatData")) {
                        d.floatData = o.json && !isFinite(m.floatData) ? String(m.floatData) : m.floatData;
                        if (o.oneofs)
                            d._floatData = "floatData";
                    }
                    if (m.contents != null && m.hasOwnProperty("contents")) {
                        d.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.toObject(m.contents, o);
                        if (o.oneofs)
                            d._contents = "contents";
                    }
                    return d;
                };

                Parameters.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                Parameters.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ContextInfo.DataSharingContext.Parameters";
                };

                return Parameters;
            })();

            return DataSharingContext;
        })();

        ContextInfo.ExternalAdReplyInfo = (function() {

            function ExternalAdReplyInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ExternalAdReplyInfo.prototype.title = null;
            ExternalAdReplyInfo.prototype.body = null;
            ExternalAdReplyInfo.prototype.mediaType = null;
            ExternalAdReplyInfo.prototype.thumbnailUrl = null;
            ExternalAdReplyInfo.prototype.mediaUrl = null;
            ExternalAdReplyInfo.prototype.thumbnail = null;
            ExternalAdReplyInfo.prototype.sourceType = null;
            ExternalAdReplyInfo.prototype.sourceId = null;
            ExternalAdReplyInfo.prototype.sourceUrl = null;
            ExternalAdReplyInfo.prototype.containsAutoReply = null;
            ExternalAdReplyInfo.prototype.renderLargerThumbnail = null;
            ExternalAdReplyInfo.prototype.showAdAttribution = null;
            ExternalAdReplyInfo.prototype.ctwaClid = null;
            ExternalAdReplyInfo.prototype.ref = null;
            ExternalAdReplyInfo.prototype.clickToWhatsappCall = null;
            ExternalAdReplyInfo.prototype.adContextPreviewDismissed = null;
            ExternalAdReplyInfo.prototype.sourceApp = null;
            ExternalAdReplyInfo.prototype.automatedGreetingMessageShown = null;
            ExternalAdReplyInfo.prototype.greetingMessageBody = null;
            ExternalAdReplyInfo.prototype.ctaPayload = null;
            ExternalAdReplyInfo.prototype.disableNudge = null;
            ExternalAdReplyInfo.prototype.originalImageUrl = null;
            ExternalAdReplyInfo.prototype.automatedGreetingMessageCtaType = null;
            ExternalAdReplyInfo.prototype.wtwaAdFormat = null;
            ExternalAdReplyInfo.prototype.adType = null;
            ExternalAdReplyInfo.prototype.wtwaWebsiteUrl = null;
            ExternalAdReplyInfo.prototype.adPreviewUrl = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_title", {
                get: $util.oneOfGetter($oneOfFields = ["title"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_body", {
                get: $util.oneOfGetter($oneOfFields = ["body"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_mediaType", {
                get: $util.oneOfGetter($oneOfFields = ["mediaType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_thumbnailUrl", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_mediaUrl", {
                get: $util.oneOfGetter($oneOfFields = ["mediaUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_thumbnail", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnail"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceType", {
                get: $util.oneOfGetter($oneOfFields = ["sourceType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceId", {
                get: $util.oneOfGetter($oneOfFields = ["sourceId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceUrl", {
                get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_containsAutoReply", {
                get: $util.oneOfGetter($oneOfFields = ["containsAutoReply"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_renderLargerThumbnail", {
                get: $util.oneOfGetter($oneOfFields = ["renderLargerThumbnail"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_showAdAttribution", {
                get: $util.oneOfGetter($oneOfFields = ["showAdAttribution"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_ctwaClid", {
                get: $util.oneOfGetter($oneOfFields = ["ctwaClid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_ref", {
                get: $util.oneOfGetter($oneOfFields = ["ref"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_clickToWhatsappCall", {
                get: $util.oneOfGetter($oneOfFields = ["clickToWhatsappCall"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_adContextPreviewDismissed", {
                get: $util.oneOfGetter($oneOfFields = ["adContextPreviewDismissed"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceApp", {
                get: $util.oneOfGetter($oneOfFields = ["sourceApp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_automatedGreetingMessageShown", {
                get: $util.oneOfGetter($oneOfFields = ["automatedGreetingMessageShown"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_greetingMessageBody", {
                get: $util.oneOfGetter($oneOfFields = ["greetingMessageBody"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_ctaPayload", {
                get: $util.oneOfGetter($oneOfFields = ["ctaPayload"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_disableNudge", {
                get: $util.oneOfGetter($oneOfFields = ["disableNudge"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_originalImageUrl", {
                get: $util.oneOfGetter($oneOfFields = ["originalImageUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_automatedGreetingMessageCtaType", {
                get: $util.oneOfGetter($oneOfFields = ["automatedGreetingMessageCtaType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_wtwaAdFormat", {
                get: $util.oneOfGetter($oneOfFields = ["wtwaAdFormat"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_adType", {
                get: $util.oneOfGetter($oneOfFields = ["adType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_wtwaWebsiteUrl", {
                get: $util.oneOfGetter($oneOfFields = ["wtwaWebsiteUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_adPreviewUrl", {
                get: $util.oneOfGetter($oneOfFields = ["adPreviewUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ExternalAdReplyInfo.create = function create(properties) {
                return new ExternalAdReplyInfo(properties);
            };

            ExternalAdReplyInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    w.uint32(18).string(m.body);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(24).int32(m.mediaType);
                if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                    w.uint32(34).string(m.thumbnailUrl);
                if (m.mediaUrl != null && Object.hasOwnProperty.call(m, "mediaUrl"))
                    w.uint32(42).string(m.mediaUrl);
                if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                    w.uint32(50).bytes(m.thumbnail);
                if (m.sourceType != null && Object.hasOwnProperty.call(m, "sourceType"))
                    w.uint32(58).string(m.sourceType);
                if (m.sourceId != null && Object.hasOwnProperty.call(m, "sourceId"))
                    w.uint32(66).string(m.sourceId);
                if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                    w.uint32(74).string(m.sourceUrl);
                if (m.containsAutoReply != null && Object.hasOwnProperty.call(m, "containsAutoReply"))
                    w.uint32(80).bool(m.containsAutoReply);
                if (m.renderLargerThumbnail != null && Object.hasOwnProperty.call(m, "renderLargerThumbnail"))
                    w.uint32(88).bool(m.renderLargerThumbnail);
                if (m.showAdAttribution != null && Object.hasOwnProperty.call(m, "showAdAttribution"))
                    w.uint32(96).bool(m.showAdAttribution);
                if (m.ctwaClid != null && Object.hasOwnProperty.call(m, "ctwaClid"))
                    w.uint32(106).string(m.ctwaClid);
                if (m.ref != null && Object.hasOwnProperty.call(m, "ref"))
                    w.uint32(114).string(m.ref);
                if (m.clickToWhatsappCall != null && Object.hasOwnProperty.call(m, "clickToWhatsappCall"))
                    w.uint32(120).bool(m.clickToWhatsappCall);
                if (m.adContextPreviewDismissed != null && Object.hasOwnProperty.call(m, "adContextPreviewDismissed"))
                    w.uint32(128).bool(m.adContextPreviewDismissed);
                if (m.sourceApp != null && Object.hasOwnProperty.call(m, "sourceApp"))
                    w.uint32(138).string(m.sourceApp);
                if (m.automatedGreetingMessageShown != null && Object.hasOwnProperty.call(m, "automatedGreetingMessageShown"))
                    w.uint32(144).bool(m.automatedGreetingMessageShown);
                if (m.greetingMessageBody != null && Object.hasOwnProperty.call(m, "greetingMessageBody"))
                    w.uint32(154).string(m.greetingMessageBody);
                if (m.ctaPayload != null && Object.hasOwnProperty.call(m, "ctaPayload"))
                    w.uint32(162).string(m.ctaPayload);
                if (m.disableNudge != null && Object.hasOwnProperty.call(m, "disableNudge"))
                    w.uint32(168).bool(m.disableNudge);
                if (m.originalImageUrl != null && Object.hasOwnProperty.call(m, "originalImageUrl"))
                    w.uint32(178).string(m.originalImageUrl);
                if (m.automatedGreetingMessageCtaType != null && Object.hasOwnProperty.call(m, "automatedGreetingMessageCtaType"))
                    w.uint32(186).string(m.automatedGreetingMessageCtaType);
                if (m.wtwaAdFormat != null && Object.hasOwnProperty.call(m, "wtwaAdFormat"))
                    w.uint32(192).bool(m.wtwaAdFormat);
                if (m.adType != null && Object.hasOwnProperty.call(m, "adType"))
                    w.uint32(200).int32(m.adType);
                if (m.wtwaWebsiteUrl != null && Object.hasOwnProperty.call(m, "wtwaWebsiteUrl"))
                    w.uint32(210).string(m.wtwaWebsiteUrl);
                if (m.adPreviewUrl != null && Object.hasOwnProperty.call(m, "adPreviewUrl"))
                    w.uint32(218).string(m.adPreviewUrl);
                return w;
            };

            ExternalAdReplyInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ExternalAdReplyInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    case 2: {
                            m.body = r.string();
                            break;
                        }
                    case 3: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 4: {
                            m.thumbnailUrl = r.string();
                            break;
                        }
                    case 5: {
                            m.mediaUrl = r.string();
                            break;
                        }
                    case 6: {
                            m.thumbnail = r.bytes();
                            break;
                        }
                    case 7: {
         